/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.common;

import com.ibm.etools.fa.common.Address;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Formatter;
import java.util.StringTokenizer;

public class MiniDumpRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int LINE_HEADER_WIDTH = 18;
    private static final int ADDRESSIBLE_UNIT_SIZE = 9;
    private byte[] DDirMdHdr = new byte[4];
    private long DDirMdAddr64;
    private long DDirMdAddr31;
    private char DDirMdKey;
    private char DDirMdSubpool;
    private byte[] DDirMdResv = new byte[2];
    private int DDirMdASID;
    private byte[] DDirMdData = new byte[4096];
    private boolean hasHeaderInfo = false;
    private StringBuffer formattedData = null;
    private int numberOfLines = -1;
    private Address startAddress = null;

    public boolean equals(Object obj) {
        if (obj instanceof MiniDumpRecord) {
            MiniDumpRecord other = (MiniDumpRecord)obj;
            return this.DDirMdAddr64 == other.getDDirMdAddr64() && this.DDirMdAddr31 == other.getDDirMdAddr31();
        }
        return false;
    }

    public long getDDirMdAddr31() {
        return this.DDirMdAddr31;
    }

    public long getDDirMdAddr64() {
        return this.DDirMdAddr64;
    }

    public int getDDirMdASID() {
        return this.DDirMdASID;
    }

    public byte[] getDDirMdData() {
        return this.DDirMdData;
    }

    public byte[] getDDirMdHdr() {
        return this.DDirMdHdr;
    }

    public char getDDirMdKey() {
        return this.DDirMdKey;
    }

    public byte[] getDDirMdResv() {
        return this.DDirMdResv;
    }

    public char getDDirMdSubpool() {
        return this.DDirMdSubpool;
    }

    public boolean parseRecord(byte[] buffer) {
        if (buffer == null) {
            return false;
        }
        System.arraycopy(buffer, 0, this.DDirMdHdr, 0, 4);
        this.DDirMdAddr64 = this.parseUnsignedInt(buffer, 4);
        this.DDirMdAddr31 = this.parseUnsignedInt(buffer, 8);
        this.DDirMdKey = (char)buffer[12];
        this.DDirMdSubpool = (char)buffer[13];
        System.arraycopy(buffer, 14, this.DDirMdResv, 0, 2);
        this.DDirMdASID = this.parseSignedInt(buffer, 16);
        System.arraycopy(buffer, 20, this.DDirMdData, 0, 4096);
        return true;
    }

    public long parseUnsignedInt(byte[] buffer, int start) {
        long i1 = (buffer[start++] & 0xFF) << 24;
        long i2 = (buffer[start++] & 0xFF) << 16;
        long i3 = (buffer[start++] & 0xFF) << 8;
        long i4 = buffer[start++] & 0xFF;
        return i1 | i2 | i3 | i4;
    }

    public int parseSignedInt(byte[] buffer, int start) {
        int i1 = (buffer[start++] & 0xFF) << 24;
        int i2 = (buffer[start++] & 0xFF) << 16;
        int i3 = (buffer[start++] & 0xFF) << 8;
        int i4 = buffer[start++] & 0xFF;
        return i1 | i2 | i3 | i4;
    }

    public int getNumberOfLines() {
        return this.numberOfLines;
    }

    public int getTotalLengthOfFormattedText() {
        if (this.formattedData == null) {
            return -1;
        }
        return this.formattedData.length();
    }

    public int getLineNumberForAddress(long address) {
        return (int)(address - this.DDirMdAddr31) / 32 + (this.hasHeaderInfo ? 1 : 0);
    }

    public int getOffsetWithinLine(long address) {
        long startAddressOffset = (address - this.DDirMdAddr31) / 32L * 32L;
        int offset = (int)(address - (this.DDirMdAddr31 + startAddressOffset));
        int gapCount = 0;
        switch (offset / 4) {
            case 1: {
                gapCount = 1;
                break;
            }
            case 2: {
                gapCount = 2;
                break;
            }
            case 3: {
                gapCount = 3;
                break;
            }
            case 4: {
                gapCount = 5;
                break;
            }
            case 5: {
                gapCount = 6;
                break;
            }
            case 6: {
                gapCount = 7;
                break;
            }
            case 7: {
                gapCount = 8;
            }
        }
        int skipWidth = (offset *= 2) + gapCount;
        System.out.println("Show address " + address);
        System.out.println("gapCount = " + gapCount + " skipWidth = " + skipWidth);
        return 18 + skipWidth;
    }

    public void clearFormattedPage() {
        this.formattedData = null;
        this.numberOfLines = -1;
        this.hasHeaderInfo = false;
    }

    public StringBuffer formatPage(Address priorPageAddress, Address startAddress) {
        if (!startAddress.equals(this.startAddress)) {
            this.clearFormattedPage();
        }
        if (this.formattedData != null) {
            return this.formattedData;
        }
        this.formattedData = new StringBuffer(50000);
        Formatter f = new Formatter(this.formattedData);
        long currentAddress = this.DDirMdAddr31;
        int index = 0;
        int max = this.DDirMdAddr31 == 0L ? 2048 : 4096;
        this.numberOfLines = 0;
        if (priorPageAddress.getAddress31() == this.getDDirMdAddr31() && priorPageAddress.getAddress64() == this.getDDirMdAddr64()) {
            if (this.getDDirMdAddr31() != 0L || this.getDDirMdAddr64() != 0L) {
                f.format("####### Address range 00000000 to %08X not in minidump ############\n", this.getDDirMdAddr31() - 1L);
                this.numberOfLines = 1;
                this.hasHeaderInfo = true;
            }
        } else if (priorPageAddress.getAddress31() + 4096L != this.getDDirMdAddr31()) {
            if (priorPageAddress.getAddress31() == 0L) {
                f.format("####### Address range %08X to %08X not in minidump ############\n", priorPageAddress.getAddress31() + 2048L, this.getDDirMdAddr31() - 1L);
                this.numberOfLines = 1;
                this.hasHeaderInfo = true;
            } else {
                f.format("####### Address range %08X to %08X not in minidump ############\n", priorPageAddress.getAddress31() + 4096L, this.getDDirMdAddr31() - 1L);
                this.numberOfLines = 1;
                this.hasHeaderInfo = true;
            }
        }
        while (index < max) {
            String text = "";
            try {
                text = new String(this.DDirMdData, index, 32, "Cp1047");
                if (text.length() > 32) {
                    System.out.println("actual length is " + text.length());
                }
                text = this.checkASCII(text);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            long offset = this.getDDirMdAddr31() + (long)index - startAddress.getAddress31();
            char sign = '+';
            if (offset < 0L) {
                sign = '-';
                offset = -offset;
            }
            String offsetStr = String.valueOf(sign) + Long.toHexString(offset).toUpperCase();
            f.format("%08X %8s %02X%02X%02X%02X %02X%02X%02X%02X %02X%02X%02X%02X %02X%02X%02X%02X  %02X%02X%02X%02X %02X%02X%02X%02X %02X%02X%02X%02X %02X%02X%02X%02X *%s*\n", currentAddress, offsetStr, this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], this.DDirMdData[index++], text);
            currentAddress += 32L;
            ++this.numberOfLines;
        }
        return this.formattedData;
    }

    private String checkASCII(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                if (Character.isWhitespace(c)) {
                    sb.append(' ');
                } else {
                    sb.append(c);
                }
            } else {
                sb.append('.');
            }
            ++i;
        }
        return sb.toString();
    }

    public Address getSelectedAddress(int charOffset) {
        long currentLineOffset = 0L;
        int charSoFar = 0;
        if (this.formattedData == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(this.formattedData.toString(), "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (line.charAt(0) == '#') {
                charSoFar += line.length() + 1;
                continue;
            }
            if (charOffset < charSoFar + line.length() + 1) {
                int offsetWithinLine = charOffset - charSoFar;
                if (offsetWithinLine >= 18 && offsetWithinLine < 26) {
                    return new Address(0L, this.getDDirMdAddr31() + currentLineOffset);
                }
                if (offsetWithinLine >= 27 && offsetWithinLine < 35) {
                    return new Address(0L, this.getDDirMdAddr31() + (currentLineOffset += 4L));
                }
                if (offsetWithinLine >= 36 && offsetWithinLine < 44) {
                    return new Address(0L, this.getDDirMdAddr31() + (currentLineOffset += 8L));
                }
                if (offsetWithinLine >= 45 && offsetWithinLine < 53) {
                    return new Address(0L, this.getDDirMdAddr31() + (currentLineOffset += 12L));
                }
                if (offsetWithinLine >= 55 && offsetWithinLine < 63) {
                    return new Address(0L, this.getDDirMdAddr31() + (currentLineOffset += 16L));
                }
                if (offsetWithinLine >= 64 && offsetWithinLine < 72) {
                    return new Address(0L, this.getDDirMdAddr31() + (currentLineOffset += 20L));
                }
                if (offsetWithinLine >= 73 && offsetWithinLine < 81) {
                    return new Address(0L, this.getDDirMdAddr31() + (currentLineOffset += 24L));
                }
                if (offsetWithinLine >= 82 && offsetWithinLine < 90) {
                    return new Address(0L, this.getDDirMdAddr31() + (currentLineOffset += 28L));
                }
                return null;
            }
            charSoFar += line.length() + 1;
            currentLineOffset += 32L;
        }
        return null;
    }

    public Address getClosestAddress(int charOffset) {
        long currentLineOffset = 0L;
        int charSoFar = 0;
        if (this.formattedData == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(this.formattedData.toString(), "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (charOffset < charSoFar + line.length() + 1) {
                if (line.charAt(0) == '#') {
                    return new Address(0L, this.getDDirMdAddr31() + currentLineOffset);
                }
                int offsetWithinLine = charOffset - charSoFar;
                if (offsetWithinLine < 18) {
                    return new Address(0L, this.getDDirMdAddr31() + currentLineOffset);
                }
                if (offsetWithinLine >= 18 && offsetWithinLine < 26) {
                    return new Address(0L, this.getDDirMdAddr31() + (currentLineOffset += (long)((offsetWithinLine - 18) / 2)));
                }
                if (offsetWithinLine >= 27 && offsetWithinLine < 35) {
                    return new Address(0L, this.getDDirMdAddr31() + (currentLineOffset += (long)(4 + (offsetWithinLine - 27) / 2)));
                }
                if (offsetWithinLine >= 36 && offsetWithinLine < 44) {
                    return new Address(0L, this.getDDirMdAddr31() + (currentLineOffset += (long)(8 + (offsetWithinLine - 36) / 2)));
                }
                if (offsetWithinLine >= 45 && offsetWithinLine < 53) {
                    return new Address(0L, this.getDDirMdAddr31() + (currentLineOffset += (long)(12 + (offsetWithinLine - 45) / 2)));
                }
                if (offsetWithinLine >= 55 && offsetWithinLine < 63) {
                    return new Address(0L, this.getDDirMdAddr31() + (currentLineOffset += (long)(16 + (offsetWithinLine - 55) / 2)));
                }
                if (offsetWithinLine >= 64 && offsetWithinLine < 72) {
                    return new Address(0L, this.getDDirMdAddr31() + (currentLineOffset += (long)(20 + (offsetWithinLine - 64) / 2)));
                }
                if (offsetWithinLine >= 73 && offsetWithinLine < 81) {
                    return new Address(0L, this.getDDirMdAddr31() + (currentLineOffset += (long)(24 + (offsetWithinLine - 73) / 2)));
                }
                if (offsetWithinLine >= 82 && offsetWithinLine < 90) {
                    return new Address(0L, this.getDDirMdAddr31() + (currentLineOffset += (long)(28 + (offsetWithinLine - 82) / 2)));
                }
                return new Address(0L, this.getDDirMdAddr31() + (currentLineOffset += 31L));
            }
            charSoFar += line.length() + 1;
            currentLineOffset += 32L;
        }
        return null;
    }

    public int getCharacterOffsetForLine(int lineNo) {
        StringTokenizer st = new StringTokenizer(this.formattedData.toString(), "\n");
        int charSoFar = 0;
        int lineCount = 0;
        while (st.hasMoreElements()) {
            if (lineCount == lineNo) {
                return charSoFar;
            }
            String currentLine = st.nextToken();
            charSoFar += currentLine.length() + 1;
            ++lineCount;
        }
        return charSoFar;
    }
}

