/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.common;

import com.ibm.etools.fa.common.Address;
import com.ibm.etools.fa.common.UserNoteEntry;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class UserNotes
implements Serializable {
    private static final long serialVersionUID = 1L;
    ArrayList userNotes = new ArrayList();

    public ArrayList getUserNotes() {
        return this.userNotes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.userNotes.size()) {
            sb.append(String.valueOf(this.userNotes.get(i).toString()) + "\n");
            ++i;
        }
        return sb.toString();
    }

    public UserNoteEntry getUserNote(Address address) {
        int i = 0;
        while (i < this.userNotes.size()) {
            UserNoteEntry currentEntry = (UserNoteEntry)this.userNotes.get(i);
            if (currentEntry.getAddress().equals(address)) {
                return currentEntry;
            }
            ++i;
        }
        return null;
    }

    public void insertUserNote(UserNoteEntry entry) {
        int i = 0;
        while (i < this.userNotes.size()) {
            UserNoteEntry currentEntry = (UserNoteEntry)this.userNotes.get(i);
            if (currentEntry.getAddress().equals(entry.getAddress())) {
                this.userNotes.remove(i);
                this.userNotes.add(entry);
                return;
            }
            ++i;
        }
        this.userNotes.add(entry);
    }

    public boolean parseData(ArrayList userNoteEntries) {
        try {
            int totalUserNoteRecordLength = 0;
            int i = 0;
            while (i < userNoteEntries.size()) {
                byte[] currentRec = (byte[])userNoteEntries.get(i);
                int dataLength = this.parseUnsignedShort(currentRec, 4);
                totalUserNoteRecordLength += dataLength;
                ++i;
            }
            byte[] combinedUserNoteData = new byte[totalUserNoteRecordLength];
            int currentOffset = 0;
            int i2 = 0;
            while (i2 < userNoteEntries.size()) {
                byte[] currentRec = (byte[])userNoteEntries.get(i2);
                int dataLength = this.parseUnsignedShort(currentRec, 4);
                int dataOffset = this.parseUnsignedShort(currentRec, 6);
                System.arraycopy(currentRec, dataOffset, combinedUserNoteData, currentOffset, dataLength);
                currentOffset += dataLength;
                ++i2;
            }
            int recordStart = 0;
            while (recordStart != -1) {
                recordStart = this.readRecord(combinedUserNoteData, recordStart);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private int readRecord(byte[] buffer, int startOffset) {
        long end;
        long address = this.parseUnsignedInt(buffer, startOffset);
        if (address == (end = -1L)) {
            return -1;
        }
        int dataStart = startOffset + 8;
        int dataEnd = -1;
        int i = startOffset + 8;
        while (i < buffer.length) {
            if (buffer[i] == 0 && buffer[i + 1] == 0) {
                dataEnd = i + 2;
                break;
            }
            ++i;
        }
        String note = "";
        try {
            note = new String(buffer, dataStart, dataEnd - dataStart, "Cp1047");
        }
        catch (UnsupportedEncodingException e) {
            note = e.getMessage();
        }
        UserNoteEntry entry = new UserNoteEntry(new Address(0L, address), this.replaceZeroToNewLine(note));
        this.userNotes.add(entry);
        return dataEnd;
    }

    private String replaceZeroToNewLine(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\u0000') {
                sb.append('\n');
            } else {
                sb.append(s.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public long parseUnsignedInt(byte[] buffer, int start) {
        long i1 = (buffer[start++] & 0xFF) << 24;
        long i2 = (buffer[start++] & 0xFF) << 16;
        long i3 = (buffer[start++] & 0xFF) << 8;
        long i4 = buffer[start++] & 0xFF;
        return i1 | i2 | i3 | i4;
    }

    public int parseUnsignedShort(byte[] buffer, int start) {
        int i1 = (buffer[start++] & 0xFF) << 8;
        int i2 = buffer[start++] & 0xFF;
        return i1 | i2;
    }
}

