/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.pages;

import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.plugin.HistoryFileMonitorThread;
import com.ibm.etools.fa.util.GUIUtility;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.view.summary.HistoryFileElement;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HistoryFileMonitorConfigureDialog
extends Dialog {
    public final long DEFAULT_MONITOR_INTERVAL = 100000L;
    private String systemName;
    private String historyFileName;
    private HistoryFileElement histFileElement;
    private Text messageText;
    private Text systemNameText;
    private Text histFileNameText;
    private Text intervalText;
    private Button monitorControlButton;
    private Button okButton;

    public HistoryFileMonitorConfigureDialog(Shell parent, String systemName, String historyFileName, HistoryFileElement histFileElement) {
        super(parent);
        this.systemName = systemName;
        this.historyFileName = historyFileName;
        this.histFileElement = histFileElement;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = GUIUtility.createComposite(parent, 1);
        this.messageText = GUIUtility.createTextField(composite);
        this.messageText.setEditable(false);
        this.setDefaultMessage();
        this.createEntryComposite(composite);
        this.createButtonsComposite(composite);
        return composite;
    }

    private void setMessage(String msg) {
        this.messageText.setText(msg);
    }

    private void setDefaultMessage() {
        this.messageText.setText(NLS.getString("HistoryFileMonitorConfigureDialog.Desc"));
    }

    private void createEntryComposite(Composite parent) {
        Composite composite = GUIUtility.createComposite(parent, 2);
        GUIUtility.createLabel(composite, NLS.getString("SystemName"), 1);
        this.systemNameText = GUIUtility.createTextField(composite);
        this.systemNameText.setEditable(false);
        this.systemNameText.setText(this.systemName);
        GUIUtility.createLabel(composite, NLS.getString("HistFileName"), 1);
        this.histFileNameText = GUIUtility.createTextField(composite);
        this.histFileNameText.setEditable(false);
        this.histFileNameText.setText(this.historyFileName);
        GUIUtility.createLabel(composite, NLS.getString("MonitorInterval"), 1);
        this.intervalText = GUIUtility.createTextField(composite);
        this.intervalText.setEditable(true);
        this.intervalText.setFocus();
        if (FAPlugin.getDefault().monitorExist(this.systemName, this.historyFileName)) {
            HistoryFileMonitorThread monitor = FAPlugin.getDefault().getMonitor(this.systemName, this.historyFileName);
            this.intervalText.setText(String.valueOf(monitor.getInterval() / 1000L));
        } else {
            this.intervalText.setText("100");
        }
    }

    private void createButtonsComposite(Composite parent) {
        Composite composite = GUIUtility.createComposite(parent, 2);
        GridData gridData = new GridData();
        gridData.widthHint = 70;
        this.monitorControlButton = new Button(composite, 8);
        this.monitorControlButton.setLayoutData((Object)gridData);
        if (FAPlugin.getDefault().monitorExist(this.systemName, this.historyFileName)) {
            this.monitorControlButton.setText(NLS.getString("Stop"));
        } else {
            this.monitorControlButton.setText(NLS.getString("Start"));
        }
        this.monitorControlButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (FAPlugin.getDefault().monitorExist(HistoryFileMonitorConfigureDialog.this.systemName, HistoryFileMonitorConfigureDialog.this.historyFileName)) {
                    System.out.println("Stopping the monitor...");
                    FAPlugin.getDefault().stopMonitor(HistoryFileMonitorConfigureDialog.this.systemName, HistoryFileMonitorConfigureDialog.this.historyFileName);
                    HistoryFileMonitorConfigureDialog.this.monitorControlButton.setText(NLS.getString("Start"));
                } else {
                    System.out.println("Starting the monitor...");
                    long interval = HistoryFileMonitorConfigureDialog.this.getInterval();
                    if (interval != -1L) {
                        System.out.println("Configured to start the monitor every " + interval / 1000L + " seconds...");
                        HistoryFileMonitorConfigureDialog.this.setDefaultMessage();
                        HistoryFileMonitorThread monitor = new HistoryFileMonitorThread(HistoryFileMonitorConfigureDialog.this.historyFileName, HistoryFileMonitorConfigureDialog.this.systemName, interval, HistoryFileMonitorConfigureDialog.this.histFileElement);
                        FAPlugin.getDefault().addNewMonitor(HistoryFileMonitorConfigureDialog.this.systemName, HistoryFileMonitorConfigureDialog.this.historyFileName, monitor);
                        monitor.start();
                        HistoryFileMonitorConfigureDialog.this.monitorControlButton.setText(NLS.getString("Stop"));
                    } else {
                        HistoryFileMonitorConfigureDialog.this.setMessage(NLS.getString("HistoryFileMonitorConfigureDialog.InvalidInterval"));
                    }
                }
            }
        });
        this.okButton = new Button(composite, 8);
        this.okButton.setLayoutData((Object)gridData);
        this.okButton.setText(NLS.getString("OK"));
        this.okButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                HistoryFileMonitorConfigureDialog.this.close();
            }
        });
    }

    private long getInterval() {
        String value = this.intervalText.getText().trim();
        if (value.length() == 0) {
            return -1L;
        }
        try {
            long interval = Long.parseLong(value);
            return interval *= 1000L;
        }
        catch (Exception exception) {
            return -1L;
        }
    }
}

