/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.plugin;

import com.ibm.etools.fa.plugin.HistoryFileMonitorThread;
import com.ibm.etools.fa.util.NLS;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class FAPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.etools.fa.plugin.FAPlugin";
    private static FAPlugin plugin;
    private IProject configProject;
    private String configProjectName = "FA";
    private FormColors formColors;
    private HashMap<String, HistoryFileMonitorThread> historyFileMonitors;

    public FAPlugin() {
        plugin = this;
        this.historyFileMonitors = new HashMap();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        this.stopAllMonitors();
        super.stop(context);
    }

    public static FAPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return FAPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static IPath getPath() {
        return plugin.getStateLocation();
    }

    public IProject getConfigProject() throws CoreException {
        if (this.configProject == null) {
            IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            this.configProject = myWorkspaceRoot.getProject(this.configProjectName);
            if (!this.configProject.exists()) {
                this.configProject.create((IProgressMonitor)new NullProgressMonitor());
            }
            if (!this.configProject.isOpen()) {
                this.configProject.open((IProgressMonitor)new NullProgressMonitor());
            }
        }
        return this.configProject;
    }

    public IFile getFile(String fileNameWithPath) throws CoreException {
        IProject configProject = this.getConfigProject();
        IFile file = configProject.getFile(fileNameWithPath);
        IPath path = file.getFullPath();
        if (path.segmentCount() > 2) {
            String[] segments = path.segments();
            String current = "";
            int i = 1;
            while (i < segments.length - 1) {
                IFolder folder = configProject.getFolder(current = current.length() == 0 ? segments[i] : String.valueOf(current) + File.separator + segments[i]);
                if (!folder.exists()) {
                    folder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                ++i;
            }
        }
        return file;
    }

    public void log(int status, final String message, Exception e, boolean displayDialog) {
        try {
            Shell shell;
            Status errorStatus = null;
            errorStatus = status == 2 || status == 1 ? new Status(status, PLUGIN_ID, 4, message, (Throwable)e) : new Status(status, PLUGIN_ID, 8, message, (Throwable)e);
            FAPlugin.getDefault().getLog().log((IStatus)errorStatus);
            if (displayDialog && (shell = Display.getCurrent().getActiveShell()) != null) {
                if (status == 1) {
                    shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openInformation((Shell)shell, (String)NLS.getString("FAPlugin.InfoTitle"), (String)message);
                        }
                    });
                } else if (status == 2) {
                    shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openWarning((Shell)shell, (String)NLS.getString("FAPlugin.WarningTitle"), (String)message);
                        }
                    });
                } else {
                    shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openError((Shell)shell, (String)NLS.getString("FAPlugin.ErrorTitle"), (String)message);
                        }
                    });
                }
            }
        }
        catch (Exception exception) {}
    }

    public String[] getDialogValues(String key) {
        String[] values = this.getDialogSettings().getArray(key);
        if (values == null) {
            return new String[0];
        }
        return values;
    }

    public void addNewDialogValueIfNew(String key, String newValue) {
        boolean foundMatch = false;
        if (newValue == null || newValue.length() == 0) {
            return;
        }
        String[] values = this.getDialogValues(key);
        ArrayList<String> valueList = new ArrayList<String>();
        int i = 0;
        while (i < values.length) {
            valueList.add(values[i]);
            ++i;
        }
        i = 0;
        while (i < valueList.size()) {
            if (((String)valueList.get(i)).equals(newValue)) {
                valueList.remove(i);
                valueList.add(0, newValue);
                foundMatch = true;
                break;
            }
            ++i;
        }
        if (!foundMatch) {
            valueList.add(0, newValue);
        }
        String[] newValues = new String[valueList.size()];
        int i2 = 0;
        while (i2 < valueList.size()) {
            newValues[i2] = (String)valueList.get(i2);
            ++i2;
        }
        this.getDialogSettings().put(key, newValues);
    }

    public FormColors getFormColors(Display display) {
        if (this.formColors == null) {
            this.formColors = new FormColors(display);
            this.formColors.markShared();
        }
        return this.formColors;
    }

    private String createHistoryFileMonitorKey(String systemName, String historyFileName) {
        return String.valueOf(systemName) + ":" + historyFileName;
    }

    public void stopAllMonitors() {
        Set<String> keys = this.historyFileMonitors.keySet();
        for (String key : keys) {
            System.out.println("Removing: " + key);
            Thread monitor = this.historyFileMonitors.get(key);
            monitor.interrupt();
        }
    }

    public void addNewMonitor(String systemName, String historyFileName, HistoryFileMonitorThread monitor) {
        String key = this.createHistoryFileMonitorKey(systemName, historyFileName);
        if (this.monitorExist(systemName, historyFileName)) {
            HistoryFileMonitorThread oldMonitor = this.historyFileMonitors.remove(key);
            oldMonitor.interrupt();
            this.historyFileMonitors.put(key, monitor);
        } else {
            this.historyFileMonitors.put(key, monitor);
        }
    }

    public boolean monitorExist(String systemName, String historyFileName) {
        String key = this.createHistoryFileMonitorKey(systemName, historyFileName);
        return this.historyFileMonitors.containsKey(key);
    }

    public void stopMonitor(String systemName, String historyFileName) {
        String key = this.createHistoryFileMonitorKey(systemName, historyFileName);
        HistoryFileMonitorThread oldMonitor = this.historyFileMonitors.remove(key);
        if (oldMonitor != null) {
            oldMonitor.interrupt();
        }
    }

    public HistoryFileMonitorThread getMonitor(String systemName, String historyFileName) {
        String key = this.createHistoryFileMonitorKey(systemName, historyFileName);
        return this.historyFileMonitors.get(key);
    }
}

