/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.plugin;

import com.ibm.etools.fa.common.HistoryIndexFileEntry;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.subsystem.FASubSystem;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.util.RSESystemManagement;
import com.ibm.etools.fa.view.details.DetailedHistoryFileView;
import com.ibm.etools.fa.view.details.FAHistoryFileViewData;
import com.ibm.etools.fa.view.summary.HistoryFileElement;
import com.ibm.etools.fa.view.summary.HistoryFilesView;
import com.ibm.etools.fa.view.summary.TreeElement;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class HistoryFileMonitorThread
extends Thread {
    private boolean runnableSuccessful = false;
    private String historyFileName;
    private String systemName;
    private long sleepIntervalInMilliseconds;
    private HistoryFileElement histFileElement;

    public HistoryFileMonitorThread(String historyFileName, String systemName, long sleepIntervalInMillseconds, HistoryFileElement histFileElement) {
        this.historyFileName = historyFileName;
        this.systemName = systemName;
        this.sleepIntervalInMilliseconds = sleepIntervalInMillseconds;
        this.histFileElement = histFileElement;
    }

    public void run() {
        while (true) {
            if (this.isInterrupted()) {
                System.out.println("Finishing the thread for " + this.systemName + " " + this.historyFileName);
                return;
            }
            try {
                this.retrieveAndAddHistoryFileInfo(this.systemName, this.historyFileName, this.histFileElement);
            }
            catch (Exception e) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)NLS.getString("HistoryFileMonitorThread.ErrJobTitle"), (String)NLS.getString("HistoryFileMonitorThread.ErrJobMsg"));
                    }
                });
                FAPlugin.getDefault().log(4, NLS.getString("HistoryFileMonitorThread.ErrJobMsg"), e, false);
                return;
            }
            try {
                Thread.sleep(this.sleepIntervalInMilliseconds);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Finishing the thread for " + this.systemName + " " + this.historyFileName + " (being interrupted)");
                return;
            }
        }
    }

    public long getInterval() {
        return this.sleepIntervalInMilliseconds;
    }

    private void openErrorThreadSafe(final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message);
            }
        });
    }

    private void retrieveAndAddHistoryFileInfo(final String systemName, final String histFileName, final HistoryFileElement histFileElement) throws Exception {
        Job refreshHistFileJob = new Job(String.valueOf(NLS.getString("RemoveCachedInformationAction.JobTitle")) + " " + histFileElement.getLabel()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    FASubSystem faSubSystem;
                    monitor.beginTask(String.valueOf(NLS.getString("RemoveCachedInformationAction.JobTitle")) + " " + histFileElement.getLabel(), 2);
                    IPath path = FAPlugin.getPath().append(String.valueOf(File.separator) + systemName + File.separator + histFileName + File.separator);
                    File tmpFile = path.append("$$INDEX").toFile();
                    if (tmpFile.exists()) {
                        tmpFile.delete();
                    }
                    if ((faSubSystem = RSESystemManagement.getFASubSystem(systemName)) == null) {
                        HistoryFileMonitorThread.this.openErrorThreadSafe(NLS.getString("HistoryFilesView.NoSystemTitle"), String.valueOf(NLS.getString("HistoryFilesView.NoSystemMsg")) + " " + systemName);
                        HistoryFileMonitorThread.this.runnableSuccessful = false;
                        return Status.OK_STATUS;
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        return Status.OK_STATUS;
                    }
                    System.out.println("Getting " + histFileName + " info from " + systemName + " to " + path.toString());
                    if (!faSubSystem.readHistoryFile(histFileName, path.toString(), "$$INDEX")) {
                        HistoryFileMonitorThread.this.openErrorThreadSafe(NLS.getString("RemoveCachedInformationAction.FailureTitle"), NLS.getString("RemoveCachedInformationAction.FailureMsg"));
                        HistoryFileMonitorThread.this.runnableSuccessful = false;
                        return Status.OK_STATUS;
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        return Status.OK_STATUS;
                    }
                    HistoryFileMonitorThread.this.runnableSuccessful = true;
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    HistoryFileMonitorThread.this.openErrorThreadSafe(NLS.getString("RemoveCachedInformationAction.FailureTitle"), NLS.getString("RemoveCachedInformationAction.FailureMsg"));
                    FAPlugin.getDefault().log(4, NLS.getString("RemoveCachedInformationAction.FailureMsg"), e, false);
                    HistoryFileMonitorThread.this.runnableSuccessful = false;
                    return Status.OK_STATUS;
                }
            }
        };
        refreshHistFileJob.setPriority(30);
        refreshHistFileJob.setRule((ISchedulingRule)FAPlugin.getDefault().getConfigProject());
        refreshHistFileJob.addJobChangeListener(new IJobChangeListener(){

            public void running(IJobChangeEvent event) {
            }

            public void scheduled(IJobChangeEvent event) {
            }

            public void sleeping(IJobChangeEvent event) {
            }

            public void aboutToRun(IJobChangeEvent event) {
            }

            public void awake(IJobChangeEvent event) {
            }

            public void done(IJobChangeEvent event) {
                if (HistoryFileMonitorThread.this.runnableSuccessful) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            ObjectInputStream input;
                            File tmpFile;
                            block14: {
                                block15: {
                                    block16: {
                                        IPath path = FAPlugin.getPath().append(String.valueOf(File.separator) + systemName + File.separator + histFileName + File.separator);
                                        tmpFile = path.append("$$INDEX").toFile();
                                        input = null;
                                        input = new ObjectInputStream(new FileInputStream(tmpFile));
                                        ArrayList newHistFileData = (ArrayList)input.readObject();
                                        if (HistoryFileMonitorThread.this.sameIndexFile(newHistFileData, histFileElement.getHistoryFileData().readCachedIndexFileContents())) break block14;
                                        if (MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)NLS.getString("HistoryFileMonitorThread.HistFileUpdatedTitle"), (String)(String.valueOf(NLS.getString("HistoryFileMonitorThread.HistFileUpdatedQuestion")) + " " + systemName + " " + histFileName))) break block15;
                                        if (input == null) break block16;
                                        try {
                                            input.close();
                                        }
                                        catch (Exception exception) {}
                                    }
                                    tmpFile.delete();
                                    return;
                                }
                                try {
                                    try {
                                        HistoryFileMonitorThread.this.removeAllChildren(histFileElement);
                                        IFile localCacheFile = FAPlugin.getDefault().getFile(String.valueOf(systemName) + File.separator + histFileName + File.separator + "$$INDEX");
                                        localCacheFile.setContents((InputStream)new FileInputStream(tmpFile), true, true, (IProgressMonitor)new NullProgressMonitor());
                                        IWorkbenchPage activePage = FAPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                        if (activePage.findView("com.ibm.etools.fa.view.details.DetailedHistoryFileView") != null) {
                                            DetailedHistoryFileView view = (DetailedHistoryFileView)activePage.showView("com.ibm.etools.fa.view.details.DetailedHistoryFileView");
                                            ArrayList<FAHistoryFileViewData> viewList = new ArrayList<FAHistoryFileViewData>();
                                            viewList.add(histFileElement.getHistoryFileData());
                                            view.populateTable(viewList, histFileElement.getHistoryFileData().getHistFileName());
                                        }
                                    }
                                    catch (Exception e) {
                                        FAPlugin.getDefault().log(4, NLS.getString("HistoryFileMonitorThread.ErrAfterJob"), e, true);
                                    }
                                }
                                catch (Throwable throwable) {
                                    if (input != null) {
                                        try {
                                            input.close();
                                        }
                                        catch (Exception exception) {}
                                    }
                                    tmpFile.delete();
                                    throw throwable;
                                }
                            }
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (Exception exception) {}
                            }
                            tmpFile.delete();
                        }
                    });
                }
            }
        });
        refreshHistFileJob.schedule();
    }

    private boolean sameIndexFile(ArrayList newIndexFileContents, ArrayList oldIndexFileContents) {
        if (newIndexFileContents.size() != oldIndexFileContents.size()) {
            return false;
        }
        int i = 0;
        while (i < newIndexFileContents.size()) {
            HistoryIndexFileEntry anEntry = (HistoryIndexFileEntry)newIndexFileContents.get(i);
            if (!this.contains(oldIndexFileContents, anEntry)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean contains(ArrayList list, HistoryIndexFileEntry anEntry) {
        int i = 0;
        while (i < list.size()) {
            HistoryIndexFileEntry tmp = (HistoryIndexFileEntry)list.get(i);
            if (tmp.equals(anEntry)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void expandView(TreeElement element, int level) {
        IWorkbenchPage activePage = FAPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        HistoryFilesView faView = (HistoryFilesView)activePage.findView("com.ibm.etools.fa.view.summary.HistoryFilesView");
        faView.expand(element, level);
        faView.refresh();
    }

    protected void removeAllChildren(TreeElement element) {
        element.removeAllChildren();
        this.refreshView();
    }

    protected void refreshView() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage activePage = FAPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                HistoryFilesView faView = (HistoryFilesView)activePage.findView("com.ibm.etools.fa.view.summary.HistoryFilesView");
                faView.refresh();
            }
        });
    }
}

