/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.subsystem;

import com.ibm.etools.systems.dftsubsystem.impl.DefaultSubSystemImpl;
import com.ibm.etools.systems.dstore.core.model.DataElement;
import com.ibm.etools.systems.dstore.core.model.DataStore;
import com.ibm.etools.systems.subsystems.ServerLauncher;
import com.ibm.etools.systems.subsystems.impl.AbstractSystemManager;
import com.ibm.etools.systems.universal.UniversalSystem;
import com.ibm.etools.systems.universal.util.StatusMonitor;
import com.ibm.etools.systems.universal.util.StatusMonitorFactory;
import com.ibm.etools.zos.system.zOSSystem;
import com.ibm.etools.zos.system.zOSSystemManager;
import java.io.File;
import java.util.ArrayList;

public class FASubSystem
extends DefaultSubSystemImpl {
    public FASubSystem() {
        System.out.println("FASubSystem constructor called...");
    }

    public ServerLauncher getRemoteServerLauncher() {
        if (this.getSystemType().equalsIgnoreCase("z/OS")) {
            ServerLauncher launcher = null;
            zOSSystem zosSystem = (zOSSystem)this.getSystem();
            if (zosSystem.hasCommonServerLauncher()) {
                launcher = zosSystem.getCommonServerLauncher();
                if (launcher.eContainer() == null) {
                    this.setRemoteServerLauncher(launcher);
                }
            } else {
                launcher = super.getRemoteServerLauncher();
                if (launcher != null) {
                    zosSystem.setCommonServerLauncher(launcher);
                }
            }
            return launcher;
        }
        return super.getRemoteServerLauncher();
    }

    public AbstractSystemManager getSystemManager() {
        return zOSSystemManager.getThezOSSystemManager();
    }

    protected DataStore getDataStore() {
        UniversalSystem uSystem = (UniversalSystem)this.getSystem();
        DataStore dataStore = uSystem.getDataStore();
        return dataStore;
    }

    private boolean checkConnection() {
        if (this.isConnected()) {
            return true;
        }
        try {
            this.connect();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean readHistoryFile(String historyFileName, String path, String localIndexFileName) {
        if (!this.checkConnection()) {
            return false;
        }
        DataElement histRoot = this.getDataStore().find("fa.history.file");
        if (histRoot == null) {
            System.out.println("Failed to find hist root!");
            return false;
        }
        System.out.println("Found hist root!!");
        DataElement command = this.getDataStore().localDescriptorQuery(histRoot, "fa.history.file.readHistoryFileContents");
        if (command != null) {
            System.out.println("Found command for hist root!");
        } else {
            System.out.println("Faild to find hist file command!");
        }
        this.getDataStore().setAttribute(7, path);
        DataElement arg1 = this.getDataStore().createObject(command, "name", historyFileName);
        DataElement arg2 = this.getDataStore().createObject(command, "name", localIndexFileName);
        ArrayList<DataElement> args = new ArrayList<DataElement>();
        args.add(arg1);
        args.add(arg2);
        DataElement status = this.getDataStore().command(command, args, histRoot);
        String finished = null;
        while (finished == null) {
            StatusMonitor smon = StatusMonitorFactory.getInstance().getStatusMonitorFor(this.getSystem(), this.getDataStore());
            try {
                smon.waitForUpdate(status);
            }
            catch (Exception e) {
                System.out.println("Failed to wait!!");
                e.printStackTrace();
                return false;
            }
            finished = status.getAttribute(4);
            if (finished.equals("fa:done") || finished.equals("fa:failure") || finished.equals("fa:unknown")) continue;
            System.out.println("Not finished yet.... [" + finished + "]");
            finished = null;
        }
        System.out.println("name = " + status.getAttribute(2));
        System.out.println("source = " + status.getAttribute(4));
        System.out.println("done!");
        return finished.equals("fa:done");
    }

    public boolean readHistoryFileMemberReportAndDump(String historyFileName, String memberName, String path, String reportFileName, String miniDumpFileName) {
        if (!this.checkConnection()) {
            return false;
        }
        DataElement memRoot = this.getDataStore().find("fa.history.fault.entry");
        if (memRoot == null) {
            System.out.println("Failed to find mem root!");
            return false;
        }
        System.out.println("Found mem root!!");
        DataElement command = this.getDataStore().localDescriptorQuery(memRoot, "fa.history.fault.entry.read.report.and.minidump");
        if (command != null) {
            System.out.println("Found command for member root!");
        } else {
            System.out.println("Faild to find hist file command!");
        }
        this.getDataStore().setAttribute(7, path);
        DataElement arg1 = this.getDataStore().createObject(command, "name", historyFileName);
        DataElement arg2 = this.getDataStore().createObject(command, "name", memberName);
        DataElement arg3 = this.getDataStore().createObject(command, "name", reportFileName);
        DataElement arg4 = this.getDataStore().createObject(command, "name", miniDumpFileName);
        ArrayList<DataElement> args = new ArrayList<DataElement>();
        args.add(arg1);
        args.add(arg2);
        args.add(arg3);
        args.add(arg4);
        DataElement status = this.getDataStore().command(command, args, memRoot);
        String finished = null;
        while (finished == null) {
            StatusMonitor smon = StatusMonitorFactory.getInstance().getStatusMonitorFor(this.getSystem(), this.getDataStore());
            try {
                smon.waitForUpdate(status);
            }
            catch (Exception e) {
                System.out.println("Failed to wait!!");
                e.printStackTrace();
                return false;
            }
            finished = status.getAttribute(4);
            if (finished.equals("fa:done") || finished.equals("fa:failure") || finished.equals("fa:unknown")) continue;
            System.out.println("Not finished yet.... [" + finished + "]");
            finished = null;
        }
        System.out.println("name = " + status.getAttribute(2));
        System.out.println("source = " + status.getAttribute(4));
        System.out.println("done!");
        return finished.equals("fa:done");
    }

    public boolean readHistoryFileMemberReportOnly(String historyFileName, String memberName, String path, String reportFileName) {
        if (!this.checkConnection()) {
            return false;
        }
        DataElement memRoot = this.getDataStore().find("fa.history.fault.entry");
        if (memRoot == null) {
            System.out.println("Failed to find mem root!");
            return false;
        }
        System.out.println("Found mem root!!");
        DataElement command = this.getDataStore().localDescriptorQuery(memRoot, "fa.history.fault.entry.read.report.only");
        if (command != null) {
            System.out.println("Found command for member root!");
        } else {
            System.out.println("Faild to find hist file command!");
        }
        this.getDataStore().setAttribute(7, path);
        DataElement arg1 = this.getDataStore().createObject(command, "name", historyFileName);
        DataElement arg2 = this.getDataStore().createObject(command, "name", memberName);
        DataElement arg3 = this.getDataStore().createObject(command, "name", reportFileName);
        ArrayList<DataElement> args = new ArrayList<DataElement>();
        args.add(arg1);
        args.add(arg2);
        args.add(arg3);
        DataElement status = this.getDataStore().command(command, args, memRoot);
        String finished = null;
        while (finished == null) {
            StatusMonitor smon = StatusMonitorFactory.getInstance().getStatusMonitorFor(this.getSystem(), this.getDataStore());
            try {
                smon.waitForUpdate(status);
            }
            catch (Exception e) {
                System.out.println("Failed to wait!!");
                e.printStackTrace();
                return false;
            }
            finished = status.getAttribute(4);
            if (finished.equals("fa:done") || finished.equals("fa:failure") || finished.equals("fa:unknown")) continue;
            System.out.println("Not finished yet.... [" + finished + "]");
            finished = null;
        }
        System.out.println("name = " + status.getAttribute(2));
        System.out.println("source = " + status.getAttribute(4));
        System.out.println("done!");
        return finished.equals("fa:done");
    }

    public boolean readDataSetMember(String dataSetMemberName, String path, String localFileName) {
        if (!this.checkConnection()) {
            return false;
        }
        DataElement root = this.getDataStore().find("fa.data.set.handler");
        DataElement command = this.getDataStore().localDescriptorQuery(root, "fa.data.set.copy");
        this.getDataStore().setAttribute(7, path);
        DataElement arg1 = this.getDataStore().createObject(command, "name", dataSetMemberName);
        DataElement arg2 = this.getDataStore().createObject(command, "name", localFileName);
        ArrayList<DataElement> args = new ArrayList<DataElement>();
        args.add(arg1);
        args.add(arg2);
        DataElement status = this.getDataStore().command(command, args, root);
        String finished = null;
        while (finished == null) {
            StatusMonitor smon = StatusMonitorFactory.getInstance().getStatusMonitorFor(this.getSystem(), this.getDataStore());
            try {
                smon.waitForUpdate(status);
            }
            catch (Exception e) {
                System.out.println("Failed to wait!!");
                e.printStackTrace();
                return false;
            }
            finished = status.getAttribute(4);
            if (finished.equals("fa:done") || finished.equals("fa:failure") || finished.equals("fa:unknown")) continue;
            System.out.println("Not finished yet.... [" + finished + "]");
            finished = null;
        }
        System.out.println("name = " + status.getAttribute(2));
        System.out.println("source = " + status.getAttribute(4));
        System.out.println("done!");
        return finished.equals("fa:done");
    }

    public boolean callIDIDAWithDataSetName(String dataSetName) {
        if (!this.checkConnection()) {
            return false;
        }
        DataElement histRoot = this.getDataStore().find("fa.native.idida.interface");
        if (histRoot == null) {
            System.out.println("Failed to find hist root!");
            return false;
        }
        System.out.println("Found hist root!!");
        DataElement command = this.getDataStore().localDescriptorQuery(histRoot, "fa.native.idida.callIDIDA.with.dataset");
        if (command != null) {
            System.out.println("Found command for hist root!");
        } else {
            System.out.println("Faild to find hist file command!");
        }
        DataElement arg1 = this.getDataStore().createObject(command, "name", dataSetName);
        ArrayList<DataElement> args = new ArrayList<DataElement>();
        args.add(arg1);
        DataElement status = this.getDataStore().command(command, args, histRoot);
        StatusMonitor smon = StatusMonitorFactory.getInstance().getStatusMonitorFor(this.getSystem(), this.getDataStore());
        try {
            smon.waitForUpdate(status);
        }
        catch (Exception e) {
            System.out.println("Failed to wait!!");
            e.printStackTrace();
            return false;
        }
        System.out.println("name = " + status.getAttribute(2));
        System.out.println("source = " + status.getAttribute(4));
        System.out.println("done!");
        return true;
    }

    public boolean callIDIDAWithFaultEntryName(String faultEntryName, String histFileName) {
        if (!this.checkConnection()) {
            return false;
        }
        DataElement histRoot = this.getDataStore().find("fa.native.idida.interface");
        if (histRoot == null) {
            System.out.println("Failed to find hist root!");
            return false;
        }
        System.out.println("Found hist root!!");
        DataElement command = this.getDataStore().localDescriptorQuery(histRoot, "fa.native.idida.callIDIDA.with.fault.entry");
        if (command != null) {
            System.out.println("Found command for hist root!");
        } else {
            System.out.println("Faild to find hist file command!");
        }
        DataElement arg1 = this.getDataStore().createObject(command, "name", faultEntryName);
        DataElement arg2 = this.getDataStore().createObject(command, "name", histFileName);
        ArrayList<DataElement> args = new ArrayList<DataElement>();
        args.add(arg1);
        args.add(arg2);
        DataElement status = this.getDataStore().command(command, args, histRoot);
        StatusMonitor smon = StatusMonitorFactory.getInstance().getStatusMonitorFor(this.getSystem(), this.getDataStore());
        try {
            smon.waitForUpdate(status);
        }
        catch (Exception e) {
            System.out.println("Failed to wait!!");
            e.printStackTrace();
            return false;
        }
        System.out.println("name = " + status.getAttribute(2));
        System.out.println("source = " + status.getAttribute(4));
        System.out.println("done!");
        return true;
    }

    public boolean readISPFProfile(String localPath, String localFileName, String execName, String ispfProfDsn, String tmpDsn, String appID) {
        if (!this.checkConnection()) {
            return false;
        }
        DataElement ispfInterface = this.getDataStore().find("fa.native.ispf.interface");
        if (ispfInterface == null) {
            System.out.println("Failed to find ISPF interface root!");
            return false;
        }
        System.out.println("Found ISPF interface root");
        DataElement command = this.getDataStore().localDescriptorQuery(ispfInterface, "fa.ispf.profile.retrieve");
        if (command != null) {
            System.out.println("Found command for hist root!");
        } else {
            System.out.println("Faild to find hist file command!");
        }
        this.getDataStore().setAttribute(7, localPath);
        DataElement arg1 = this.getDataStore().createObject(command, "name", execName);
        DataElement arg2 = this.getDataStore().createObject(command, "name", ispfProfDsn);
        DataElement arg3 = this.getDataStore().createObject(command, "name", tmpDsn);
        DataElement arg4 = this.getDataStore().createObject(command, "name", appID);
        DataElement arg5 = this.getDataStore().createObject(command, "name", localFileName);
        File localFile = new File(String.valueOf(localPath) + File.separator + localFileName);
        if (localFile.exists()) {
            localFile.delete();
        }
        ArrayList<DataElement> args = new ArrayList<DataElement>();
        args.add(arg1);
        args.add(arg2);
        args.add(arg3);
        args.add(arg4);
        args.add(arg5);
        DataElement status = this.getDataStore().command(command, args, ispfInterface);
        String finished = null;
        while (finished == null) {
            StatusMonitor smon = StatusMonitorFactory.getInstance().getStatusMonitorFor(this.getSystem(), this.getDataStore());
            try {
                smon.waitForUpdate(status);
            }
            catch (Exception e) {
                System.out.println("Failed to wait!!");
                e.printStackTrace();
                return false;
            }
            finished = status.getAttribute(4);
            if (finished.equals("fa:done") || finished.equals("fa:failure") || finished.equals("fa:unknown")) continue;
            System.out.println("Not finished yet.... [" + finished + "]");
            finished = null;
        }
        System.out.println("name = " + status.getAttribute(2));
        System.out.println("source = " + status.getAttribute(4));
        System.out.println("done!");
        return finished.equals("fa:done");
    }

    public boolean readViewInformation(String viewDsn, String localPath, String localFileName) {
        if (!this.checkConnection()) {
            return false;
        }
        DataElement ispfInterface = this.getDataStore().find("fa.native.ispf.interface");
        if (ispfInterface == null) {
            System.out.println("Failed to find ISPF interface root!");
            return false;
        }
        System.out.println("Found ISPF interface root");
        DataElement command = this.getDataStore().localDescriptorQuery(ispfInterface, "fa.ispf.view.retrieve");
        if (command != null) {
            System.out.println("Found command for hist root!");
        } else {
            System.out.println("Faild to find hist file command!");
        }
        this.getDataStore().setAttribute(7, localPath);
        DataElement arg1 = this.getDataStore().createObject(command, "name", viewDsn);
        DataElement arg2 = this.getDataStore().createObject(command, "name", localFileName);
        File localFile = new File(String.valueOf(localPath) + File.separator + localFileName);
        if (localFile.exists()) {
            localFile.delete();
        }
        ArrayList<DataElement> args = new ArrayList<DataElement>();
        args.add(arg1);
        args.add(arg2);
        DataElement status = this.getDataStore().command(command, args, ispfInterface);
        String finished = null;
        while (finished == null) {
            StatusMonitor smon = StatusMonitorFactory.getInstance().getStatusMonitorFor(this.getSystem(), this.getDataStore());
            try {
                smon.waitForUpdate(status);
            }
            catch (Exception e) {
                System.out.println("Failed to wait!!");
                e.printStackTrace();
                return false;
            }
            finished = status.getAttribute(4);
            if (finished.equals("fa:done") || finished.equals("fa:failure") || finished.equals("fa:unknown")) continue;
            System.out.println("Not finished yet.... [" + finished + "]");
            finished = null;
        }
        System.out.println("name = " + status.getAttribute(2));
        System.out.println("source = " + status.getAttribute(4));
        System.out.println("done!");
        return finished.equals("fa:done");
    }
}

