/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.util;

import com.ibm.etools.fa.common.Address;

public class AddressHandler {
    public static Address verifyAddress(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        if (s.length() > 8) {
            int sepIndex = s.indexOf(32);
            if (sepIndex != -1) {
                String high = s.substring(0, sepIndex);
                String low = s.substring(sepIndex + 1, s.length());
                if (high.length() > 8 || low.length() > 8) {
                    return null;
                }
                if (low.length() != 8) {
                    return null;
                }
                try {
                    long highAddrValue = Long.parseLong(high, 16);
                    long lowAddrValue = Long.parseLong(low, 16);
                    return new Address(highAddrValue, lowAddrValue);
                }
                catch (Exception exception) {
                    return null;
                }
            }
            int length = s.length();
            String high = s.substring(0, length - 8);
            String low = s.substring(length - 8, length);
            if (high.length() > 8) {
                return null;
            }
            try {
                long highAddrValue = Long.parseLong(high, 16);
                long lowAddrValue = Long.parseLong(low, 16);
                return new Address(highAddrValue, lowAddrValue);
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            long value = Long.parseLong(s, 16);
            return new Address(0L, value);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

