/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.fa.view.details.actions;

import com.ibm.etools.fa.common.HistoryIndexFileEntry;
import com.ibm.etools.fa.jobs.DownloadMinidumpJob;
import com.ibm.etools.fa.plugin.FAPlugin;
import com.ibm.etools.fa.util.EditorManagement;
import com.ibm.etools.fa.util.NLS;
import com.ibm.etools.fa.view.details.actions.DetailedViewAction;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;

public class BrowseMiniDumpActionForDetailedView
extends DetailedViewAction {
    public void run(IAction action) {
        try {
            HistoryIndexFileEntry entry = (HistoryIndexFileEntry)this.currentSelection.get(this.currentSelection.size() - 1);
            String faultID = entry.DDirHdCFaultID();
            String projPath = String.valueOf(this.detailedView.getSystemAliasName()) + File.separator + entry.getHistoryFileName() + File.separator + faultID + File.separator;
            String miniDumpFileName = String.valueOf(projPath) + faultID + ".md";
            String rptFileName = String.valueOf(projPath) + faultID + ".far";
            IFile miniDumpFile = FAPlugin.getDefault().getFile(miniDumpFileName);
            IFile reportFile = FAPlugin.getDefault().getFile(rptFileName);
            if (!miniDumpFile.exists()) {
                DownloadMinidumpJob downloadMinidumpJob = new DownloadMinidumpJob(this.detailedView.getSystemAliasName(), entry.getHistoryFileName(), faultID, miniDumpFile, reportFile, null);
                downloadMinidumpJob.runJob();
            } else {
                EditorManagement.openEditor(miniDumpFile);
            }
        }
        catch (Exception e) {
            FAPlugin.getDefault().log(4, NLS.getString("BrowseMiniDumpActionForDetailedView.ErrMsg"), e, true);
        }
    }
}

