/* Control and Diagnostics Management End header file ****************/
/*                                                                   */
/*   IBM Fault Analyzer                                              */
/*                                                                   */
/*   IBM Confidential    OCO Source Materials                        */
/*                                                                   */
/*   5655-R46                                                        */
/*   (C) Copyright IBM Corp. 2000, 2004. All rights reserved.        */
/*                                                                   */
/*   The source code for this program is not published or otherwise  */
/*   divested of its trade secrets, irrespective of what has been    */
/*   deposited with the U.S. Copyright Office.                       */
/*                                                                   */
/****************************************************************************************************************/
/*|:h3.IDICHEND.H  Control and Diagnostics Management End header file         */
/*|:p.                                                                        */
/*|This header file is designed to be included last in the #include list.     */
/*|It is used between all components, primarilary for debug definition        */
/*|and other general use macros or functions.                                 */

#include <string.h>
#include <stdlib.h>

/*********************************************************************/
/*   API Structure forward declarations                              */
/*********************************************************************/

/******************************************************************************/
/*   API Function and Structure Definitions                                   */
/******************************************************************************/

void dxprintf(char *fmt, ...); /* internally called by dprintf for debug printing*/

/*|:p.idi_error is used to signal that an internal problem has occurred       */
/*|which is likely to cause missing or incorrect analysis results.            */
/*|When this function is called, a key item named IDI_ERROR is                */
/*|created, containing the passed text.  The existence of this key            */
/*|name will cause a warning to be written to the analysis report.            */
/*|Further, if ZZDEBUG is in effect, a dprintf is written and also            */
/*|the IDI_ERROR key items are listed at the top of the analysis              */
/*|report.                                                                    */
/*|:xmp.                                                                      */
void idi_error(int severity, char *fmt, ...);
/*|:exmp.                                                                     */

/* structures for LE/MVS stack searching */
#ifdef __cplusplus
extern "builtin"
#else
  #ifndef gdsabuiltin
    #pragma linkage(_gdsa,builtin)
    #define gdsabuiltin 1
  #endif
#endif
int* _gdsa();

#define DIF if (opts.debug[0] != '\0')
#define XIF if (opts.debug[0] == '*' || strchr(opts.debug,compidc))

#define IDI_ERROR {                                       \
  int dpi = 0 ;                                           \
  void *pdsa = (void*)(*((int*)_gdsa()+1)) ;              \
  for ( ; pdsa !=0 && pdsa!=opts.maindsaback ; dpi++ )    \
    pdsa = (void*)(*( (int*)pdsa+1) ) ;                   \
  strcpy(error_file, __FILE__);                           \
  error_line = __LINE__;                                  \
  if (opts.debug[0]) printf("%2d ", dpi);                 \
} idi_error

#define dprintf DIF { \
   char *pfx; \
   char *pf = (pfx = strrchr(__FILE__, '/')) ? pfx : __FILE__; \
   int dpi = 0 ;                                           \
   void *pdsa = (void*)(*((int*)_gdsa()+1)) ;              \
   for ( ; pdsa !=0 && pdsa!=opts.maindsaback ; dpi++ )    \
     pdsa = (void*)(*( (int*)pdsa+1) ) ;                   \
   dodxprintf = 1 ;                                        \
   printf("%2d %s :%4.4d ",dpi,pf,__LINE__); } dxprintf

#define xprintf XIF { \
   char *pfx; \
   char *pf = (pfx = strrchr(__FILE__, '/')) ? pfx : __FILE__; \
   int dpi = 0 ;                                           \
   void *pdsa = (void*)(*((int*)_gdsa()+1)) ;              \
   for ( ; pdsa !=0 && pdsa!=opts.maindsaback ; dpi++ )    \
     pdsa = (void*)(*( (int*)pdsa+1) ) ;                   \
   dodxprintf = 1 ;                                        \
   printf("%2d %s :%4.4d ",dpi,pf,__LINE__); } dxprintf

/*|:p.                                                                        */
/*|The dprintf() function takes the same arguments as the                     */
/*|standard dprintf() function.  It has the advantage of providing            */
/*|the file and line from which it is called, plus is part of the DEBUG()     */
/*|option providing dynamic control over the output for each component.       */
/*|:note.dprintf() expands to multipul statements an so may upset your        */
/*|apparent logic on if, else, constructs, unless you enclose it within       */
/*|curly brackets.                                                            */
/*| :xmp.                                                                     */
/*|                                                                           */
/*|void  ddump(void *addr, int length, char *title );                         */
/*|                                                                           */
/*| :exmp.                                                                    */
/*|The ddump() dynamically dumps from addr for length with title.             */
/*|It is conditioned by the DEBUG()                                           */
/*|option providing dynamic control over the output for each component.       */

void  DXDUMP(void *addr, int length, char *title, char *file, int line );

#define ddump(addr,length,title) { \
   char *pfx; \
   char *pf = (pfx = strrchr(__FILE__, '/')) ? pfx : __FILE__; \
  if(opts.debug[0]!= '\0') \
  DXDUMP( addr, length, title, pf, __LINE__ ); }

#define xdump(addr,length,title) { \
   char *pfx; \
   char *pf = (pfx = strrchr(__FILE__, '/')) ? pfx : __FILE__; \
  if(opts.debug[0]=='*' || strchr( opts.debug,compidc)) \
  DXDUMP( addr, length, title, pf, __LINE__ ); }

/*| :xmp.                                                                     */
/*|                                                                           */
/*|void  dldump(void *addr, int length, char *title );                        */
/*|                                                                           */
/*| :exmp.                                                                    */
/*|The dldump() dynamically dumps from logical addr for length with title.    */
/*|The Logical address is the original address not the malloc'd address.      */
/*|It is conditioned by the DEBUG()                                           */
/*|option providing dynamic control over the output for each component.       */

void  DXLDUMP(void *addr, int length, char *title, char *file, int line );

#define dldump(addr,length,title) { \
   char *pfx; \
   char *pf = (pfx = strrchr(__FILE__, '/')) ? pfx : __FILE__; \
  if(opts.debug[0]!= '\0') \
  DXLDUMP( addr, length, title, pf, __LINE__ ); }

/*|:h4.COPYSTRING and COPYDATA macros                                */
/*|COPYSTRING works with pointers to zero terminated strings.        */
/*|The target string pointer should initially contain zero or a      */
/*|pointer to a previous allocation that will be realloc()'ed.       */
/*|COPYDATA is similar to COPYSTRING but needs a source length input.*/
/*|The macros look after the target storage allocation.              */
#if 0
/*|:xmp.                                                             */

COPYSTRING(pString,Source) ;    // pString is a pointer to char, Source is zero terminated

COPYDATA(pData,Source,length) ; // pData is pointer to char, Source is length long.

/*|:exmp.                                                            */
#endif
#define COPYSTRING(psztarget,pszsource)  \
        psztarget = strcpy(realloc(psztarget,strlen(pszsource)+1),pszsource)
#define COPYDATA(ptarget,psource,length)  \
        ptarget = memcpy(realloc(ptarget,length),psource,length)

/*|:h4.Memory allocation macros                                      */
/*|:p.The following preprocessor directives facilitate transparent   */
/*|replacement of the memory allocation library functions malloc(),  */
/*|calloc() and realloc() and free() by the macros to call           */
/*|CMALLOC() CCALLOC() CREALLOC() ) and CFREE().  Upper case         */
/*|is used to facilitate unambiguous call from assembler regardless  */
/*|of mixed case or longname compile and link situations.            */
/*|The upper C* functions call the original LE memory allocation     */
/*|library function through standard libvec and prelink/link         */
/*|mechanism. the calls to malloc etc. in this function are          */
/*|enclosed in parentheses to stop the recursive macro call.         */
/*|:nt.If dbgheap.h is used, it must be included before this header  */
/*|file (which should always be the last included header file        */
/*|anyway).  The macros automatically check that memory was available*/
/*|for the allocation request, providing a diagnostic message on     */
/*|failure of the allocation and so remove this requirement from     */
/*|the open code.  They are placed here in the API section for       */
/*|understanding only, no code change is required to use them.       */
/*|:ent.                                                             */
/*|:xmp.                                                             */
#define malloc(size)       CMALLOC(size, __FILE__, __LINE__)
#define calloc(num, size)  CCALLOC(num, size, __FILE__, __LINE__)
#define realloc(ptr, size) CREALLOC(ptr, size, __FILE__, __LINE__)
//#define free(ptr)          CFREE(ptr, __FILE__, __LINE__)
/*|:exmp.                                                            */

void *CMALLOC(size_t, char *, int);
void *CCALLOC(size_t, size_t, char *, int);
void *CREALLOC(void *, size_t, char *, int);
void  CFREE(void *, char *, int);

/*|:h4.C File management macros                                      */
/*|:p.The following preprocessor directives facilitate transparent   */
/*|replacement of the c-runtime main file I/O calls for tracing and  */
/*|export caching. fopen() fclose() fread() and fwrite() are traced. */
#ifdef fopen
  #undef fopen
#endif
#ifdef fclose
  #undef fclose
#endif
#ifdef fread
  #undef fread
#endif
#ifdef fwrite
  #undef fwrite
#endif
FILE    *fxopen( const char *dataset, const char *mode, char *file, int line) ;
int      fxclose( FILE *fp, char *file, int line) ;
size_t   fxread( void *buf, size_t size, size_t rept, FILE *fp, char *file, int line) ;
size_t   fxwrite( const void *buf, size_t size, size_t rept, FILE *fp, char *file, int line) ;
/*|:xmp.                                                             */
#define  fopen( file, mode) \
         fxopen(file, mode, __FILE__, __LINE__)
#define  fclose( fp ) \
         fxclose(fp , __FILE__, __LINE__)
#define  fread( buf, size, rept, fp ) \
         fxread(buf, size, rept, fp, __FILE__, __LINE__ )
#define  fwrite( buf, size, rept, fp) \
         fxwrite(buf, size, rept, fp, __FILE__, __LINE__)
/*|:exmp.                                                            */

#ifdef memmove
  #undef memmove
#endif
#define memmove(to,from,length) xmemmove(to,from,length)
void * xmemmove (void *to, const void *from, size_t size) ;
