/* API header Dump Dictionary and Navigation *************************/
/*                                                                   */
/*   IBM Fault Analyzer                                              */
/*                                                                   */
/*   IBM Confidential    OCO Source Materials                        */
/*                                                                   */
/*   5655-R46                                                        */
/*   (C) Copyright IBM Corp. 2000, 2005. All rights reserved.        */
/*                                                                   */
/*   The source code for this program is not published or otherwise  */
/*   divested of its trade secrets, irrespective of what has been    */
/*   deposited with the U.S. Copyright Office.                       */
/*                                                                   */
/****************************************************************************************************************/
/*|:h3.IDIIH.H                                                       */
 
#define HDSPEye 0x0808CEE0
 
/*********************************************************************/
/*   API Structure forward declarations                              */
/*********************************************************************/
struct IANCHOR ;
typedef struct IANCHOR IANCHOR ;
struct ICUDATA ;
typedef struct ICUDATA ICUDATA ;
struct SF ;
typedef struct SF SF ;
 
/******************************************************************************/
/*   API Function and Structure Definitions                                   */
/******************************************************************************/
/*********************************************************************/
/*|:h4.IDadd()                                                       */
/*|IDadd() adds ID information to the Dump Dictionary.               */
/*|The add and mod functions of Dump Dictionary,                     */
/*|take copies of the data passed as string and address data.        */
/*|If an IDadd() would create an ID of the same name and same address*/
/*|as an existing IANCHOR, the IDadd() is internally converted to    */
/*|an IDmod() preventing duplication of IANCHORs with the same       */
/*|name and address.                                                 */
/*|:xmp.*/
/*| */
/*|IANCHOR *IDadd(char *ID, int address, int length, char *modelname, char *author) ; */
/*| */
/*|:exmp.*/
IANCHOR *IDadd(char *ID, int address, int length, char *modelname, char *author, char *file, int line) ;
#define  IDadd( ID, address, length, modelname, author) \
         IDadd( ID, address, length, modelname, author, __FILE__, __LINE__)
 
/*********************************************************************/
/*|:h4.IDaddDup()                                                    */
/*|IDaddDup() adds a Duplicate ID at the same address to the         */
/*|thus deliberatly defeating the IDmod conversion that would        */
/*|normally happen.  The caller is responsible for insuring the      */
/*|duplicate is really required.  Current usage is only for IANCHORs */
/*|where COBOL BLL banes were duplicating but unique parent pointers */
/*|where required.                                                   */
/*|:xmp.*/
/*| */
/*|IANCHOR *IDaddDup( IANCHOR *pID, char *file, int line) ;          */
/*| */
/*|:exmp.*/
IANCHOR *IDaddDup( IANCHOR *pID, char *file, int line) ;
#define  IDaddDup( pID) \
         IDaddDup( pID, __FILE__, __LINE__)
 
 
/*********************************************************************/
/*|:h4.IDmod()                                                       */
/*|IDmod() modifies existing Dictionary ID information in an         */
/*|IANCHOR.  Use -1 in the length field to show a new value is not   */
/*|supplied, in other fields null indicates no new value.            */
/*|:xmp.*/
/*|  */
/*|IANCHOR *IDmod( IANCHOR *original, int length, IANCHOR *parent, int typeword, int typeword2, IANCHOR *hparent);
/*|  */
/*|  IANCHOR *original ;  \* IANCHOR address to be modifyed */
/*|  int      length ;    \* length of item, or null if not known */
/*|  IANCHOR *parent;     \* parent IANCHOR (eg. CSECT parent is Load Module i.e it 'contains' the CSECT) */
/*|  int      typeword;   \* word for specific use by the type, MODULE' uses this for load segment base offset */
/*|                       \* CSECT' and EP' set typeword to MemId (LE member language)defined IDIIH.H & prodtabl*/
/*|  int      typeword2;  \* second word for specific use by the type, CSECT' uses this for LANGX information */
/*|  IANCHOR *hparent;    \* hierarchal parent IANCHOR (normally used by the CICS system abend scripts and ISPF)*/
/*|  */
/*|:exmp.*/
IANCHOR *IDmod( IANCHOR *original, int length, IANCHOR *parent, int typeword, int typeword2, IANCHOR *hparent,
        char *file, int line);
#define  IDmod( original, length, parent, typeword, typeword2, hparent) \
         IDmod( original, length, parent, typeword, typeword2, hparent, __FILE__, __LINE__)
 
 
/******************************************************************************/
/*|:h4.IDlocate()                                                             */
/*|The IDlocate() call is used to ask Dump Dictionary and                     */
/*|Navigation to locate and return a control block or area from the dump.     */
/*|:xmp.                                                                      */
/*|                                                                           */
/*|IANCHOR *IDlocate(char *ID) ;                                              */
/*|                                                                           */
/*|:exmp.                                                                     */
/*|The IDlocate call returns a pointer to the IANCHOR found if successful,    */
/*|zero if if the request is not found and -ve values to report               */
/*|more complex error codes.  The IANCHOR is a structure that                 */
/*|anchors the data from the dump.  It contains additional                    */
/*|information such as the length, address in the dump, type of data          */
/*|such as CSECT etc..  These IANCHORs may be chained                         */
/*|together by their 'FullDup', 'GenDup' or 'AddrDup' entries.                */
/*|Full IDs have a quoted suffix, generic keys have no suffix.                */
/*|The generic key is the key excluding any                                   */
/*|quote (') and suffix portion of the key, or the whole key when there is    */
/*|no suffix.  When IDLocate() is call from a script selection or execution   */
/*|it implecitly sets up notify linkages that insures the script is           */
/*|re-dispatched if the ID's for which it has issued IDLocat are created      */
/*|or altered.                                                                */
IANCHOR *IDlocate(char *ID, char *file, int line) ;
#define  IDlocate( ID) \
         IDlocate( ID, __FILE__, __LINE__)
 
/*****************************************************************************/
/*|:h4.DumpLocate()                                                          */
/*|The DumpLocate() call accepts a character string containing dictionary    */
/*|names, field offsets and pointer notation so that a chain of addresses    */
/*|can be traversed. It returns the logical address for the area at the end  */
/*|of the chain.                                                             */
/*|chain.                                                                    */
/*|:xmp.                                                                     */
/*|                                                                          */
/*|int DumpLocate(int startaddr, char *string) ;                             */
/*|                                                                          */
/*|:exmp.                                                                    */
int     DumpLocate(int startaddr, char *string, char *file, int line) ;
#define DumpLocate( startaddr, string) \
        DumpLocate( startaddr, string, __FILE__, __LINE__)
 
 
/*****************************************************************************/
/*|:h4.MFoffset()                                                            */
/*|Supplied a model and field name, return the field offset or -1            */
/*|:xmp.                                                                     */
/*|int MFoffset( char *model, char *field) ;*/
/*|:exmp.                                                                    */
int     MFoffset( char *model, char *field, char*file, int line) ;
#define MFoffset( model, field) \
        MFoffset( model, field, __FILE__, __LINE__)
 
/*****************************************************************************/
/*|:h4.AFoffset()                                                            */
/*|Supplied an address and field name, return the field offset or -1         */
/*|The address must have an IANCHOR mapped that includes the model name.     */
/*|:xmp.                                                                     */
/*|int AFoffset( int addr, char *field) ;*/
/*|:exmp.                                                                    */
int     AFoffset( int addr, char *field, char *file, int line) ;
#define AFoffset( addr, field) \
        AFoffset( addr, field, __FILE__, __LINE__)
 
/*********************************************************************************/
/*|:h4.MFlength()                                                                */
/*|MFlength has Model and Field input to return length.                          */
/*|Returns 0 for error or not available                                          */
/*|Field input of pointer to null means get the model length.                    */
/*|:xmp.                                                                         */
/*|int MFlength( char *model, char *field) ;*/
/*|:exmp.                                                                        */
int     MFlength( char *model, char *field, char *file, int line) ;
#define MFlength( model, field) \
        MFlength( model, field, __FILE__, __LINE__)
 
/*********************************************************************************/
/*|:h4.AFlength()                                                                */
/*|AFlength has Address and Field input to return length.  The address must      */
/*|have a IANCHOR with a model name.  Returns 0 for error or not available.      */
/*|Field input of pointer to null means get the model length.                    */
/*|:xmp.                                                                         */
/*|int AFlength( int addr, char *field) ;*/
/*|:exmp.                                                                        */
int     AFlength( int addr, char *field, char *file, int line) ;
#define AFlength( addr, field) \
        AFlength( addr, field, __FILE__, __LINE__)
 
/*********************************************************************************/
/*|:h4.MFdescription()                                                           */
/*|MFdescription has Model and Field input to return description.                */
/*|Returns pointer to null if error or not available.                            */
/*|Field input of pointer to null means get the model description.               */
/*|:xmp.                                                                         */
/*|char *MFdescription( char *model, char *field) ;*/
/*|:exmp.                                                                        */
char   *MFdescription( char *model, char *field, char *file, int line) ;
#define MFdescription( model, field) \
        MFdescription( model, field, __FILE__, __LINE__)
 
/**************************************************************************************/
/*|:h4.AFdescription()                                                                */
/*|AFdescription has Address and Field input to return description.  The address must */
/*|have a IANCHOR with a model name.  Returns ptr to null for error or not available. */
/*|Field input of pointer to null means get the model description.                    */
/*|:xmp.                                                                              */
/*|char *AFdescription( int addr, char *field) ;*/
/*|:exmp.                                                                             */
char   *AFdescription( int addr, char *field, char *file, int line) ;
#define AFdescription( addr, field) \
        AFdescription( addr, field, __FILE__, __LINE__)
 
/**************************************************************************************/
/*|:h4.MFattribute()                                                                  */
/*|MFattribute has Model and Field input to return attribute.                         */
/*|Returns pointer to null if error or not available.                                 */
/*|Field input of pointer to null means get the model attribute.                      */
/**************************************************************************************/
/*|:xmp.                                                                              */
/*|char *MFattribute( char *model, char *field) ;*/
/*|:exmp.                                                                             */
char   *MFattribute( char *model, char *field, char *file, int line) ;
#define MFattribute( model, field) \
        MFattribute( model, field, __FILE__, __LINE__)
 
/**************************************************************************************/
/*|:h4.AFattribute()                                                                  */
/*|AFattribute has Address and Field input to return attribute.  The address must     */
/*|have a IANCHOR with a model name.  Returns ptr to null for error or not available. */
/*|Field input of pointer to null means get the model attribute.                      */
/**************************************************************************************/
/*|:xmp.                                                                              */
/*|char *AFattribute( int addr, char *field) ;*/
/*|:exmp.                                                                             */
char   *AFattribute( int addr, char *field, char *file, int line) ;
#define AFattribute( addr, field) \
        AFattribute( addr, field, __FILE__, __LINE__)
 
/**************************************************************************************/
/*|:h4.getMfields()                                                                   */
/*|getMfields returns a space delimited null terminated string to be freed by the     */
/*|caller containg the field names from the model, in offset order.                   */
/**************************************************************************************/
/*|:xmp.                                                                              */
/*|char *getMfields( char *model) ;*/
/*|:exmp.                                                                             */
char   *getMfields( char *model, char *file, int line) ;
#define getMfields( model) \
        getMfields( model, __FILE__, __LINE__)
 
/**************************************************************************************/
/*|:h4.AFlocate()                                                                     */
/*|AFlocate has Address and Field input to return the malloc'd address of the field.  */
/*|The address must have a IANCHOR with a model name.  Returns null ptr for error.    */
/**************************************************************************************/
/*|:xmp.                                                                              */
/*|char *AFlocate( int addr, char *field) ;*/
/*|:exmp.                                                                             */
char   *AFlocate( int addr, char *field, char *file, int line) ;
#define AFlocate( addr, field) \
        AFlocate( addr, field, __FILE__, __LINE__)
 
/**************************************************************************************/
/*|:h4.IFlocate()                                                                     */
/*|IFlocate has Dictionary name and Field input to return the malloc'd address of the */
/*|field. The first IANCHOR with name is used. Returns null ptr for error.            */
/**************************************************************************************/
/*|:xmp.                                                                              */
/*|char *IFlocate( char *name, char *field) ;*/
/*|:exmp.                                                                             */
char   *IFlocate( char *name, char *field, char *file, int line) ;
#define IFlocate( name, field) \
        IFlocate( name, field, __FILE__, __LINE__)
 
/*********************************************************************************/
/*|:h4.dumpMF()                                                                  */
/*|dumpMF() is called at the end of processing to see if the model and field     */
/*|data needs to be dumped.  This is only something we do din a development      */
/*|phase to build new model data from online SYSLOGIC or from an input merge.    */
/*|:xmp.                                                                         */
void dumpMF( void) ;
/*|:exmp.                                                                        */
 
/*********************************************************************/
/*|:h4.WhereAmI()                                                    */
/*|WhereAmI returns the IANCHOR with an equal virtual dump address,  */
/*|or the IANCHOR with the closest dump address in the lower         */
/*|(towards zero) direction, to the logical dump address passed.     */
/*|The IANCHOR pointer that is returned must be checked by the       */
/*|caller for its applicability to the address passed.  If there is  */
/*|more than on IANCHOR with the same dump address, the IANCHOR will */
/*|have the 'same address' IANCHORS chained from its AddrDup field.  */
/*|:p.The user should, as a minimum, check that the address that is  */
/*|searched for is within the length indicated in the IANCHOR.       */
/*|:xmp.*/
/*|  */
/*|IANCHOR *WhereAmI(int addr) ;                                     */
/*|  */
/*|:exmp.*/
IANCHOR *WhereAmI(int addr, char *file, int line) ;
#define  WhereAmI( addr) \
         WhereAmI( addr, __FILE__, __LINE__)
 
/*********************************************************************/
/*|:h4.WhatsNext()                                                   */
/*|WhatsNext returns the IANCHOR with a virtual dump address,        */
/*|at least one byte higher than the address passed.                 */
/*|It is effectivly an ID scan in the opposite direction to WhereAmI.*/
/*|:xmp.*/
/*|  */
/*|IANCHOR *WhatsNext(int addr) ;                                    */
/*|  */
/*|:exmp.*/
IANCHOR *WhatsNext(int addr, char *file, int line) ;
#define  WhatsNext( addr) \
         WhatsNext( addr, __FILE__, __LINE__)
 
/*|:exmp.*/
/******************************************************************************/
/*|:h4.dumpID()                                                      */
/*|:p.                                                                        */
/*|The dumpID() function (macro), dumps Dictionary Informatin IANCHOR structures.*/
/*|It is conditioned by the DEBUG() option providing dynamic control over     */
/*|the output for each component.  It dumps just the IANCHOR address          */
/*|passed, or all Dictionary data if a null arguement is passed.              */
/*|:xmp.                                                                      */
/*|                                                                           */
/*|void dumpID( IANCHOR *ID );                                                */
/*|                                                                           */
/*|:exmp.                                                                     */
 
void  dumpxID( IANCHOR *id, char *file, int line );
 
#define dumpID(id) { \
  if(opts.debug[0]!= '\0') \
    dumpxID( id, __FILE__, __LINE__ ); }
 
 
 
/*****************************************************************************/
/*|:h4.LEDSAChk()                                                    */
/*|:p.LEDSAChk() is passed the address of a DSA. It checks whether the DSA   */
/*|is an LE Stack Frame and is therefore owned by an LE-enabled compile unit.*/
/*|If so it extracts information identifying the compile unit and returns    */
/*|this to the caller.                                                       */
/*|:xmp.*/
 
ICUDATA *LEDSAChk(int DSAptr) ;
 
/*|:exmp.*/
/*****************************************************************************/
/*|:h4.LECSECTChk()                                                  */
/*|:p.LECSECTChk() is passed the address of a CSECT IANCHOR. It checks the   */
/*|CSECT is for an LE-enabled program. If so, it extracts information        */
/*|identifying the compile unit and returns this to the caller.              */
/*|:xmp.*/
 
ICUDATA *LECSECTChk(IANCHOR *pIA) ;
 
/*|:exmp.*/
/*|:h4.LECuData()                                                    */
/*|:p.This internal function is passed an Entry Point address and a  */
/*|pointer to an ICUDATA structure.  It checks whether the Entry     */
/*|Point is for an program recognised by LE.  If so, it fills out    */
/*|the ICUDATA structure with information from the PPAs identifying  */
/*|the program.                                                      */
/*|:xmp.*/
 
int LECuData(int ep, ICUDATA *pCU);
 
/*|:exmp.*/
/*|:xmp.*/
struct     IANCHOR {   /* header for dump storage */
  IANCHOR *FullDup ;   /* next IANCHOR in chain if duplicates, self if only entry */
  IANCHOR *GenDup ;    /* next IANCHOR in chain if generic duplicates, self if only entry */
  char    *ID ;        /* Dictionary entry name, pointer to null terminated string */
  int      address ;   /* original dump address of item or -1 for a shadow entry */
  int      length ;    /* length of item, or null if not known */
  char    *modelname ; /* null or pointer to IPCS model name that can map this area */
  int      event ;     /* alteration event number */
  char    *author;     /* pointer to string with name of function providing ID/address */
  GARRAY  *notify;     /* null or pointer to notify array */
  IANCHOR *parent;     /* parent IANCHOR (eg. CSECT parent is Load Module i.e it 'contains' the CSECT) */
  IANCHOR *AddrDup ;   /* next IANCHOR in chain if address duplicates, self if only entry */
  int      typeword;   /* word for specific use by the type, MODULE' uses this for load segment base offset */
                       /* CSECT' and EP' set typeword to MemId (LE member language) defined IDIIH.H & prodtable */
  int      typeword2;  /* second word for specific use by the type, CSECT' uses this for LANGX information */
  IANCHOR *hparent;    /* hierarchal parent IANCHOR (normally used by the CICS system abend scripts and ISPF) */
  void    *PPfunction; /* Panel processing multi-use function pointer, or Panel Key Name if PPkn is on */
  char    *description;/* may have a pointer to a descriptive string for this area of storage. */
  int      elements;   /* the number of elements in the array of which this IANCHOR describes element zero */
  int      PPkn:1;     /* flag to set use of PPfunction to Key Name pointer if PPkn is on */
} ;
/*|:exmp.*/
 
/*|:xmp.*/
struct    ICUDATA {     /* Compile Unit data structure                                    */
  int     MemId ;       /* Member Language Id                                             */
  char   *CUName ;      /* Compile Unit name                                              */
  int     CUAddr ;      /* Start of Compile Unit                                          */
  char   *EPName ;      /* Entry Point name                                               */
  int     EPAddr ;      /* Entry Point address                                            */
  char   *ServLvl;      /* Service Level                                                  */
  char    CDate[8];     /* Compilation date (YYYYMMDD)                                    */
  char    CTime[6];     /* Compilation time (HHMMSS)                                      */
  int     UserCode : 2; /* 0=Unknown  1=User Code  2=Library Routine                      */
} ;
/*|:exmp.*/
 
/* Member language identifiers                                                            */
/* Values less than MEMUNKNOWN are LE and are from the PPA2                               */
/* Values greater than MEMUNKNOWN are NON-LE and are set by scripts.                      */
#define MEMLE      0x01 /* Language Environment (CEL)                                     */
#define MEMCC      0x03 /* OS/390 C/C++                                                   */
#define MEMCOBOL   0x05 /* COBOL for OS/390 & VM                                          */
#define MEMDT      0x06 /* Debug Tool                                                     */
#define MEMFORT    0x07 /* VS FORTRAN                                                     */
#define MEMDCE     0x08 /* DCE                                                            */
#define MEMPLI     0x0A /* PL/I for MVS & VM                                              */
#define MEMEPLI    0x0B /* Enterprise PL/I for z/OS                                       */
#define MEMOES     0x0C /* OpenEdition Sockets                                            */
#define MEMASM     0x0F /* Assembler                                                      */
#define MEMUNKNOWN 0xF0 /* Unknown Language                                               */
#define MEMCOB2    0xF1 /* COBOL II                                                       */
#define MEMOSVSCOB 0xF2 /* OS/VS COBOL                                                    */
 
/********************************************************************/
/* Language Environment stack frame                                 */
/********************************************************************/
struct SF {
  union {
    char          _Cff0;          /* Flag Byte 0                 */
    struct {
     unsigned    _Cfdsa:1;        /* 0 = DSA in LWS              */
     unsigned    _Cfoncell:1;     /* 0 = No ON Cells             */
     unsigned    _Cfdynonc:1;     /* 0 = No Dynamic ONCBs        */
     unsigned    _Cfcdsa:1;       /* 1 = C DSA                   */
     unsigned    _Cftype:2;       /* 00 = Procedure DSA          */
                                  /* 01 = Begin DSA              */
                                  /* 10 = Library DSA            */
                                  /* 11 = On-unit DSA            */
     unsigned    _Cfdummy:1;      /* 0 = Not a dummy DSA         */
     unsigned    _Cfsub:1;        /* 0 = Not a subtask dummy DSA */
    } Cff0s;                      /* Flag Byte 0 - structure     */
  } Cff0u;                        /* Flag Byte 0 - union         */
  struct {
    unsigned    Cfcm:1;           /* Byte CFFC is meaningful     */
    unsigned    Crnb:1;           /* Restore NAB on GOTO         */
    unsigned    Crce:1;           /* Restore curr-enable on GOTO */
    unsigned    Covr:1;           /* Callee can use this DSA     */
    unsigned    Cgto:1;           /* EXIT DSA                    */
    unsigned    Csnt:1;           /* Statement # table exists    */
    unsigned    Csye:1;           /* Sysprint enqed by this block*/
    unsigned    Cffb:1;           /* Flags in Flags 2 are valid  */
  } Cff1;                         /* Flag Byte 1                 */
  char           Cff2;            /* Flag Byte 2                 */
  char           Cff3;            /* Flag Byte 3                 */
  SF            *Cchb;            /* Save area backchain address */
  char          *Cchbx;           /* Unused                      */
  char          *Crsa[15];        /* Register Save Area  (14-12) */
  char          *Clws;            /* A(LWS)                      */
  char          *Cnab;            /* NAB                         */
  char          *Capp;            /* A(TTA)                      */
 /*******************************************************************/
 /*                                                                 */
 /*    Block Enable bits.                                           */
 /*                                                                 */
 /*******************************************************************/
    struct {
      unsigned Cecchk:1;            /* CHECK disabled               */
      unsigned Ceczod:1;            /* ZERODIVIDE disabled          */
      unsigned Cecfov:1;            /* FIXEDOVERFLOW disabled       */
      unsigned Cecsiz:1;            /* SIZE disabled                */
      unsigned Ceccnv:1;            /* CONVERSION disabled          */
      unsigned Cecovf:1;            /* OVERFLOW disabled            */
      unsigned Cecufl:1;            /* UNDERFLOW disabled           */
      unsigned Cecssz:1;            /* STRINGSIZE disabled          */
      unsigned Cecstr:1;            /* STRINGRANGE disabled         */
      unsigned Cecsub:1;            /* SUBSCRIPTRANGE disabled      */
      unsigned Cfill7:6;            /* Reserved                     */
    } Cena;
 /*******************************************************************/
 /*                                                                 */
 /*   Current enable bits.                                          */
 /*                                                                 */
 /*******************************************************************/
    struct {
      unsigned  Cecchk:1;        /* CHECK disabled               */
      unsigned  Ceczod:1;        /* ZERODIVIDE disabled          */
      unsigned  Cecfov:1;        /* FIXEDOVERFLOW disabled       */
      unsigned  Cecsiz:1;        /* SIZE disabled                */
      unsigned  Ceccnv:1;        /* CONVERSION disabled          */
      unsigned  Cecovf:1;        /* OVERFLOW disabled            */
      unsigned  Cecufl:1;        /* UNDERFLOW disabled           */
      unsigned  Cecssz:1;        /* STRINGSIZE disabled          */
      unsigned  Cecstr:1;        /* STRINGRANGE disabled         */
      unsigned  Cecsub:1;        /* SUBSCRIPTRANGE disabled      */
      unsigned  Cfill9:6;        /* Reserved                     */
    } Ccna;
    char         *Caad;          /* A(ATTACHING DSA) IN dummy   */
    char         *Cson;          /* A(FIRST STATIC ONCB)        */
    char         *Cdon;          /* A(LATEST DYNAMIC ONCB)      */
    char         *Cdhhsave;      /* Reg 12 saved by hkhndlr     */
    char         Cxx001[4];      /* Reserved                    */
    unsigned     Cinv;           /* INVOCATION count (CHKR)     */
    char         *Caoc;          /* A(ON CELLS)                 */
    char         Comp;           /* COMPILER ID IF CIMP IS SET  */
    char         Cxx002;         /* IMPLEMENTATION DEFINED      */
    struct {                     /* Flag Byte 2                 */
      unsigned   C2ld:1;         /* Last PL/1 DSA               */
      unsigned   C2id:1;         /* Ignore DSA for SNAP         */
      unsigned   C2in:1;         /* ILC DSA after interrupt     */
      unsigned   C2ic:1;         /* Invocation count in this DSA*/
      unsigned   C2sy:1;         /* Symbolic dump for this DSA  */
      unsigned   C2fl:1;         /* There are TSO line numbers  */
      unsigned   C2fws:1;        /* VERSION 2 Indicator         */
      unsigned   Res1:1;         /* Not used                    */
    } Cff2x;                     /* Flag Byte 2                 */
    char  Cffc;                  /* CONTROL TASK FLAGS          */
    char *ParmList;              /* parameter list (saved)      */
} ;
 
#define Cff0            Cff0u._Cff0
#define Cfdsa           Cff0u.Cff0s._Cfdsa
#define Cfoncell        Cff0u.Cff0s._Cfoncell
#define Cfdynonc        Cff0u.Cff0s._Cfdynonc
#define Cfcdsa          Cff0u.Cff0s._Cfcdsa
#define Cftype          Cff0u.Cff0s._Cftype
#define Cfdummy         Cff0u.Cff0s._Cfdummy
#define Cfsub           Cff0u.Cff0s._Cfsub
