/* Side File Processor ***********************************************/
/*                                                                   */
/*   IBM Fault Analyzer                                              */
/*                                                                   */
/*   IBM Confidential    OCO Source Materials                        */
/*                                                                   */
/*   5655-R46                                                        */
/*   (C) Copyright IBM Corp. 2000, 2006.  All rights reserved.       */
/*                                                                   */
/*   The source code for this program is not published or otherwise  */
/*   divested of its trade secrets, irrespective of what has been    */
/*   deposited with the U.S. Copyright Office.                       */
/*                                                                   */
/****************************************************************************************************************/
/*|:h3.IDIVSIDE.C                                                    */
/*********************************************************************/

#define FA_PC 1  // use compile option -D

#ifdef FA_PC
#define LITTLE_ENDIAN 1
#else
#define FA_PC 0
#pragma pagesize(32000)
#pragma csect(code,"IDIVSIDE")
#pragma csect(static,"IDSVSIDE")
#endif

#include <string.h>
#include <ctype.h>
#include <errno.h>

#ifdef FA_PC
#include "leawi.h"
#include "ceeedcct.h"
#else
#pragma comment (copyright, \
"Licensed Materials - Property of IBM \
5655-R46 (C) \
Copyright IBM Corp. 2000, 2005.  All Rights Reserved.      \
Us Government Users Restricted Rights - Use, duplication or \
disclosure restricted by GSA ADP Schedule Contract with \
IBM Corp.")
#include <leawi.h>
#include <ceeedcct.h>
#include <iconv.h>
#endif

#include <setjmp.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys\stat.h>

#include "idich.h"
#include "ididh.h"
#include "idihhspc.h"
#include "idikh.h"
#include "idiih.h"
#include "idixh.h"
#include "idixhseg.h"
#include "idieh.h"
#include "idiviwdb.include"
#include "idivh.h"
#include "idiph.h"
#include "idivi.include"
#include "idichusx.h"
#include "idichsub.h"
#include "idichendpc.h"
#include "idicvt.h"
#include "com_ibm_etools_fa_langx_Langx.h"

//ENV env;               /* User exit environment information */
//UEXITCOM uexitcom;     /* Common user-exit-related area */

/* defines for language listing files                                */
#define lASM      3
#define lREST     40
#define lC        41
#define lCOBOL    42
#define lPLI      43
#define lFORTRAN  44
#define lCOBOLO   45
#define lEPLI     46
#define lCPRE     5

/* defines for return values in "indic" */

#define errnon  0    /* No errors                               */
#define erreos 10    /* Already at end of source lines          */
#define errbos 11    /* Already at beginning of source lines    */
#define erruns 12    /* Request unsuccessful                    */
#define errout 13    /* Displacement outside CSECT              */
#define errnos 14    /* No source record found for displacement */
#define errlst 15    /* Listing/Langx file not found            */
#define errpof 16    /* Not point of failure module             */
#define errnex 17    /* Program name excluded                   */
#define erradd 50    /* Parameter "srcaddr" is zero             */
#define errcst 51    /* Return code error from xCsectId         */
#define erropn 52    /* IDILANGX file open error                */
#define errlan 53    /* Language not recognised                 */
#define errlod 54    /* IDILANGX Load error                     */
#define errexc 55    /* IDILANGX Execution error                */
#define errcls 56    /* IDILANGX file close error               */
#define erralx 57    /* allocation error for ddtempx            */
#define errfre 58    /* free error for ddtempx                  */
#define errlim 59    /* limit of symbol tables exceeded         */
#define errpli 60    /* PL1 hidden padding so unreliable        */
#define errali 61    /* allocation error for ddtempi            */
#define errian 62    /* error with IANCHOR passed               */
#define errnam 63    /* error locating a search name            */
#define errnsr 64    /* Source not required for real time       */
#define errall 65    /* Malloc etc failure                      */
#define errfrm 66    /* idilangx record problems                */

#define un32  _symbol_rec3_union2
#define un323 _symbol_rec3_union2._symbol_rec3_struct1._symbol_rec3_union3
#define un324 _symbol_rec3_union2._symbol_rec3_struct1._symbol_rec3_union4
#define un4sn sym_r4_size.sym_r4_numeric
#define un4sb sym_r4_size.sym_r4_bit_string
#define un4sr sym_r4_size.sym_r4_refers
#define un5sn sym_r5_size.sym_r5_numeric
#define un5sb sym_r5_size.sym_r5_bit_string
#define un5sr sym_r5_size.sym_r5_refers

struct PT ;
typedef struct PT PT ;
struct TAB;
typedef struct TAB TAB;

struct PT {                    /* Temporary proctab entries                  */
  int       ptst;              /* statement number                            */
  int       ptof;              /* offset                                      */
};

/* maxbuf is used to determine size of storage for source record     */
/* information. If it fills, further blocks of storage are obtained  */

#define maxbuf 100000

/* tabsize is the number of dataset names that can be stored for     */
/* the IDILANGX concatenation plus the appropriate LISTING/SYSADATA  */
/* concatenation.                                                    */

#define tabsize 30

/* passmark is the rating value that determines whether a dataset    */
/* is accepted or not. topmark is the highest rating possible.       */

#define promptpass 10
#define passmark 80
#define topmark  99

typedef int WDB_FUNC(short *parmptr);
#define ON             1
#define OFF            0


char      ddtempx[9];
void vInit(void );

LXCONT   *lookWDB(LOCL *loclp);
LXCONT   *StoreLangX(DSNRES *tabp, LOCL *loclp,char *progname,char *savename,XCSECT *xcsectp,
                     IANCHOR *pIACsect,int ltype);

void parseLangxFile(char* localLangxFile, char* localFile);
void openLocalLogFile(char* localLogFileName);
void writeLogMsg(char* msg);
void closeLocalLogFile();
void initEbcdic2AsciiTable();
char ebcdic2ascii(unsigned char c); 
char* ebcdicStr2asciiStr(unsigned char* asciiStr, unsigned char* ebcdicStr, int len);
FILE *localLogFile;
char ebcdic2asciiTable[256];

void openLocalLogFile(char* localLogFileName) {
	localLogFile = fopen(localLogFileName, "w");
}

void writeLogMsg(char* msg) {
	fprintf(localLogFile, msg);
	fprintf(localLogFile, "\n");
	fflush(localLogFile);
}

void closeLocalLogFile() {
	fflush(localLogFile);
	close(localLogFile);
}

void initEbcdic2AsciiTable() {
	//============== 0 - 49
	ebcdic2asciiTable[0] = 0x00;
	ebcdic2asciiTable[1] = 0x01;
	ebcdic2asciiTable[2] = 0x02;
	ebcdic2asciiTable[3] = 0x03;
	ebcdic2asciiTable[4] = 0x2E;
	ebcdic2asciiTable[5] = 0x09;
	ebcdic2asciiTable[6] = 0x2E;
	ebcdic2asciiTable[7] = 0x7F;
	ebcdic2asciiTable[8] = 0x2E;
	ebcdic2asciiTable[9] = 0x2E;

	ebcdic2asciiTable[10] = 0x2E;
	ebcdic2asciiTable[11] = 0x0B;
	ebcdic2asciiTable[12] = 0x0C;
	ebcdic2asciiTable[13] = 0x0D;
	ebcdic2asciiTable[14] = 0x0E;
	ebcdic2asciiTable[15] = 0x0F;
	ebcdic2asciiTable[16] = 0x10;
	ebcdic2asciiTable[17] = 0x11;
	ebcdic2asciiTable[18] = 0x12;
	ebcdic2asciiTable[19] = 0x13;
	
	ebcdic2asciiTable[20] = 0x2E;
	ebcdic2asciiTable[21] = 0x0A;
	ebcdic2asciiTable[22] = 0x0B;
	ebcdic2asciiTable[23] = 0x2E;
	ebcdic2asciiTable[24] = 0x18;
	ebcdic2asciiTable[25] = 0x19;
	ebcdic2asciiTable[26] = 0x2E;
	ebcdic2asciiTable[27] = 0x2E;
	ebcdic2asciiTable[28] = 0x1C;
	ebcdic2asciiTable[29] = 0x1D;
	
	ebcdic2asciiTable[30] = 0x1E;
	ebcdic2asciiTable[31] = 0x1F;
	ebcdic2asciiTable[32] = 0x2E;
	ebcdic2asciiTable[33] = 0x2E;
	ebcdic2asciiTable[34] = 0x1C;
	ebcdic2asciiTable[35] = 0x2E;
	ebcdic2asciiTable[36] = 0x2E;
	ebcdic2asciiTable[37] = 0x0A;
	ebcdic2asciiTable[38] = 0x17;
	ebcdic2asciiTable[39] = 0x1B;
	
	ebcdic2asciiTable[40] = 0x2E;
	ebcdic2asciiTable[41] = 0x2E;
	ebcdic2asciiTable[42] = 0x2E;
	ebcdic2asciiTable[43] = 0x2E;
	ebcdic2asciiTable[44] = 0x2E;
	ebcdic2asciiTable[45] = 0x05;
	ebcdic2asciiTable[46] = 0x06;
	ebcdic2asciiTable[47] = 0x07;
	ebcdic2asciiTable[48] = 0x2E;
	ebcdic2asciiTable[49] = 0x2E;
	
	// === 50 - 99
	ebcdic2asciiTable[50] = 0x16;
	ebcdic2asciiTable[51] = 0x2E;
	ebcdic2asciiTable[52] = 0x2E;
	ebcdic2asciiTable[53] = 0x2E;
	ebcdic2asciiTable[54] = 0x2E;
	ebcdic2asciiTable[55] = 0x04;
	ebcdic2asciiTable[56] = 0x2E;
	ebcdic2asciiTable[57] = 0x2E;
	ebcdic2asciiTable[58] = 0x2E;
	ebcdic2asciiTable[59] = 0x2E;

	ebcdic2asciiTable[60] = 0x14;
	ebcdic2asciiTable[61] = 0x15;
	ebcdic2asciiTable[62] = 0x2E;
	ebcdic2asciiTable[63] = 0x1A;
	ebcdic2asciiTable[64] = 0x20;
	ebcdic2asciiTable[65] = 0x2E;
	ebcdic2asciiTable[66] = 0xE2;
	ebcdic2asciiTable[67] = 0xE4;
	ebcdic2asciiTable[68] = 0xE0;
	ebcdic2asciiTable[69] = 0xE1;
	
	ebcdic2asciiTable[70] = 0xE3;
	ebcdic2asciiTable[71] = 0xE5;
	ebcdic2asciiTable[72] = 0xE7;
	ebcdic2asciiTable[73] = 0xF0;
	ebcdic2asciiTable[74] = 0xA2;
	ebcdic2asciiTable[75] = 0x2E;
	ebcdic2asciiTable[76] = 0x3C;
	ebcdic2asciiTable[77] = 0x28;
	ebcdic2asciiTable[78] = 0x2B;
	ebcdic2asciiTable[79] = 0x7C;
	
	ebcdic2asciiTable[80] = 0x26;
	ebcdic2asciiTable[81] = 0xE9;
	ebcdic2asciiTable[82] = 0xEA;
	ebcdic2asciiTable[83] = 0xEB;
	ebcdic2asciiTable[84] = 0xE8;
	ebcdic2asciiTable[85] = 0xED;
	ebcdic2asciiTable[86] = 0xEE;
	ebcdic2asciiTable[87] = 0xEF;
	ebcdic2asciiTable[88] = 0xEC;
	ebcdic2asciiTable[89] = 0xDF;
	
	ebcdic2asciiTable[90] = 0x21;
	ebcdic2asciiTable[91] = 0x24;
	ebcdic2asciiTable[92] = 0x2A;
	ebcdic2asciiTable[93] = 0x29;
	ebcdic2asciiTable[94] = 0x3B;
	ebcdic2asciiTable[95] = 0x5E;
	ebcdic2asciiTable[96] = 0x2D;
	ebcdic2asciiTable[97] = 0x2F;
	ebcdic2asciiTable[98] = 0xC2;
	ebcdic2asciiTable[99] = 0xC4;	
	
	// === 100 - 149
	ebcdic2asciiTable[100] = 0xC0;
	ebcdic2asciiTable[101] = 0xC1;
	ebcdic2asciiTable[102] = 0xC3;
	ebcdic2asciiTable[103] = 0xC5;
	ebcdic2asciiTable[104] = 0xC7;
	ebcdic2asciiTable[105] = 0xD1;
	ebcdic2asciiTable[106] = 0xA6;
	ebcdic2asciiTable[107] = 0x2C;
	ebcdic2asciiTable[108] = 0x25;
	ebcdic2asciiTable[109] = 0x5F;

	ebcdic2asciiTable[110] = 0x3E;
	ebcdic2asciiTable[111] = 0x3F;
	ebcdic2asciiTable[112] = 0xF8;
	ebcdic2asciiTable[113] = 0xC9;
	ebcdic2asciiTable[114] = 0xCA;
	ebcdic2asciiTable[115] = 0xCB;
	ebcdic2asciiTable[116] = 0xC8;
	ebcdic2asciiTable[117] = 0xCD;
	ebcdic2asciiTable[118] = 0xCE;
	ebcdic2asciiTable[119] = 0xCF;

	ebcdic2asciiTable[120] = 0xCC;
	ebcdic2asciiTable[121] = 0x5F;
	ebcdic2asciiTable[122] = 0x3A;
	ebcdic2asciiTable[123] = 0x23;
	ebcdic2asciiTable[124] = 0x40;
	ebcdic2asciiTable[125] = 0x27;
	ebcdic2asciiTable[126] = 0x3D;
	ebcdic2asciiTable[127] = 0x22;
	ebcdic2asciiTable[128] = 0xD8;
	ebcdic2asciiTable[129] = 0x61;
	
	ebcdic2asciiTable[130] = 0x62;
	ebcdic2asciiTable[131] = 0x63;
	ebcdic2asciiTable[132] = 0x64;
	ebcdic2asciiTable[133] = 0x65;
	ebcdic2asciiTable[134] = 0x66;
	ebcdic2asciiTable[135] = 0x67;
	ebcdic2asciiTable[136] = 0x68;
	ebcdic2asciiTable[137] = 0x69;
	ebcdic2asciiTable[138] = 0xAB;
	ebcdic2asciiTable[139] = 0xBB;
	
	ebcdic2asciiTable[140] = 0xF0;
	ebcdic2asciiTable[141] = 0x0D;
	ebcdic2asciiTable[142] = 0xDE;
	ebcdic2asciiTable[143] = 0xB1;
	ebcdic2asciiTable[144] = 0xB0;
	ebcdic2asciiTable[145] = 0x6A;
	ebcdic2asciiTable[146] = 0x6B;
	ebcdic2asciiTable[147] = 0x6C;
	ebcdic2asciiTable[148] = 0x6D;
	ebcdic2asciiTable[149] = 0x6E;	
	
	// 150 - 199
	ebcdic2asciiTable[150] = 0x6F;
	ebcdic2asciiTable[151] = 0x70;
	ebcdic2asciiTable[152] = 0x71;
	ebcdic2asciiTable[153] = 0x72;
	ebcdic2asciiTable[154] = 0xAA;
	ebcdic2asciiTable[155] = 0xBA;
	ebcdic2asciiTable[156] = 0xE6;
	ebcdic2asciiTable[157] = 0xB8;
	ebcdic2asciiTable[158] = 0xC6;
	ebcdic2asciiTable[159] = 0xA4;

	ebcdic2asciiTable[160] = 0xB5;
	ebcdic2asciiTable[161] = 0x7E;
	ebcdic2asciiTable[162] = 0x73;
	ebcdic2asciiTable[163] = 0x74;
	ebcdic2asciiTable[164] = 0x75;
	ebcdic2asciiTable[165] = 0x76;
	ebcdic2asciiTable[166] = 0x77;
	ebcdic2asciiTable[167] = 0x78;
	ebcdic2asciiTable[168] = 0x79;
	ebcdic2asciiTable[169] = 0x7A;
	
	ebcdic2asciiTable[170] = 0xA1;
	ebcdic2asciiTable[171] = 0xBF;
	ebcdic2asciiTable[172] = 0xD0;
	ebcdic2asciiTable[173] = 0x5B;
	ebcdic2asciiTable[174] = 0xFE;
	ebcdic2asciiTable[175] = 0xAE;
	ebcdic2asciiTable[176] = 0xAC;
	ebcdic2asciiTable[177] = 0xA3;
	ebcdic2asciiTable[178] = 0xA5;
	ebcdic2asciiTable[179] = 0x95;
	
	ebcdic2asciiTable[180] = 0xA9;
	ebcdic2asciiTable[181] = 0xA7;
	ebcdic2asciiTable[182] = 0xB6;
	ebcdic2asciiTable[183] = 0xBC;
	ebcdic2asciiTable[184] = 0xBD;
	ebcdic2asciiTable[185] = 0xBE;
	ebcdic2asciiTable[186] = 0xDD;
	ebcdic2asciiTable[187] = 0xA8;
	ebcdic2asciiTable[188] = 0xAF;
	ebcdic2asciiTable[189] = 0x5D;
	
	ebcdic2asciiTable[190] = 0x92;
	ebcdic2asciiTable[191] = 0xD7;
	ebcdic2asciiTable[192] = 0x7B;
	ebcdic2asciiTable[193] = 0x41;
	ebcdic2asciiTable[194] = 0x42;
	ebcdic2asciiTable[195] = 0x43;
	ebcdic2asciiTable[196] = 0x44;
	ebcdic2asciiTable[197] = 0x45;
	ebcdic2asciiTable[198] = 0x46;
	ebcdic2asciiTable[199] = 0x47;		
	
	// 200 - 249
	ebcdic2asciiTable[200] = 0x48;
	ebcdic2asciiTable[201] = 0x49;
	ebcdic2asciiTable[202] = 0x9B;
	ebcdic2asciiTable[203] = 0xF4;
	ebcdic2asciiTable[204] = 0xF6;
	ebcdic2asciiTable[205] = 0xF2;
	ebcdic2asciiTable[206] = 0xF3;
	ebcdic2asciiTable[207] = 0xF5;
	ebcdic2asciiTable[208] = 0x7D;
	ebcdic2asciiTable[209] = 0x4A;
	
	ebcdic2asciiTable[210] = 0x4B;
	ebcdic2asciiTable[211] = 0x4C;
	ebcdic2asciiTable[212] = 0x4D;
	ebcdic2asciiTable[213] = 0x4E;
	ebcdic2asciiTable[214] = 0x4F;
	ebcdic2asciiTable[215] = 0x50;
	ebcdic2asciiTable[216] = 0x51;
	ebcdic2asciiTable[217] = 0x52;
	ebcdic2asciiTable[218] = 0xB9;
	ebcdic2asciiTable[219] = 0xFB;
	
	ebcdic2asciiTable[220] = 0xFC;
	ebcdic2asciiTable[221] = 0xF9;
	ebcdic2asciiTable[222] = 0xFA;
	ebcdic2asciiTable[223] = 0xFF;
	ebcdic2asciiTable[224] = 0x5C;
	ebcdic2asciiTable[225] = 0xF7;
	ebcdic2asciiTable[226] = 0x53;
	ebcdic2asciiTable[227] = 0x54;
	ebcdic2asciiTable[228] = 0x55;
	ebcdic2asciiTable[229] = 0x56;
	
	ebcdic2asciiTable[230] = 0x57;
	ebcdic2asciiTable[231] = 0x58;
	ebcdic2asciiTable[232] = 0x59;
	ebcdic2asciiTable[233] = 0x5A;
	ebcdic2asciiTable[234] = 0xB2;
	ebcdic2asciiTable[235] = 0xD4;
	ebcdic2asciiTable[236] = 0xD6;
	ebcdic2asciiTable[237] = 0xD2;
	ebcdic2asciiTable[238] = 0xD3;
	ebcdic2asciiTable[239] = 0xD5;
	
	ebcdic2asciiTable[240] = 0x30;
	ebcdic2asciiTable[241] = 0x31;
	ebcdic2asciiTable[242] = 0x32;
	ebcdic2asciiTable[243] = 0x33;
	ebcdic2asciiTable[244] = 0x34;
	ebcdic2asciiTable[245] = 0x35;
	ebcdic2asciiTable[246] = 0x36;
	ebcdic2asciiTable[247] = 0x37;
	ebcdic2asciiTable[248] = 0x38;
	ebcdic2asciiTable[249] = 0x39;
	
	// === 250 - 255
	ebcdic2asciiTable[250] = 0xB3;
	ebcdic2asciiTable[251] = 0xDB;
	ebcdic2asciiTable[252] = 0xDC;
	ebcdic2asciiTable[253] = 0xD9;
	ebcdic2asciiTable[254] = 0xDA;
	
	ebcdic2asciiTable[255] = 0x2E;
}

char ebcdic2ascii(unsigned char c) {
	return ebcdic2asciiTable[c];
}

char* ebcdicStr2asciiStr(unsigned char* asciiStr, unsigned char* ebcdicStr, int len) {
	int i;
	for (i = 0; i < len; i++) {
		asciiStr[i] = ebcdic2ascii(ebcdicStr[i]);
	}
	return asciiStr;
}

//JNIEXPORT void JNICALL Java_JNITest_parse   pws test driver
JNIEXPORT void JNICALL Java_com_ibm_etools_fa_langx_Langx_parse
   (JNIEnv * env, jobject obj, jstring lxFile, jstring lFile, jstring localLogFileName) {
   jboolean iscopy;
   const char *localLangxFile;
   const char *localFile;
   const char *localLogFile;
   
   printf("entering JNI c code\n");
   localLangxFile = (*env)->GetStringUTFChars(env, lxFile, &iscopy);
   printf("localLangxFile = %s\n", localLangxFile);
   localFile = (*env)->GetStringUTFChars(env, lFile, &iscopy);
   printf("localFile = %s\n", localFile);
   localLogFile = (*env)->GetStringUTFChars(env, localLogFileName, &iscopy);
   printf("localLogFile = %s\n", localLogFile);
   initEbcdic2AsciiTable();
   openLocalLogFile(localLogFile);
   writeLogMsg("Start to process langx file...");
   parseLangxFile(localLangxFile, localFile);
   writeLogMsg("Finished processing langx file...");
   printf("exiting JNI c code\n");
   closeLocalLogFile();
}

void parseLangxFile(char* localLangxFile, char* localFile){
  LXCONT *lxcont;
  DSNRES tabp;
  LOCL locl;                    //used  to store error codes in:   loclp->indic
  char progname[256];    //looks like PDS name
  //char localFile[256];   //local file to create
  char savename[] = "";         // uses progname if this is blank
  XCSECT *xcsectp;              // parameter for StoreLangX, but not used
  IANCHOR IACsect;              // parameter for StoreLangX, address field is referenced but not used here
  int ltype = lCOBOL;
  char *cobsout;
  LXSOUR *lxs;
  int fh;
  IACsect.address = NULL;
  strcpy(progname,localLangxFile);
  //strcpy(tabp.repdsn,progname);
  //strcpy(tabp.dddsn,progname);   //not used here for pc
  printf("Start side1\n");
  vInit();

  memset(&locl, 0x00, sizeof(locl));

  lxcont = StoreLangX(&tabp, &locl, progname, savename, xcsectp, &IACsect, ltype);
  if(lxcont == NULL) {
     printf("Error: StoreLangX failed.\n");
     return -1;
  }

  if(lxcont->sourf == NULL) {
    printf("No COBOL source found \n");
    return;
  }

  printf("StoreLangX complete\n");

  fh = _open(localFile, O_RDONLY, S_IREAD);
  if(fh > 0) {
    printf("File: %s exists.\n", localFile);
    return;
  } else {
    fh = _creat(localFile, S_IREAD | S_IWRITE);
    if(fh > 0) {
      lxs = (LXSOUR*)lxcont->sourf;
      while(lxs) {
        int len, writeLen;
        writeLogMsg("Just about to call transline...");
        cobsout = transline(lxcont,lxs, &locl, 0);
        writeLogMsg("Finished calling transline...");
        len = strlen(cobsout);
        writeLen = _write(fh, cobsout, len);
        if(writeLen != len) {
           printf("write error\n");
           return;
        }
        writeLen = _write(fh, "\n", 1);
        if(writeLen != 1) {
           printf("write error\n");
           return;
        }
        lxs = lxs->sosonp;
      }
      _close(fh);
    }
  }
  lxs = (LXSOUR*)lxcont->sourf;
  while(lxs) {
    if(cobsout == NULL) {
       //printf("transline returned NULL for COBOL source.\n");
    } else {
      //printf("COBOL source: %s \n",cobsout);
    }
    lxs = lxs->sosonp;
  }
  _close(fh);
  //printf("end of main program\n");
  return;
}

/*******************************************************************/
/*******************************************************************/
/* Main program.                                                   */
/*******************************************************************/
/*******************************************************************/
int  main(int argc, char *argv[]) {
  char localLangxFile[256];
  char localFile[256];   //local file to create
  strcpy(localLangxFile,argv[1]);
  strcpy(localFile,argv[2]);
  parseLangxFile(localLangxFile, localFile);
}


/*********************************************************************/
/*|:h4.StoreLangX()                                                  */
/*|:p.StoreLangX() reads the IDILANGX file and stores the records    */
/*|for easy access to Fault Analyzer.                                */
/*|The data is stored according to the following illustration:       */
/*|:xmp.                                                             */
/*|                                                                  */
/*|  ------------------------------------------------------------    */
/*|  | Vcom area                      |firstidi|                |    */
/*|  ------------------------------------------------------------    */
/*| LXCONT                                |                          */
/*| ------------                          |                          */
/*||           |<--------------------------       Source recs        */
/*||           |         ---------------------------------------     */
/*|| sourf     |-------->| LXSOUR     | LXSOUR  |              |     */
/*||           |         |-----------------------              |     */
/*||           |         |                                     |     */
/*||           |         |                                     |     */
/*||           |         |                                     |     */
/*||           |         ---------------------------------------     */
/*||           |                                                     */
/*||           |         Symbol lookup SYLO                          */
/*||           |         -------------------     -------------       */
/*|| sylop     |-------->|id |     -|------|--->|symbol rec   |      */
/*|| syloc     |         |-----------------|     -------------       */
/*||           |         |id |     -|------|---> -------------       */
/*||           |         |-----------------|    |symbol rec   |      */
/*||           |         |id |      |   ---|--   -------------       */
/*||           |         |-----------------| |                       */
/*||           |         |                 | |                       */
/*||           |         ------------------- |                       */
/*||           |                             \/                      */
/*||           |                            MISC                     */
/*||           |                            ----      -----------    */
/*||           |   BASL                --- | 1  |--->| structure |   */
/*|| baslp-----|->---------------      |    ----      -----------    */
/*|| baslc     |  |id|BLW_0000  |      |                             */
/*||           |  ---------------      |    MISC                     */
/*||           |  |id|BLL_0000  |      |    ----      -----------    */
/*||           |  ---------------      |-->| 2  |--->| array     |   */
/*||           |  |id|BLF_0000  |      |    ----      -----------    */
/*||           |  ---------------      |                             */
/*||           |                       |    MISC                     */
/*||           |                       |    ----      -----------    */
/*||           |   AOFF                |-->| 3  |--->| Xref      |   */
/*|| aoffp-----|->---------------      |    ----      -----------    */
/*||           |  |file|line|off|      |                             */
/*||           |  ---------------      |    MISC                     */
/*||           |  |file|line|off|      |    ----      -----------    */
/*||           |  ---------------      |-->| 4  |--->| locates   |   */
/*||           |  |file|line|off|      |    ----      -----------    */
/*||           |  ---------------      |                             */
/*||           |                       |    MISC                     */
/*||           |                       |    ----      -----------    */
/*||           |   SCOP                |-->| 5  |--->| plist     |   */
/*|| scopp-----|->---------------      |    ----      -----------    */
/*|| scopc     |  |st|end|own|id|      |                             */
/*||           |  ---------------      |    MISC                     */
/*||           |  |st|end|own|id|      |    ----      -----------    */
/*||           |  ---------------      |-->| 6  |--->| respecify |   */
/*||           |  |st|end|own|id|           ----      -----------    */
/*||           |  ---------------                                    */
/*||           |                     CSEC                            */
/*||           |                   ----------                        */
/*|| csecp-----|------------------>|        |                        */
/*|| csecc     |                   |        |---                     */
/*||           |                   ----------  |                     */
/*||           |                      |        |                     */
/*||           |                      ----------                     */
/*||           |                     FILI                            */
/*||           |                   ----------                        */
/*|| filip-----|------------------>|        |                        */
/*|| filic     |                   |        |---                     */
/*||           |                   ----------  |                     */
/*||           |                      |        |                     */
/*||           |                      ----------                     */
/*||           |                     VALI                            */
/*||           |                   ----------                        */
/*|| valip-----|------------------>|        |                        */
/*|| valic     |                   |        |---                     */
/*||           |                   ----------  |                     */
/*||           |                      |        |                     */
/*||           |                      ----------                     */
/*||           |    OSVS                                             */
/*||           |   ----------                                        */
/*|| osvsp-----|-->|        |                                        */
/*||           |   ----------                                        */
/*|-------------                                                     */
/*|:exmp.                                                            */
/*********************************************************************/

LXCONT  *StoreLangX(DSNRES *tabp, LOCL *loclp,char *progname,char *savename,XCSECT *xcsectp,
                     IANCHOR *pIACsect,int ltype) {
LXCONT   *COp;
LXCSEC   *CSp=0;
LXSYLO   *curSLp = 0;
LXMISC   *curMISCp = 0, *tempMISCp = 0;
LXSCOP   *lscopn;
LXFILI   *FIp, *cFIp;
char     *ptr,*tempptr=0;
char     *pszbuf;
int       i,inbytes;
int       sidelang=0;
FILE     *inf ;
char      filwdbx[60];
int       curID = 0;
int       count00 = 0;
ctxt1p    txtptr;
ctxt1ep   txteptr;
char     *lsourc;
char     *lsourn,*lsoure;
char     *lsymbn,*lsymbe,*lsymbf;
int       lsylom,lbaslm,laoffm;
size_t count;    //for fread
int converted;
int pws=0;

  printf(" Entered StoreLangX\n");
  //printf("sizeof(struct source_rec2) = %i\n",sizeof(_Packed struct source_rec2));
  //printf("sizeof(struct source_rec3) = %i\n",sizeof(_Packed struct source_rec3));
  //printf("sizeof(int) = %i\n",sizeof(int));
  //printf("sizeof(short) = %i\n",sizeof(short));
  //printf("sizeof(char) = %i\n",sizeof(char));

  pszbuf  = (char *)malloc(32760) ;  /* wdblangx record area          */



  if (FA_PC)
    sprintf(filwdbx, "%s", progname);
  else if ((tabp->jcldd == 1) ||
      (tabp->jcldd == 3))
    sprintf(filwdbx, "%s(%s)", tabp->dddsn, progname);
  else
    sprintf(filwdbx, "'%s(%s)'", tabp->dddsn, progname);

  //printf("Attempting to open IDILANGX file %s\n",filwdbx);
  if (FA_PC)
    inf  = fopen(filwdbx,"rb") ;
  else
    inf  = fopen(filwdbx,"rb,type=record") ;
  if (inf!=NULL) {
    printf("Successful opening of IDILANGX: %s \n", filwdbx);
  }
  else {
    printf("Failure to open localLangxFile: %s\n", filwdbx);
    loclp->indic = erropn;
    return(0);
  }

  /* Allocate storage for Controlling record */

  COp = (LXCONT *)calloc(1,sizeof(struct LXCONT));
  COp->wdblang    = ltype;
  COp->dsname     = (char *)malloc(strlen(tabp->repdsn) + 1);
  COp->addr       = pIACsect->address;
  strcpy(COp->dsname, tabp->repdsn);
  if (strlen(savename))
    strncpy(COp->WdbProg,savename,strlen(savename));
  else
    strncpy(COp->WdbProg,progname,strlen(progname));
  COp->filecrit = (DSNRES *)malloc(sizeof(DSNRES));
  memcpy(COp->filecrit,tabp,sizeof(DSNRES));

  if (pVcom->firstidi == 0) {
    COp->nextProg = 0 ;
    pVcom->firstidi = (LXCONT *)COp ;
  }
  else {
    COp->nextProg = pVcom->firstidi ;
    pVcom->firstidi = (LXCONT *)COp ;
  }
  /***************************************************************************/
  /* Allocate Source Record area                                             */
  /***************************************************************************/

  COp->souri  = 0;
  COp->nosrc  = 0;
  COp->sourf  = (char *)malloc(maxbuf) ; /* source record area          */

  lsourc  = COp->sourf;          /* initialise current ptr      */
  lsourn  = COp->sourf;          /* set next available slot     */
  lsoure  = COp->sourf+maxbuf-1; /* set end of block            */

  /***************************************************************************/
  /* Allocate Symbol Record area                                             */
  /***************************************************************************/

  lsymbf  = (char *)malloc(maxbuf) ; /* symbol record area          */

  lsymbn  = lsymbf;          /* set next available slot     */
  lsymbe  = lsymbf+maxbuf-1; /* set end of block            */

  /***************************************************************************/
  /* Allocate Base Locator Table area                                        */
  /***************************************************************************/

  lbaslm = 200;
  COp->baslp = (char *)calloc(1,lbaslm * sizeof(LXBASL)) ;
  COp->baslc = 0;

  /****************************************************************************************/
  /*                                                                                      */
  /* Read each record and convert old types to latest before storing.                     */
  /*                                                                                      */
  /****************************************************************************************/

  if (FA_PC) {
    unsigned int scount;
    inbytes = fread(pszbuf, 1, 4, inf); /* read vb */       /* pws skip first 4 bytes  */
    printf("first read; inbytes = %i\n",inbytes);
    printf("pszbuf = 0x%2.2X %2.2X %2.2X %2.2X\n", *pszbuf, *(pszbuf+1), *(pszbuf+2), *(pszbuf+3));
    scount = *(unsigned int*)pszbuf;
    scount = revbi(scount);
    count = (size_t)(scount);
    printf("count = %i\n",count);
  }else{
    count = 32760;
  }
  inbytes = fread(pszbuf, 1, count, inf); /* read first record  */
  while ((!feof(inf)) && (inbytes)) {     /* while good records */
    // short / interger fields need to have bytes switched from big-endian to little
    // endian before converting record types because some fields change type.
    // the converted variable ensures that fields are only converted once. PWS
    converted = 0;
    pws++;
    //printf("************* record: %d\n",pws);
    ptr = pszbuf;
    //printf("inbytes = %d\n", inbytes);
    if (*(ptr) == 0x06) {                 /* old Number_of_Symbols type 1*/
      struct nbr_symbols_rec  *fptr;
      /* kenichi _Packed */ struct nbr_symbols_rec2 *tptr;
      //printf("0x06: record conversion\n");
      if (!tempptr) {
        tempptr = (char *)malloc(32760);  /* get temp storage   */
      }
      fptr = (struct nbr_symbols_rec *)ptr;
      tptr = (/*kenichi _Packed*/ struct nbr_symbols_rec2 *)tempptr;

      // switch bytes from big to little endian
      fptr->nbr_symbols         = revbi(fptr->nbr_symbols);
      fptr->nbr_symbol_arrays   = revbi(fptr->nbr_symbol_arrays);
      fptr->nbr_symbol_LongName = revbi(fptr->nbr_symbol_LongName);
      fptr->nbr_symbol_name_id  = revbi(fptr->nbr_symbol_name_id);
      fptr->nbr_symbol_DFmts    = revbi(fptr->nbr_symbol_DFmts);
      fptr->nbr_symbol_classes  = revbi(fptr->nbr_symbol_classes);
      fptr->nbr_symbol_Lnks     = revbi(fptr->nbr_symbol_Lnks);
      fptr->nbr_symbol_PLists   = revbi(fptr->nbr_symbol_PLists);
      fptr->nbr_symbol__x       = revbs(fptr->nbr_symbol__x);
      fptr->nbr_symbol_exts     = revbs(fptr->nbr_symbol_exts);
      converted = 1;

      tptr->nbr_sym_r2_type        = 0x31;
      tptr->nbr_sym_r2_pad         = fptr->nbr_sym_r_pad;
      tptr->nbr_symbols2           = fptr->nbr_symbols;
      tptr->nbr_symbol2_arrays     = fptr->nbr_symbol_arrays;
      tptr->nbr_symbol2_LongName   = fptr->nbr_symbol_LongName;
      tptr->nbr_symbol2_name_id    = fptr->nbr_symbol_name_id;
      tptr->nbr_symbol2_DFmts      = fptr->nbr_symbol_DFmts;
      tptr->nbr_symbol2_classes    = fptr->nbr_symbol_classes;
      tptr->nbr_symbol2_Lnks       = fptr->nbr_symbol_Lnks;
      tptr->nbr_symbol2_PLists     = fptr->nbr_symbol_PLists;
      tptr->nbr_symbol2__x         = fptr->nbr_symbol__x;
      tptr->nbr_symbol2_exts       = fptr->nbr_symbol_exts;
      inbytes = sizeof(/*kenichi _Packed*/ struct nbr_symbols_rec2);

      ptr = tempptr;
    }
    if (*(ptr) == 0x19) {                 /* old Locates type 1 */
      /* kenichi _Packed*/ struct loc_rec *fptr;
      /* kenichi _Packed*/ struct loc_rec2 *tptr;
      short *fdptr;
      int   *tdptr;
      //printf("0x19: record conversion\n");
      if (!tempptr) {
        tempptr = (char *)malloc(32760);  /* get temp storage   */
      }
      fptr = (/* kenichi _Packed*/ struct loc_rec *)ptr;
      tptr = (/* kenichi _Packed*/ struct loc_rec2 *)tempptr;

      // switch bytes from big to little endian
      fptr->loc_r_owner     = revbs(fptr->loc_r_owner);
      fptr->loc_r_nbr_ident = revbs(fptr->loc_r_nbr_ident);
      converted = 1;

      tptr->loc_r2_type        = 0x3C;
      tptr->loc_r2_owner       = fptr->loc_r_owner ;
      tptr->loc_r2_nbr_ident   = fptr->loc_r_nbr_ident ;
      fdptr = (short *)fptr->loc_r_ident ;
      tdptr = (int *)tptr->loc_r2_ident ;
      for (i=0;
           i<fptr->loc_r_nbr_ident ;
           i++) {
        *fdptr = revbs(*fdptr);      //endian switch
        *(tdptr)    = *(fdptr) ;
        fdptr++;
        tdptr++;
      }
      inbytes = sizeof(/* kenichi _Packed */ struct loc_rec2) +
                  ((fptr->loc_r_nbr_ident - 1) * sizeof(tptr->loc_r2_ident));

      ptr = tempptr;
    }
    if (*(ptr) == 0x10) {                 /* old Source type 2  */
      /* kenichi _Packed */struct source_rec2 *fptr;
      /* kenichi _Packed */struct source_rec3 *tptr;
      //printf("0x10: record conversion\n");
      if (!tempptr) {
        tempptr = (char *)malloc(32760);  /* get temp storage   */
      }
      fptr = (/* kenichi _Packed*/ struct source_rec2 *)ptr;
      tptr = (/* kenichi _Packed*/ struct source_rec3 *)tempptr;

      // switch bytes from big to little endian
      fptr->src_r2_CSECT_ = revbs(fptr->src_r2_CSECT_);
      fptr->src_r2_offset = revbi(fptr->src_r2_offset);
      fptr->src_r2_line_num = revbs(fptr->src_r2_line_num);
      fptr->src_r2_stmt_num = revbs(fptr->src_r2_stmt_num);
      converted = 1;

      tptr->source_rec3_type   = 0x2E;
      tptr->src_r3_flags       = fptr->src_r2_flags;
      tptr->src_r3_text_ln     = fptr->src_r2_text_ln;
      tptr->src_r3_CSECT_      = fptr->src_r2_CSECT_;
      tptr->src_r3_offset      = fptr->src_r2_offset;
      tptr->src_r3_line_num    = fptr->src_r2_line_num;
      tptr->src_r3_stmt_num    = fptr->src_r2_stmt_num;
      tptr->src_r3_type        = fptr->src_r2_type;
      memcpy(tptr->src_r3_text,fptr->src_r2_text,fptr->src_r2_text_ln);
      inbytes = sizeof(/* kenichi _Packed*/ struct source_rec3) +
                tptr->src_r3_text_ln - 1 ;
      ptr = tempptr;
    }
    if (*(ptr) == 0x24) {                 /* old Symbol type 3  */
      /* kenichi _Packed*/ struct symbol_rec3 *fptr ;
      /* kenichi _Packed*/ struct symbol_rec5 *tptr ;
      //printf("0x24: record conversion\n");
      if (!tempptr) {
        tempptr = (char *)malloc(32760);  /* get temp storage   */
      }
      fptr = (/* kenichi _Packed*/ struct symbol_rec3 *)ptr;
      tptr = (/* kenichi _Packed*/ struct symbol_rec5 *)tempptr;

      // switch bytes from big to little endian
      fptr->sym_r3_ident    = revbs(fptr->sym_r3_ident);
      fptr->sym_r3_stmt_dcl = revbs(fptr->sym_r3_stmt_dcl);
      fptr->sym_r3_owner    = revbs(fptr->sym_r3_owner);
      fptr->_symbol_rec3_union1.sym_r3_offset = revbi(fptr->_symbol_rec3_union1.sym_r3_offset);
      fptr->sym_r3_bdy_align  = revbs(fptr->sym_r3_bdy_align);
      fptr->sym_r3_bdy_posn   = revbs(fptr->sym_r3_bdy_posn);
      fptr->sym_r3_struct_id  = revbs(fptr->sym_r3_struct_id);
      fptr->sym_r3_struct_idx = revbs(fptr->sym_r3_struct_idx);
      fptr->sym_r3_type_id    = revbs(fptr->sym_r3_type_id);
      fptr->sym_r3_class_id   = revbs(fptr->sym_r3_class_id);
      fptr->sym_r3_CSECT_     = revbs(fptr->sym_r3_CSECT_);
      fptr->sym_r3_flags1     = revbs(fptr->sym_r3_flags1);
      fptr->sym_r3_flags2     = revbs(fptr->sym_r3_flags2);
      converted = 1;

      tptr->symbol_rec5_type   = 0x4D;
      tptr->sym_r5_ident       = fptr->sym_r3_ident ;
      tptr->sym_r5_stmt_dcl    = fptr->sym_r3_stmt_dcl ;
      tptr->sym_r5_owner       = fptr->sym_r3_owner ;
      tptr->sym_r5_offset      =
          fptr->_symbol_rec3_union1.sym_r3_offset ;

      tptr->un5sr.sym_r5_offset_len  = 0 ; /* clear this 6 byte area */
      tptr->un5sr.sym_r5_varies_on   = 0 ;
      switch(fptr->sym_r3_display) {
        case 0 :
        case 1 :
        case 2 :
        case 4 :
        case 6 :
        case 8 :
        case 9 :
        case 10:
        case 22:
        case 11:
        case 12:
        case 13:
        case 14:
        case 15:
        case 16:
        case 17:
        case 18: {
          fptr->un32.sym_r3_precision = revbi(fptr->un32.sym_r3_precision); //endian switch
          tptr->un5sn.sym_r5_precision = fptr->un32.sym_r3_precision ;
        }
        break ;
        case 3 :
        case 7 : {
          fptr->un323.sym_r3_offset_len = revbs(fptr->un323.sym_r3_offset_len);  //endian switch
          fptr->un324.sym_r3_varies_on  = revbs(fptr->un324.sym_r3_varies_on);   //endian switch
          tptr->un5sr.sym_r5_offset_len = fptr->un323.sym_r3_offset_len;
          tptr->un5sr.sym_r5_varies_on  = fptr->un324.sym_r3_varies_on ;
        }
        break ;
        case 5 : {
          fptr->un323.sym_r3_bit_len = revbs(fptr->un323.sym_r3_bit_len);  //endian switch
          fptr->un324.sym_r3_bit_bdy = revbs(fptr->un324.sym_r3_bit_bdy);  //endian switch
          tptr->un5sb.sym_r5_bit_len    = fptr->un323.sym_r3_bit_len ;
          tptr->un5sb.sym_r5_bit_bdy    = fptr->un324.sym_r3_bit_bdy ;
        }
        break;
      }
      tptr->sym_r5_bdy_align   = fptr->sym_r3_bdy_align ;
      tptr->sym_r5_bdy_posn    = fptr->sym_r3_bdy_posn ;
      tptr->sym_r5_struct_id   = fptr->sym_r3_struct_id ;
      tptr->sym_r5_struct_idx  = fptr->sym_r3_struct_idx ;
      tptr->sym_r5_find        = fptr->sym_r3_find ;
      tptr->sym_r5_display     = fptr->sym_r3_display ;
      tptr->sym_r5_type_id     = fptr->sym_r3_type_id ;
      tptr->sym_r5_class_id    = fptr->sym_r3_class_id ;
      tptr->sym_r5_CSECT_      = fptr->sym_r3_CSECT_ ;
      tptr->sym_r5_nodec       = 0;
      tptr->sym_r5_flags1       = fptr->sym_r3_flags1 ;
      tptr->sym_r5_flags2       = fptr->sym_r3_flags2 ;
      tptr->sym_r5_flags3       = fptr->sym_r3_flags3 ;
      tptr->sym_r5_flags4       = 0 ;
      if ((fptr->sym_r3_flags3 & 0x80) == 0x80) { /* test long name */
        struct sym_r3_long_sym *flptr;
        struct sym_r5_long_sym *tlptr;
        flptr = (struct sym_r3_long_sym *)&fptr->sym_r3_name_ln8;
        tlptr = (struct sym_r5_long_sym *)&tptr->sym_r5_name_ln8;

        flptr->sym_r3_name_ln15  = revbs(flptr->sym_r3_name_ln15);  // endian switch

        tlptr->sym_r5_name_ln15   = flptr->sym_r3_name_ln15 ;
        memcpy(tlptr->sym_r5_name15,flptr->sym_r3_name15,
                     flptr->sym_r3_name_ln15) ;
      }
      else {

        tptr->sym_r5_name_ln8   = fptr->sym_r3_name_ln8 ;
        memcpy(tptr->sym_r5_name8,fptr->sym_r3_name8,
                     fptr->sym_r3_name_ln8) ;
        inbytes = sizeof(/* kenichi _Packed */struct symbol_rec5) +
                tptr->sym_r5_name_ln8 - 1 ;
      }
      ptr = tempptr;
    }
    if (*(ptr) == 0x34) {                 /* old Symbol type 4  */
      /* KENICHI _Packed*/ struct symbol_rec4 *fptr ;
      /* KENICHI _Packed*/ struct symbol_rec5 *tptr ;
      //printf("0x34: record conversion\n");
      if (!tempptr) {
        tempptr = (char *)malloc(32760);  /* get temp storage   */
      }
      fptr = (/* KENICHI _Packed*/ struct symbol_rec4 *)ptr;
      tptr = (/* KENICHI _Packed*/ struct symbol_rec5 *)tempptr;

      // switch bytes from big to little endian
      fptr->sym_r4_ident      = revbi(fptr->sym_r4_ident);
      fptr->sym_r4_stmt_dcl   = revbi(fptr->sym_r4_stmt_dcl);
      fptr->sym_r4_owner      = revbi(fptr->sym_r4_owner);
      fptr->sym_r4_offset     = revbi(fptr->sym_r4_offset);
      fptr->sym_r4_bdy_align  = revbs(fptr->sym_r4_bdy_align);
      fptr->sym_r4_bdy_posn   = revbs(fptr->sym_r4_bdy_posn);
      fptr->sym_r4_struct_id  = revbi(fptr->sym_r4_struct_id);
      fptr->sym_r4_struct_idx = revbi(fptr->sym_r4_struct_idx);
      fptr->sym_r4_type_id    = revbi(fptr->sym_r4_type_id);
      fptr->sym_r4_class_id   = revbi(fptr->sym_r4_class_id);
      fptr->sym_r4_CSECT_     = revbs(fptr->sym_r4_CSECT_);
      fptr->sym_r4_flags1     = revbs(fptr->sym_r4_flags1);
      fptr->sym_r4_flags2     = revbs(fptr->sym_r4_flags2);
      converted = 1;

      tptr->symbol_rec5_type   = 0x4D;
      tptr->sym_r5_ident       = fptr->sym_r4_ident ;
      tptr->sym_r5_stmt_dcl    = fptr->sym_r4_stmt_dcl ;
      tptr->sym_r5_owner       = fptr->sym_r4_owner ;
      tptr->sym_r5_offset      = fptr->sym_r4_offset ;
      tptr->un5sr.sym_r5_offset_len  = 0 ; /* clear this 6 byte area */
      tptr->un5sr.sym_r5_varies_on   = 0 ;
      switch(fptr->sym_r4_display) {
        case 0 :
        case 1 :
        case 2 :
        case 4 :
        case 6 :
        case 8 :
        case 9 :
        case 10:
        case 22:
        case 11:
        case 12:
        case 13:
        case 14:
        case 15:
        case 16:
        case 17:
        case 18: {
          fptr->un4sn.sym_r4_precision = revbi(fptr->un4sn.sym_r4_precision);  // endian switch
          tptr->un5sn.sym_r5_precision = fptr->un4sn.sym_r4_precision ;
        }
        break ;
        case 3 :
        case 7 : {
          fptr->un4sr.sym_r4_offset_len = revbs(fptr->un4sr.sym_r4_offset_len);  // endian switch
          fptr->un4sr.sym_r4_varies_on  = revbi(fptr->un4sr.sym_r4_varies_on);   // endian switch
          tptr->un5sr.sym_r5_offset_len = fptr->un4sr.sym_r4_offset_len;
          tptr->un5sr.sym_r5_varies_on  = fptr->un4sr.sym_r4_varies_on ;
        }
        break ;
        case 5 : {
          fptr->un4sb.sym_r4_bit_len    = revbs(fptr->un4sb.sym_r4_bit_len);  // endian switch
          fptr->un4sb.sym_r4_bit_bdy    = revbs(fptr->un4sb.sym_r4_bit_bdy);  // endian switch
          tptr->un5sb.sym_r5_bit_len    = fptr->un4sb.sym_r4_bit_len ;
          tptr->un5sb.sym_r5_bit_bdy    = fptr->un4sb.sym_r4_bit_bdy ;
        }
        break;
      }
      tptr->sym_r5_bdy_align   = fptr->sym_r4_bdy_align ;
      tptr->sym_r5_bdy_posn    = fptr->sym_r4_bdy_posn ;
      tptr->sym_r5_struct_id   = fptr->sym_r4_struct_id ;
      tptr->sym_r5_struct_idx  = fptr->sym_r4_struct_idx ;
      tptr->sym_r5_find        = fptr->sym_r4_find ;
      tptr->sym_r5_display     = fptr->sym_r4_display ;
      tptr->sym_r5_type_id     = fptr->sym_r4_type_id ;
      tptr->sym_r5_class_id    = fptr->sym_r4_class_id ;
      tptr->sym_r5_CSECT_      = fptr->sym_r4_CSECT_ ;
      tptr->sym_r5_nodec       = 0;
      tptr->sym_r5_flags1       = fptr->sym_r4_flags1 ;
      tptr->sym_r5_flags2       = fptr->sym_r4_flags2 ;
      tptr->sym_r5_flags3       = fptr->sym_r4_flags3 ;
      tptr->sym_r5_flags4       = 0;
      if ((fptr->sym_r4_flags3 & 0x80) == 0x80) { /* test long name */
        struct sym_r4_long_sym *flptr;
        struct sym_r5_long_sym *tlptr;
        flptr = (struct sym_r4_long_sym *)&fptr->sym_r4_name_ln8;
        tlptr = (struct sym_r5_long_sym *)&tptr->sym_r5_name_ln8;
        flptr->sym_r4_name_ln15 = revbs(flptr->sym_r4_name_ln15) ;   // endian switch
        tlptr->sym_r5_name_ln15   = flptr->sym_r4_name_ln15 ;
        memcpy(tlptr->sym_r5_name15,flptr->sym_r4_name15,
                     flptr->sym_r4_name_ln15) ;
      }
      else {
        tptr->sym_r5_name_ln8   = fptr->sym_r4_name_ln8 ;
        memcpy(tptr->sym_r5_name8,fptr->sym_r4_name8,
                     fptr->sym_r4_name_ln8) ;
        inbytes = sizeof(/* KENICHI _Packed*/ struct symbol_rec5) +
                tptr->sym_r5_name_ln8 - 1 ;
      }
      ptr = tempptr;
    }
    if (*(ptr) == 0x0C) {                 /* old Struct type 1  */
      /* KENICHI _Packed*/ struct struct_rec *fptr ;
      /* KENICHI _Packed*/ struct struct_rec2 *tptr ;
      /* KENICHI _Packed*/ struct struct_r_elements *feptr;
      /* KENICHI _Packed*/ struct struct_r2_elements *teptr;
      //printf("0x0c: record conversion\n");
      if (!tempptr) {
        tempptr = (char *)malloc(32760);  /* get temp storage   */
      }
      fptr = (/* KENICHI _Packed*/ struct struct_rec *)ptr;
      tptr = (/* KENICHI _Packed*/ struct struct_rec2 *)tempptr;

      // switch bytes from big to little endian
      fptr->struct_r_owner      = revbs(fptr->struct_r_owner);
      fptr->struct_r_elm_total  = revbs(fptr->struct_r_elm_total);
      fptr->struct_r_elm_first  = revbs(fptr->struct_r_elm_first);
      fptr->struct_r_elm_last   = revbs(fptr->struct_r_elm_last);
      converted = 1;
      tptr->struct_r2_type   = 0x3B;
      tptr->struct_r2_owner  = fptr->struct_r_owner ;
      tptr->struct_r2_elm_total = fptr->struct_r_elm_total ;
      tptr->struct_r2_elm_first = fptr->struct_r_elm_first ;
      tptr->struct_r2_elm_last  = fptr->struct_r_elm_last  ;
      feptr = (/* KENICHI _Packed*/ struct struct_r_elements*)fptr->struct_r_element;
      teptr = (/* KENICHI _Packed*/ struct struct_r2_elements*)tptr->struct_r2_element;
      for (i=0;
           i<fptr->struct_r_elm_last - fptr->struct_r_elm_first + 1 ;
           i++) {
        feptr->struct_r_elm_ident  = revbs(feptr->struct_r_elm_ident);   // endian switch
        feptr->struct_r_elm_depth  = revbs(feptr->struct_r_elm_depth);   // endian switch
        feptr->struct_r_elm_level  = revbs(feptr->struct_r_elm_level);   // endian switch
        teptr->struct_r2_elm_ident = feptr->struct_r_elm_ident ;
        teptr->struct_r2_elm_depth = feptr->struct_r_elm_depth ;
        teptr->struct_r2_elm_level = feptr->struct_r_elm_level ;
        feptr++;
        teptr++;
      }
      inbytes = sizeof(/* KENICHI _Packed*/ struct struct_rec2) +
                (sizeof(/* KENICHI _Packed*/ struct struct_r2_elements) *
                (tptr->struct_r2_elm_last - tptr->struct_r2_elm_first));
      ptr = tempptr;
    }
    if (*(ptr) == 0x12) {                 /* old Array  type 2  */
      /* KENICHI _Packed*/ struct array_rec2 *fptr ;
      /* KENICHI _Packed*/ struct array_rec4 *tptr ;
      struct array_r2_dims *fdptr;
      /* KENICHI _Packed*/ struct array_r4_dims *tdptr;
      //printf("0x12: record conversion\n");
      if (!tempptr) {
        tempptr = (char *)malloc(32760);  /* get temp storage   */
      }
      fptr = (/* KENICHI _Packed*/ struct array_rec2 *)ptr;
      tptr = (/* KENICHI _Packed*/ struct array_rec4 *)tempptr;

      // switch bytes from big to little endian
      fptr->array_r2_sym_ident = revbs(fptr->array_r2_sym_ident);   // endian switch
      converted = 1;

      tptr->array_r4_type   = 0x4C;
      tptr->array_r4_nbr_dims    = fptr->array_r2_nbr_dims ;
      tptr->array_r4_sym_ident   = fptr->array_r2_sym_ident ;
      tptr->array_r4_dep_ident   = 0;
      fdptr = (struct array_r2_dims*)fptr->array_r2_dim_info ;
      tdptr = (/* KENICHI _Packed*/ struct array_r4_dims*)tptr->array_r4_dim_info ;
      for (i=0;
           i<fptr->array_r2_nbr_dims ;
           i++) {
        fdptr->array_r2_low_bnd = revbi(fdptr->array_r2_low_bnd);   // endian switch
        fdptr->array_r2_hi_bnd  = revbi(fdptr->array_r2_hi_bnd);    // endian switch
        tdptr->array_r4_low_bnd    = fdptr->array_r2_low_bnd ;
        tdptr->array_r4_hi_bnd     = fdptr->array_r2_hi_bnd ;
        fdptr++;
        tdptr++;
      }
      inbytes = sizeof(/* KENICHI _Packed*/ struct array_rec4) +
                (sizeof(/* KENICHI _Packed*/ struct array_r4_dims) *
                (tptr->array_r4_nbr_dims - 1));
      ptr = tempptr;
    }
    if (*(ptr) == 0x35) {                 /*     Array  type 3  */
      /* KENICHI _Packed*/ struct array_rec3 *fptr ;
      /* KENICHI _Packed*/ struct array_rec4 *tptr ;
      struct array_r3_dims *fdptr;
      /* KENICHI _Packed*/ struct array_r4_dims *tdptr;
      //printf("0x35: record conversion\n");
      if (!tempptr) {
        tempptr = (char *)malloc(32760);  /* get temp storage   */
      }
      fptr = (/* KENICHI _Packed*/ struct array_rec3 *)ptr;
      tptr = (/* KENICHI _Packed*/ struct array_rec4 *)tempptr;

      // switch bytes from big to little endian
      fptr->array_r3_sym_ident = revbs(fptr->array_r3_sym_ident);   // endian switch
      converted = 1;

      tptr->array_r4_type   = 0x4C;
      tptr->array_r4_nbr_dims    = fptr->array_r3_nbr_dims ;
      tptr->array_r4_sym_ident   = fptr->array_r3_sym_ident ;
      tptr->array_r4_dep_ident   = 0;
      fdptr = (struct array_r3_dims*)fptr->array_r3_dim_info ;
      tdptr = (/* KENICHI _Packed*/ struct array_r4_dims*)tptr->array_r4_dim_info ;
      for (i=0;
           i<fptr->array_r3_nbr_dims ;
           i++) {
        fdptr->array_r3_low_bnd = revbi(fdptr->array_r3_low_bnd);   // endian switch
        fdptr->array_r3_hi_bnd  = revbi(fdptr->array_r3_hi_bnd);    // endian switch
        tdptr->array_r4_low_bnd    = fdptr->array_r3_low_bnd ;
        tdptr->array_r4_hi_bnd     = fdptr->array_r3_hi_bnd ;
        fdptr++;
        tdptr++;
      }
      inbytes = sizeof(/* KENICHI _Packed*/ struct array_rec4) +
                (sizeof(/* KENICHI _Packed*/ struct array_r4_dims) *
                (tptr->array_r4_nbr_dims - 1));
      ptr = tempptr;
    }
    if (*(ptr) == 0x28) {                 /* old Plist  type 1  */
      /* KENICHI _Packed*/ struct PList_rec  *fptr ;
      /* KENICHI _Packed*/ struct PList_rec2 *tptr ;
      short *fdptr;
      int   *tdptr;
      //printf("0x28: record conversion\n");
      if (!tempptr) {
        tempptr = (char *)malloc(32760);  /* get temp storage   */
      }
      fptr = (/* KENICHI _Packed*/ struct PList_rec *)ptr;
      tptr = (/* KENICHI _Packed*/ struct PList_rec2 *)tempptr;

      // switch bytes from big to little endian
      fptr->PList_r_owner     = revbs(fptr->PList_r_owner);
      fptr->PList_r_nbr_parms = revbi(fptr->PList_r_nbr_parms);
      fptr->PList_r_stmt_num  = revbs(fptr->PList_r_stmt_num);
      fptr->PList_r_CSECT_    = revbs(fptr->PList_r_CSECT_);
      fptr->PList_r_Offset    = revbi(fptr->PList_r_Offset);
      converted = 1;

      tptr->PList_r2_type   = 0x43;
      tptr->PList_r2_owner       = fptr->PList_r_owner ;
      tptr->PList_r2_nbr_parms   = fptr->PList_r_nbr_parms ;
      tptr->PList_r2_CSECT_      = fptr->PList_r_CSECT_;
      tptr->PList_r2_stmt_num    = fptr->PList_r_stmt_num ;
      tptr->PList_r2_Offset      = fptr->PList_r_Offset ;
      fdptr = (short *)fptr->PList_r_parm_ident ;
      tdptr = (int *)tptr->PList_r2_parm_ident ;
      for (i=0;
           i<fptr->PList_r_nbr_parms ;
           i++) {
        *fdptr = revbs(*fdptr);   // endian switch
        *(tdptr)    = *(fdptr) ;
        fdptr++;
        tdptr++;
      }
      inbytes = sizeof(/* KENICHI _Packed*/ struct PList_rec2) +
                (4 * (tptr->PList_r2_nbr_parms - 1));
      ptr = tempptr;
    }
    if (*(ptr) == 0x15) {                 /* old CSECT longname  type 1  */
      /* KENICHI _Packed*/ struct CSECT_ln_rec  *fptr ;
      /* KENICHI _Packed*/ struct CSECT_ln_rec2 *tptr ;
      //printf("0x15: record conversion\n");
      if (!tempptr) {
        tempptr = (char *)malloc(32760);  /* get temp storage   */
      }
      fptr = (/* KENICHI _Packed*/struct CSECT_ln_rec *)ptr;
      tptr = (/* KENICHI _Packed*/ struct CSECT_ln_rec2 *)tempptr;

      // switch bytes from big to little endian
      fptr->CSECT_ln_r_CSECT_ = revbs(fptr->CSECT_ln_r_CSECT_);
      converted = 1;

      tptr->CSECT_ln_rec2_type   = 0x45;
      tptr->CSECT_ln_r2_CSECT_      = fptr->CSECT_ln_r_CSECT_;
      tptr->CSECT_ln_r2_name_ln     = fptr->CSECT_ln_r_name_ln;
      memcpy(tptr->CSECT_ln_r2_name,fptr->CSECT_ln_r_name,
                     fptr->CSECT_ln_r_name_ln) ;
      inbytes = sizeof(/* KENICHI _Packed*/ struct CSECT_ln_rec2) +
                (tptr->CSECT_ln_r2_name_ln - 1);
      ptr = tempptr;
    }

  /****************************************************************************************/
  /*                                                                                      */
  /* End of conversions. Now store required record types.                                 */
  /*                                                                                      */
  /****************************************************************************************/
    switch (*(ptr)) {

      case 0x00: {                /* Title   record             */
        //printf("case 0x00: title record\n");
        count00++;
        if (count00 > 1) {
          if (COp->aoffc)
            COp->aoffp = (LXAOFF *)realloc(COp->aoffp,COp->aoffc * sizeof(LXAOFF));

          if (fclose(inf)) {
            loclp->indic = errcls ;
            return(0) ;
          }
          if (tempptr)
            free(tempptr);
          free(pszbuf);

          return((LXCONT *)COp);
        }
      }
      break;
      case 0x03: {                /* Version record             */
        struct version_rec2 *verptr;
        //printf("case 0x03: version record\n");
        verptr = (struct version_rec2 *)ptr;
        COp->margl = verptr->LangX_r2_margin_l; /* save left/right margins */
        COp->margr = verptr->LangX_r2_margin_r;
        sidelang = (int)(*(ptr+4));              /* Compiler Language           */
      }
      break;
      case 0x25 : {                       /* Compile Information         */
        //printf("case 0x25: compiler info\n");
        if (sidelang) {
          comp1p cm1ptr;
          if ((*(ptr+101) & 0x40) == 0x40) {  /* is optimized flag ON ?      */
            COp->optim   = 1;
          }
          if ((*(ptr+101) & 0x08) == 0x08) {  /* is line rather than stmt best  */
            COp->storlin = 1;
          }
          COp->blnumb = 0;                    /* Unknown as yet                 */
          cm1ptr = (comp1p)ptr;
          if (cm1ptr->CompI_r_Num == 'H') {
    //printf("XXXX BL numbering is hex\n");
            COp->blnumb = 2;                  /* Hex BL numbering               */
          }
          if (cm1ptr->CompI_r_Num == 'D') {
    //printf("XXXX BL numbering is dec\n");
            COp->blnumb = 1;                  /* Dec BL numbering               */
          }
        }
      }
      break ;
      case 0x45 :                         /* Csect Longname              */
      case 0x0E : {                       /* Csect                       */
        LXCSEC *tCSp;
        //printf("case 0x45,0x0E: Csect longname\n");


        if (sidelang) {
          /* KENICHI _Packed*/ struct CSECT_ln_rec2 *fptr ;
          tCSp = (LXCSEC *)malloc(sizeof(LXCSEC) + inbytes - 1) ;
          memcpy(tCSp->cstext,ptr,inbytes);
          if(converted == 0) {
            fptr = (/* KENICHI _Packed*/ struct CSECT_ln_rec2 *)&tCSp->cstext;
            // switch bytes from big to little endian
            fptr->CSECT_ln_r2_CSECT_  = revbs(fptr->CSECT_ln_r2_CSECT_);
            fptr->CSECT_ln_r2_name_ln = revbs(fptr->CSECT_ln_r2_name_ln);
          }
          tCSp->cscsp = 0;
          if (COp->csecc == 0)
            COp->csecp = tCSp;
          else
            CSp->cscsp = tCSp;
          CSp = tCSp;
          COp->csecc++;
        }
      }
      break ;
      case 0x4B :                         /* source record type 4        */
      case 0x2E : {                       /* source record type 3        */
        LXSOUR *SOp,*oSOp;
        /* KENICHI _Packed*/ struct source_rec3 *tptr;
        tptr = (/* KENICHI _Packed*/ struct source_rec3 *)ptr;
        //printf("case: 0x4B,0x2E; source record type 3 or 4 \n");
        if (sidelang) {
          if ((*(ptr) == 0x4B)     &&
              (COp->souri == 3)) {
            printf("Error in storing IDILANGX file - mixed source record types\n");
            loclp->indic = errfrm;
            return 0;
          }
          if ((*(ptr) == 0x2E)     &&
              (COp->souri == 4)) {
            printf("Error in storing IDILANGX file - mixed source record types\n");
            loclp->indic = errfrm;
            return 0;
          }

          if (*(ptr) == 0x4B)
            COp->souri = 4;
          else
            COp->souri = 3;
          if(converted == 0) {
            tptr->src_r3_CSECT_ = revbs(tptr->src_r3_CSECT_);
            tptr->src_r3_offset = revbi(tptr->src_r3_offset);
            tptr->src_r3_line_num = revbi(tptr->src_r3_line_num);
            tptr->src_r3_stmt_num = revbi(tptr->src_r3_stmt_num);
          }
          //printf("src_r3_text_ln = %d \n", tptr->src_r3_text_ln);
          //printf("src_r3_CSECT_= %d \n",tptr->src_r3_CSECT_);
          //printf("src_r3_offset = %d\n",tptr->src_r3_offset);
          //printf("src_r3_flags = 0x%2.2X\n",tptr->src_r3_flags);
          //printf("src_r3_line_num = %d \n",tptr->src_r3_line_num);
          //printf("src_r3_stmt_num = %d \n",tptr->src_r3_stmt_num);
          //printf("src_r3_type = %d\n", tptr->src_r3_type);

          if ((inbytes+sizeof(LXSOUR)-1) > (lsoure - lsourn) ) {
            char *tsoptr;
            tsoptr  = (char *)malloc(maxbuf) ;           /* next source record area         */
            oSOp = (LXSOUR *)lsourc;
            oSOp->sosonp = (LXSOUR *)tsoptr;

            lsourn  = tsoptr;                            /* set next available slot         */
            lsoure  = lsourn+maxbuf-1;                   /* set end of block                */
          }
          else {
            if (COp->sourf == lsourn) {                  /* first record in first block     */
              oSOp = 0;
            }
            else {
              oSOp = (LXSOUR *)lsourc;
              oSOp->sosonp = (LXSOUR *)lsourn;           /* point last record to this one   */
            }
          }
          SOp = (LXSOUR *)lsourn;
          SOp->sosonp = 0;
          SOp->sosopp = oSOp;
          memcpy(SOp->sotext,ptr,inbytes);              /* store new record                */
          lsourc = lsourn;                              /* and update controlling pointers */
          lsourn = lsourn + inbytes + sizeof(LXSOUR) - 1;
          COp->nosrc++;
        }

      }
      break ;
      case 0x31 : {                       /* Number of symbols   record  */
        //printf("case: 0x31; Number of symbols record \n");
        if (sidelang) {
          nsym2p ns2ptr;
          ns2ptr = (nsym2p)ptr;


          if(converted ==0) {             // endian switch
            ns2ptr->nbr_symbols2          = revbi(ns2ptr->nbr_symbols2);
            ns2ptr->nbr_symbol2_arrays    = revbi(ns2ptr->nbr_symbol2_arrays);
            ns2ptr->nbr_symbol2_LongName  = revbi(ns2ptr->nbr_symbol2_LongName);
            ns2ptr->nbr_symbol2_name_id   = revbi(ns2ptr->nbr_symbol2_name_id);
            ns2ptr->nbr_symbol2_DFmts     = revbi(ns2ptr->nbr_symbol2_DFmts);
            ns2ptr->nbr_symbol2_classes   = revbi(ns2ptr->nbr_symbol2_classes);
            ns2ptr->nbr_symbol2_Lnks      = revbi(ns2ptr->nbr_symbol2_Lnks);
            ns2ptr->nbr_symbol2_PLists    = revbi(ns2ptr->nbr_symbol2_PLists);
            ns2ptr->nbr_symbol2__x        = revbs(ns2ptr->nbr_symbol2__x);
            ns2ptr->nbr_symbol2_exts      = revbs(ns2ptr->nbr_symbol2_exts);
          }

          lsylom = ns2ptr->nbr_symbols2;

          /* Create the symbol lookup table */

          COp->sylop = (char *)calloc(1,lsylom * sizeof(LXSYLO)) ;
          COp->syloc = 0;
        }
      }
      break ;
      case 0x4D : {                       /* Symbol record type 5        */
        LXSYLO *SLp;
        symb5p sr5ptr;
        //printf("case: 0x4D; Symbol record type 5 \n");
        if ((sidelang) && (COp->sylop)) {
          sr5ptr = (symb5p)ptr;
          if(converted == 0){
            sr5ptr->sym_r5_ident    = revbi(sr5ptr->sym_r5_ident);
            sr5ptr->sym_r5_stmt_dcl = revbi(sr5ptr->sym_r5_stmt_dcl);
            sr5ptr->sym_r5_owner    = revbi(sr5ptr->sym_r5_owner);
            sr5ptr->sym_r5_offset   = revbi(sr5ptr->sym_r5_offset);
            sr5ptr->sym_r5_bdy_align  = revbs(sr5ptr->sym_r5_bdy_align);
            sr5ptr->sym_r5_bdy_posn   = revbs(sr5ptr->sym_r5_bdy_posn);
            sr5ptr->sym_r5_struct_id  = revbi(sr5ptr->sym_r5_struct_id);
            sr5ptr->sym_r5_struct_idx = revbi(sr5ptr->sym_r5_struct_idx);
            sr5ptr->sym_r5_type_id    = revbi(sr5ptr->sym_r5_type_id);
            sr5ptr->sym_r5_class_id   = revbi(sr5ptr->sym_r5_class_id);
            sr5ptr->sym_r5_CSECT_     = revbs(sr5ptr->sym_r5_CSECT_);
            sr5ptr->sym_r5_nodec      = revbs(sr5ptr->sym_r5_nodec);
            sr5ptr->sym_r5_flags1     = revbs(sr5ptr->sym_r5_flags1);
            sr5ptr->sym_r5_flags2     = revbs(sr5ptr->sym_r5_flags2);
            switch(sr5ptr->sym_r5_display) {
              case 0 :
              case 1 :
              case 2 :
              case 4 :
              case 6 :
              case 8 :
              case 9 :
              case 10:
              case 22:
              case 11:
              case 12:
              case 13:
              case 14:
              case 15:
              case 16:
              case 17:
              case 18: {
                sr5ptr->un5sn.sym_r5_precision = revbi(sr5ptr->un5sn.sym_r5_precision); //endian switch
              }
              break ;
              case 3 :
              case 7 : {
                sr5ptr->un5sr.sym_r5_offset_len = revbs(sr5ptr->un5sr.sym_r5_offset_len);  //endian switch
                sr5ptr->un5sr.sym_r5_varies_on  = revbi(sr5ptr->un5sr.sym_r5_varies_on);   //endian switch
              }
              break ;
              case 5 : {
                sr5ptr->un5sb.sym_r5_bit_len = revbs(sr5ptr->un5sb.sym_r5_bit_len);  //endian switch
                sr5ptr->un5sb.sym_r5_bit_bdy = revbs(sr5ptr->un5sb.sym_r5_bit_bdy);  //endian switch
              }
              break;
            }
          }
          //pws convert names
          if (((memcmp(sr5ptr->sym_r5_name8,"@BL",3) == 0)  ||
               (memcmp(sr5ptr->sym_r5_name8,"@IL",3) == 0)  ||
               (memcmp(sr5ptr->sym_r5_name8,"@ID",3) == 0)) &&
              ((sr5ptr->sym_r5_name_ln8 > 4)                ||
               ((sr5ptr->sym_r5_name_ln8 == 4)              &&
                (memcmp(sr5ptr->sym_r5_name8,"@IDX",4) == 0)))) {
            char *wrkptr;
            int tlen;
            LXBASL *BLp;

            /* Store data in base locator table    */

            COp->baslc++;
            if (COp->baslc > lbaslm) {
              lbaslm = lbaslm + 200;
              COp->baslp = (char *)realloc(COp->baslp,lbaslm * sizeof(LXBASL));
            }
            BLp = (LXBASL *)(COp->baslp + (sizeof(LXBASL) * (COp->baslc - 1)));
            BLp->blid = sr5ptr->sym_r5_ident;
            if (sr5ptr->sym_r5_name_ln8 > 9)
              tlen = 9;
            else
              tlen = sr5ptr->sym_r5_name_ln8;
            memcpy(BLp->blname,sr5ptr->sym_r5_name8,tlen);
            BLp->blname[tlen] = '\0';
          }
          else {
            char *tmpptr = lsymbn;

            /* Create the symbol record in storage */

            if (inbytes > (lsymbe - lsymbn)) {
              tmpptr = (char *)malloc(maxbuf);
              lsymbn = tmpptr;
              lsymbe = tmpptr + maxbuf - 1;
            }
            memcpy(tmpptr,ptr,inbytes);
            lsymbn = lsymbn + inbytes;

            /* Add to symbol lookup table          */

            if (COp->syloc >= lsylom) {
                                                   /* Cannot happen unless number of symbols record not found */
              printf("ERROR: Number of symbols record not found or logic problem\n");
              loclp->indic = errlim;
              return(0);
            }
            else {
              COp->syloc++;
              SLp = (LXSYLO *)(COp->sylop + (sizeof(LXSYLO) * (COp->syloc - 1)));
              SLp->slid = sr5ptr->sym_r5_ident;
              SLp->slsyp = tmpptr;
              curID  = sr5ptr->sym_r5_ident;
              curSLp = SLp;
              curMISCp = 0;
            }
          }
        }
      }
      break ;
      case 0x3E : {                       /* Respecify record            */
        rfy3p rr3ptr;
        //printf("case: 0x3E; Respecify record \n");
        if ((sidelang) && (COp->sylop)) {
          rr3ptr = (rfy3p)ptr;
          if(converted == 0) {
            rr3ptr->rfy_r3_sym_id   = revbi(rr3ptr->rfy_r3_sym_id);
            rr3ptr->rfy_r3_stmt_num = revbi(rr3ptr->rfy_r3_stmt_num);
            rr3ptr->rfy_r3_base_id  = revbi(rr3ptr->rfy_r3_base_id);
            rr3ptr->rfy_r3_f_Ofs    = revbs(rr3ptr->rfy_r3_f_Ofs);
            rr3ptr->rfy_r3_CSECT_   = revbs(rr3ptr->rfy_r3_CSECT_);
            rr3ptr->rfy_r3_Offset   = revbi(rr3ptr->rfy_r3_Offset);
          }
          if (rr3ptr->rfy_r3_sym_id == curID) {
            tempMISCp = (LXMISC *)malloc( sizeof(LXMISC) + inbytes - 1) ;
            if (curMISCp) {
              curMISCp->msmsp = tempMISCp;
            }
            else {
              curSLp->slmsp = tempMISCp;
            }
            curMISCp = tempMISCp;
            memcpy(tempMISCp->mstext,ptr,inbytes);
            tempMISCp->msrt = 6;
            tempMISCp->msmsp = 0;
          }
        }
      }
      break;
      case 0x4C : {                       /* Array record                */
        arra4p ar4ptr;
        //printf("case: 0x4C; Array record \n");
        if ((sidelang) && (COp->sylop)) {
          ar4ptr = (arra4p)ptr;
          if(converted == 0) {
            ar4ptr->array_r4_sym_ident = revbi(ar4ptr->array_r4_sym_ident);
            ar4ptr->array_r4_dep_ident = revbi(ar4ptr->array_r4_dep_ident);
            //pws need to convert arrar_r4_dims based on size
          }
          if (ar4ptr->array_r4_sym_ident == curID) {
            tempMISCp = (LXMISC *)malloc( sizeof(LXMISC) + inbytes - 1) ;
            if (curMISCp) {
              curMISCp->msmsp = tempMISCp;
            }
            else {
              curSLp->slmsp = tempMISCp;
            }
            curMISCp = tempMISCp;
            memcpy(tempMISCp->mstext,ptr,inbytes);
            tempMISCp->msrt = 2;
            tempMISCp->msmsp = 0;
          }
        }
      }
      break ;
      case 0x3B : {                       /* Structure record            */
        stru2p st2ptr;
        //printf("case: 0x3B; Structure record \n");
        if ((sidelang) && (COp->sylop)) {
          st2ptr = (stru2p)ptr;
          if(converted == 0) {        // switch bytes from big to little endian
            /* KENICHI _Packed*/ struct struct_r2_elements *st2eptr;
            st2ptr->struct_r2_owner      = revbi(st2ptr->struct_r2_owner);
            st2ptr->struct_r2_elm_total  = revbs(st2ptr->struct_r2_elm_total);
            st2ptr->struct_r2_elm_first  = revbs(st2ptr->struct_r2_elm_first);
            st2ptr->struct_r2_elm_last   = revbs(st2ptr->struct_r2_elm_last);

            st2eptr = (/* KENICHI _Packed*/ struct struct_r2_elements*)st2ptr->struct_r2_element;
            for (i=0;
                 i<st2ptr->struct_r2_elm_last - st2ptr->struct_r2_elm_first + 1 ;
                 i++) {
              st2eptr->struct_r2_elm_ident  = revbs(st2eptr->struct_r2_elm_ident);   // endian switch
              st2eptr->struct_r2_elm_depth  = revbs(st2eptr->struct_r2_elm_depth);   // endian switch
              st2eptr->struct_r2_elm_level  = revbs(st2eptr->struct_r2_elm_level);   // endian switch
              st2eptr++;
            }
          }
          if (st2ptr->struct_r2_owner == curID) {
            tempMISCp = (LXMISC *)malloc( sizeof(LXMISC) + inbytes - 1) ;
            if (curMISCp) {
              curMISCp->msmsp = tempMISCp;
            }
            else {
              curSLp->slmsp = tempMISCp;
            }
            curMISCp = tempMISCp;
            memcpy(tempMISCp->mstext,ptr,inbytes);
            tempMISCp->msrt = 1;
            tempMISCp->msmsp = 0;
          }
        }
      }
      break ;
      case 0x49 : {                       /* Xref record                 */
        xref1p xrptr;
        //printf("case: 0x49; Xref record \n");
        if ((sidelang) && (COp->sylop)) {
          xrptr = (xref1p)ptr;
          if(converted == 0) {        // switch bytes from big to little endian
            /* KENICHI _Packed*/ struct xref_r1_elements *xreptr;
            xrptr->xref_r1_ident  = revbi(xrptr->xref_r1_ident);
            xrptr->xref_r1_total  = revbs(xrptr->xref_r1_total);
            xrptr->xref_r1_first  = revbs(xrptr->xref_r1_first);
            xrptr->xref_r1_last   = revbs(xrptr->xref_r1_last);
            xreptr = (/* KENICHI _Packed*/ struct xref_r1_elements*)xrptr->xref_r1_element;
            for (i=0;
                 i<xrptr->xref_r1_last - xrptr->xref_r1_first + 1 ;
                 i++) {
              xreptr->xref_r1_stmt     = revbi(xreptr->xref_r1_stmt);   // endian switch
              xreptr->xref_r1_line     = revbi(xreptr->xref_r1_line);   // endian switch
              xreptr++;
            }
          }
          if (xrptr->xref_r1_ident == curID) {
            tempMISCp = (LXMISC *)malloc( sizeof(LXMISC) + inbytes - 1) ;
            if (curMISCp) {
              curMISCp->msmsp = tempMISCp;
            }
            else {
              curSLp->slmsp = tempMISCp;
            }
            curMISCp = tempMISCp;
            memcpy(tempMISCp->mstext,ptr,inbytes);
            tempMISCp->msrt = 3;
            tempMISCp->msmsp = 0;
          }
        }
      }
      break ;

      case 0x3C : {               /* Locates                    */
        loca2p locptr;
        //printf("case: 0x3C; Locates \n");
        if ((sidelang) && (COp->sylop)) {
          locptr = (loca2p)ptr;
          if(converted == 0) {
            int *iptr;
            locptr->loc_r2_owner     = revbi(locptr->loc_r2_owner);
            locptr->loc_r2_nbr_ident = revbs(locptr->loc_r2_nbr_ident);
            iptr = (int *)locptr->loc_r2_nbr_ident ;
            for (i=0;
                 i<locptr->loc_r2_nbr_ident ;
                 i++) {
              *iptr = revbi(*iptr);
              iptr++;
            }
          }
          if (locptr->loc_r2_owner == curID) {
            tempMISCp = (LXMISC *)malloc( sizeof(LXMISC) + inbytes - 1) ;
            if (curMISCp) {
              curMISCp->msmsp = tempMISCp;
            }
            else {
              curSLp->slmsp = tempMISCp;
            }
            curMISCp = tempMISCp;
            memcpy(tempMISCp->mstext,ptr,inbytes);
            tempMISCp->msrt = 4;
            tempMISCp->msmsp = 0;
          }
        }
      }
      break ;

      case 0x43 : {               /* PList   record           */
        plis2p plstptr;
        //printf("case: 0x43; PList record \n");
        if ((sidelang) && (COp->sylop)) {
          plstptr = (plis2p)ptr;
          if(converted == 0) {
            int *iptr;
            plstptr->PList_r2_owner     = revbi(plstptr->PList_r2_owner);
            plstptr->PList_r2_nbr_parms = revbs(plstptr->PList_r2_nbr_parms);
            plstptr->PList_r2_CSECT_    = revbs(plstptr->PList_r2_CSECT_);
            plstptr->PList_r2_stmt_num  = revbi(plstptr->PList_r2_stmt_num);
            plstptr->PList_r2_Offset    = revbi(plstptr->PList_r2_Offset);
            iptr = (int *)plstptr->PList_r2_parm_ident;
            for (i=0;
                 i<plstptr->PList_r2_nbr_parms;
                 i++) {
              *iptr = revbi(*iptr);
              iptr++;
            }
          }
          if (plstptr->PList_r2_owner == curID) {
            tempMISCp = (LXMISC *)malloc( sizeof(LXMISC) + inbytes - 1) ;
            if (curMISCp) {
              curMISCp->msmsp = tempMISCp;
              curMISCp = tempMISCp;
            }
            else {
              curSLp->slmsp = tempMISCp;
            }
            memcpy(tempMISCp->mstext,ptr,inbytes);
            tempMISCp->msrt = 5;
            tempMISCp->msmsp = 0;
          }
        }
      }
      break ;

      case 0x4A : {                       /* Assembler Offset (C++ text) */
        LXAOFF *tAOp;
        int   stepsize,i;
        //printf("case: 0x4A; Assembler Offset \n");
        if (sidelang) {
          txtptr = (ctxt1p)ptr;

          if(converted == 0) {
            txtptr->CTxt_r1_count = revbs(txtptr->CTxt_r1_count);
          }

          txteptr = &(txtptr->CTxt_r1_element[0]);
          stepsize = sizeof(/* KENICHI _Packed*/ struct CTxt_r1_elements);
          if (COp->aoffc == 0) {
            COp->aoffp = (LXAOFF *)malloc(maxbuf) ;
            laoffm = maxbuf / sizeof(LXAOFF);
          }
          for (i=0;i<txtptr->CTxt_r1_count;i++) {

            if(converted == 0) {
              txteptr->CTxt_r1_file_  = revbs(txteptr->CTxt_r1_file_);
              txteptr->CTxt_r1_line_  = revbs(txteptr->CTxt_r1_line_);
              txteptr->CTxt_r1_offset = revbs(txteptr->CTxt_r1_offset);
            }

            COp->aoffc++;
            if (COp->aoffc >= laoffm) {
              laoffm = COp->aoffc * 2;
              COp->aoffp = (LXAOFF *)realloc(COp->aoffp,laoffm * sizeof(LXAOFF));
            }
            tAOp = COp->aoffp + COp->aoffc - 1;
            tAOp->aofile = txteptr->CTxt_r1_file_;
            tAOp->aoline = txteptr->CTxt_r1_line_;
            tAOp->aooff  = txteptr->CTxt_r1_offset;
            txteptr++;
          }
        }
      }
      break ;

      case 0x2C : {               /* Scope type 3               */
        LXSCOP *SCp;
        scop3p  sc3ptr;
        scop3ep sc3eptr;
        int     i,thisc;

        //printf("case: 0x2C; Scope type 3 \n");

        if (sidelang) {
          sc3ptr = (scop3p)ptr;
          if(converted == 0) {
            sc3ptr->scope_r3_total = revbs(sc3ptr->scope_r3_total);
            sc3ptr->scope_r3_first = revbs(sc3ptr->scope_r3_first);
            sc3ptr->scope_r3_last  = revbs(sc3ptr->scope_r3_last);
          }
          if (!COp->scopc) {
            COp->scopc = sc3ptr->scope_r3_total;
            COp->scopp = (LXSCOP *)malloc(sizeof(LXSCOP) * COp->scopc);
            SCp = lscopn = COp->scopp;
          }
          else
            SCp = lscopn;
          thisc = sc3ptr->scope_r3_last - sc3ptr->scope_r3_first + 1;
          sc3eptr = sc3ptr->scope_info3;
          for (i=0;i<thisc;i++,SCp++,sc3eptr++) {

            if(converted == 0) {
               sc3eptr->scope_start3     = revbi(sc3eptr->scope_start3);
               sc3eptr->scope_end3       = revbi(sc3eptr->scope_end3);
               sc3eptr->scope_owner3     = revbs(sc3eptr->scope_owner3);
               sc3eptr->scope_auto_base3 = revbs(sc3eptr->scope_auto_base3);
               sc3eptr->scope_Ident3     = revbi(sc3eptr->scope_Ident3);
            }
            SCp->scstart = sc3eptr->scope_start3;
            SCp->scend   = sc3eptr->scope_end3;
            SCp->scowner = sc3eptr->scope_owner3;
            SCp->scident = sc3eptr->scope_Ident3;
            lscopn = SCp + 1;
          }
        }
      }
      break ;

      case 0x4E : {               /* File Include record type 1 */
        fili1p  fi1ptr;

        //printf("case: 0x4E; File Include record type 1 \n");

        if (sidelang) {
          fi1ptr = (fili1p)ptr;
          if(converted == 0) {
            fi1ptr->FInc_r1_file     = revbi(fi1ptr->FInc_r1_file);
            fi1ptr->FInc_r1_inc_file = revbi(fi1ptr->FInc_r1_inc_file);
            fi1ptr->FInc_r1_inc_line = revbi(fi1ptr->FInc_r1_inc_line);
          }
          /* Create an LXFILI record in storage                 */
          FIp = (LXFILI *)malloc(sizeof(LXFILI) + fi1ptr->FInc_r1_name_len);
          FIp->fifinp = 0;        /* no next record yet         */
          if (!COp->filic) {
            COp->filic = 1;
            COp->filip = FIp;     /* Control record LXFILI pointer points to 1st record */
            cFIp       = FIp;     /* maintain current LXFILI pointer                    */
          }
          else {
            cFIp->fifinp = FIp;
            COp->filic++;
            cFIp = FIp;
          }
          cFIp->fifile = fi1ptr->FInc_r1_file;     /* File number                       */
          cFIp->fiincf = fi1ptr->FInc_r1_inc_file; /* Included From file number         */
          cFIp->fiincl = fi1ptr->FInc_r1_inc_line; /* Included From line number         */
                                                   /* File name                         */
          memcpy(cFIp->finame,fi1ptr->FInc_r1_name,fi1ptr->FInc_r1_name_len);
          cFIp->finame[fi1ptr->FInc_r1_name_len] = '\0'; /* terminate string            */
        }
      }
      break ;

      case 0x4F : {               /* Validation record type 1   */
        LXVALI *VAp;
        vali1p  va1ptr;
        vali1ep va1eptr;
        int     i,thisc;
        //printf("case: 0x4F; Validation record type 1 \n");

        if (sidelang) {
          va1ptr = (vali1p)ptr;
          if(converted == 0) {
            va1ptr->valid_r1_total = revbs(va1ptr->valid_r1_total);
          }
          COp->valic = va1ptr->valid_r1_total;
          COp->valip = (LXVALI *)malloc(sizeof(LXVALI) * COp->valic);
          VAp = COp->valip;
          thisc = va1ptr->valid_r1_total;
          va1eptr = va1ptr->valid_info1;
          for (i=0;i<thisc;i++,va1eptr++,VAp++) {
            if(converted == 0) {
              va1eptr->valid_r1_type = revbi(va1eptr->valid_r1_type);
              va1eptr->valid_r1_len  = revbi(va1eptr->valid_r1_len);
              va1eptr->valid_r1_loc  = revbi(va1eptr->valid_r1_loc);
            }
            VAp->vatype  = va1eptr->valid_r1_type;
            VAp->valen   = va1eptr->valid_r1_len;
            VAp->valoc   = va1eptr->valid_r1_loc;
          }
        }
      }
      break ;

      case 0x50 : {               /* os/vs cobol record type 1  */
        //printf("case: 0x50; os/vs cobol record type 1  \n");
        COp->osvsp = (char *)malloc(inbytes) ;
        memcpy(COp->osvsp,ptr,inbytes);
      }
      break ;

      case 0x52 : {               /* compiler options   type 1  */
        //printf("case: 0x52; compiler options type 1  \n");
        if (COp->CompOpts) {      /* not first x'52' record     */
          int strl = strlen(COp->CompOpts);
          char *optptr;
          COp->CompOpts = (char *)realloc(COp->CompOpts,strl + inbytes-2) ;
          optptr = COp->CompOpts + strl;
          memcpy(optptr,ptr+3,inbytes-3);
          optptr = optptr + inbytes - 3;
          *(optptr) = '\0';
        }
        else {
          COp->CompOpts = (char *)calloc(1,inbytes-2) ;
          memcpy(COp->CompOpts,ptr+3,inbytes-3);
        }
      }
      break ;
      //printf("case 0x%2.2x not found******************** \n", *ptr);
    }

    if (FA_PC) {
      unsigned int scount;
      inbytes = fread(pszbuf, 1, 4, inf); /* read first record  */
      //printf("inbytes = %i\n",inbytes);
      //printf("pszbuf = 0x%2.2X %2.2X %2.2X %2.2X\n", *pszbuf, *(pszbuf+1), *(pszbuf+2), *(pszbuf+3));
      if (feof(inf) || inbytes <= 0) {
         //printf("eof\n");
         break;
      }
      scount = *(unsigned int*)pszbuf;
      scount = revbi(scount);
      count = (size_t)(scount);
      //printf("count = %i\n",count);
    }else{
      count = 32760;
    }
    inbytes = fread(pszbuf, 1, count, inf); /* read next record       */
    //printf("inbytes = %i\n",inbytes);
    //printf("pszbuf = 0x%2.2X %2.2X %2.2X %2.2X\n", *pszbuf, *(pszbuf+1), *(pszbuf+2), *(pszbuf+3));
  }                                      /* while good records        */

  /***************************************************************************/
  /* Free storage no longer required                                         */
  /***************************************************************************/

  if (COp->aoffc)
    COp->aoffp = (LXAOFF *)realloc(COp->aoffp,COp->aoffc * sizeof(LXAOFF));

  if (fclose(inf)) {
    loclp->indic = errcls ;
    return(0) ;
  }
  if (tempptr)
    free(tempptr);
  free(pszbuf);

  return((LXCONT *)COp);
}


//copied from idivlocl.c

/*********************************************************************/
/*|:h4.transline()                                                   */
/*|:p.transline() unpacks a source line from IDILANGX.               */
/*********************************************************************/
/* transline receives a pointer to an LXSOUR record or a LXSYLO      */
/* record and returns a pointer to a string containing the source    */
/* record. However, if a LXSYLO record is passed, build a symbol     */
/* declaration statement (Suppressed copybooks).                     */
/*                                                                   */
/*********************************************************************/
char *transline(LXCONT *COp,void *recptr,LOCL *loclp,int actual) {
sour3p  so3ptr;
sour4p  so4ptr;
symb5p  sr5ptr;
LXSOUR *SOp;
LXSYLO *SLp;

int calclen,clen,i,ltype,bufsize=90;
char *fromptr,*toptr,*srcbuf,*endptr,*ptr;
struct sym_r5_long_sym *tlptr;

  writeLogMsg("transline called....");
  //printf("transline()\n");
  if (!(COp)) {
    loclp->indic = erruns;
    printf("transline entered with control pointer COp zero\n");
    return 0;
  }
  loclp->lineind = COp->storlin;             /* STMT if 0 else NUMBER */

  if (((int)recptr >= (int)(COp->sylop))                &&
      ((int)recptr <= (int)(((LXSYLO *)COp->sylop) + COp->syloc))) {

    /* We have a symbol look-up entry so we have come from a COBSTORE that */
    /* has a SUPPRESSED COPYBOOK in. We need to build a declaration.       */

    SLp = (LXSYLO *)recptr;
    sr5ptr = (symb5p)SLp->slsyp ;
    if (*(char *)(sr5ptr) != 0x4D) {
      loclp->indic = erruns;
      printf("transline: expecting a symbol record but not recognised\n");
      return 0;
    }
    srcbuf = (char *)malloc(bufsize) ;
    //memset(srcbuf, ' ',bufsize) ;
    memset(srcbuf, 0x40,bufsize) ;   //endian
    strcpy(srcbuf+6," @ "); /* character to recognise suppressed item in report */
    if (sr5ptr->sym_r5_flags3 & 0x80) {  /* long symbol name */
      tlptr = (struct sym_r5_long_sym *)&sr5ptr->sym_r5_name_ln8;
      i = tlptr->sym_r5_name_ln15;
      ptr = tlptr->sym_r5_name15;
    }
    else {  /* short symbol name */
      i = sr5ptr->sym_r5_name_ln8;
      ptr = sr5ptr->sym_r5_name8;
    }
    if (i>80) i = 80;
    memcpy(srcbuf+9,ptr,i);
    *(srcbuf+i+9) = '\0';
    loclp->lastchar = '.'; /* ????? */

    return(srcbuf) ;
  }

  /* So its a LXSOUR record */

  SOp = (LXSOUR *)recptr;
  so3ptr = (sour3p)SOp->sotext;
  if ((*(char*)(so3ptr) == 0x2E) || /* source record */
      (*(char*)(so3ptr) == 0x4B)) { /* source record */
    int wrk_len;
    char *wrk_from;
    int wrk_pack = 0;
    int smacro = 0;
    if (*(char*)(so3ptr) == 0x2E) {
      if (so3ptr->src_r3_type == 2)
        smacro = 1;
      loclp->file = 0;
      loclp->line = so3ptr->src_r3_line_num;
      loclp->stmt = so3ptr->src_r3_stmt_num;
      if (actual)
        loclp->actdispl = so3ptr->src_r3_offset;
      if (so3ptr->src_r3_flags & PACKED )  /* packed  */
        wrk_pack = 1;
      wrk_len = so3ptr->src_r3_text_ln;
      wrk_from = (char *)so3ptr->src_r3_text;
    }
    else { /* Record Type 4B */
      so4ptr = (sour4p)so3ptr;
      if (so4ptr->src_r4_type == 2)
        smacro = 1;
      loclp->file = so4ptr->src_r4_file_;
      loclp->line = so4ptr->src_r4_line_num;
      loclp->stmt = so4ptr->src_r4_stmt_num;
      if (actual)
        loclp->actdispl = so4ptr->src_r4_offset;
      //if (so4ptr->src_r4_packed == 1    )  /* packed  */
      if (so4ptr->src_r4_flags & PACKED    )  /* packed  */
        wrk_pack = 1;
      wrk_len = so4ptr->src_r4_text_ln;
      wrk_from = (char *)so4ptr->src_r4_text;
    }
    if ((loclp->lxcontp) &&
        (loclp->lxcontp->wdblang == lASM)) {
      int stmt = loclp->stmt;

      loclp->stmt = loclp->line;
    //loclp->line = 0;        $$ZAP what's with this? I need line=line and stmt=stmt!!!
      loclp->line = stmt;   // but will work with line=stmt and stmt=line for now... zzzjb
      loclp->file = 0;
    }
    calclen = wrk_len;
    if (wrk_pack) { /* packed  */
    	writeLogMsg("Packed data....");
      fromptr = wrk_from;
      endptr = fromptr + wrk_len;
      while (fromptr < endptr) {
        if (*(fromptr) == 0xFE) { /* packed spaces follow    */
          fromptr++;
          calclen = calclen + *(fromptr) - 2;
        }
        if (*(fromptr) == 0xFF) { /* packed non-spaces follow*/
          calclen = calclen + *(fromptr+1) - 3;
          fromptr=fromptr+2;
        }
        fromptr++;
      }
      srcbuf = (char *)malloc(calclen+2) ;
      fromptr = wrk_from;
      toptr = srcbuf;
      if ((loclp->lxcontp) &&
          (loclp->lxcontp->wdblang == lASM)) {
        if (smacro)
          //*(srcbuf) = '+';
          *(srcbuf) = 0x4E;   //endian
        else
          //*(srcbuf) = ' ';
          *(srcbuf) = 0x40;   //endian
        toptr = srcbuf + 1;
      }
      endptr = fromptr + wrk_len;
      if (wrk_len > 0) {
      	char buffer[100];
      	sprintf(buffer, "wrk_len = %d", wrk_len);
      	writeLogMsg(buffer);
        while (fromptr < endptr) {
          
           sprintf(buffer, "fromptr %2.2X %2.2X %2.2X %2.2X %2.2X", (unsigned char) *(fromptr-5), (unsigned char) *(fromptr-4), (unsigned char) *(fromptr-3), (unsigned char) *(fromptr-2), (unsigned char) *(fromptr-1));
           writeLogMsg(buffer);
           
           sprintf(buffer, "fromptr2 %2.2X %2.2X %2.2X %2.2X %2.2X", (unsigned char) *(fromptr), (unsigned char) *(fromptr+11), (unsigned char) *(fromptr+2), (unsigned char) *(fromptr+3), (unsigned char)*(fromptr+4));
           writeLogMsg(buffer);           
      
          //if (((unsigned char) (*(fromptr))) == 0xFE) {//(unsigned char) 0xFE) { /* packed spaces follow    */
          if (*(fromptr) == 0xFE) {
          	writeLogMsg("packed spaces follow...");
            clen = *(fromptr+1) ;
            for (i=0;i<clen;i++) {
              //*(toptr) = ' ';
              *(toptr) = 0x40;     // endian
              toptr++;
              writeLogMsg("added space...");
            }
            fromptr=fromptr+2;
            writeLogMsg("finished packed space...");
          }
          else if (*(fromptr) == 0xFF) { /* packed non-spaces follow*/
          	writeLogMsg("packed non-space follow...");
            clen = *(fromptr+1) ;
            fromptr=fromptr+2;
            for (i=0;i<clen;i++) {
              *(toptr) = *(fromptr);
               toptr++;
               writeLogMsg("adding something...");
            }
            fromptr++;
            writeLogMsg("finished packed non space...");
          }
          else {
            *(toptr) = *(fromptr);
            toptr++;
            fromptr++;
            writeLogMsg("Other entry...");
          }
        }
      } else {
      	// KENICHI
      	writeLogMsg("No length determined...");
      }
      *(toptr) = '\0';                  /* terminate string */
    }
    else {
    	writeLogMsg("Not packed data!");
      srcbuf = (char *)malloc(calclen+2) ;
      fromptr = wrk_from;
      toptr = srcbuf;
      if ((loclp->lxcontp) &&
          (loclp->lxcontp->wdblang == lASM)) {
        if (smacro)
          *(srcbuf) = '+';
        else
          *(srcbuf) = ' ';
        toptr = srcbuf + 1;
      }
      memcpy(toptr,fromptr,calclen);
      toptr = toptr + calclen;
      *(toptr) = '\0';                  /* terminate string */
    }

    // translate on PC
    writeLogMsg("Just before FA_PC...");
    if(FA_PC) {
    	/*
      char *textout;
      char *iconvin;
      char *iconvout;
      
      iconvout = textout = (char *)malloc(calclen+2) ;
      iconvout[calclen] = '\0';
      iconvin = srcbuf;
      
      ebcdicStr2asciiStr(iconvout, iconvin, calclen);
      memcpy(srcbuf, textout, calclen+2);
      	
	writeLogMsg("ASCII start.........");
	writeLogMsg(iconvout);
	writeLogMsg("ASCII end...........");
	
    	writeLogMsg("Should be performing iconv for the following text");
    	writeLogMsg(srcbuf);
    	writeLogMsg("finished...");
    	*/
    	
      size_t inleft; // number of bytes left in inbuf
      size_t outleft;// number of bytes left in outbuf
     // iconv_t cd;     // conversion descriptor          
      int    rc;     // return code of iconv()
      char *textout;
      char *iconvin;
      char *iconvout;
      char tmpBuffer[1025];
      
      sprintf(tmpBuffer, "%2.2X %2.2X %2.2X %2.2X %2.2X", srcbuf[0], srcbuf[1], srcbuf[2], srcbuf[3], srcbuf[4]);
      writeLogMsg(tmpBuffer);
   
      sprintf(tmpBuffer, "%2.2X %2.2X %2.2X %2.2X %2.2X", srcbuf[5], srcbuf[6], srcbuf[7], srcbuf[8], srcbuf[9]);
      writeLogMsg(tmpBuffer); 

      iconvout = textout = (char *)malloc(calclen+2) ;
      iconvin = srcbuf;

/*
      cd = iconv_open("IBM-850", "IBM-1047");
      if(cd == (iconv_t)(-1)) {
         printf("Error: iconv_open returned -1\n");
         return 0;
      }
      */
      inleft = outleft = calclen+2;
      /*
      rc = iconv(cd, &iconvin, &inleft, &iconvout, &outleft);
      if (rc == -1) {
        printf("ICONV error, quit \n");
        return 0;
      }
      */
      ebcdicStr2asciiStr(iconvout, iconvin, inleft);
      memcpy(srcbuf,textout,calclen+2);
      
    }
    writeLogMsg("After FA_PC....");


  /* Now eliminate any non-printable characters      */

    ConvertNonPrint(srcbuf, (int)(toptr-srcbuf), 1);

  /* Now find last non-blank character               */

    if ((loclp->lxcontp)                     &&
        ((loclp->lxcontp->wdblang == lPLI)   ||
         (loclp->lxcontp->wdblang == lEPLI))) {
      loclp->margl = loclp->lxcontp->margl;
      loclp->margr = loclp->lxcontp->margr;
      i = strlen(srcbuf);
      if (loclp->margr > i)
        loclp->margr = i;

      toptr = srcbuf + loclp->margr - 1;
      while ((toptr > (srcbuf + loclp->margl - 1)) &&
             (*(toptr) == ' ')) {
        toptr--;
      }
      loclp->lastchar = *(toptr);

      return(srcbuf) ;
    }

    if ((loclp->lxcontp)                       &&
        ((loclp->lxcontp->wdblang == lCOBOL)   ||
         (loclp->lxcontp->wdblang == lCOBOLO))) {
      //if (*(srcbuf + 6) == '*') {
      if (*(srcbuf + 6) == '*') {
        loclp->lastchar = '*';
        return(srcbuf);
      }
      if (toptr > srcbuf + 72)   /* sequences on right */
        toptr = srcbuf + 71;
      else
        toptr = toptr - 1;
    }
    else
      toptr = toptr - 1;

    while ((toptr > srcbuf) && (*(toptr) == ' ')) {
      toptr--;
    }
    loclp->lastchar = *(toptr);

    return(srcbuf) ;
  }
  else {
    loclp->indic = erruns;
    printf("transline: expecting a source record but not recognised\n");
    return 0;
  }
}

/*********************************************************************/
/*|:h4.findSymbol()                                                  */
/*|:p.findSymbol() performs a binary search to find the              */
/*|correct Id entry in the Symbol Lookup table.                      */
/*********************************************************************/
/*
LXSYLO *findSymbol(LXCONT *COp,int Id ) {
LXSYLO *SLp;

  SLp = (LXSYLO *)bsearch(&(Id),COp->sylop,COp->syloc,sizeof(LXSYLO),compare2);

  return(SLp);

} */


/*********************************************************************/
/*|:h4.vInit()                                                       */
/*|:p.vInit() initializes the pVcom area and any other initial setup */
/*|required for Program Source View                                  */
/*********************************************************************/
void vInit(void ) {
  pVcom = (VCOMMON *) calloc(1, sizeof(VCOMMON)) ;
  strcpy( pVcom->eye, "VCOMMON") ;
}


//copied from idicusub.c
/*********************************************************************/
/*|:h4.ConvertNonPrint()                                             */
/*|:p.Convert non-printable characters to periods.                   */
/*|:p.Exclude DBCS characters from conversion if dbcsflag is         */
/*|non-zero.                                                         */
/*********************************************************************/
void ConvertNonPrint(char *pText, int len, int dbcsflag) {
  int i, j, dbcsState = 0;

  for (i = 0; i < len; ++i) {
    if (dbcsflag && pText[i] == SHIFT_OUT) {
      /* Need to look ahead for a 'shift in' to determine if this is a valid
         DBCS sequence */
      for (j = i + 1; j < len; ++j) {
        if (!pText[j])
          break;  /* DBCS cannot contain X'00' bytes */
        if (pText[j] == SHIFT_IN) {
          dbcsState = 1;
          break;
        }
      }
    }
    if (!dbcsState && !isprint(pText[i]))
      pText[i] = '.';
    if (dbcsflag && pText[i] == SHIFT_IN)
      dbcsState = 0;
  }
}
