/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.action;

import com.ibm.fmi.model.DefiningObject;
import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.FMIResourceIterator;
import com.ibm.fmi.model.Field;
import com.ibm.fmi.model.FieldIterator;
import com.ibm.fmi.model.TemplattedData;
import com.ibm.fmi.model.event.FMIResource;
import com.ibm.fmi.model.exception.FMIException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.ui.UiPlugin;
import com.ibm.fmi.ui.action.EditorAction;
import com.ibm.fmi.ui.dialog.RecordDialog;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class AddRowActions
extends EditorAction {
    protected String text;

    public AddRowActions(String text) {
        super(text);
        this.text = text;
    }

    public void run() {
        int index = 0;
        Iterator it = this.getStructuredSelection().iterator();
        Object obj = it.next();
        DisplayLine line = (DisplayLine)obj;
        TemplattedData input = (TemplattedData)line.getParent();
        FMIResourceIterator dlIter = input.getDisplayLineIterator();
        FieldIterator fi = input.getCurLayout().getFieldIterator();
        Vector<DefiningObject> dOs = new Vector<DefiningObject>();
        while (fi.hasNext()) {
            Field field = fi.next();
            if (!(field instanceof DefiningObject)) continue;
            dOs.add((DefiningObject)field);
        }
        int[] values = null;
        if (!dOs.isEmpty()) {
            Shell shell = Display.getDefault().getActiveShell();
            RecordDialog dialog = new RecordDialog(dOs, shell);
            dialog.open();
            values = dialog.getValues();
            if (values == null) {
                return;
            }
        }
        try {
            index = dlIter.indexOf((FMIResource)line);
            if (this.text.equals(UiPlugin.getString("ADD_RECORD_AFTER"))) {
                ++index;
            }
            if (values != null) {
                input.addRecord(input.getCurLayout(), values, index);
            } else {
                input.addRecord(input.getCurLayout(), new int[0], index);
            }
        }
        catch (FMIParseException e) {
            UiPlugin.trace(0, (Object)this, UiPlugin.getString("error.invald.add"), e);
            e.printStackTrace();
        }
        catch (FMIException e) {
            UiPlugin.trace(0, (Object)this, UiPlugin.getString("error.invald.add"), e);
        }
    }
}

