/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.dialog;

import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.TemplattedData;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.ui.UiPlugin;
import com.ibm.fmi.ui.providers.HexRecordWrapper;
import java.util.Iterator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class RemoveRecordDialog
extends MessageDialog {
    Iterator it;
    DisplayLine dispLine;

    public RemoveRecordDialog(Shell parentShell, Iterator it) {
        super(parentShell, UiPlugin.getString("Dialog.remove.title"), null, UiPlugin.getString("Dialog.remove.message"), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        this.it = it;
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        if (buttonId == 0) {
            while (this.it.hasNext()) {
                Object obj = this.it.next();
                DisplayLine dLine = null;
                if (obj instanceof DisplayLine) {
                    dLine = (DisplayLine)obj;
                } else if (obj instanceof HexRecordWrapper) {
                    dLine = ((HexRecordWrapper)obj).getRecord();
                }
                if (dLine == null) continue;
                try {
                    ((TemplattedData)dLine.getParent()).removeDisplayLine(dLine);
                }
                catch (FMIKeyException e) {
                    UiPlugin.trace(1, (Object)this, UiPlugin.getString("Error.removeLine"), e);
                }
                catch (FMIModelException e) {
                    UiPlugin.trace(1, (Object)this, UiPlugin.getString("Error.removeLine"), e);
                }
            }
        }
        this.close();
    }
}

