/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.ui.editoropener;

import com.ibm.etools.systems.core.SystemPlugin;
import com.ibm.etools.systems.core.resources.ISystemEditableRemoteObject;
import com.ibm.fmi.client.FMIClientUtilities;
import com.ibm.fmi.client.FMIEditSessionProperties;
import com.ibm.fmi.client.FMIEditorInput;
import com.ibm.fmi.client.operation.FMIDownloadOperation;
import com.ibm.fmi.ui.editors.FileManagerIntegrationEditor;
import com.ibm.ftt.resources.core.physical.IPhysicalResource;
import com.ibm.ftt.resources.zos.filesystem.MVSResource;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import com.ibm.ftt.resources.zos.util.MVSSystemEditableRemoteFile;
import com.ibm.ftt.resources.zos.zosphysical.ZOSResource;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSResourceImpl;
import com.ibm.ftt.ui.actions.UIActionsResources;
import com.ibm.ftt.ui.actions.core.ActionsPlugin;
import com.ibm.ftt.ui.actions.editoropener.AbstractEditorOpener;
import com.ibm.ftt.ui.resources.core.editor.EditorOpenerException;
import com.ibm.ftt.ui.resources.core.editor.EditorUtils;
import com.ibm.ftt.ui.resources.core.editor.IEditorOpener;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.IProgressService;

public class FMIPhysicalReferenceEditorOpener
extends AbstractEditorOpener {
    public static final String COPY_RIGHT = "  Licensed Materials - Property of IBM, 5724-L44, (C) Copyright IBM Corp. 2006 All rights reserved.  US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static FMIPhysicalReferenceEditorOpener eINSTANCE = new FMIPhysicalReferenceEditorOpener();

    public static IEditorOpener getInstance() {
        return eINSTANCE;
    }

    private FMIPhysicalReferenceEditorOpener() {
    }

    public void open(Object resource) throws Exception {
        ZOSResource remoteFile = this.getRemoteFile(resource);
        this.getEditorID(remoteFile, null);
        Object editorObject = this.getEditorObject(resource);
        if (remoteFile == null) {
            ActionsPlugin.getDefault().writeMsg(Level.SEVERE, "*** com.ibm.ftt.ui.actions.MVSPhysicalEditorOpener#open(Object): Could not retrieve remote file object, ZOSResource for " + resource);
            throw new EditorOpenerException(NLS.bind((String)UIActionsResources.MVSEditorOpener_CouldNotRetrieveRemoteFile, (Object)resource.toString(), (Object)resource.getClass().getName()), "com.ibm.ftt.ui.actions", 1);
        }
        if (editorObject == null) {
            ActionsPlugin.getDefault().writeMsg(Level.SEVERE, "*** com.ibm.ftt.ui.actions.MVSPhysicalEditorOpener#open(Object): Could not retrieve editor object for " + remoteFile.getResourceIdentifier().getFullNameString());
            throw new EditorOpenerException(NLS.bind((String)UIActionsResources.MVSEditorOpener_CouldNotRetrieveEditorObject, (Object)resource.toString(), (Object)resource.getClass().getName()), "com.ibm.ftt.ui.actions", 1);
        }
        this.processOpen(remoteFile, editorObject, null, false);
    }

    public void open(Object resource, IEditorDescriptor editorDescriptor) throws Exception {
        ZOSResource remoteFile = this.getRemoteFile(resource);
        this.getEditorID(remoteFile, null);
        Object editorObject = this.getEditorObject(resource);
        if (remoteFile == null) {
            ActionsPlugin.getDefault().writeMsg(Level.SEVERE, "*** com.ibm.ftt.ui.actions.MVSPhysicalEditorOpener#open(Object,String): Could not retrieve remote file object, ZOSResource for " + resource);
            throw new EditorOpenerException(NLS.bind((String)UIActionsResources.MVSEditorOpener_CouldNotRetrieveRemoteFile, (Object)resource.toString(), (Object)resource.getClass().getName()), "com.ibm.ftt.ui.actions", 1);
        }
        if (editorObject == null) {
            ActionsPlugin.getDefault().writeMsg(Level.SEVERE, "*** com.ibm.ftt.ui.actions.MVSPhysicalEditorOpener#open(Object,String): Could not retrieve editor object for " + remoteFile.getResourceIdentifier().getFullNameString());
            throw new EditorOpenerException(NLS.bind((String)UIActionsResources.MVSEditorOpener_CouldNotRetrieveEditorObject, (Object)resource.toString(), (Object)resource.getClass().getName()), "com.ibm.ftt.ui.actions", 1);
        }
        this.processOpen(remoteFile, editorObject, editorDescriptor, false);
    }

    public void browse(Object resource) throws Exception {
    }

    protected void processOpen(ZOSResource remoteFile, Object editObject, IEditorDescriptor editorDescriptor, boolean browse) throws Exception {
        if (remoteFile == null) {
            return;
        }
        String editorId = this.getEditorID(remoteFile, editorDescriptor);
        MVSResource rsc = ((ZOSResourceImpl)remoteFile).getMvsResource();
        FMIClientUtilities.cleanUpDatasets((String)FMIClientUtilities.getLocalPath((MVSResource)rsc));
        FMIEditorInput fmiInput = null;
        try {
            String templateName = FMIClientUtilities.getTemplateName((IPhysicalResource)remoteFile);
            try {
                FMIDownloadOperation downloadOperation = new FMIDownloadOperation(rsc, (ZOSResourceImpl)editObject, templateName);
                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                progressService.run(true, false, (IRunnableWithProgress)downloadOperation);
                IFile file = downloadOperation.getFile();
                FMIEditSessionProperties properties = FMIClientUtilities.getDatasetProperties((MVSResource)rsc);
                fmiInput = new FMIEditorInput(file, properties, (ZOSResourceImpl)remoteFile);
            }
            catch (InterruptedException ie) {
                ErrorDialog.openError((Shell)SystemPlugin.getActiveWorkbenchShell(), (String)"Error downloading file", (String)ie.getMessage(), (IStatus)new Status(4, "FMIEditor", 0, ie.getMessage(), null));
                throw ie;
            }
        }
        catch (Exception e) {
            ActionsPlugin.getDefault().writeMsg(Level.SEVERE, "*** com.ibm.ftt.ui.actions.FMIPhysicalReferenceEditorOpener#processOpen(ZOSResource,Object,String): Could not retrieve file contents for " + remoteFile.getResourceIdentifier().getFullNameString(), (Throwable)e);
            throw e;
        }
        if (fmiInput != null) {
            IWorkbenchPage page;
            IDE.setDefaultEditor((IFile)fmiInput.getFile(), (String)editorId);
            IWorkbenchWindow dw = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (dw != null && (page = dw.getActivePage()) != null) {
                try {
                    FileManagerIntegrationEditor cfr_ignored_0 = (FileManagerIntegrationEditor)IDE.openEditor((IWorkbenchPage)page, (IEditorInput)fmiInput, (String)editorId);
                }
                catch (PartInitException e) {
                    ActionsPlugin.getDefault().writeMsg(Level.SEVERE, "*** com.ibm.ftt.ui.actions.MVSEditorOpener#processOpen(ZOSResource,Object,String): Could not open editor " + editorId, (Throwable)e);
                    throw e;
                }
            }
        }
    }

    private String getEditorID(ZOSResource remoteFile, IEditorDescriptor editorDescriptor) {
        String editorId = null;
        if (editorDescriptor != null) {
            editorId = editorDescriptor.getId();
        }
        if (editorId == null) {
            editorId = EditorUtils.getInstance().getDefaultEditor((Object)remoteFile).getId();
        }
        return editorId;
    }

    public Object getEditorObject(Object resource) {
        return ((MVSFileResource)resource).getZOSResource();
    }

    public ZOSResource getRemoteFile(Object resource) {
        return ((MVSFileResource)resource).getZOSResource();
    }

    public ISystemEditableRemoteObject getEditableRemoteObject(Object element, IEditorDescriptor editorDescriptor) {
        String id = editorDescriptor.getId();
        return new MVSSystemEditableRemoteFile((MVSFileResource)element, id);
    }

    protected IFile getIFile(Object resource) throws Exception {
        return null;
    }
}

