/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model;

import com.ibm.fmi.model.FieldGroup;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.fmi.model.event.FMIModelFieldChangeEvent;
import com.ibm.fmi.model.event.IFMIModelListener;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIKeyException;
import com.ibm.fmi.model.exception.FMIModelException;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field
extends FieldGroup {
    protected final String IN_FIELD = "in Field";
    protected final char BADFIELDCHAR = (char)42;
    protected boolean isValid = false;
    protected int displayIndex;
    protected boolean isKeyField;
    protected boolean isAligned;
    protected int displayOrder;
    public static final int UNDEFINED_DISPLAY_ORDER = 511;
    protected IFMIDataTypeConverter converter = null;
    protected Object[] conversionParams = null;
    protected String strValue = null;
    public static final int FULL_RECORD_WIDTH = -22;

    public Field(String name, int level, int recordOffset, int length, int numSlackBytes, int symbol, boolean isAligned, IFMIDataTypeConverter converter, Object[] conversionParameters) throws FMIConversionException {
        super(name, level, recordOffset, length, symbol, new FieldGroup[0]);
        this.numSlackBytes = numSlackBytes;
        this.converter = converter;
        this.conversionParams = conversionParameters;
        this.maxAsciiWidth = this.converter.getMaxASCIIWidth(this.ebcdicWidth, this.conversionParams);
        this.isAligned = isAligned;
        this.editable = true;
        this.empty = false;
        this.isKeyField = false;
        this.hasContent = true;
        this.displayOrder = 0;
    }

    @Override
    public Field copy() {
        try {
            Field newField = new Field(this.name, this.level, this.recordOffset, this.ebcdicWidth, this.numSlackBytes, this.symbol, this.isAligned, this.converter, this.conversionParams);
            newField.hasRedefine = this.hasRedefine;
            newField.editable = this.editable;
            newField.empty = this.empty;
            newField.setStartLayoutIndex(this.startLayoutIndex);
            newField.setDisplayOrder(this.displayOrder);
            newField.setIsKeyField(this.isKeyField);
            return newField;
        }
        catch (FMIConversionException fe) {
            fe.printStackTrace();
            return null;
        }
    }

    @Override
    public void setUpChildren() {
    }

    public void setMaxEbcdicWidth(int maxEbcdicWidth) {
        this.ebcdicWidth = maxEbcdicWidth;
    }

    public String getAsciiStr() {
        return this.strValue;
    }

    @Override
    public int getActualEbcdicWidth() {
        return this.empty ? 0 : super.getActualEbcdicWidth();
    }

    public void setDefaultValue() throws FMIModelException {
        byte[] defaultEbcdic = this.converter.getDefaultValue(this.ebcdicWidth, this.conversionParams);
        try {
            this.setEbcdic(defaultEbcdic, 0, false, true, false);
        }
        catch (FMIConversionException fMIConversionException) {
            throw new FMIModelException("Internal Error - invalid default field");
        }
    }

    @Override
    public int setEbcdic(byte[] ebcdic, int decrement, boolean initializing, boolean forceVal, boolean fireEvent) throws FMIConversionException, FMIKeyException, FMIModelException {
        if (decrement != 0) {
            this.recordOffset -= decrement;
        }
        byte[] ebcdicValue = this.getEbcdicValue();
        if (!initializing && Arrays.equals(ebcdic, ebcdicValue)) {
            return decrement;
        }
        if (initializing) {
            ebcdic = ebcdicValue;
        }
        try {
            String convertString;
            if (this.maxAsciiWidth == this.NO_WIDTH || this.maxAsciiWidth == -22) {
                this.maxAsciiWidth = this.converter.getMaxASCIIWidth(ebcdicValue.length, this.conversionParams);
            }
            if (!this.checkSpecialCriteria(convertString = this.converter.EBCDICtoASCIIstr(ebcdic, this.maxAsciiWidth, this.conversionParams), ebcdic)) {
                return decrement;
            }
            ebcdicValue = ebcdic;
            this.strValue = convertString;
            this.actualWidth = ebcdicValue.length;
            this.isValid = true;
            if (fireEvent) {
                this.fireChange(ebcdicValue);
            }
            if (!initializing) {
                this.parentResource.setRecordContent(this.recordOffset, ebcdic, this, fireEvent);
            }
        }
        catch (FMIConversionException fe) {
            if (forceVal) {
                this.setFieldInError(ebcdicValue, ebcdic, initializing, fireEvent);
            }
            throw this.addMessageToConversionException(fe);
        }
        this.initialized = true;
        return decrement;
    }

    protected boolean checkSpecialCriteria(String stringVal, byte[] ebcdicVal) throws FMIModelException {
        return true;
    }

    protected void setFieldInError(byte[] oldValue, byte[] newValue, boolean initializing, boolean fireEvent) throws FMIModelException {
        this.isValid = false;
        this.strValue = "";
        int i = 0;
        while (i < this.maxAsciiWidth) {
            this.strValue = String.valueOf(this.strValue) + '*';
            ++i;
        }
        if (!initializing && newValue != null) {
            this.parentResource.setRecordContent(this.recordOffset, newValue, this, fireEvent);
        }
        if (fireEvent && oldValue != null) {
            this.fireChange(oldValue);
        }
    }

    protected void updateStringValue(boolean test) throws FMIModelException {
        byte[] ebcdicValue = this.getEbcdicValue();
        try {
            String tempString = this.converter.EBCDICtoASCIIstr(ebcdicValue, this.maxAsciiWidth, this.conversionParams);
            if (!this.checkSpecialCriteria(tempString, ebcdicValue)) {
                throw new FMIModelException("Change causes invalid Field");
            }
            if (!test) {
                this.strValue = tempString;
                this.isValid = true;
            }
        }
        catch (FMIConversionException fMIConversionException) {
            this.setFieldInError(null, null, false, false);
        }
    }

    protected void fireChange(byte[] oldValue) throws FMIModelException {
        this.fireModelFieldChangeEvent(new FMIModelFieldChangeEvent(this, (Record)this.parentResource, FMIModelFieldChangeEvent.FMIFieldOperation.CHANGE, oldValue));
    }

    @Override
    public byte[] getEbcdicValue() {
        int width = this.actualWidth == 0 ? this.ebcdicWidth : this.actualWidth;
        return this.parentResource.getRecordContent(this.recordOffset, width);
    }

    public void setASCIIStr(String ascii, boolean fireEvent) throws FMIConversionException, FMIKeyException, FMIModelException {
        if (this.strValue == null && ascii != null || this.strValue != null && !this.strValue.equals(ascii)) {
            try {
                byte[] ebcdicValue = this.getEbcdicValue();
                byte[] newEbcdicValue = this.converter.ASCIIstrToEBCDIC(ascii, ebcdicValue, this.ebcdicWidth, this.conversionParams);
                String newStringValue = this.converter.EBCDICtoASCIIstr(newEbcdicValue, this.maxAsciiWidth, this.conversionParams);
                if (!this.checkSpecialCriteria(newStringValue, newEbcdicValue)) {
                    return;
                }
                this.strValue = newStringValue;
                this.parentResource.setRecordContent(this.recordOffset, newEbcdicValue, this, fireEvent);
                if (fireEvent) {
                    this.fireChange(ebcdicValue);
                }
                this.isValid = true;
            }
            catch (FMIConversionException fe) {
                this.isValid = false;
                throw this.addMessageToConversionException(fe);
            }
        }
    }

    protected FMIConversionException addMessageToConversionException(FMIConversionException fe) {
        fe.addToMessage(" in Field \"" + this.name + "\"");
        return fe;
    }

    public void setConverter(IFMIDataTypeConverter converter) throws FMIModelException {
        this.converter = converter;
    }

    public String toString() {
        return this.strValue;
    }

    public void validateASCIIchange(String ascii) throws FMIConversionException, FMIModelException, FMIKeyException {
        if (!this.converter.validateASCII(ascii, this.ebcdicWidth, this.conversionParams)) {
            throw new FMIConversionException("Provided value is invalid for this data type");
        }
    }

    public void validateEBCDICchange(byte[] ebcdic) throws FMIConversionException, FMIModelException, FMIKeyException {
        this.converter.EBCDICtoASCIIstr(ebcdic, this.maxAsciiWidth, this.conversionParams);
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setConversionParameters(Object[] conversionParameters) {
        this.conversionParams = conversionParameters;
    }

    public boolean isNumeric() {
        return this.converter == null ? false : this.converter.isNumeric();
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public void setEmpty(boolean empty) {
        this.empty = empty;
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    Field getField(int index) {
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException("Array out of bounds");
        }
        return this;
    }

    public String getConverterSymbol() {
        if (this.converter != null) {
            return this.converter.getSymbol();
        }
        return null;
    }

    @Override
    public void addModelListenerAllLevels(IFMIModelListener listener) {
        this.addModelListener(listener);
    }

    @Override
    public void removeModelListenerAllLevels(IFMIModelListener listener) {
        this.removeModelListener(listener);
    }

    @Override
    public int getMaxEbcdicWidth() {
        return this.empty ? 0 : super.getMaxEbcdicWidth();
    }

    @Override
    ArrayList<Field> testRecordChange(int offset, int length, Field changedField) throws FMIModelException {
        if (this == changedField || !this.recordChangeApplies(offset, length)) {
            return null;
        }
        this.updateStringValue(true);
        ArrayList<Field> thisList = new ArrayList<Field>(1);
        thisList.add(this);
        return thisList;
    }

    @Override
    int getNumSlackBytes() {
        return this.numSlackBytes;
    }

    public void setDisplayOrder(int displayOrder) {
        this.displayOrder = displayOrder;
    }

    public int getDisplayOrder() {
        return this.displayOrder;
    }

    public void setDisplayIndex(int displayIndex) {
        this.displayIndex = displayIndex;
    }

    public int getDisplayIndex() {
        return this.displayIndex;
    }

    @Override
    public boolean isAligned() {
        return this.isAligned;
    }

    @Override
    public boolean requiresHalfWordBoundary() {
        return this.converter.requiresHalfWordBoundary(this.ebcdicWidth);
    }

    @Override
    public boolean requiresFullWordBoundary() {
        return this.converter.requiresFullWordBoundary(this.ebcdicWidth);
    }

    @Override
    public int setSlackBytes(FieldGroup nextGroup) {
        if (nextGroup != null && nextGroup.isAligned()) {
            int endPosition = this.recordOffset + this.ebcdicWidth;
            if (nextGroup.requiresFullWordBoundary() && endPosition % 4 != 0) {
                this.numSlackBytes = 4 - endPosition % 4;
            } else if (nextGroup.requiresHalfWordBoundary() && endPosition % 2 != 0) {
                this.numSlackBytes = 1;
            }
        }
        return this.numSlackBytes;
    }

    public void setIsKeyField(boolean isKeyField) {
        this.isKeyField = isKeyField;
    }

    public boolean isKeyField() {
        return this.isKeyField;
    }
}

