/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.datatypeconverters;

import com.ibm.fmi.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.fmi.model.exception.FMIConversionException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Stack;

public class FMIInternalFloatingPointDataTypeConverter
implements IFMIDataTypeConverter {
    private final int FLOATBYTES = 4;
    private final int DOUBLEBYTES = 8;
    private final int DOUBLEBITS = 64;
    private final String INVALID_DOUBLE = "Invalid Value";
    private final String INVALID_FIELD_WIDTH = "Invalid field width";

    public byte[] ASCIIstrToEBCDIC(String asciiString, byte[] oldEBCDIC, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        long wholepart;
        BigDecimal sixteen = new BigDecimal(16);
        BigDecimal bdFraction = null;
        BigDecimal bdResult = null;
        int characteristic = 0;
        int hexpos = 0;
        boolean nowhole = false;
        boolean firstdigithit = false;
        boolean doFractionConversion = true;
        int mantissalength = 0;
        int compareResult = 0;
        BigDecimal bd = null;
        try {
            bd = new BigDecimal(asciiString);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FMIConversionException("Invalid Value");
        }
        byte[] bin = null;
        if (tgtWidth == 4 || tgtWidth == 8) {
            bin = new byte[tgtWidth];
            int i = 0;
            while (i < bin.length) {
                bin[i] = 0;
                ++i;
            }
        } else {
            throw new FMIConversionException("Invalid field width");
        }
        mantissalength = bin.length - 1;
        compareResult = bd.compareTo(new BigDecimal(0));
        if (compareResult == 0) {
            return bin;
        }
        if (compareResult == -1) {
            bin[0] = (byte)(bin[0] & 0xFFFFFF80);
        }
        if ((wholepart = bd.longValue()) != 0L) {
            if (wholepart < 0L) {
                wholepart = -wholepart;
            }
            Stack<Byte> st = new Stack<Byte>();
            while (wholepart != 0L) {
                st.push((byte)(wholepart % 16L));
                wholepart /= 16L;
            }
            characteristic = (byte)st.size();
            if (characteristic > mantissalength * 2) {
                doFractionConversion = false;
            }
            int i = 0;
            while (i < mantissalength * 2 && !st.isEmpty()) {
                byte next;
                byte b = (Byte)st.pop();
                if (i == mantissalength * 2 - 1 && (next = ((Byte)st.pop()).byteValue()) >= 7) {
                    b = (byte)(b + 1);
                }
                if (i % 2 == 0) {
                    b = (byte)(b << 4);
                }
                int n = i / 2 + 1;
                bin[n] = (byte)(bin[n] | b);
                hexpos = (byte)(hexpos + 1);
                ++i;
            }
        } else {
            nowhole = true;
        }
        if (doFractionConversion) {
            bdFraction = FMIInternalFloatingPointDataTypeConverter.getFractionPart(bd);
            while (hexpos < mantissalength * 2) {
                bdResult = bdFraction.multiply(sixteen);
                if (hexpos == mantissalength * 2 - 1) {
                    MathContext mc = new MathContext(1, RoundingMode.HALF_UP);
                    bdResult = bdResult.round(mc);
                }
                byte b = 0;
                b = bdResult.byteValue();
                bdFraction = FMIInternalFloatingPointDataTypeConverter.getFractionPart(bdResult);
                if (hexpos % 2 == 0) {
                    b = (byte)(b << 4);
                }
                if (nowhole) {
                    if (b != 0) {
                        firstdigithit = true;
                    }
                    if (firstdigithit) {
                        int n = hexpos / 2 + 1;
                        bin[n] = (byte)(bin[n] | b);
                        hexpos = (byte)(hexpos + 1);
                        continue;
                    }
                    characteristic = (byte)(characteristic - 1);
                    continue;
                }
                int n = hexpos / 2 + 1;
                bin[n] = (byte)(bin[n] | b);
                hexpos = (byte)(hexpos + 1);
            }
        }
        bin[0] = (byte)(bin[0] | characteristic + 64);
        return bin;
    }

    private static BigDecimal getFractionPart(BigDecimal input) {
        BigInteger wholepart = input.toBigInteger();
        return input.subtract(new BigDecimal(wholepart));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String EBCDICtoASCIIstr(byte[] EBCDICval, int maxStrLength, Object[] extraParams) throws FMIConversionException {
        int i;
        byte[] fraction;
        boolean negative;
        boolean useBigDecimal = false;
        double total = 0.0;
        BigDecimal bd = null;
        if (EBCDICval == null) {
            throw new FMIConversionException();
        }
        if (EBCDICval.length <= 0) throw new FMIConversionException("Invalid Value");
        byte exponent = EBCDICval[0];
        exponent = (byte)(exponent & 0x7F);
        exponent = (byte)(exponent - 64);
        boolean bl = negative = (EBCDICval[0] & 0xFFFFFF80) == -128;
        if (EBCDICval.length == 4) {
            fraction = new byte[]{EBCDICval[1], EBCDICval[2], EBCDICval[3]};
        } else {
            if (EBCDICval.length != 8) throw new FMIConversionException("Invalid Value");
            fraction = new byte[7];
            i = 0;
            while (i < 7) {
                fraction[i] = EBCDICval[i + 1];
                ++i;
            }
            useBigDecimal = true;
            bd = new BigDecimal(0);
        }
        int pow = exponent - 1;
        i = 0;
        while (i < fraction.length) {
            int b = fraction[i] & 0xF0;
            double c = (double)(b >>= 4) * Math.pow(16.0, pow);
            b = fraction[i] & 0xF;
            if ((c += (double)b * Math.pow(16.0, pow - 1)) != 0.0) {
                if (useBigDecimal) {
                    bd = bd.add(new BigDecimal(c));
                } else {
                    total += c;
                }
            }
            pow -= 2;
            ++i;
        }
        String tmpString = null;
        tmpString = useBigDecimal ? bd.toString() : Double.toString(total);
        return negative ? "-" + tmpString : tmpString;
    }

    public String correctASCIIStringFormat(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        boolean negative;
        boolean isFloat = tgtWidth == 4;
        boolean isDouble = tgtWidth == 8;
        boolean bl = negative = asciiString.charAt(0) == '-';
        if (!isFloat && !isDouble) {
            throw new FMIConversionException("Invalid field width");
        }
        try {
            double bfpDouble = 0.0;
            if (isFloat) {
                Float f = Float.valueOf(Float.parseFloat(asciiString));
                bfpDouble = f.doubleValue();
            } else if (isDouble) {
                bfpDouble = Double.parseDouble(asciiString);
            }
            return this.generateFormattedASCII(bfpDouble, isFloat, negative, tgtWidth);
        }
        catch (Exception exception) {
            throw new FMIConversionException("Invalid Value");
        }
    }

    private String generateFormattedASCII(double bfpDouble, boolean isFloat, boolean negative, int tgtWidth) {
        if (isFloat) {
            if (negative) {
                return String.format("%1$13.7E", bfpDouble);
            }
            return String.format(" %1$12.7E", bfpDouble);
        }
        if (negative) {
            return String.format("%1$20.14E", bfpDouble);
        }
        return String.format(" %1$19.14E", bfpDouble);
    }

    public int getMaxASCIIWidth(int ebcdicWidth, Object[] extraParams) throws FMIConversionException {
        if (ebcdicWidth == 4) {
            return 14;
        }
        if (ebcdicWidth == 8) {
            return 23;
        }
        throw new FMIConversionException("Error determining maximum ASCII field length");
    }

    private double parseComp12(String displayString, boolean isFloat) {
        return Double.parseDouble(displayString);
    }

    public boolean validateASCII(String asciiString, int tgtWidth, Object[] extraParams) throws FMIConversionException {
        boolean isDouble;
        if (asciiString.length() > this.getMaxASCIIWidth(tgtWidth, extraParams)) {
            throw new FMIConversionException("Field data exceeds maximum display width");
        }
        boolean isFloat = tgtWidth == 4;
        boolean bl = isDouble = tgtWidth == 8;
        if (!isFloat && !isDouble) {
            throw new FMIConversionException("Invalid Value");
        }
        try {
            this.parseComp12(asciiString, isFloat);
        }
        catch (Exception exception) {
            throw new FMIConversionException("Invalid Value");
        }
        return true;
    }

    public boolean isNumeric() {
        return false;
    }

    public String getSymbol() {
        return "FP";
    }

    public byte[] getDefaultValue(int length, Object[] extraParams) {
        byte[] bytes = new byte[length];
        int i = 0;
        while (i < bytes.length) {
            bytes[i] = 0;
            ++i;
        }
        return bytes;
    }

    public boolean requiresFullWordBoundary(int length) {
        return length >= 4;
    }

    public boolean requiresHalfWordBoundary(int length) {
        return length == 2;
    }
}

