/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.fm;

import com.ibm.fmi.model.ByteUtilities;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.fm.Segment;
import java.nio.ByteBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaSegment
extends Segment {
    private short expressionLength;
    private short rexxLength;
    private short numRefSymbols;
    private boolean expressionInvalid;
    private boolean needRexx;
    private boolean rexxRequiredValid;
    private boolean exprBuiltFrom26;
    private static final int INVALID_BIT = 8;
    private static final int NEED_REXX_BIT = 7;
    private static final int REXX_REQUIRED_BIT = 6;
    private static final int BUILD_26_BIT = 5;
    private byte setNumber;
    private int ssaPtr;
    private String expression;
    private String rexxLine;
    private ArrayList<CriteriaRefSymbol> refSymbols;

    CriteriaSegment(ByteBuffer buf) throws FMIParseException {
        super(buf);
    }

    @Override
    public void parse(ByteBuffer buf) throws FMIParseException {
        this.expressionLength = buf.getShort();
        this.rexxLength = buf.getShort();
        this.numRefSymbols = buf.getShort();
        byte tempByte = buf.get();
        this.expressionInvalid = ByteUtilities.testBit(tempByte, 8);
        this.needRexx = ByteUtilities.testBit(tempByte, 7);
        this.rexxRequiredValid = ByteUtilities.testBit(tempByte, 6);
        this.exprBuiltFrom26 = ByteUtilities.testBit(tempByte, 5);
        this.setNumber = buf.get();
        this.ssaPtr = buf.getInt();
        try {
            if (this.expressionLength > 0) {
                this.expression = ByteUtilities.getString(buf, this.expressionLength);
            }
            if (this.rexxLength > 0) {
                this.rexxLine = ByteUtilities.getString(buf, this.rexxLength);
            }
        }
        catch (FMIConversionException fMIConversionException) {
            throw new FMIParseException();
        }
        if (this.numRefSymbols > 0) {
            this.refSymbols = new ArrayList(this.numRefSymbols);
            int i = 0;
            while (i < this.numRefSymbols) {
                this.refSymbols.add(new CriteriaRefSymbol(buf));
                ++i;
            }
        }
    }

    public boolean isExprBuiltFrom26() {
        return this.exprBuiltFrom26;
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean isExpressionInvalid() {
        return this.expressionInvalid;
    }

    public short getExpressionLength() {
        return this.expressionLength;
    }

    public boolean isNeedRexx() {
        return this.needRexx;
    }

    public short getNumRefSymbols() {
        return this.numRefSymbols;
    }

    public short getRexxLength() {
        return this.rexxLength;
    }

    public boolean isRexxRequiredValid() {
        return this.rexxRequiredValid;
    }

    public byte getSetNumber() {
        return this.setNumber;
    }

    public int getSsaPtr() {
        return this.ssaPtr;
    }

    public String getRexxLine() {
        return this.rexxLine;
    }

    public ArrayList<CriteriaRefSymbol> getRefSymbols() {
        return this.refSymbols;
    }

    class CriteriaRefSymbol {
        int symbol;
        short position;
        short errorCode;

        CriteriaRefSymbol(ByteBuffer buf) {
            this.symbol = buf.getInt();
            this.position = buf.getShort();
            this.errorCode = buf.getShort();
        }

        public short getErrorCode() {
            return this.errorCode;
        }

        public short getPosition() {
            return this.position;
        }

        public int getSymbol() {
            return this.symbol;
        }
    }
}

