/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.fm;

import com.ibm.fmi.model.ByteUtilities;
import com.ibm.fmi.model.datatypeconverters.FMIAlphaNumericDataTypeConverter;
import com.ibm.fmi.model.datatypeconverters.FMIAlphabeticDataTypeConverter;
import com.ibm.fmi.model.datatypeconverters.FMIBinaryDataTypeConverter;
import com.ibm.fmi.model.datatypeconverters.FMIInternalFloatingPointDataTypeConverter;
import com.ibm.fmi.model.datatypeconverters.FMIPackedDecimalDataTypeConverter;
import com.ibm.fmi.model.datatypeconverters.FMIZonedDecimalDataTypeConverter;
import com.ibm.fmi.model.datatypeconverters.IFMIDataTypeConverter;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.fm.SecondarySegmentHeader;
import com.ibm.fmi.model.fm.Segment;
import com.ibm.fmi.model.fm.SegmentFactory;
import com.ibm.fmi.model.fm.SegmentHeader;
import java.nio.ByteBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainFieldDescriptorSegment
extends Segment {
    SecondarySegmentHeader secHeader;
    private static byte GROUP_BIT = (byte)8;
    private static byte OCCURS_BIT = (byte)7;
    private static byte ODO_BIT = (byte)6;
    private static byte EXT_DO_BIT = (byte)5;
    private static byte REDEFINES_BIT = (byte)4;
    private static byte RENAMES_BIT = (byte)3;
    private static byte ODO_TGT_BIT = (byte)2;
    private static byte VARYING_BIT = 1;
    private static byte BINARY_BIT = (byte)8;
    private static byte EXTERNAL_FLOATING_BIT = (byte)7;
    private static byte INTERNAL_FLOATING_BIT = (byte)6;
    private static byte PACKED_DECIMAL_BIT = (byte)5;
    private static byte ZONED_DECIMAL_BIT = (byte)4;
    private static byte SIGNED_BIT = (byte)3;
    private static byte NUMERIC_EDITED_BIT = (byte)2;
    private static byte BIT_BIT = 1;
    private static byte ALPHABETIC_BIT = (byte)8;
    private static byte ALPHANUMERIC_BIT = (byte)7;
    private static byte ALPHANUMERIC_EDITED_BIT = (byte)6;
    private static byte GROUP_CONTAINS_ODO_BIT = (byte)5;
    private static byte DBCS_BIT = (byte)4;
    private static byte GROUP_VAR_BIT = (byte)3;
    private static byte EGCS_BIT = (byte)2;
    private static byte EGCS_EDITED_BIT = 1;
    private static byte NOT_SELECTED_BIT = (byte)8;
    private static byte RELOCATION_BIT = (byte)7;
    private static byte NO_EDIT_BIT = (byte)6;
    private static byte EXPRESSION_INVALID_BIT = (byte)5;
    private static byte SELECTED_BIT = (byte)4;
    private static byte ALL_ELEM_SELECTED_BIT = (byte)3;
    private static byte MAPPING_SEG_BIT = (byte)2;
    private static byte CHILD_ODO_EXISTS_BIT = 1;
    private static byte IMS_KEY_BIT = (byte)8;
    private static byte IMS_INDEX_BIT = (byte)7;
    private static byte FROM_PL1_BIT = (byte)6;
    private static byte IMS_ACTIVE_BIT = (byte)5;
    private static byte IMS_SUBSEQUENCE_BIT = (byte)4;
    private static byte IMS_LENGTH_BIT = (byte)3;
    private static byte DB2_NO_UPDATES_BIT = (byte)2;
    private static byte HOLD_COLUMN_BIT = 1;
    private static byte PL1_VARYING_BIT = (byte)8;
    private static byte PL1_VARYINGZ_BIT = (byte)7;
    private static byte PL1_DIMS_BIT = (byte)6;
    private static byte PL1_SIGNED_BIT = (byte)5;
    private static byte PL1_UNSIGNED_BIT = (byte)4;
    private static byte PL1_ALIGNED_BIT = (byte)3;
    private static byte PL1_UNALIGNED_BIT = (byte)2;
    private static byte PL1_MULTIPLE_DIMS_BIT = 1;
    private static byte DB2_TIME_BIT = (byte)8;
    private static byte DB2_TIMESTAMP_BIT = (byte)7;
    private static byte DB2_DATE_BIT = (byte)6;
    private static byte DB2_BINARY_BIT = (byte)5;
    private static byte DB2_CHARACTER_BIT = (byte)4;
    private static byte DB2_GRAPHIC_BIT = (byte)3;
    private static byte DB2_ROWID_BIT = (byte)2;
    private static byte DB2_NULL_BIT = 1;
    private static byte DB2_NON_UNIQUE_BIT = (byte)8;
    private static byte DB2_UNIQUE_BIT = (byte)7;
    private static byte DB2_PRIMARY_BIT = (byte)6;
    private static byte DB2_FOREIGN_BIT = (byte)5;
    private static byte DB2_CHECK_CONSTRAINT_BIT = (byte)4;
    private static byte DB2_ORDER_DESCENDING_BIT = (byte)3;
    private static byte DB2_PART_OF_KEY_BIT = (byte)2;
    private static byte DB2_DEF_ATTRIBUTE_BIT = 1;
    private byte levelNumber;
    private boolean isGroupItem;
    private boolean isOccursItem;
    private boolean isOccursDependingOnItem;
    private boolean dependingOnFieldIsExternal;
    private boolean hasRedefines;
    private boolean hasRenames;
    private boolean isODOTarget;
    private boolean isVaryingLength;
    private IFMIDataTypeConverter dataType;
    private boolean isSigned;
    private boolean groupContainsODO;
    private boolean isDBCS;
    private boolean groupVariableItem;
    private boolean EGCS_item;
    private boolean EGCS_edited;
    private int fieldStart;
    private int fieldLength;
    private int fieldDimensions;
    private byte signField;
    private byte justified;
    private short pictureLen;
    private int ODOvalue;
    private int curOffset;
    private int occursMin;
    private int occursMax;
    private byte scale;
    private byte precision;
    private boolean notSelected;
    private boolean relocationRequired;
    private boolean noEdit;
    private boolean expressionInvalid;
    private boolean selected;
    private boolean allElementarySelected;
    private boolean mappingSegExists;
    private boolean childODOExists;
    private boolean IMS_Key;
    private boolean IMS_Index_Search;
    private boolean fromPL1;
    private boolean IMS_Active_Index;
    private boolean IMS_Subsequence;
    private boolean isLengthField;
    private boolean DB2noUpdates;
    private boolean holdColumn;
    private boolean pl1Varying;
    private boolean pl1Varyingz;
    private boolean pl1DimsBounds;
    private boolean pl1Signed;
    private boolean pl1Unsigned;
    private boolean pl1Aligned;
    private boolean pl1Unaligned;
    private boolean pl1MultipleDims;
    private byte bitOffset;
    private short bitLen;
    private short sqlType;
    private boolean db2Time;
    private boolean db2Timestamp;
    private boolean db2Date;
    private boolean db2BinaryLob;
    private boolean db2CharacterLob;
    private boolean db2Graphic;
    private boolean db2RowId;
    private boolean db2Nullable;
    private boolean db2NonUniqueIndex;
    private boolean db2UniqueIndex;
    private boolean db2PrimaryKey;
    private boolean db2ForeignKey;
    private boolean db2CheckConstraint;
    private boolean db2OrderDescending;
    private boolean db2PartOfkey;
    private boolean db2DefAttribute;
    private short db2ColumnNumber;
    private short orderBySequenceNumber;
    private short displayOrder;
    private byte align;
    private byte pl1BinScale;
    private String name;
    private String picture;
    private int numSlackBytes = 0;
    private ArrayList<MainFieldChainSymbol> symbols;
    private ArrayList<Segment> associatedSegments;

    MainFieldDescriptorSegment(ByteBuffer buf) throws FMIParseException {
        super(buf);
    }

    @Override
    public void parse(ByteBuffer buf) throws FMIParseException {
        this.secHeader = new SecondarySegmentHeader(buf);
        this.levelNumber = buf.get();
        this.getDataTypeFlags(buf);
        this.fieldStart = buf.getInt();
        this.fieldLength = buf.getInt();
        this.fieldDimensions = buf.getInt();
        this.signField = buf.get();
        this.justified = buf.get();
        this.pictureLen = buf.getShort();
        this.ODOvalue = buf.getInt();
        this.curOffset = buf.getInt();
        this.occursMin = buf.getInt();
        this.occursMax = buf.getInt();
        this.scale = buf.get();
        this.precision = buf.get();
        this.getMiscFlags(buf);
        this.getPL1Flags(buf);
        this.bitOffset = buf.get();
        this.bitLen = buf.getShort();
        this.sqlType = buf.getShort();
        this.getDB2Flags(buf);
        this.db2ColumnNumber = buf.getShort();
        this.orderBySequenceNumber = buf.getShort();
        this.displayOrder = buf.getShort();
        this.align = buf.get();
        this.pl1BinScale = buf.get();
        this.getChainedSymbols(buf);
        short nameLen = buf.getShort();
        try {
            this.name = ByteUtilities.getString(buf, nameLen);
            if (this.pictureLen > 0) {
                this.picture = ByteUtilities.getString(buf, this.pictureLen);
            }
        }
        catch (FMIConversionException fMIConversionException) {
            throw new FMIParseException();
        }
        this.getAssociatedSegments(buf);
    }

    private void getChainedSymbols(ByteBuffer buf) {
        this.symbols = new ArrayList();
        int i = 0;
        while (i < this.secHeader.getNumChain()) {
            this.symbols.add(new MainFieldChainSymbol(buf));
            ++i;
        }
    }

    private void getDataTypeFlags(ByteBuffer buf) throws FMIParseException {
        byte flag = buf.get();
        this.isGroupItem = ByteUtilities.testBit(flag, GROUP_BIT);
        this.isOccursItem = ByteUtilities.testBit(flag, OCCURS_BIT);
        this.isOccursDependingOnItem = ByteUtilities.testBit(flag, ODO_BIT);
        this.dependingOnFieldIsExternal = ByteUtilities.testBit(flag, EXT_DO_BIT);
        this.hasRedefines = ByteUtilities.testBit(flag, REDEFINES_BIT);
        this.hasRenames = ByteUtilities.testBit(flag, RENAMES_BIT);
        this.isODOTarget = ByteUtilities.testBit(flag, ODO_TGT_BIT);
        this.isVaryingLength = ByteUtilities.testBit(flag, VARYING_BIT);
        flag = buf.get();
        byte flag2 = buf.get();
        if (ByteUtilities.testBit(flag, BINARY_BIT)) {
            this.dataType = new FMIBinaryDataTypeConverter();
        } else {
            if (ByteUtilities.testBit(flag, EXTERNAL_FLOATING_BIT)) {
                throw new FMIParseException("External Floating point unsupported");
            }
            if (ByteUtilities.testBit(flag, INTERNAL_FLOATING_BIT)) {
                this.dataType = new FMIInternalFloatingPointDataTypeConverter();
            } else if (ByteUtilities.testBit(flag, PACKED_DECIMAL_BIT)) {
                this.dataType = new FMIPackedDecimalDataTypeConverter();
            } else if (ByteUtilities.testBit(flag, ZONED_DECIMAL_BIT)) {
                this.dataType = new FMIZonedDecimalDataTypeConverter();
            } else {
                if (ByteUtilities.testBit(flag, NUMERIC_EDITED_BIT)) {
                    throw new FMIParseException("Numeric Edited not supported");
                }
                if (ByteUtilities.testBit(flag, BIT_BIT)) {
                    throw new FMIParseException("Bit data type not supported");
                }
                if (ByteUtilities.testBit(flag2, ALPHABETIC_BIT)) {
                    this.dataType = new FMIAlphabeticDataTypeConverter();
                } else if (ByteUtilities.testBit(flag2, ALPHANUMERIC_BIT)) {
                    this.dataType = new FMIAlphaNumericDataTypeConverter();
                } else if (ByteUtilities.testBit(flag2, ALPHANUMERIC_EDITED_BIT)) {
                    throw new FMIParseException("Alphanumeric Edited not supported");
                }
            }
        }
        this.isSigned = ByteUtilities.testBit(flag, SIGNED_BIT);
        this.groupContainsODO = ByteUtilities.testBit(flag2, GROUP_CONTAINS_ODO_BIT);
        this.isDBCS = ByteUtilities.testBit(flag2, DBCS_BIT);
        this.groupVariableItem = ByteUtilities.testBit(flag2, GROUP_VAR_BIT);
        this.EGCS_item = ByteUtilities.testBit(flag2, EGCS_BIT);
        this.EGCS_edited = ByteUtilities.testBit(flag2, EGCS_EDITED_BIT);
        if (this.EGCS_item || this.EGCS_edited) {
            throw new FMIParseException("EGCS not supported");
        }
    }

    private void getMiscFlags(ByteBuffer buf) throws FMIParseException {
        byte flag = buf.get();
        this.notSelected = ByteUtilities.testBit(flag, NOT_SELECTED_BIT);
        this.childODOExists = ByteUtilities.testBit(flag, CHILD_ODO_EXISTS_BIT);
        flag = buf.get();
        this.IMS_Key = ByteUtilities.testBit(flag, IMS_KEY_BIT);
        this.IMS_Index_Search = ByteUtilities.testBit(flag, IMS_INDEX_BIT);
        this.fromPL1 = ByteUtilities.testBit(flag, FROM_PL1_BIT);
        this.IMS_Active_Index = ByteUtilities.testBit(flag, IMS_ACTIVE_BIT);
        this.IMS_Subsequence = ByteUtilities.testBit(flag, IMS_SUBSEQUENCE_BIT);
        this.DB2noUpdates = ByteUtilities.testBit(flag, DB2_NO_UPDATES_BIT);
        if (this.IMS_Key || this.IMS_Index_Search || this.IMS_Active_Index || this.IMS_Subsequence) {
            throw new FMIParseException("IMS not supported");
        }
        if (this.DB2noUpdates) {
            throw new FMIParseException("DB2 not supported");
        }
    }

    private void getPL1Flags(ByteBuffer buf) throws FMIParseException {
        byte flag = buf.get();
        this.pl1Varying = ByteUtilities.testBit(flag, PL1_VARYING_BIT);
        this.pl1Varyingz = ByteUtilities.testBit(flag, PL1_VARYINGZ_BIT);
        if (this.pl1Varying || this.pl1Varyingz) {
            throw new FMIParseException("PL/1 Varying data types not supported");
        }
        this.pl1DimsBounds = ByteUtilities.testBit(flag, PL1_DIMS_BIT);
        this.pl1Signed = ByteUtilities.testBit(flag, PL1_SIGNED_BIT);
        this.pl1Unsigned = ByteUtilities.testBit(flag, PL1_UNSIGNED_BIT);
        this.pl1Aligned = ByteUtilities.testBit(flag, PL1_ALIGNED_BIT);
        this.pl1Unaligned = ByteUtilities.testBit(flag, PL1_UNALIGNED_BIT);
        this.pl1MultipleDims = ByteUtilities.testBit(flag, PL1_MULTIPLE_DIMS_BIT);
    }

    private void getDB2Flags(ByteBuffer buf) throws FMIParseException {
        byte flag = buf.get();
        this.db2Time = ByteUtilities.testBit(flag, DB2_TIME_BIT);
        this.db2Timestamp = ByteUtilities.testBit(flag, DB2_TIMESTAMP_BIT);
        this.db2Date = ByteUtilities.testBit(flag, DB2_DATE_BIT);
        this.db2BinaryLob = ByteUtilities.testBit(flag, DB2_BINARY_BIT);
        this.db2CharacterLob = ByteUtilities.testBit(flag, DB2_CHARACTER_BIT);
        this.db2Graphic = ByteUtilities.testBit(flag, DB2_GRAPHIC_BIT);
        this.db2RowId = ByteUtilities.testBit(flag, DB2_ROWID_BIT);
        this.db2Nullable = ByteUtilities.testBit(flag, DB2_NULL_BIT);
        byte flag2 = buf.get();
        this.db2NonUniqueIndex = ByteUtilities.testBit(flag, DB2_NON_UNIQUE_BIT);
        this.db2UniqueIndex = ByteUtilities.testBit(flag, DB2_UNIQUE_BIT);
        this.db2PrimaryKey = ByteUtilities.testBit(flag, DB2_PRIMARY_BIT);
        this.db2ForeignKey = ByteUtilities.testBit(flag, DB2_FOREIGN_BIT);
        this.db2CheckConstraint = ByteUtilities.testBit(flag, DB2_CHECK_CONSTRAINT_BIT);
        this.db2OrderDescending = ByteUtilities.testBit(flag, DB2_ORDER_DESCENDING_BIT);
        this.db2PartOfkey = ByteUtilities.testBit(flag, DB2_PART_OF_KEY_BIT);
        this.db2DefAttribute = ByteUtilities.testBit(flag, DB2_DEF_ATTRIBUTE_BIT);
        if (flag != 0 || flag2 != 0) {
            throw new FMIParseException("DB2 not supported");
        }
    }

    private void getAssociatedSegments(ByteBuffer buf) throws FMIParseException {
        SegmentHeader header = new SegmentHeader(buf);
        while (header.getLength() > 0 && header.getType() > 20 && header.getType() < 42) {
            Segment seg = SegmentFactory.buildSegment(header, buf);
            if (this.associatedSegments == null) {
                this.associatedSegments = new ArrayList();
            }
            this.associatedSegments.add(seg);
            header = new SegmentHeader(buf);
        }
    }

    public byte getAlign() {
        return this.align;
    }

    public boolean isAllElementarySelected() {
        return this.allElementarySelected;
    }

    public ArrayList<Segment> getAssociatedSegments() {
        return this.associatedSegments;
    }

    public short getBitLen() {
        return this.bitLen;
    }

    public boolean isChildODOExists() {
        return this.childODOExists;
    }

    public int getCurOffset() {
        return this.curOffset;
    }

    public IFMIDataTypeConverter getDataType() {
        return this.dataType;
    }

    public boolean isDb2BinaryLob() {
        return this.db2BinaryLob;
    }

    public boolean isDb2CharacterLob() {
        return this.db2CharacterLob;
    }

    public boolean isDb2CheckConstraint() {
        return this.db2CheckConstraint;
    }

    public short getDb2ColumnNumber() {
        return this.db2ColumnNumber;
    }

    public boolean isDb2Date() {
        return this.db2Date;
    }

    public boolean isDb2DefAttribute() {
        return this.db2DefAttribute;
    }

    public boolean isDb2ForeignKey() {
        return this.db2ForeignKey;
    }

    public boolean isDb2Graphic() {
        return this.db2Graphic;
    }

    public boolean isDb2NonUniqueIndex() {
        return this.db2NonUniqueIndex;
    }

    public boolean isDB2noUpdates() {
        return this.DB2noUpdates;
    }

    public boolean isDb2Nullable() {
        return this.db2Nullable;
    }

    public boolean isDb2OrderDescending() {
        return this.db2OrderDescending;
    }

    public boolean isDb2PartOfkey() {
        return this.db2PartOfkey;
    }

    public boolean isDb2PrimaryKey() {
        return this.db2PrimaryKey;
    }

    public boolean isDb2RowId() {
        return this.db2RowId;
    }

    public boolean isDb2Time() {
        return this.db2Time;
    }

    public boolean isDb2Timestamp() {
        return this.db2Timestamp;
    }

    public boolean isDb2UniqueIndex() {
        return this.db2UniqueIndex;
    }

    public boolean isDependingOnFieldIsExternal() {
        return this.dependingOnFieldIsExternal;
    }

    public short getDisplayOrder() {
        return this.displayOrder;
    }

    public boolean isEGCS_edited() {
        return this.EGCS_edited;
    }

    public boolean isEGCS_item() {
        return this.EGCS_item;
    }

    public boolean isExpressionInvalid() {
        return this.expressionInvalid;
    }

    public int getFieldDimensions() {
        return this.fieldDimensions;
    }

    public int getFieldLength() {
        return this.fieldLength;
    }

    public int getFieldStart() {
        return this.fieldStart;
    }

    public boolean isFromPL1() {
        return this.fromPL1;
    }

    public boolean groupContainsODO() {
        return this.groupContainsODO;
    }

    public boolean isGroupVariableItem() {
        return this.groupVariableItem;
    }

    public boolean hasRedefines() {
        return this.hasRedefines;
    }

    public boolean hasRenames() {
        return this.hasRenames;
    }

    public boolean isHoldColumn() {
        return this.holdColumn;
    }

    public byte getBitOffset() {
        return this.bitOffset;
    }

    public boolean isIMS_Active_Index() {
        return this.IMS_Active_Index;
    }

    public boolean isIMS_Index_Search() {
        return this.IMS_Index_Search;
    }

    public boolean isIMS_Key() {
        return this.IMS_Key;
    }

    public boolean isIMS_Subsequence() {
        return this.IMS_Subsequence;
    }

    public boolean isDBCS() {
        return this.isDBCS;
    }

    public boolean isGroupItem() {
        return this.isGroupItem;
    }

    public boolean isLengthField() {
        return this.isLengthField;
    }

    public boolean isOccursDependingOnItem() {
        return this.isOccursDependingOnItem;
    }

    public boolean isOccursItem() {
        return this.isOccursItem;
    }

    public boolean isODOTarget() {
        return this.isODOTarget;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isVaryingLength() {
        return this.isVaryingLength;
    }

    public byte getJustified() {
        return this.justified;
    }

    public byte getLevelNumber() {
        return this.levelNumber;
    }

    public boolean isMappingSegExists() {
        return this.mappingSegExists;
    }

    public boolean isNoEdit() {
        return this.noEdit;
    }

    public boolean isNotSelected() {
        return this.notSelected;
    }

    public int getOccursMax() {
        return this.occursMax;
    }

    public int getOccursMin() {
        return this.occursMin;
    }

    public int getODOvalue() {
        return this.ODOvalue;
    }

    public short getOrderBySequenceNumber() {
        return this.orderBySequenceNumber;
    }

    public short getPictureLen() {
        return this.pictureLen;
    }

    public boolean isPl1Aligned() {
        return this.pl1Aligned;
    }

    public byte getPl1BinScale() {
        return this.pl1BinScale;
    }

    public boolean isPl1DimsBounds() {
        return this.pl1DimsBounds;
    }

    public boolean isPl1MultipleDims() {
        return this.pl1MultipleDims;
    }

    public boolean isPl1Signed() {
        return this.pl1Signed;
    }

    public boolean isPl1Unaligned() {
        return this.pl1Unaligned;
    }

    public boolean isPl1Unsigned() {
        return this.pl1Unsigned;
    }

    public boolean isPl1Varying() {
        return this.pl1Varying;
    }

    public boolean isPl1Varyingz() {
        return this.pl1Varyingz;
    }

    public byte getPrecision() {
        return this.precision;
    }

    public boolean isRelocationRequired() {
        return this.relocationRequired;
    }

    public byte getScale() {
        return this.scale;
    }

    public SecondarySegmentHeader getSecHeader() {
        return this.secHeader;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public byte getSignField() {
        return this.signField;
    }

    public short getSqlType() {
        return this.sqlType;
    }

    public ArrayList<MainFieldChainSymbol> getSymbols() {
        return this.symbols;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public int getParentSymbol() {
        return this.symbols.get(0).getParent();
    }

    public int getChildSymbol() {
        return this.symbols.get(0).getChild();
    }

    public int getOccursDependingOnSymbol() {
        return this.symbols.get(0).getOccurs();
    }

    public int getRedefineSymbol() {
        return this.symbols.get(0).getRedefine();
    }

    public int getSiblingSymbol() {
        return this.symbols.get(0).getSibling();
    }

    public int getNumSlackBytes() {
        return this.numSlackBytes;
    }

    public void setNumSlackBytes(int numSlackBytes) {
        this.numSlackBytes = numSlackBytes;
    }

    class MainFieldChainSymbol {
        private int sibling;
        private int child;
        private int redefine;
        private int occurs;
        private int parent;

        MainFieldChainSymbol(ByteBuffer buf) {
            this.sibling = buf.getInt();
            this.child = buf.getInt();
            this.redefine = buf.getInt();
            this.occurs = buf.getInt();
            this.parent = buf.getInt();
        }

        public int getChild() {
            return this.child;
        }

        public int getOccurs() {
            return this.occurs;
        }

        public int getParent() {
            return this.parent;
        }

        public int getRedefine() {
            return this.redefine;
        }

        public int getSibling() {
            return this.sibling;
        }
    }
}

