/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.fm;

import com.ibm.fmi.model.ByteUtilities;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.fm.Segment;
import java.nio.ByteBuffer;

public class SaveFileSegment
extends Segment {
    private String eyecatcher;
    private boolean segmentedAttr;
    private byte version;
    private byte templateType;
    private byte language;
    private int symbolCount;
    private String saveDate;
    private String saveTime;
    private static final int EYECATCHER_LENGTH = 8;
    private static final int SAVEDATE_LENGTH = 8;
    private static final int SAVETIME_LENGTH = 8;
    private static final int SEGMENTED_ATTR_BIT = 8;

    public SaveFileSegment(ByteBuffer buf) throws FMIParseException {
        super(buf);
    }

    protected void parse(ByteBuffer buf) throws FMIParseException {
        try {
            this.eyecatcher = ByteUtilities.getString(buf, 8);
            byte tempByte = buf.get();
            this.segmentedAttr = ByteUtilities.testBit(tempByte, 8);
            this.version = buf.get();
            this.templateType = buf.get();
            this.language = buf.get();
            this.symbolCount = buf.getInt();
            this.saveDate = ByteUtilities.getString(buf, 8);
            this.saveTime = ByteUtilities.getString(buf, 8);
        }
        catch (FMIConversionException fMIConversionException) {
            throw new FMIParseException();
        }
    }

    public String getEyecatcher() {
        return this.eyecatcher;
    }

    public byte getLanguage() {
        return this.language;
    }

    public String getSaveDate() {
        return this.saveDate;
    }

    public String getSaveTime() {
        return this.saveTime;
    }

    public boolean isSegmentedAttr() {
        return this.segmentedAttr;
    }

    public int getSymbolCount() {
        return this.symbolCount;
    }

    public byte getTemplateType() {
        return this.templateType;
    }

    public byte getVersion() {
        return this.version;
    }
}

