/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.fm;

import com.ibm.fmi.model.ByteUtilities;
import com.ibm.fmi.model.exception.FMIConversionException;
import com.ibm.fmi.model.exception.FMIParseException;
import com.ibm.fmi.model.fm.Segment;
import java.nio.ByteBuffer;

class SourceStatementSegment
extends Segment {
    private int sourceId;
    private short sourceLength;
    private static final int FREE_SPACE = 8;
    private String sourceStatement;

    SourceStatementSegment(ByteBuffer buf) throws FMIParseException {
        super(buf);
    }

    protected void parse(ByteBuffer buf) throws FMIParseException {
        this.sourceId = buf.getInt();
        this.sourceLength = buf.getShort();
        buf.position(buf.position() + 8);
        try {
            if (this.sourceLength > 0) {
                this.sourceStatement = ByteUtilities.getString(buf, this.sourceLength);
            }
        }
        catch (FMIConversionException fMIConversionException) {
            throw new FMIParseException();
        }
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public short getSourceLength() {
        return this.sourceLength;
    }

    public String getSourceStatement() {
        return this.sourceStatement;
    }
}

