/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.model.shadowline;

import com.ibm.fmi.model.DisplayLine;
import com.ibm.fmi.model.Record;
import com.ibm.fmi.model.RecordLayout;
import com.ibm.fmi.model.TemplattedData;
import com.ibm.fmi.model.exception.FMIModelException;
import com.ibm.fmi.model.shadowline.HiddenSet;
import com.ibm.fmi.model.shadowline.ShadowLine;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuppressedSet
extends HiddenSet {
    @Override
    public boolean isOfSet(byte[] record) {
        byte compByte = record[17];
        int check = 64;
        return (compByte & check) == check;
    }

    @Override
    public RecordLayout getLayout() {
        return this.layout;
    }

    @Override
    public String getMessage(int numRecords) {
        return String.valueOf(numRecords) + " records suppressed (" + this.layout.getName() + ")";
    }

    @Override
    public ShadowLine getInstance() {
        return new SuppressedSet();
    }

    @Override
    public boolean canSplit() {
        return false;
    }

    @Override
    public DisplayLine splitOffBeginning() throws FMIModelException {
        throw new FMIModelException("Cannot split this HiddenSet");
    }

    @Override
    public DisplayLine splitOffEnd() throws FMIModelException {
        throw new FMIModelException("Cannot split this HiddenSet");
    }

    @Override
    public DisplayLine splitOffBeginning(int numUpper) throws FMIModelException {
        throw new FMIModelException("Cannot split this HiddenSet");
    }

    @Override
    public DisplayLine splitOffEnd(int numLower) throws FMIModelException {
        throw new FMIModelException("Cannot split this HiddenSet");
    }

    @Override
    public List<DisplayLine> changeLayout(RecordLayout layout) throws FMIModelException {
        ArrayList<DisplayLine> newSet = null;
        if (this.layout != layout) {
            newSet = new ArrayList<DisplayLine>(1);
            newSet.add(this);
        } else {
            newSet = new ArrayList(this.records.size());
            for (Record r : this.records) {
                r.setParent(this.parent);
                r.removeModelListener(this);
                r.addModelListener((TemplattedData)this.parent);
                r.getHeader().setNotSuppressed();
                newSet.add(r);
            }
        }
        return newSet;
    }

    @Override
    protected boolean canMerge(HiddenSet target) {
        if (!(target instanceof SuppressedSet)) {
            return false;
        }
        SuppressedSet targetSupp = (SuppressedSet)target;
        return targetSupp.getLayout().getSymbol() == this.getLayout().getSymbol();
    }
}

