/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fmi.client.operation;

import com.ibm.etools.systems.core.SystemPlugin;
import com.ibm.etools.systems.dstore.core.model.DataElement;
import com.ibm.etools.systems.dstore.core.model.DataStore;
import com.ibm.etools.systems.dstore.extra.internal.extra.IDomainListener;
import com.ibm.fmi.client.FMIClientUtilities;
import com.ibm.ftt.resources.core.physical.IPhysicalResource;
import com.ibm.ftt.resources.zos.filesystem.MVSResource;
import com.ibm.ftt.resources.zos.util.MVSFileTransferStatusListener;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSResourceImpl;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class FMISaveOperation
extends WorkspaceModifyOperation {
    private ZOSResourceImpl resource;
    private byte[] changedRecords;

    public FMISaveOperation(ZOSResourceImpl resource, byte[] changedRecords) {
        this.resource = resource;
        this.changedRecords = changedRecords;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        MVSResource mvsResource = this.resource.getMvsResource();
        try {
            DataElement de = mvsResource.getDataElement();
            DataStore dstore = de.getDataStore();
            String remotePath = FMIClientUtilities.getRemoteDataset(mvsResource);
            String remoteMember = FMIClientUtilities.getRemoteMember(mvsResource);
            if (remoteMember != null) {
                remotePath = String.valueOf(remotePath) + "(" + remoteMember + ")";
            }
            String datasetName = remotePath;
            String templateName = FMIClientUtilities.getTemplateName((IPhysicalResource)this.resource);
            if (templateName != null && !templateName.equals("")) {
                remotePath = String.valueOf(remotePath) + "@" + templateName;
            }
            String byteStreamHandlerId = "FMIByteStreamHandler";
            DataElement minerInfo = dstore.findMinerInformation("com.ibm.ftt.rse.mvs.server.miners.MVSFileSystemMiner");
            MVSFileTransferStatusListener listener = new MVSFileTransferStatusListener(datasetName, SystemPlugin.getActiveWorkbenchShell(), dstore, minerInfo);
            dstore.getDomainNotifier().addDomainListener((IDomainListener)listener);
            dstore.replaceFile(remotePath, this.changedRecords, this.changedRecords.length, true, byteStreamHandlerId);
            listener.waitForUpdate();
            dstore.getDomainNotifier().removeDomainListener((IDomainListener)listener);
            if (listener.uploadHasFailed()) {
                throw new Exception(listener.getErrorMessage());
            }
        }
        catch (Exception e) {
            throw new InterruptedException(e.getMessage());
        }
    }
}

