/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.cdz.core;

import com.ibm.cdz.common.TraceUtil;
import com.ibm.ftt.projects.core.logical.ILogicalResource;
import com.ibm.ftt.projects.core.logicalfactory.LogicalProjectRegistryFactory;
import com.ibm.ftt.projects.zos.zoslogical.LZOSProject;
import com.ibm.ftt.projects.zos.zoslogical.LZOSSubProject;
import com.ibm.ftt.resources.core.physical.IPhysicalResource;
import com.ibm.ftt.resources.zos.PBResourceMvsUtils;
import com.ibm.ftt.resources.zos.filesystem.MVSResource;
import com.ibm.ftt.resources.zos.zosfactory.ZOSPhysicalResourceFinder;
import com.ibm.ftt.resources.zos.zosfactory.ZOSResourceIdentifier;
import com.ibm.ftt.resources.zos.zosfactory.ZosfactoryFactory;
import com.ibm.ftt.resources.zos.zosphysical.ZOSDataSetMember;
import com.ibm.ftt.resources.zos.zosphysical.ZOSResource;
import com.ibm.ftt.resources.zos.zosphysical.ZOSSequentialDataSet;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSDataSetMemberImpl;
import com.ibm.ftt.resources.zos.zosphysical.impl.ZOSResourceImpl;
import com.ibm.ftt.ui.resources.core.editor.EditorOpener;
import com.ibm.tpf.connectionmgr.errorlist.RemoteMarkerDefaultResovler;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.services.files.RemoteFileException;

public class EventFileMarkerResolver
extends RemoteMarkerDefaultResovler {
    public void openFileForMarker(Map markerAttributes) {
        String sourceFileName = EventFileMarkerResolver.getSourceFileName(markerAttributes);
        boolean isPhysical = EventFileMarkerResolver.isPhysicalResource(sourceFileName);
        String errorFileName = (String)markerAttributes.get("sourceFileName");
        if (errorFileName != null) {
            if ((errorFileName = this.convertToPathRepresentation(sourceFileName, errorFileName, isPhysical)) != null) {
                markerAttributes.put("sourceFileName", errorFileName);
                this.resolve(sourceFileName, markerAttributes, isPhysical);
            } else {
                errorFileName = (String)markerAttributes.get("sourceFileName");
                markerAttributes.put("sourceFileName", errorFileName.trim());
                super.openFileForMarker(markerAttributes);
            }
        }
    }

    private static boolean isPhysicalResource(String sourceFileName) {
        String[] split;
        return sourceFileName == null || (split = sourceFileName.split("/")) == null || split.length <= 2;
    }

    private static String getSourceFileName(Map markerAttributes) {
        String sourceFileNameList = (String)markerAttributes.get("actionFileName");
        String result = "";
        if (sourceFileNameList != null) {
            String[] split = sourceFileNameList.split(",");
            result = split[split.length - 1];
        }
        return result;
    }

    public void resolve(String sourceFileName, Map markerAttributes, boolean isPhysical) {
        int lineNumber = (Integer)markerAttributes.get("lineNumber");
        int charStart = (Integer)markerAttributes.get("charStart");
        int charEnd = (Integer)markerAttributes.get("charEnd");
        String systemName = (String)markerAttributes.get("hostName");
        int sourceIndx = sourceFileName.lastIndexOf("/");
        if (sourceIndx > -1) {
            ZOSResource res;
            int startIndx = sourceFileName.substring(0, sourceIndx).lastIndexOf("/");
            if (startIndx <= -1) {
                startIndx = -1;
            }
            String sourceDatasetName = sourceFileName.substring(startIndx + 1, sourceIndx);
            String sourceMemberName = sourceFileName.substring(sourceIndx + 1);
            String errorFileName = (String)markerAttributes.get("sourceFileName");
            ZOSResourceIdentifier identifier = ZosfactoryFactory.eINSTANCE.createZOSResourceIdentifier();
            identifier.setDataSetName(sourceDatasetName);
            identifier.setMemberName(sourceMemberName);
            identifier.setSystem(systemName);
            ZOSPhysicalResourceFinder finder = ZosfactoryFactory.eINSTANCE.createZOSPhysicalResourceFinder();
            IPhysicalResource sourceResource = finder.findPhysicalResource(identifier);
            if (sourceResource instanceof ZOSResource && ((res = (ZOSResource)sourceResource) instanceof ZOSDataSetMember || res instanceof ZOSSequentialDataSet)) {
                int errorFileIndex;
                MVSResource rsc = ((ZOSResourceImpl)res).getMvsResource();
                MVSResource owner = rsc.getLockOwner();
                if (owner != null && !owner.equals(rsc)) {
                    PBResourceMvsUtils.focusEditor((IFile)owner.getLocalResource());
                    return;
                }
                ILogicalResource errorResource = null;
                if (!isPhysical) {
                    errorResource = this.getLogicalResource(errorFileName, rsc.getExtension());
                    int index = errorFileName.indexOf(47);
                    if (index != -1) {
                        errorFileName = errorFileName.substring(index + 1);
                    }
                    if ((index = errorFileName.indexOf(47)) != -1) {
                        errorFileName = errorFileName.substring(index + 1);
                    }
                }
                if (errorResource == null && (errorFileIndex = errorFileName.indexOf("/")) > -1) {
                    String errorDataSetName = errorFileName.substring(0, errorFileIndex);
                    String errorMemberName = errorFileName.substring(errorFileIndex + 1);
                    ZOSResourceIdentifier identifier1 = ZosfactoryFactory.eINSTANCE.createZOSResourceIdentifier();
                    identifier1.setDataSetName(errorDataSetName);
                    identifier1.setMemberName(errorMemberName);
                    identifier1.setSystem(systemName);
                    ZOSPhysicalResourceFinder finder1 = ZosfactoryFactory.eINSTANCE.createZOSPhysicalResourceFinder();
                    errorResource = finder1.findPhysicalResource(identifier1);
                }
                Path path = new Path(errorFileName);
                try {
                    if (errorResource != null) {
                        EditorOpener.getInstance().gotoLine((Object)errorResource, lineNumber, charStart, charEnd);
                    } else {
                        TraceUtil.getInstance().write(EventFileMarkerResolver.class.getName(), "ZOSRemoteMarkerResolver.openFileForMarker#: Unable to find the resource representing the error file name with path: " + path);
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private ILogicalResource getLogicalResource(String errorFileName, String extension) {
        String[] parts = errorFileName.split("/");
        if (parts != null && parts.length == 4) {
            String projectName = parts[0];
            Object[] projects = LogicalProjectRegistryFactory.getSingleton().getProjects();
            int i = 0;
            while (i < projects.length) {
                LZOSSubProject subproject;
                LZOSProject project;
                if (projects[i] instanceof LZOSProject && (project = (LZOSProject)projects[i]).getName().equals(projectName) && (subproject = (LZOSSubProject)project.findMember(parts[1])) != null) {
                    ILogicalResource res = (ILogicalResource)subproject.findMember((IPath)new Path(String.valueOf(errorFileName) + "." + extension));
                    return res;
                }
                ++i;
            }
        }
        return null;
    }

    private String convertToPathRepresentation(String sourceFileName, String errorFileName, boolean isPhysical) {
        if (isPhysical) {
            MVSResourceInfo info = this.getMVSResourceInfo(errorFileName);
            if (info != null) {
                return String.valueOf(info.getDatasetName()) + "/" + info.getMemberName();
            }
            return null;
        }
        return this.convertToLogicalPathRepresentation(sourceFileName, errorFileName);
    }

    private MVSResourceInfo getMVSResourceInfo(String errorFileName) {
        int trimStartIndx = (errorFileName = errorFileName.trim()).startsWith("'") ? 1 : 0;
        int trimEndIndx = errorFileName.endsWith("'") ? 1 : 0;
        int startBracketIndex = (errorFileName = errorFileName.substring(trimStartIndx, errorFileName.length() - trimEndIndx)).indexOf(40);
        if (startBracketIndex != -1) {
            String dsName = errorFileName.substring(0, startBracketIndex);
            String memName = errorFileName.substring(startBracketIndex + 1, errorFileName.indexOf(41));
            return new MVSResourceInfo(dsName, memName);
        }
        return null;
    }

    private String convertToLogicalPathRepresentation(String sourceFileName, String errorFileName) {
        String[] result = this.getProjSubProjName(sourceFileName);
        MVSResourceInfo info = this.getMVSResourceInfo(errorFileName);
        if (info != null) {
            if (result != null) {
                String projName = result[0] != null ? String.valueOf(result[0]) + "/" : "";
                String subProjName = result[1] != null ? String.valueOf(result[1]) + "/" : "";
                return String.valueOf(projName) + subProjName + info.getDatasetName() + "/" + info.getMemberName();
            }
            return String.valueOf(info.getDatasetName()) + "/" + info.getMemberName();
        }
        return null;
    }

    private String[] getProjSubProjName(String sourceFileName) {
        String compareString;
        String[] result = new String[2];
        int index = sourceFileName.indexOf(47);
        if (index != -1) {
            result[0] = sourceFileName.substring(0, index);
        }
        if ((compareString = sourceFileName.substring(index + 1)) != null && (index = compareString.indexOf(47)) != -1) {
            result[1] = compareString.substring(0, index);
        }
        return result;
    }

    public IFile getIFileFromMarkerAttributes(Map markerAttributes) {
        String errorFileName = (String)markerAttributes.get("sourceFileName");
        if (errorFileName != null) {
            String systemName = (String)markerAttributes.get("hostName");
            MVSResourceInfo info = this.getMVSResourceInfo(errorFileName);
            if (info != null) {
                ZOSResourceIdentifier identifier = ZosfactoryFactory.eINSTANCE.createZOSResourceIdentifier();
                identifier.setDataSetName(info.getDatasetName());
                identifier.setMemberName(info.getMemberName());
                identifier.setSystem(systemName);
                ZOSPhysicalResourceFinder finder = ZosfactoryFactory.eINSTANCE.createZOSPhysicalResourceFinder();
                IPhysicalResource sourceResource = finder.findPhysicalResource(identifier);
                if (sourceResource != null) {
                    try {
                        return ((ZOSDataSetMemberImpl)sourceResource).getMvsResource().getFile(null);
                    }
                    catch (RemoteFileException remoteFileException) {
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            } else {
                errorFileName = errorFileName.trim();
                markerAttributes.put("sourceFileName", errorFileName);
            }
        }
        return super.getIFileFromMarkerAttributes(markerAttributes);
    }

    private static class MVSResourceInfo {
        private String dsName;
        private String memberName;

        public MVSResourceInfo(String dsName, String memberName) {
            this.dsName = dsName;
            this.memberName = memberName;
        }

        public String getDatasetName() {
            return this.dsName;
        }

        public String getMemberName() {
            return this.memberName;
        }
    }
}

