/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.cdz.core;

import com.ibm.cdz.common.TraceUtil;
import com.ibm.ftt.projects.core.logical.ILogicalResource;
import com.ibm.ftt.resources.core.physical.IPhysicalResource;
import com.ibm.ftt.resources.zos.PBSystemIFileProperties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;

public class ResourceUtil {
    public static Object getResource(IFile file) {
        if (file != null) {
            PBSystemIFileProperties properties = new PBSystemIFileProperties((IResource)file);
            Object resource = properties.getRemoteFileObject();
            Object editObject = properties.getRemoteEditObject();
            if (editObject != null) {
                if (editObject instanceof ILogicalResource) {
                    return (ILogicalResource)editObject;
                }
                if (editObject instanceof IPhysicalResource) {
                    return (IPhysicalResource)editObject;
                }
            } else {
                if (resource == null) {
                    TraceUtil.getInstance().write(ResourceUtil.class.getName(), "getResource(): no RemoteFileObject associated with " + file.getFullPath());
                    return file;
                }
                if (resource instanceof IAdaptable) {
                    return (IAdaptable)resource;
                }
                TraceUtil.getInstance().write(ResourceUtil.class.getName(), "getResource(): no edit path is set for file " + file.getFullPath() + " and RemoteFileObject " + resource + " is not an IAdapatable");
            }
        } else {
            TraceUtil.getInstance().write(ResourceUtil.class.getName(), "getResource(): could not retrieve IFile.");
        }
        return file;
    }
}

