/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.cdz.core.editor.actions;

import com.ibm.cdz.remote.core.editor.RemoteCEditor;
import com.ibm.cdz.remote.core.extensionpoints.api.IEditorContext;
import com.ibm.cdz.remote.core.extensionpoints.api.IRemoteEditor;
import com.ibm.cdz.remote.core.extensionpoints.api.IResourceResolver;
import com.ibm.ftt.cdz.core.MVSResourceResolver;
import com.ibm.ftt.cdz.core.Messages;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import com.ibm.ftt.ui.actions.PBRemoteSyntaxAction;
import com.ibm.ftt.ui.actions.UIActionsResources;
import com.ibm.tpf.lpex.editor.TPFEditor;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchPartLabelProvider;

public class MVSRemoteSyntaxCheck
extends Action {
    private PBRemoteSyntaxAction _remoteSyntaxCheckAction;
    IRemoteEditor _editor;

    public MVSRemoteSyntaxCheck(IFile file, IRemoteEditor editor) {
        super(MVSRemoteSyntaxCheck.getMenuName(editor));
        IAdaptable remoteObject;
        ISystemEditableRemoteObject editableFile;
        boolean enabled = false;
        IEditorContext context = editor.getEditorContext();
        IResourceResolver rr = context.getResourceResolver();
        if (rr instanceof MVSResourceResolver && (editableFile = ((MVSResourceResolver)rr).getRemoteEditable(file, false)) != null && (remoteObject = editableFile.getRemoteObject()) instanceof MVSFileResource) {
            StructuredSelection selection = new StructuredSelection((Object)remoteObject);
            this._remoteSyntaxCheckAction = new PBRemoteSyntaxAction(UIActionsResources.RemoteSyntaxCheck_menuItem, (IStructuredSelection)selection);
            enabled = this._remoteSyntaxCheckAction.isEnabled();
        }
        this.setEnabled(enabled);
        this._editor = editor;
    }

    private static String getMenuName(IRemoteEditor editor) {
        RemoteCEditor part = null;
        if (editor instanceof RemoteCEditor) {
            part = (RemoteCEditor)editor;
        } else if (editor instanceof TPFEditor) {
            part = ((TPFEditor)editor).getLpexEditor();
        }
        if (part.isDirty()) {
            return Messages.RemoteSyntaxCheck_save;
        }
        return UIActionsResources.RemoteSyntaxCheck_menuItem;
    }

    public void run() {
        boolean doAction = true;
        RemoteCEditor editor = null;
        NullProgressMonitor monitor = new NullProgressMonitor();
        if (this._editor instanceof RemoteCEditor) {
            editor = (RemoteCEditor)this._editor;
        } else if (this._editor instanceof TPFEditor) {
            editor = ((TPFEditor)this._editor).getLpexEditor();
        }
        if (editor != null) {
            editor.doSave((IProgressMonitor)monitor);
        }
        if (doAction && !monitor.isCanceled()) {
            this._remoteSyntaxCheckAction.run();
        }
    }

    private boolean saveDirtyEditors(IEditorPart[] dirtyEditors) {
        if (dirtyEditors.length > 0) {
            ArrayList<IEditorPart> saveEditors = new ArrayList<IEditorPart>();
            int i = 0;
            while (i < dirtyEditors.length) {
                saveEditors.add(dirtyEditors[i]);
            }
            AdaptableList input = new AdaptableList(saveEditors);
            ListSelectionDialog dlg = new ListSelectionDialog(this.getShell(), (Object)input, (IStructuredContentProvider)new WorkbenchContentProvider(), (ILabelProvider)new WorkbenchPartLabelProvider(), Messages.RemoteSyntaxCheck_saveEditors_message);
            dlg.setInitialSelections(saveEditors.toArray(new Object[saveEditors.size()]));
            dlg.setTitle(Messages.RemoteSyntaxCheck_saveEditors_title);
            int result = dlg.open();
            if (result == 1) {
                return false;
            }
            Object[] filesToSave = dlg.getResult();
            int i2 = 0;
            while (i2 < filesToSave.length) {
                if (filesToSave[i2] instanceof IEditorPart) {
                    ((IEditorPart)filesToSave[i2]).doSave((IProgressMonitor)new NullProgressMonitor());
                }
                ++i2;
            }
        }
        return true;
    }

    private Shell getShell() {
        RemoteCEditor editor = null;
        if (this._editor instanceof RemoteCEditor) {
            editor = editor;
        } else if (this._editor instanceof TPFEditor) {
            editor = ((TPFEditor)this._editor).getLpexEditor();
        }
        return editor.getSite().getShell();
    }
}

