/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ftt.cdz.ui.composites;

import com.ibm.cdz.common.util.GridUtil;
import com.ibm.cdz.remote.ui.composites.IncludeTableContentProvider;
import com.ibm.cdz.remote.ui.composites.IncludeTableLabelProvider;
import com.ibm.ftt.cdz.core.Messages;
import com.ibm.ftt.projects.zos.zoslogical.LZOSPartitionedDataSet;
import com.ibm.ftt.resources.zos.model.MVSFileResource;
import com.ibm.ftt.ui.rse.utils.RSESelectionObject;
import com.ibm.ftt.ui.rse.utils.RSEUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.ui.SystemBaseForm;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class RemoteIncludesForm
extends SystemBaseForm
implements ISelectionChangedListener,
ICellModifier,
ICellEditorValidator {
    private List _includes;
    private Button _addButton;
    private Button _removeButton;
    private Button _upButton;
    private Button _downButton;
    private TableViewer _viewer;
    private String _tablePrompt;
    private ISubSystem _ss;

    public RemoteIncludesForm(ISystemMessageLine msgLine, ISubSystem ss, String tablePrompt) {
        super(null, msgLine);
        this._ss = ss;
        this._tablePrompt = tablePrompt;
        this._includes = new ArrayList();
    }

    public void setIncludes(String includesStr) {
        this._includes.clear();
        if (includesStr != null && includesStr.length() > 0) {
            String[] includes = includesStr.split(",");
            int i = 0;
            while (i < includes.length) {
                this._includes.add(includes[i]);
                ++i;
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this._viewer.getTable().setEnabled(enabled);
        if (!enabled) {
            this._addButton.setEnabled(enabled);
            this._removeButton.setEnabled(enabled);
            this._upButton.setEnabled(enabled);
            this._downButton.setEnabled(enabled);
        } else {
            this.updateButtonStates((IStructuredSelection)((StructuredSelection)this._viewer.getSelection()));
        }
    }

    public String getIncludes() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this._includes.size()) {
            buf.append(this._includes.get(i));
            buf.append(",");
            ++i;
        }
        return buf.toString();
    }

    public Control createContents(Composite parent) {
        super.setShell(parent.getShell());
        Composite c = SystemWidgetHelpers.createComposite((Composite)parent, (int)1);
        c.setLayoutData((Object)new GridData(1808));
        this.createTableViewer(c);
        Composite buttonBar = SystemWidgetHelpers.createComposite((Composite)c, (int)4);
        this._addButton = SystemWidgetHelpers.createPushButton((Composite)buttonBar, (String)com.ibm.cdz.remote.ui.Messages.RemoteIncludesForm_AddButton_label, (Listener)this);
        this._addButton.setToolTipText(com.ibm.cdz.remote.ui.Messages.RemoteIncludesForm_AddButton_tooltip);
        this._removeButton = SystemWidgetHelpers.createPushButton((Composite)buttonBar, (String)com.ibm.cdz.remote.ui.Messages.RemoteIncludesForm_RemoveButton_label, (Listener)this);
        this._removeButton.setToolTipText(com.ibm.cdz.remote.ui.Messages.RemoteIncludesForm_RemoveButton_label);
        this._removeButton.setEnabled(false);
        this._upButton = SystemWidgetHelpers.createPushButton((Composite)buttonBar, (String)com.ibm.cdz.remote.ui.Messages.RemoteIncludesForm_MoveUpButton_label, (Listener)this);
        this._upButton.setToolTipText(com.ibm.cdz.remote.ui.Messages.RemoteIncludesForm_MoveUpButton_tooltip);
        this._upButton.setEnabled(false);
        this._downButton = SystemWidgetHelpers.createPushButton((Composite)buttonBar, (String)com.ibm.cdz.remote.ui.Messages.RemoteIncludesForm_MoveDownButton_label, (Listener)this);
        this._downButton.setToolTipText(com.ibm.cdz.remote.ui.Messages.RemoteIncludesForm_MoveDownButton_tooltip);
        this._downButton.setEnabled(false);
        this.updateIncludes();
        return this._addButton;
    }

    private void createTableViewer(Composite parent) {
        Group tableComp = SystemWidgetHelpers.createGroupComposite((Composite)parent, (int)1, (String)this._tablePrompt);
        tableComp.setLayout((Layout)new GridLayout());
        tableComp.setLayoutData((Object)new GridData(1808));
        this._viewer = new TableViewer((Composite)tableComp, 2058);
        this._viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Table table = this._viewer.getTable();
        GridData data = GridUtil.createFill();
        data.heightHint = 30;
        data.widthHint = 80;
        table.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        CellEditor[] cellEditors = new CellEditor[]{new TextCellEditor((Composite)table)};
        this._viewer.setCellEditors(cellEditors);
        this._viewer.setCellModifier((ICellModifier)this);
        this._viewer.setColumnProperties(new String[]{Messages.RemoteIncludesForm_IncludePath});
        cellEditors[0].setValidator((ICellEditorValidator)this);
        this._viewer.setContentProvider((IContentProvider)new IncludeTableContentProvider());
        this._viewer.setLabelProvider((IBaseLabelProvider)new IncludeTableLabelProvider());
    }

    private void removeInclude(String path) {
        this._includes.remove(path);
        this.updateIncludes();
    }

    private void addInclude(String path) {
        this._includes.add(path);
        this.updateIncludes();
    }

    public void updateIncludes() {
        this._viewer.getTable().removeAll();
        this._viewer.add(this._includes.toArray());
    }

    public void handleBrowse() {
        RSESelectionObject selection = RSEUtil.browseLocalAndRemoteContainers(null, (boolean)false, (boolean)false, (boolean)true, (boolean)false, (boolean)true, (boolean)false, (Shell)this.getShell());
        if (selection != null) {
            if (selection instanceof MVSFileResource) {
                MVSFileResource res = (MVSFileResource)selection;
                MVSFileResource parent = res.getParentRemoteFile();
                if (parent == null) {
                    this.addInclude(res.getName());
                } else {
                    StringBuffer str = new StringBuffer(parent.getName());
                    str.append("(");
                    str.append(res.getName());
                    str.append(")");
                    this.addInclude(str.toString());
                }
            } else if (selection instanceof IRemoteFile) {
                IRemoteFile file = (IRemoteFile)selection;
                this.addInclude(file.getAbsolutePath());
            } else if (selection instanceof LZOSPartitionedDataSet) {
                LZOSPartitionedDataSet dataSet = (LZOSPartitionedDataSet)selection;
                this.addInclude(dataSet.getName());
            } else if (selection instanceof RSESelectionObject) {
                String path = selection.getContainerPath();
                this.addInclude(path);
            }
        }
    }

    public void handleEvent(Event evt) {
        Widget w = evt.widget;
        if (w == this._addButton) {
            this.handleBrowse();
        } else if (w == this._removeButton) {
            IStructuredSelection sel = (IStructuredSelection)this._viewer.getSelection();
            for (Object obj : sel) {
                this.removeInclude((String)obj);
            }
            if (this._includes.size() == 0) {
                this._downButton.setEnabled(false);
                this._upButton.setEnabled(false);
                this._removeButton.setEnabled(false);
            }
        } else if (w == this._upButton) {
            IStructuredSelection sel = (IStructuredSelection)this._viewer.getSelection();
            Object first = sel.getFirstElement();
            int curIndex = this._includes.indexOf(first);
            this._includes.remove(first);
            this._includes.add(--curIndex, first);
            this._viewer.getTable().deselectAll();
            this.updateIncludes();
            this._viewer.setSelection((ISelection)new StructuredSelection(first));
        } else if (w == this._downButton) {
            IStructuredSelection sel = (IStructuredSelection)this._viewer.getSelection();
            Object first = sel.getFirstElement();
            int curIndex = this._includes.indexOf(first);
            this._includes.remove(first);
            this._includes.add(++curIndex, first);
            this._viewer.getTable().deselectAll();
            this.updateIncludes();
            this._viewer.setSelection((ISelection)new StructuredSelection(first));
        }
    }

    protected void updateButtonStates(IStructuredSelection sel) {
        this._addButton.setEnabled(true);
        if (sel.isEmpty()) {
            this._downButton.setEnabled(false);
            this._upButton.setEnabled(false);
            this._removeButton.setEnabled(false);
        } else if (sel.size() == 1) {
            Object first = sel.getFirstElement();
            int index = this._includes.indexOf(first);
            this._downButton.setEnabled(index + 1 != this._includes.size());
            this._upButton.setEnabled(index != 0);
            this._removeButton.setEnabled(true);
        } else {
            this._removeButton.setEnabled(true);
            this._downButton.setEnabled(false);
            this._upButton.setEnabled(false);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        this.updateButtonStates(sel);
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        return element;
    }

    public void modify(Object item, String property, Object value) {
        Object element = ((TableItem)item).getData();
        if (!element.equals(value)) {
            int index = this._includes.indexOf(element);
            this._includes.remove(element);
            this._includes.add(index, value);
            this.updateIncludes();
        }
    }

    public String isValid(Object value) {
        return null;
    }
}

