#!/bin/sh
#
# Licensed materials - Property of IBM
# 5724-T07 Copyright IBM Corp. 2008
# All rights reserved
# US Government users restricted rights  -  Use, duplication or
# disclosure restricted by GSA ADP schedule contract with IBM Corp.
#
# Shell script to start RSE daemon
#
#                      +- 4035 --- /etc/rdz ---+
# >>-rsed.sh-+-------+-+-----------------------+-><
#            +- IVP -+ |        +- /etc/rdz -+ |
#                      +- port -+------------+-+
#                               +- path -----+
# 

if test "$1" = "ivp" -o "$1" = "IVP"
then
  _RSE_DAEMON_IVP_TEST=1
  _RSE_PWD_IVP=$(pwd)
  echo
  echo RSE daemon IVP test
  shift
fi

echo
date
id
echo

if test $1
then
  _RSE_PORT=$1
  echo RSE daemon port is $_RSE_PORT
else
  _RSE_PORT=4035
  echo RSE daemon port is $_RSE_PORT --default
fi

if test $2
then
  _RSE_CONFIG=$2
  echo RSE configuration files located in $_RSE_CONFIG
else
  _RSE_CONFIG=/etc/rdz
  echo RSE configuration files located in $_RSE_CONFIG --default
fi

echo $_RSE_CONFIG
cd $_RSE_CONFIG
set -a
echo ">>" rsed.$3.envvars
rm ./rsed.envvars
cp ./rsed.$3.envvars ./rsed.envvars
. ./rsed.envvars
echo
echo current environment variables
echo
set
echo

if test $_RSE_DAEMON_IVP_TEST
then
  echo starting java...
  echo
  java -version 2>&1
  cd $_RSE_PWD_IVP
  echo
  echo RSE daemon IVP ended
else
	echo current class path: $CLASSPATH
	echo RSE_LIB: $RSE_LIB
	echo _RSE_JAVAOPTS: $_RSE_JAVAOPTS
	echo java $_RSE_JAVAOPTS $_RSE_DAEMON_CLASS $_RSE_PORT
  java $_RSE_JAVAOPTS $_RSE_DAEMON_CLASS $_RSE_PORT
fi
