#IBM Confidential
#OCO Source Materials
#5724-H79
#��� Copyright IBM Corp. 2009
#The source code for this program is not published or otherwise
#divested of its trade secrets, irrespective of what has
#been deposited with the U.S. Copyright Office.

#!/usr/bin/perl -w

use Shell;
use POSIX ":sys_wait_h";
use Time::HiRes qw(usleep);

{
  $userIN    		 = $ARGV[0];
  $timeout			 = $ARGV[1];
  $pwdIN = <STDIN>;
  chomp($pwdIN);

  if (not defined $ARGV[2]) {
	  @passwdStruct = getpwnam($userIN);
	  if (@passwdStruct == 0)
	  {
	     print("invalid user name\n");
	     exit(-1);
	  }
	  else
	  {
	    $passwd=$passwdStruct[1];
	    $encryptedPWD = crypt($pwdIN, $passwd);
	
	    if ($passwd eq $encryptedPWD)
	    {
			print("success\n");
			exit(0);
	    }
	    else
	    {
			use Net::Domain;
			use Net::FTP; 
			$host = hostname();
			chomp($host);
			$ftp = Net::FTP->new($host, Debug => 0)
				  or die "Cannot connect to $host: $@";
			if (!$ftp->login($userIN, $pwdIN)) {
			   	print "incorrect password\n";
                exit(-1);
			} else {		
				print "success\n";
			    exit(0);
	   		}
	    }
	 }
  } else {
	 	$newPwd = <STDIN>;
  		chomp($newPwd);

	   	use IPC::Open3;
	   	$pid = open3(*WRITE, *READ, *ERR, "passwd");
	   	if (not defined $pid) {
	   		print("insufficient resources\n");
	   		exit(-1);
	   	} else {
		   	$SIG{'PIPE'} = 'PIPE_handler';
	   		use IO::Select;
		   	$sW = new IO::Select(*WRITE);
			$ok = 1;	
		   	if ($sW->can_write(10)) {
		   		print WRITE $pwdIN."\n";
		   	} else {
		   		close(WRITE);
		   		$ok=0;
		   	}
		   	
		   	if ($ok && $sW->can_write(20)) {
				print WRITE $newPwd."\n";
		   	} else {
		   		close(WRITE);
		   		$ok=0;
		   	} 

		   	if ($ok && $sW->can_write(20)) {
		   		print WRITE $newPwd."\n";
		   	} else {
		   		$ok=0;
		   		close(WRITE);
		   	}

   			$i=0;
   			do {
   				$i=$i+1000;
	   			usleep(1);
				$kid = waitpid($pid , WNOHANG);
		    } while ($kid>-1 && $kid !=$pid && $i<$timeout);
		    
		    if ($kid==-1 || $kid!=$pid) {
				close(WRITE);
				$ok=0;
   			}
   			
   			if (!$ok) {
   				$error = <ERR>;
   				chomp($error);
   				$index = index ($error, "passwd: ");
   				if ($index>-1) {
   					$error = substr($error,$index+8);
   				} else {
	   				$index = index ($error, ": ");
	   				if ($index>-1) {
   						$error = substr($error,$index+3);
		   				$index = index ($error, ": ");
		   				if ($index>-1) {
   							$error = substr($error,$index+2);
   						}	   				
   					}	   				
   				}
   				print $error."\n";
		   		exit(-1);
   			} else {
   				print "password changed";
   				exit(0);
   			}
	   	}
		
  }
}

sub PIPE_handler {
	$ok = 0;
}


