/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.cfgmgr;

import com.ibm.dmh.cfgmgr.ConfigEntry;
import com.ibm.dmh.cfgmgr.ConfigFile;
import com.ibm.dmh.cfgmgr.ConfigRuntimeException;
import com.ibm.dmh.cfgmgr.PasswordUtil;
import com.ibm.dmh.util.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigMgr {
    private static Hashtable<String, ConfigFile> configFileTable = new Hashtable();
    private static ArrayList<String> configSearchPaths = new ArrayList();
    public static ConfigRuntimeException loadErrorsException = null;

    public static String[] getConfigSearchPaths() {
        return configSearchPaths.toArray(new String[configSearchPaths.size()]);
    }

    public static void load(String string) throws ConfigRuntimeException {
        ArrayList<String> arrayList = new ArrayList<String>();
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.clear();
        if (string == null || string.equals("")) {
            linkedList.add("Search path passed to ConfigMgr.load() was empty:  searchPath=[" + string + "]");
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                try {
                    String object;
                    File file = new File(string2);
                    if (!file.exists() || arrayList.contains(object = file.getCanonicalPath())) continue;
                    arrayList.add(object);
                }
                catch (Exception exception) {
                    throw new ConfigRuntimeException("Could not get canonical path for token [" + string2 + "].", exception);
                }
            }
            boolean bl = configSearchPaths.size() == arrayList.size();
            for (int i = 0; i < configSearchPaths.size() && bl; ++i) {
                if (configSearchPaths.get(i).equalsIgnoreCase((String)arrayList.get(i))) continue;
                bl = false;
            }
            if (bl) {
                return;
            }
            configSearchPaths = arrayList;
            File file = null;
            for (String string2 : configSearchPaths) {
                file = new File(string2);
                if (!file.exists()) continue;
                if (!file.canRead()) {
                    linkedList.add("Search path passed to ConfigMgr.load() is not readable:  searchPath=[" + string + "]");
                    continue;
                }
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file2 = fileArray[i];
                    if (!file2.isFile() || !file2.getAbsolutePath().toLowerCase().endsWith(".cfg")) continue;
                    ConfigFile configFile = null;
                    try {
                        configFile = new ConfigFile(file2.getAbsolutePath());
                        if (configFileTable.containsKey(configFile.name)) continue;
                        configFileTable.put(configFile.name, configFile);
                        continue;
                    }
                    catch (ConfigRuntimeException configRuntimeException) {
                        linkedList.addAll(configRuntimeException.getErrors());
                    }
                }
            }
            for (ConfigFile configFile : configFileTable.values()) {
                try {
                    configFile.resolveAllValues();
                    configFile.save();
                }
                catch (ConfigRuntimeException configRuntimeException) {
                    linkedList.addAll(configRuntimeException.getErrors());
                }
            }
        }
        if (!linkedList.isEmpty()) {
            loadErrorsException = new ConfigRuntimeException("Problems occurred while trying to load configuration files into memory. ", linkedList);
        }
        if (loadErrorsException != null) {
            throw loadErrorsException;
        }
    }

    public static void reload() throws ConfigRuntimeException {
        String string = StringUtils.join(configSearchPaths.toArray(), File.pathSeparator);
        configSearchPaths.clear();
        configFileTable.clear();
        ConfigMgr.load(string);
    }

    public static void addPath(String string) throws ConfigRuntimeException {
        ConfigMgr.load(StringUtils.join(configSearchPaths.toArray(), File.pathSeparator) + File.pathSeparator + string);
    }

    public static void set(String string, String string2, boolean bl) throws ConfigRuntimeException {
        ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(string)).set(ConfigMgr.getLastTokens(string), string2, bl);
    }

    public static void set(String string, String string2, String string3, boolean bl) throws ConfigRuntimeException {
        ConfigMgr.getConfigFile(string).set(string2, string3, bl);
    }

    public static String get(String string) throws ConfigRuntimeException {
        return ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(string)).get(ConfigMgr.getLastTokens(string));
    }

    public static Set<String> getStringSet(String string) throws ConfigRuntimeException {
        return new HashSet<String>(Arrays.asList(StringUtils.split(ConfigMgr.get(string), ',')));
    }

    public static String get(String string, String string2) {
        String string3 = string2;
        try {
            string3 = ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(string)).get(ConfigMgr.getLastTokens(string), string2);
            if (StringUtils.isEmpty(string3)) {
                string3 = string2;
            }
        }
        catch (ConfigRuntimeException configRuntimeException) {
            string3 = string2;
        }
        return string3;
    }

    public static String get(String string, Object[] objectArray) throws ConfigRuntimeException {
        return ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(string)).get(ConfigMgr.getLastTokens(string), objectArray);
    }

    public static String get(String string, Object[] objectArray, String string2) throws ConfigRuntimeException {
        return ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(string)).get(ConfigMgr.getLastTokens(string), objectArray, string2);
    }

    public static boolean getBoolean(String string) throws ConfigRuntimeException {
        String string2 = ConfigMgr.get(string).toUpperCase();
        int n = string2.length() == 0 ? 70 : (int)string2.charAt(0);
        return n == 84 || n == 89 || n == 49;
    }

    public static long getTime(String string) throws ConfigRuntimeException {
        String string2 = ConfigMgr.get(string).toUpperCase();
        try {
            return StringUtils.parseTime(string2);
        }
        catch (Exception exception) {
            throw new ConfigRuntimeException("Invalid value for key [" + string + "].  " + exception.getMessage());
        }
    }

    public static boolean getBoolean(String string, boolean bl) throws ConfigRuntimeException {
        String string2 = ConfigMgr.get(string, "" + bl).toUpperCase();
        int n = string2.length() == 0 ? 70 : (int)string2.charAt(0);
        return n == 84 || n == 89 || n == 49;
    }

    public static int getInt(String string) throws ConfigRuntimeException {
        try {
            return Integer.parseInt(ConfigMgr.get(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigRuntimeException("Cannot return value as int for key [" + string + "].  Value was [" + ConfigMgr.get(string) + "].");
        }
    }

    public static int[] getInts(String string) throws ConfigRuntimeException {
        try {
            return StringUtils.getInts(ConfigMgr.get(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigRuntimeException("Cannot return value as int for key [" + string + "].  Value was [" + ConfigMgr.get(string) + "].");
        }
    }

    public static int getInt(String string, int n) throws ConfigRuntimeException {
        return StringUtils.getInt(ConfigMgr.get(string, (String)null), n);
    }

    public static Set<String> getKeyNames(String string) throws ConfigRuntimeException {
        return ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(string)).getKeyNamesInSection(ConfigMgr.getLastTokens(string));
    }

    public static boolean isEncoded(String string, String string2) throws ConfigRuntimeException {
        return ConfigMgr.getConfigFile(string).isEncoded(string2);
    }

    public static boolean isEncoded(String string) throws ConfigRuntimeException {
        return ConfigMgr.getConfigFile(ConfigMgr.getFirstToken(string)).isEncoded(ConfigMgr.getLastTokens(string));
    }

    public static Hashtable<String, String> getSection(String string) throws ConfigRuntimeException {
        try {
            Map<String, ConfigEntry> map = ConfigMgr.getConfigFile((String)ConfigMgr.getFirstToken((String)string)).sectionValuesMap.get(ConfigMgr.getLastTokens(string));
            if (map == null) {
                throw new ConfigRuntimeException("Section not found for key [" + string + "].");
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            for (ConfigEntry configEntry : map.values()) {
                hashtable.put(configEntry.propName, configEntry.getValue());
            }
            return hashtable;
        }
        catch (Exception exception) {
            throw new ConfigRuntimeException("Exception of type [" + exception.getClass().getName() + "] " + "caught in method ConfigMgr.getSection() for key [" + string + "]", exception);
        }
    }

    public static Map<String, String> getConfigMap(String string) throws ConfigRuntimeException {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        Map<String, ConfigEntry> map = ConfigMgr.getConfigFile((String)string).allValuesMap;
        for (Map.Entry<String, ConfigEntry> entry : map.entrySet()) {
            treeMap.put(entry.getKey(), entry.getValue().getValue());
        }
        return treeMap;
    }

    public static void save() throws ConfigRuntimeException {
        for (ConfigFile configFile : configFileTable.values()) {
            configFile.save();
        }
    }

    public static void createBatchEnvFile(String string, String string2, boolean bl, boolean bl2) throws ConfigRuntimeException {
        try {
            ConfigFile configFile = ConfigMgr.getConfigFile(string);
            StringBuffer stringBuffer = new StringBuffer("echo off\r\n\r\n");
            stringBuffer.append("rem This file was automatically generated from the contents in the " + string + ".cfg file\r\n\r\n");
            stringBuffer.append("rem version 2\r\n\r\n");
            if (string.indexOf(46) > -1) {
                string = string.substring(0, string.lastIndexOf(46));
            }
            for (String string3 : configFile.sectionList) {
                for (String string4 : configFile.sectionContents.get(string3)) {
                    if (string4.length() > 0 && string4.charAt(0) == '=') {
                        ConfigEntry configEntry = configFile.allValuesMap.get(string4.substring(1));
                        stringBuffer.append("set " + configEntry.configKey.replace('.', '_') + "=" + configEntry.getValue() + "\r\n");
                        continue;
                    }
                    stringBuffer.append("rem " + string4 + "\r\n");
                }
            }
            FileWriter fileWriter = new FileWriter(string2);
            fileWriter.write(stringBuffer.toString());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            throw new ConfigRuntimeException("Exception of type [" + exception.getClass().getName() + "] " + "caught while trying to generate batch file [" + string2 + "].");
        }
    }

    public static void createShellEnvFile(String string, String string2, boolean bl, boolean bl2) throws ConfigRuntimeException {
        try {
            ConfigFile configFile = ConfigMgr.getConfigFile(string);
            StringBuffer stringBuffer = new StringBuffer("#!/bin/sh\n\n");
            stringBuffer.append("# This file was automatically generated from the contents in the " + string + ".cfg file\n\n");
            stringBuffer.append("# version 2\n\n");
            if (string.indexOf(46) > -1) {
                string = string.substring(0, string.lastIndexOf(46));
            }
            for (String string3 : configFile.sectionList) {
                for (String string4 : configFile.sectionContents.get(string3)) {
                    if (string4.length() > 0 && string4.charAt(0) == '=') {
                        ConfigEntry configEntry = configFile.allValuesMap.get(string4.substring(1));
                        stringBuffer.append("export " + configEntry.configKey.replace('.', '_') + "=\"" + ConfigMgr.replace(configEntry.getValue(), "\\", "\\\\") + "\"\n");
                        continue;
                    }
                    stringBuffer.append((string4.startsWith("#") ? "" : "# ") + string4 + "\n");
                }
            }
            FileWriter fileWriter = new FileWriter(string2);
            fileWriter.write(stringBuffer.toString().toCharArray());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (Exception exception) {
            throw new ConfigRuntimeException("Exception of type [" + exception.getClass().getName() + "] " + "caught while trying to generate batch file [" + string2 + "].");
        }
    }

    private static String replace(String string, String string2, String string3) {
        int n = -1;
        while ((n = string.indexOf(string2, n + 1)) != -1) {
            string = string.substring(0, n) + string3 + string.substring(n += string2.length());
        }
        return string;
    }

    public static ConfigFile getConfigFile(String string) throws ConfigRuntimeException {
        Object object;
        if (string.indexOf(46) == -1) {
            string = string + ".cfg";
        }
        if (!configFileTable.containsKey(string)) {
            boolean bl = false;
            Iterator<String> iterator = configSearchPaths.iterator();
            while (iterator.hasNext() && !bl) {
                String string2 = iterator.next();
                object = new File(string2 + File.separator + string);
                try {
                    if (!((File)object).exists() || !((File)object).getCanonicalFile().getName().equals(string)) continue;
                    configFileTable.put(string, new ConfigFile(((File)object).getAbsolutePath()));
                    bl = true;
                }
                catch (Exception exception) {
                    throw new ConfigRuntimeException("Unexpected exception caught in ConfigMgr.getConfigFile(" + string + "):  msg=[" + exception.getLocalizedMessage() + "]", exception);
                }
            }
        }
        if ((object = configFileTable.get(string)) == null) {
            throw new ConfigRuntimeException("Could not find configuration file [" + string + "] " + "in search path [" + ConfigMgr.getSearchPath() + "]");
        }
        if (((ConfigFile)object).hasBeenModified) {
            try {
                ((ConfigFile)object).save();
            }
            catch (ConfigRuntimeException configRuntimeException) {
                System.err.println("WARNING:  Could not save configuration file [" + string + "].  File is read-only.  File may now contain unencoded passwords.");
                ((ConfigFile)object).hasBeenModified = false;
            }
        }
        return object;
    }

    private static String getSearchPath() {
        String string = "";
        for (int i = 0; i < configSearchPaths.size(); ++i) {
            string = string + configSearchPaths.get(i) + File.pathSeparator;
        }
        return string;
    }

    public static Hashtable<String, String> getAllValues(boolean bl) throws Exception {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        for (String string : configSearchPaths) {
            File file = new File(string);
            if (!file.exists() || !file.isDirectory()) continue;
            String[] stringArray = file.list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.toLowerCase().endsWith("cfg");
                }
            });
            for (int i = 0; i < stringArray.length; ++i) {
                ConfigFile configFile = ConfigMgr.getConfigFile(stringArray[i]);
                String string2 = stringArray[i].substring(0, stringArray[i].indexOf(46));
                for (Map.Entry<String, ConfigEntry> entry : configFile.allValuesMap.entrySet()) {
                    ConfigEntry configEntry = entry.getValue();
                    String string3 = null;
                    string3 = bl ? configEntry.getValue() : (configEntry.isEncoded ? PasswordUtil.decode(configEntry.rawValue) : configEntry.rawValue);
                    hashtable.put(string2 + "." + entry.getKey(), string3);
                }
            }
        }
        return hashtable;
    }

    public static Hashtable<String, String> getAllValues() throws Exception {
        return ConfigMgr.getAllValues(true);
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            ConfigMgr.printUsageAndExit();
        }
        if (stringArray[0].equals("setVals")) {
            String string = null;
            LinkedList<String> linkedList = new LinkedList<String>();
            boolean bl = false;
            for (int i = 1; i < stringArray.length; ++i) {
                System.out.println("looking at arg [" + stringArray[i] + "]");
                if (stringArray[i].equals("-searchPath") && stringArray.length > i + 1 && !stringArray[i + 1].startsWith("-")) {
                    string = stringArray[++i];
                    continue;
                }
                if (stringArray[i].equals("-vals")) {
                    StringBuffer charSequence = new StringBuffer();
                    while (i + 1 < stringArray.length && !stringArray[i + 1].startsWith("-")) {
                        charSequence.append(stringArray[++i] + " ");
                    }
                    String[] stringArray2 = StringUtils.split(charSequence.toString());
                    for (int j = 0; j < stringArray2.length; ++j) {
                        if (j % 2 != 1) continue;
                        linkedList.add(stringArray2[j - 1] + "=" + stringArray2[j]);
                    }
                    continue;
                }
                if (!stringArray[i].equals("-verbose")) continue;
                bl = true;
            }
            if (string == null || linkedList.size() == 0) {
                ConfigMgr.printUsageAndExit();
            }
            try {
                if (bl) {
                    System.out.println("Setting search path to [" + string + "]");
                }
                ConfigMgr.load(string);
                for (String exception : linkedList) {
                    System.out.println("Command=[" + exception + "]");
                    int n = exception.indexOf(61);
                    if (n == -1) {
                        ConfigMgr.printUsageAndExit();
                    }
                    String string2 = exception.substring(0, n);
                    String string3 = exception.substring(n + 1);
                    if (bl) {
                        System.out.println("Setting [" + string2 + "] to [" + string3 + "]");
                    }
                    ConfigMgr.set(string2, string3, false);
                }
                if (bl) {
                    System.out.println("Saving...");
                }
                ConfigMgr.save();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
            if (bl) {
                System.out.println("Done.");
            }
        } else if (stringArray[0].equals("createShellEnvFile") && stringArray.length >= 3) {
            void exception;
            String string = null;
            String string4 = null;
            String string5 = null;
            boolean bl = false;
            boolean i = true;
            while (exception < stringArray.length) {
                if (stringArray[exception].equals("-searchPath") && stringArray.length > exception + true && !stringArray[exception + true].startsWith("-")) {
                    string = stringArray[++exception];
                } else if (stringArray[exception].equals("-configFile") && stringArray.length > exception + true && !stringArray[exception + true].startsWith("-")) {
                    string4 = stringArray[++exception];
                } else if (stringArray[exception].equals("-batchPathname") && stringArray.length > exception + true && !stringArray[exception + true].startsWith("-")) {
                    string5 = stringArray[++exception];
                } else if (stringArray[exception].equals("-verbose")) {
                    bl = true;
                }
                ++exception;
            }
            if (string == null || string4 == null || string5 == null) {
                ConfigMgr.printUsageAndExit();
            }
            try {
                if (bl) {
                    System.out.println("creating shell script [" + string5 + "]...");
                }
                ConfigMgr.load(string);
                ConfigMgr.createShellEnvFile(string4, string5, false, bl);
                if (bl) {
                    System.out.println("Done.");
                }
                System.exit(0);
            }
            catch (Exception exception2) {
                exception2.printStackTrace(System.err);
            }
        } else if (stringArray[0].equals("createBatchEnvFile") && stringArray.length >= 3) {
            void var5_22;
            String string = null;
            String string6 = null;
            String string7 = null;
            boolean bl = false;
            boolean bl2 = true;
            while (var5_22 < stringArray.length) {
                if (stringArray[var5_22].equals("-searchPath") && stringArray.length > var5_22 + true && !stringArray[var5_22 + true].startsWith("-")) {
                    string = stringArray[++var5_22];
                } else if (stringArray[var5_22].equals("-configFile") && stringArray.length > var5_22 + true && !stringArray[var5_22 + true].startsWith("-")) {
                    string6 = stringArray[++var5_22];
                } else if (stringArray[var5_22].equals("-batchPathname") && stringArray.length > var5_22 + true && !stringArray[var5_22 + true].startsWith("-")) {
                    string7 = stringArray[++var5_22];
                } else if (stringArray[var5_22].equals("-verbose")) {
                    bl = true;
                }
                ++var5_22;
            }
            if (string == null || string6 == null || string7 == null) {
                ConfigMgr.printUsageAndExit();
            }
            try {
                if (bl) {
                    System.out.println("creating batch file [" + string7 + "]...");
                }
                ConfigMgr.load(string);
                ConfigMgr.createBatchEnvFile(string6, string7, false, bl);
                if (bl) {
                    System.out.println("Done.");
                }
                System.exit(0);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        } else {
            ConfigMgr.printUsageAndExit();
        }
    }

    public static void printUsageAndExit() {
        System.err.println("---Usage---");
        System.err.println("java -jar ConfigMgr.jar createBatchEnvFile -searchPath <searchPath> -configFile <configFile> -batchPathname <batchFilePath> [-verbose]");
        System.err.println("java -jar ConfigMgr.jar createShellEnvFile -searchPath <searchPath> -configFile <configFile> -batchPathname <batchFilePath> [-verbose]");
        System.err.println("java -jar ConfigMgr.jar setVals -searchPath <searchPath> -vals [var1 val1 [var2 val2...]] [-verbose]");
        System.exit(2);
    }

    private static String getFirstToken(String string) throws ConfigRuntimeException {
        if (string.indexOf(46) == -1) {
            throw new ConfigRuntimeException("Invalid config key [" + string + "].  " + "Must be of the format [config.key] or [config.section.key]");
        }
        return string.substring(0, string.indexOf(46));
    }

    private static String getLastTokens(String string) throws ConfigRuntimeException {
        if (string.indexOf(46) == -1) {
            throw new ConfigRuntimeException("Invalid config key [" + string + "].  " + "Must be of the format [config.key] or [config.section.key]");
        }
        return string.substring(string.indexOf(46) + 1);
    }

    private static String checkConfigPath(String string) {
        if (StringUtils.isEmpty(string)) {
            return null;
        }
        File file = new File(string + "\\Common.cfg");
        if (!file.exists() || !file.canRead()) {
            return null;
        }
        return file.getParent();
    }

    public static String getConfigPath() throws FileNotFoundException {
        String string = ConfigMgr.checkConfigPath(System.getProperty("wsaaConfig"));
        if (string != null) {
            return string;
        }
        string = ConfigMgr.checkConfigPath(System.getenv("WSAA_CONFIG"));
        if (string != null) {
            return string;
        }
        string = ConfigMgr.checkConfigPath(System.getenv("WSAA_HOME") + "\\config");
        if (string == null) {
            throw new FileNotFoundException("Common.cfg");
        }
        return string;
    }
}

