/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

import java.util.HashMap;
import java.util.Map;

public class DbUtil {
    public static Map<String, Integer> typeMap = new HashMap<String, Integer>();

    public static String getSqlTypeString(int n) {
        switch (n) {
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
        }
        return "UNKNOWN";
    }

    public static String getSqlTypeString(int n, int n2) {
        switch (n) {
            case 2003: {
                return "ARRAY";
            }
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY(" + n2 + ")";
            }
            case 1: {
                return "CHAR(" + n2 + ")";
            }
            case 2005: {
                return "CLOB(" + n2 + ")";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "LONGVARBINARY(" + n2 + ")";
            }
            case -1: {
                return "LONGVARCHAR(" + n2 + ")";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY(" + n2 + ")";
            }
            case 12: {
                return "VARCHAR(" + n2 + ")";
            }
        }
        return "UNKNOWN(" + n2 + ")";
    }

    public static boolean dataTypeIsNumeric(int n) {
        switch (n) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static boolean dataTypeIsTimestamp(int n) {
        switch (n) {
            case 93: {
                return true;
            }
        }
        return false;
    }

    public static boolean dataTypeIsString(int n) {
        switch (n) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    public static int getSqlType(String string) {
        Integer n;
        if (string == null) {
            return 0;
        }
        if ((string = string.toUpperCase()).indexOf(40) != -1) {
            string = string.substring(0, string.indexOf(40));
        }
        if ((n = typeMap.get(string)) == null) {
            return 0;
        }
        return n;
    }

    public static String getSqlTypeAndSizeString(int n, long l) {
        return DbUtil.getSqlTypeString(n) + (DbUtil.sqlTypeHasSize(n) ? "(" + l + ")" : "");
    }

    public static boolean sqlTypeHasSize(int n) {
        return n == -2 || n == 2004 || n == 1 || n == 2005 || n == -4 || n == -1 || n == -3 || n == 12;
    }

    public static String getDefaultForColumnType(int n) {
        switch (n) {
            case -5: 
            case 4: 
            case 5: {
                return "0";
            }
            case 1: 
            case 12: 
            case 2005: {
                return "";
            }
            case 93: {
                return "CURRENT TIMESTAMP";
            }
            case 92: {
                return "CURRENT TIME";
            }
            case 91: {
                return "CURRENT DATE";
            }
        }
        return "UNKNOWN";
    }

    public static long getSqlSize(String string) {
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        if (n == -1) {
            return 0L;
        }
        return Long.parseLong(string.substring(n + 1, n2));
    }

    static {
        typeMap.put("ARRAY", new Integer(2003));
        typeMap.put("BIGINT", new Integer(-5));
        typeMap.put("BINARY", new Integer(-2));
        typeMap.put("CHAR", new Integer(1));
        typeMap.put("CHARACTER", new Integer(1));
        typeMap.put("CLOB", new Integer(2005));
        typeMap.put("DATE", new Integer(91));
        typeMap.put("DECIMAL", new Integer(3));
        typeMap.put("DOUBLE", new Integer(8));
        typeMap.put("FLOAT", new Integer(6));
        typeMap.put("INTEGER", new Integer(4));
        typeMap.put("LONGVARBINARY", new Integer(-4));
        typeMap.put("LONGVARCHAR", new Integer(-1));
        typeMap.put("REAL", new Integer(7));
        typeMap.put("SMALLINT", new Integer(5));
        typeMap.put("TIME", new Integer(92));
        typeMap.put("TIMESTAMP", new Integer(93));
        typeMap.put("TIMESTMP", new Integer(93));
        typeMap.put("TINYINT", new Integer(-6));
        typeMap.put("VARBINARY", new Integer(-3));
        typeMap.put("VARCHAR", new Integer(12));
        typeMap.put("DATE", new Integer(93));
        typeMap.put("NUMBER", new Integer(4));
        typeMap.put("STRING", new Integer(12));
    }
}

