/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.dbutil;

import com.ibm.dmh.cfgmgr.ConfigMgr;
import com.ibm.dmh.cfgmgr.ConfigRuntimeException;
import com.ibm.dmh.cfgmgr.ExpressionSolver;
import com.ibm.dmh.cfgmgr.vars.AbstractVar;
import com.ibm.dmh.cfgmgr.vars.MathBoolVar;
import com.ibm.dmh.cfgmgr.vars.MathFloatVar;
import com.ibm.dmh.cfgmgr.vars.MathIntVar;
import com.ibm.dmh.cfgmgr.vars.VarResolver;
import com.ibm.dmh.db.DbAdmin;
import com.ibm.dmh.db.DbInfo;
import com.ibm.dmh.db.DbMetaData;
import com.ibm.dmh.db.DbResultSet;
import com.ibm.dmh.db.DbTable;
import com.ibm.dmh.dbutil.ColumnExistsVar;
import com.ibm.dmh.dbutil.IndexExistsVar;
import com.ibm.dmh.dbutil.SchemaExistsVar;
import com.ibm.dmh.dbutil.TableExistsVar;
import com.ibm.dmh.dbutil.TriggerExistsVar;
import com.ibm.dmh.dbutil.tasks.ITask;
import com.ibm.dmh.dbutil.tasks.MigrateEndMessage;
import com.ibm.dmh.util.FileContents;
import com.ibm.dmh.util.LocaleMgr;
import com.ibm.dmh.util.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    private static String dbUtilHome;
    public static String[] dbLevels;
    public static String[] migrateFromLevels;
    public static String[] migrateToLevels;
    public static String[] validOSes;
    private static final String DIV1 = "======================================================================";
    private static final String DIV2 = "----------------------------------------------------------------------";
    private static PrintWriter logFileWriter;
    private static VarResolver varResolver;
    private static Map<String, ITask> iTaskMap;

    public static void init(String configDir) {
        File f;
        dbUtilHome = System.getProperty("dbUtilHome");
        if (dbUtilHome == null || dbUtilHome.equals("") || !new File(dbUtilHome).isDirectory()) {
            System.err.println("dbUtilHome property is not set to a valid directory:  '" + dbUtilHome + "'.  Aborting...");
            System.exit(2);
        }
        try {
            ConfigMgr.load((String)configDir);
        }
        catch (ConfigRuntimeException e) {
            System.err.println(e.getMessage());
            System.exit(2);
        }
        String os = ConfigMgr.get((String)"User.Database.os");
        String tsprefix = ConfigMgr.get((String)"User.ZOS.tsprefix");
        if (os.equalsIgnoreCase("zOS") && tsprefix.length() > 5) {
            System.err.println("User.ZOS.tsprefix value must not exceed 5 characters.  User.ZOS.tsprefix=[" + tsprefix + "].  Please update User.cfg.");
            System.exit(1);
        }
        dbLevels = StringUtils.split((String)ConfigMgr.get((String)"System.dbLevels"), (char)',');
        migrateToLevels = Arrays.asList(dbLevels).subList(1, dbLevels.length).toArray(new String[dbLevels.length - 1]);
        migrateFromLevels = Arrays.asList(dbLevels).subList(0, dbLevels.length - 1).toArray(new String[dbLevels.length - 1]);
        String stagingDir = ConfigMgr.get((String)"User.Utility.stagingDir");
        File stagingDirF = new File(stagingDir);
        if (!stagingDirF.exists() && !stagingDirF.mkdirs()) {
            System.err.println("Could not create staging directory: [" + stagingDir + "].  Cannot proceed.");
            System.exit(1);
        }
        if (!stagingDirF.canRead()) {
            System.err.println("Staging directory is not readable: [" + stagingDir + "].  Cannot proceed.");
            System.exit(1);
        }
        if (!stagingDirF.canWrite()) {
            System.err.println("Staging directory is not writeable: [" + stagingDir + "].  Cannot proceed.");
            System.exit(1);
        }
        if ((f = new File(stagingDir + "/dbutil.log")).exists()) {
            File f2 = new File(stagingDir + "/dbutil.log.2");
            if (f2.exists()) {
                f2.delete();
            }
            f.renameTo(new File(stagingDir + "/dbutil.log.2"));
            f = new File(stagingDir + "/dbutil.log");
        }
        try {
            logFileWriter = new PrintWriter(new FileWriter(f));
        }
        catch (IOException e) {
            System.err.println("User does not have write authority on this directory.  Aborting...");
            System.exit(2);
        }
        Arrays.sort(validOSes);
    }

    private static void initDb(String dbUrl, String user, String pw, String dbDriver, String schemaName) {
        dbUrl = StringUtils.getString((String)dbUrl, (String)ConfigMgr.get((String)"User.Database.url"));
        user = StringUtils.getString((String)user, (String)ConfigMgr.get((String)"User.Database.user"));
        pw = StringUtils.getString((String)pw, (String)ConfigMgr.get((String)"User.Database.pw"));
        dbDriver = StringUtils.getString((String)dbDriver, (String)ConfigMgr.get((String)"User.Database.driver"));
        schemaName = StringUtils.getString((String)schemaName, (String)ConfigMgr.get((String)"User.Database.tSchema"));
        try {
            DbAdmin.initializeJdbc((String)dbUrl, (String)user, (String)pw, (String)dbDriver, null, (String)schemaName, (String)Charset.defaultCharset().toString(), (boolean)false, (int)10000, (int)30000);
        }
        catch (ClassNotFoundException e) {
            Main.logException(e);
            Main.exit(2, "Database driver not located in classpath.", false);
        }
        catch (Exception e) {
            Main.logException(e);
            Main.exit(2, "Problem occurred while trying to access database.", false);
        }
        try {
            DbAdmin.query((CharSequence)"with X(Y) as (select 1 from sysibm.sysdummy1) select Y from X", (Object[])new Object[0]).toSingleRow(new String[0]);
        }
        catch (Exception e) {
            Main.logException(e);
            Main.exit(2, "Specified JDBC driver does not support DB2 v8 syntax.", false);
        }
    }

    public static void printUsageAndExit(String msg) {
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println();
        System.err.println("---Usage---");
        System.err.println("---------------------------------------------------------------------------");
        System.err.println("dbutil -createMigratePlan {" + StringUtils.join((Object[])migrateToLevels, (String)"|") + "} {optional-args}");
        System.err.println("Create a database migration plan for the database defined in User.cfg.");
        System.err.println("The specified version is the targeted database version.");
        System.err.println();
        System.err.println("Optional arguments are as follows...");
        System.err.println("\t-configDir ? - The location of the /config directory.  Use if running");
        System.err.println("\t    from a read-only directory.");
        System.err.println();
        System.err.println("---------------------------------------------------------------------------");
        System.err.println("dbutil -runMigratePlan {optional-run-steps} {optional-args}");
        System.err.println("Runs a database migration plan created by the previous command against the");
        System.err.println("database defined in User.cfg.");
        System.err.println("");
        System.err.println("Examples:");
        System.err.println("Run all steps in all migration plans:");
        System.err.println("\tdbutil -runMigratePlan");
        System.err.println("Run steps v311.1 through v311.100:");
        System.err.println("\tdbutil -runMigratePlan v311.1-v311.100");
        System.err.println("Run all steps from v311.1 to v411.100:");
        System.err.println("\tdbutil -runMigratePlan v311.1-v411.100");
        System.err.println("Run all steps up to and including v311.100:");
        System.err.println("\tdbutil -runMigratePlan -v311.100");
        System.err.println("Run all steps including and after v311.100:");
        System.err.println("\tdbutil -runMigratePlan v311.100-");
        System.err.println("Run step v311.100 only:");
        System.err.println("\tdbutil -runMigratePlan v311.100");
        System.err.println();
        System.err.println("Optional arguments are as follows...");
        System.err.println("\t-configDir ? - The location of the /config directory.  Use if running");
        System.err.println("\t    from a read-only directory.");
        System.err.println();
        System.err.println("---------------------------------------------------------------------------");
        System.err.println("dbutil -verifySchema {" + StringUtils.join((Object[])dbLevels, (String)"|") + "} {optional-args}");
        System.err.println("Verifies that the database defined in User.cfg is at the specified version.");
        System.err.println("Displays a list of all differences in tables, indexes, columns, and ");
        System.err.println("\ttriggers.");
        System.err.println("Optional arguments are as follows (all default to values in User.cfg)...");
        System.err.println("\t-configDir ? - The location of the /config directory.  Use if running");
        System.err.println("\t    from a read-only directory.");
        System.err.println("\t-dbUrl ? - The database URL.");
        System.err.println("\t-user ? - The database userid.");
        System.err.println("\t-pw ? - The database password.");
        System.err.println("\t-os {" + StringUtils.join((Object[])validOSes, (String)"|") + "} - The operating system on ");
        System.err.println("\t\twhich the database resides.");
        System.err.println("\t-tSchema ? - The table schema name used.");
        System.err.println("\t-dbDriver ? - The database driver class name.");
        System.err.println("\t-isDistEnabled ? - True if distributed tables are present.");
        System.err.println();
        System.err.println("---------------------------------------------------------------------------");
        System.err.println("dbutil -getInfo {optional-args}");
        System.err.println("Returns the version, os, and whether dist tables are enabled on a database.");
        System.err.println("Optional arguments are as follows (all default to values in User.cfg)...");
        System.err.println("\t-configDir ? - The location of the /config directory.  Use if running");
        System.err.println("\t    from a read-only directory.");
        System.err.println("\t-dbUrl ? - The database URL.");
        System.err.println("\t-user ? - The database userid.");
        System.err.println("\t-pw ? - The database password.");
        System.err.println("\t-tSchema ? - The table schema name used.");
        System.err.println("\t-dbDriver ? - The database driver class name.");
        System.err.println();
        Main.exit(1, null, true);
    }

    public static void promptToExit(String msg, boolean rollBackOnExit) {
        System.out.print(msg + "  Continue" + (rollBackOnExit ? " (Rollback occurs if 'N')" : "") + "? {Y/N}  ");
        InputStreamReader isr = new InputStreamReader(System.in);
        try {
            while (true) {
                char c;
                if ((c = Character.toUpperCase((char)isr.read())) == 'N') {
                    try {
                        if (rollBackOnExit) {
                            DbAdmin.rollback();
                        }
                    }
                    catch (Exception e) {
                        Main.logException(e);
                    }
                    Main.exit(1, null, rollBackOnExit);
                    continue;
                }
                if (c == 'Y') break;
            }
            while (isr.ready()) {
                isr.read();
            }
            return;
        }
        catch (Exception e) {
            Main.exit(2, e.getMessage(), true);
            return;
        }
    }

    public static char prompt(String msg, char[] opts) {
        Arrays.sort(opts);
        System.out.print(msg);
        InputStreamReader isr = new InputStreamReader(System.in);
        try {
            char c;
            while (Arrays.binarySearch(opts, c = Character.toUpperCase((char)isr.read())) < 0) {
            }
            while (isr.ready()) {
                isr.read();
            }
            return c;
        }
        catch (Exception e) {
            Main.exit(2, e.getMessage(), true);
            return 'x';
        }
    }

    public static String prompt(String msg, String[] optStrings) {
        Main.logln(msg);
        char[] opts = new char[optStrings.length];
        for (int i = 0; i < optStrings.length; ++i) {
            Main.logln("{" + (i + 1) + "} - " + optStrings[i]);
            opts[i] = (char)(49 + i);
        }
        InputStreamReader isr = new InputStreamReader(System.in);
        try {
            char c;
            while (Arrays.binarySearch(opts, c = (char)isr.read()) < 0) {
            }
            while (isr.ready()) {
                isr.read();
            }
            return optStrings[c - 49];
        }
        catch (Exception e) {
            Main.exit(2, e.getMessage(), true);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block28: {
            block33: {
                block32: {
                    block31: {
                        block30: {
                            block29: {
                                System.out.println("JVM version detected: [" + System.getProperty("java.version") + "]");
                                String[] cv = StringUtils.split((String)System.getProperty("java.version"), (char)'.');
                                if (Integer.parseInt(cv[1]) < 4) {
                                    System.err.println("This utility requires JRE 1.4 or above.");
                                    System.exit(1);
                                }
                                String configDir = "./config";
                                LinkedList<String> otherArgs = new LinkedList<String>();
                                for (int i = 0; i < args.length; ++i) {
                                    if (args[i].equalsIgnoreCase("-configDir") && args.length > i + 1) {
                                        configDir = args[i + 1];
                                        ++i;
                                        continue;
                                    }
                                    otherArgs.add(args[i]);
                                }
                                args = otherArgs.toArray(new String[otherArgs.size()]);
                                File f = new File(configDir);
                                if (!f.exists()) {
                                    System.err.println("Could not locate config directory:  [" + configDir + "]");
                                    System.exit(1);
                                }
                                if (!f.canRead()) {
                                    System.err.println("Config directory is not readable:  [" + configDir + "]");
                                    System.exit(1);
                                }
                                Main.init(configDir);
                                if (args.length == 0) {
                                    Main.printUsageAndExit("No arguments specified.");
                                }
                                if (!args[0].equalsIgnoreCase("-createMigratePlan") || args.length != 2) break block29;
                                Main.initDb(null, null, null, null, null);
                                String targetVersion = args[1];
                                int r = Main.createMigratePlan(targetVersion);
                                switch (r) {
                                    case 0: {
                                        Main.logln("Finished successfully.");
                                        break;
                                    }
                                    case 1: {
                                        Main.logln("Aborted by user.");
                                        break;
                                    }
                                    default: {
                                        Main.logln("Errors occurred.");
                                        break;
                                    }
                                }
                                break block28;
                            }
                            if (!args[0].equalsIgnoreCase("-runMigratePlan")) break block30;
                            Main.initDb(null, null, null, null, null);
                            String runSteps = args.length < 2 ? "" : StringUtils.join((Object[])Arrays.asList(args).subList(1, args.length).toArray(), (String)" ");
                            int r = Main.runMigratePlan(runSteps);
                            switch (r) {
                                case 0: {
                                    Main.logln("Finished successfully.");
                                    break;
                                }
                                case 1: {
                                    Main.logln("Aborted by user.");
                                    break;
                                }
                                default: {
                                    Main.logln("Errors occurred.");
                                    break;
                                }
                            }
                            break block28;
                        }
                        if (!args[0].equalsIgnoreCase("-verifySchema") || args.length < 2) break block31;
                        Map<String, String> argMap = Main.getArgMap(args, 2, new String[]{"dbUrl", "user", "pw", "os", "tSchema", "dbDriver"});
                        String targetVersion = args[1];
                        String dbUrl = StringUtils.getString((String)argMap.get("dbUrl"), (String)ConfigMgr.get((String)"User.Database.url"));
                        String user = StringUtils.getString((String)argMap.get("user"), (String)ConfigMgr.get((String)"User.Database.user"));
                        String pw = StringUtils.getString((String)argMap.get("pw"), (String)ConfigMgr.get((String)"User.Database.pw"));
                        String os = StringUtils.getString((String)argMap.get("os"), (String)ConfigMgr.get((String)"User.Database.os"));
                        String tSchema = StringUtils.getString((String)argMap.get("tSchema"), (String)ConfigMgr.get((String)"User.Database.tSchema"));
                        String dbDriver = StringUtils.getString((String)argMap.get("dbDriver"), (String)ConfigMgr.get((String)"User.Database.driver"));
                        boolean isDistEnabled = StringUtils.getBoolean((String)argMap.get("isDistEnabled"), (boolean)ConfigMgr.getBoolean((String)"User.Database.isDistEnabled"));
                        if (Arrays.binarySearch(dbLevels, targetVersion) < 0) {
                            Main.exit(2, "Invalid database level specified.  Run dbutil without arguments for usage.", false);
                        }
                        Main.logln("Verifying database with the following properties: ");
                        Main.logln("\ttargetVersion = '" + targetVersion + "'");
                        Main.logln("\tdbUrl = '" + dbUrl + "'");
                        Main.logln("\tuser = '" + user + "'");
                        Main.logln("\tpw = '" + pw + "'");
                        Main.logln("\tos = '" + os + "'");
                        Main.logln("\ttSchema = '" + tSchema + "'");
                        Main.logln("\tdbDriver = '" + dbDriver + "'");
                        Main.logln("\tisDistEnabled = '" + isDistEnabled + "'");
                        if (Arrays.binarySearch(validOSes, os) < 0) {
                            Main.exit(1, "Invalid OS specified:  '" + os + "'.", false);
                        }
                        Main.initDb(dbUrl, user, pw, dbDriver, tSchema);
                        int r = Main.verifySchema(targetVersion, os, tSchema, isDistEnabled);
                        switch (r) {
                            case 0: {
                                Main.logln("Finished successfully.");
                                break;
                            }
                            case 1: {
                                Main.logln("Aborted by user.");
                                break;
                            }
                            default: {
                                Main.logln("Errors occurred.");
                                break;
                            }
                        }
                        break block28;
                    }
                    if (!args[0].equalsIgnoreCase("-generateVerifyFile")) break block32;
                    Map<String, String> argMap = Main.getArgMap(args, 1, new String[]{"desc", "path", "dbUrl", "user", "pw", "tSchema", "dbDriver"});
                    String desc = argMap.get("desc");
                    String path = argMap.get("path");
                    String dbUrl = StringUtils.getString((String)argMap.get("dbUrl"), (String)ConfigMgr.get((String)"User.Database.url"));
                    String user = StringUtils.getString((String)argMap.get("user"), (String)ConfigMgr.get((String)"User.Database.user"));
                    String pw = StringUtils.getString((String)argMap.get("pw"), (String)ConfigMgr.get((String)"User.Database.pw"));
                    String tSchema = StringUtils.getString((String)argMap.get("tSchema"), (String)ConfigMgr.get((String)"User.Database.tSchema"));
                    String dbDriver = StringUtils.getString((String)argMap.get("dbDriver"), (String)ConfigMgr.get((String)"User.Database.driver"));
                    Main.logln("Creating verify file with the following properties: ");
                    Main.logln("\tdesc = '" + desc + "'");
                    Main.logln("\tpath = '" + path + "'");
                    Main.logln("\tdbUrl = '" + dbUrl + "'");
                    Main.logln("\tuser = '" + user + "'");
                    Main.logln("\tpw = '" + pw + "'");
                    Main.logln("\ttSchema = '" + tSchema + "'");
                    Main.logln("\tdbDriver = '" + dbDriver + "'");
                    Main.initDb(dbUrl, user, pw, dbDriver, tSchema);
                    int r = Main.generateVerifyFile(desc, path, tSchema);
                    switch (r) {
                        case 0: {
                            Main.logln("Finished successfully.");
                            break;
                        }
                        case 1: {
                            Main.logln("Aborted by user.");
                            break;
                        }
                        default: {
                            Main.logln("Errors occurred.");
                        }
                    }
                    Main.logln(r == 0 ? "Finished successfully." : "Errors occurred");
                    break block28;
                }
                if (!args[0].equalsIgnoreCase("-getInfo")) break block33;
                Map<String, String> argMap = Main.getArgMap(args, 1, new String[]{"dbUrl", "user", "pw", "tSchema", "dbDriver"});
                String dbUrl = StringUtils.getString((String)argMap.get("dbUrl"), (String)ConfigMgr.get((String)"User.Database.url"));
                String user = StringUtils.getString((String)argMap.get("user"), (String)ConfigMgr.get((String)"User.Database.user"));
                String pw = StringUtils.getString((String)argMap.get("pw"), (String)ConfigMgr.get((String)"User.Database.pw"));
                String tSchema = StringUtils.getString((String)argMap.get("tSchema"), (String)ConfigMgr.get((String)"User.Database.tSchema"));
                String dbDriver = StringUtils.getString((String)argMap.get("dbDriver"), (String)ConfigMgr.get((String)"User.Database.driver"));
                Main.initDb(dbUrl, user, pw, dbDriver, tSchema);
                Connection c = null;
                try {
                    c = DbAdmin.getThreadConnection();
                    DbInfo dbi = new DbInfo(c, tSchema);
                    Main.logln("Url:  " + dbUrl);
                    Main.logln("Version:  " + dbi.getSchemaLevel());
                    Main.logln("OS:  " + dbi.getProduct());
                }
                catch (Exception e) {
                    try {
                        Main.logException(e);
                    }
                    catch (Throwable throwable) {
                        DbAdmin.close((Object[])new Object[]{c});
                        throw throwable;
                    }
                    DbAdmin.close((Object[])new Object[]{c});
                    break block28;
                }
                DbAdmin.close((Object[])new Object[]{c});
                break block28;
            }
            Main.exit(2, "Command not recognized.", false);
        }
        Main.exit(0, null, false);
    }

    public static void exit(int returnCode, String msg, boolean rollbackConnection) {
        if (msg != null) {
            Main.logln(msg);
        }
        try {
            if (logFileWriter != null) {
                logFileWriter.flush();
                logFileWriter.close();
            }
            if (rollbackConnection) {
                DbAdmin.rollback();
            } else {
                DbAdmin.commit();
            }
            DbAdmin.closeThreadConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(returnCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int generateVerifyFile(String desc, String path, String tSchema) {
        try {
            DbMetaData dmd = new DbMetaData(DbAdmin.getThreadConnection(), tSchema, desc);
            File outFile = new File(path);
            dmd.saveToFile(outFile);
        }
        catch (Exception e) {
            Main.logException(e);
            int n = 2;
            return n;
        }
        finally {
            DbAdmin.closeThreadConnection();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int verifySchema(String targetVersion, String os, String tSchema, boolean isDistEnabled) {
        try {
            int v = Integer.parseInt(targetVersion.substring(1));
            os = os.equalsIgnoreCase("zOS") ? "zOS" : "UDB";
            String xDist = isDistEnabled || v >= 600 ? "wDist" : "woDist";
            File compFile = new File(dbUtilHome + "/verify/" + targetVersion + "/Verify_" + os + "_" + xDist + ".xml");
            if (!compFile.exists()) {
                Main.logln("Could not locate verification file:  '" + compFile.toString() + "'");
                int n = 2;
                return n;
            }
            DbMetaData dmd = new DbMetaData(DbAdmin.getThreadConnection(), tSchema, "n/a");
            DbMetaData dmd2 = new DbMetaData(compFile, tSchema);
            String[] diffs = dmd.compareTo(dmd2);
            Main.logln("Baseline comparison showed " + diffs.length + " differences.");
            for (int i = 0; i < diffs.length; ++i) {
                Main.logln(i + 1 + ": " + diffs[i]);
            }
        }
        catch (Exception e) {
            Main.logException(e);
            int n = 2;
            return n;
        }
        finally {
            DbAdmin.closeThreadConnection();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int createMigratePlan(String targetVersion) {
        File migratePlanDir = new File(ConfigMgr.get((String)"User.Utility.stagingDir") + "/migrate_plan");
        String startVersion = null;
        if (Arrays.binarySearch(migrateToLevels, targetVersion) < 0) {
            Main.logln("Invalid target version specified:  '" + targetVersion + "'.");
            Main.logln("Valid target versions are:  " + StringUtils.join((Object[])migrateToLevels, (String)",") + ".");
            return 2;
        }
        try {
            char ch;
            DbInfo dbInfo = new DbInfo(DbAdmin.getThreadConnection(), ConfigMgr.get((String)"User.Database.tSchema"));
            Main.logln("");
            Main.logln("Database information detected...");
            Main.logln("Version:  " + dbInfo.getSchemaLevel());
            Main.logln("OS:  " + dbInfo.getProduct());
            Main.logln("");
            if (dbInfo.getSchemaLevel() < 310 && (ch = Main.prompt("Database appears to be at pre-v310 level.  Migration only supported for v310+.  Proceed with creating migration plan? {Y/N}", new char[]{'Y', 'N'})) != 'Y') {
                int n = 1;
                return n;
            }
            if (dbInfo.getSchemaLevel() == 0) {
                Main.logln("\nUnable to determine the current schema version of the database.");
                startVersion = Main.prompt("Please select from the following list of possible versions...", migrateFromLevels);
            } else {
                Main.logln("Database version appears to be at level v" + dbInfo.getSchemaLevel() + ".");
                startVersion = "v" + dbInfo.getSchemaLevel();
            }
            if (migratePlanDir.exists()) {
                int i;
                File[] oldFiles = migratePlanDir.listFiles();
                for (i = 0; i < oldFiles.length; ++i) {
                    oldFiles[i].delete();
                }
                if (!migratePlanDir.delete()) {
                    Main.logln("Could not delete the directory '" + migratePlanDir.getAbsolutePath() + "'.");
                    i = 2;
                    return i;
                }
            }
            migratePlanDir.mkdir();
            int startIndex = Arrays.binarySearch(dbLevels, startVersion);
            int targetIndex = Arrays.binarySearch(dbLevels, targetVersion);
            if (startIndex < 0 || targetIndex < 0) {
                Main.logln("Internal error occurred:  startIndex='" + startIndex + "', targetIndex='" + targetIndex + "'");
                int n = 2;
                return n;
            }
            if (targetIndex <= startIndex) {
                Main.logln("Target version '" + targetVersion + "' is less than or equal to the current database version '" + startVersion + "'.");
                Main.logln("No plan created.");
                int n = 0;
                return n;
            }
            Main.logln("\n----------------------------------------------------------------------\n Verifying current schema of database as 'v" + dbInfo.getSchemaLevel() + "'\n" + DIV2);
            int r = Main.verifyDbAtLevel("v" + dbInfo.getSchemaLevel());
            if (r == 1) {
                Main.logln("These differences could indicate custom changes made to the database.");
                Main.logln("These differences should be investigated before proceeding with the migration plan.");
                Main.promptToExit("Proceed with creating migration plan?", false);
            } else if (r == 2) {
                Main.promptToExit("Proceed with creating migration plan?", false);
            }
            Main.logln("\n----------------------------------------------------------------------\n Creating migration plan from current version '" + startVersion + "' to target version '" + targetVersion + "'.\n" + DIV2);
            for (int i = startIndex + 1; i <= targetIndex; ++i) {
                String v = dbLevels[i];
                Main.logln("Creating migration plan for version '" + v + "'");
                int x = Main.createPlanFile(dbUtilHome + "/migrate", ConfigMgr.get((String)"User.Utility.stagingDir") + "/migrate_plan", v);
                if (x == 0) continue;
                int n = x;
                return n;
            }
        }
        catch (Exception e) {
            Main.logException(e);
            Main.exit(2, null, true);
        }
        finally {
            DbAdmin.closeThreadConnection();
        }
        return 0;
    }

    private static int createPlanFile(String migrateDir, String planDir, String version) {
        String migrateFilePath = migrateDir + "/" + version + "/Migrate.xml";
        String testSuiteFilePath = migrateDir + "/" + version + "/TestSuite.xml";
        String planFilePath = planDir + File.separator + "Migrate_" + version + ".xml";
        if (!new File(migrateFilePath).exists()) {
            throw new RuntimeException("Could not locate file '" + migrateFilePath + "'");
        }
        boolean runTestSuites = ConfigMgr.getBoolean((String)"System.runTestSuites") && new File(testSuiteFilePath).exists();
        try {
            HashMap<String, String> m;
            int i;
            FileContents fc = new FileContents();
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            ArrayList taskAttrList = new ArrayList();
            ArrayList<String> taskBodyList = new ArrayList<String>();
            LinkedList tcSetupAttrList = new LinkedList();
            LinkedList<String> tcSetupBodyList = new LinkedList<String>();
            LinkedList tcTestAttrList = new LinkedList();
            LinkedList<String> tcTestBodyList = new LinkedList<String>();
            LinkedList tcCleanupAttrList = new LinkedList();
            LinkedList<String> tcCleanupBodyList = new LinkedList<String>();
            if (runTestSuites) {
                fc = Main.getResolvedXmlFileContents(testSuiteFilePath);
                Element testSuiteRoot = builder.parse(new InputSource(new StringReader(fc.getContents()))).getDocumentElement();
                NodeList testCaseList = testSuiteRoot.getElementsByTagName("TestCase");
                for (i = 0; i < testCaseList.getLength(); ++i) {
                    int j;
                    boolean ifBool;
                    Element testCaseElement = (Element)testCaseList.item(i);
                    String ifAttr = testCaseElement.getAttribute("if");
                    ifAttr = StringUtils.replace((String)ifAttr, (String)"AND", (String)"&&");
                    ifAttr = StringUtils.replace((String)ifAttr, (String)"OR", (String)"||");
                    boolean bl = ifBool = (ifAttr = varResolver.resolveString(ifAttr)).equals("") ? true : ExpressionSolver.solveBoolean((String)ifAttr);
                    if (!ifBool) continue;
                    NodeList nl = testCaseElement.getElementsByTagName("setup");
                    for (j = 0; j < nl.getLength(); ++j) {
                        m = new HashMap();
                        m.put("class", "Sql");
                        m.put("autocommit", "true");
                        m.put("desc", "TestCase Setup: " + testCaseElement.getAttribute("desc") + " [" + (j + 1) + " of " + nl.getLength() + "]");
                        tcSetupAttrList.add(m);
                        tcSetupBodyList.add(Main.getElementBody((Element)nl.item(j)));
                    }
                    nl = testCaseElement.getElementsByTagName("test");
                    for (j = 0; j < nl.getLength(); ++j) {
                        m = new HashMap();
                        m.put("class", "SqlValidate");
                        m.put("autocommit", "true");
                        m.put("desc", "TestCase Test: " + testCaseElement.getAttribute("desc") + " [" + (j + 1) + " of " + nl.getLength() + "]");
                        tcTestAttrList.add(m);
                        tcTestBodyList.add(Main.getElementBody((Element)nl.item(j)));
                    }
                    nl = testCaseElement.getElementsByTagName("cleanup");
                    for (j = 0; j < nl.getLength(); ++j) {
                        m = new HashMap();
                        m.put("class", "Sql");
                        m.put("autocommit", "true");
                        m.put("desc", "TestCase Cleanup: " + testCaseElement.getAttribute("desc") + " [" + (j + 1) + " of " + nl.getLength() + "]");
                        tcCleanupAttrList.add(m);
                        tcCleanupBodyList.add(Main.getElementBody((Element)nl.item(j)));
                    }
                }
            }
            fc = Main.getResolvedXmlFileContents(migrateFilePath);
            Element rootElement = builder.parse(new InputSource(new StringReader(fc.getContents()))).getDocumentElement();
            NodeList taskList = rootElement.getElementsByTagName("Task");
            for (i = 0; i < taskList.getLength(); ++i) {
                boolean ifBool;
                Element task = (Element)taskList.item(i);
                String taskBody = "";
                NodeList nl = task.getChildNodes();
                if (nl.getLength() > 0) {
                    taskBody = nl.item(0).getNodeValue();
                }
                String ifAttr = task.getAttribute("if");
                ifAttr = StringUtils.replace((String)ifAttr, (String)"AND", (String)"&&");
                ifAttr = StringUtils.replace((String)ifAttr, (String)"OR", (String)"||");
                boolean bl = ifBool = (ifAttr = varResolver.resolveString(ifAttr)).equals("") ? true : ExpressionSolver.solveBoolean((String)ifAttr);
                if (!ifBool) continue;
                m = new HashMap<String, String>();
                NamedNodeMap namedNodeMap = task.getAttributes();
                for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                    Node n = namedNodeMap.item(j);
                    String attrName = n.getNodeName();
                    String attrVal = n.getNodeValue();
                    if (attrName.equalsIgnoreCase("if")) continue;
                    m.put(attrName, attrVal);
                }
                taskAttrList.add(m);
                ITask iTask = Main.getITask(task.getAttribute("class"));
                if (iTask == null) {
                    Main.logln("Could not locate task implementation class: '" + task.getAttribute("class") + "'");
                    continue;
                }
                taskBodyList.add(iTask.getPlanTaskBody(taskBody, task.getAttributes()));
            }
            String s = fc.getContents();
            StringBuffer sb = new StringBuffer(s.length());
            int i1 = s.indexOf("<Task ");
            sb.append(s.substring(0, i1));
            LinkedList allAttrs = new LinkedList();
            allAttrs.addAll(tcSetupAttrList);
            allAttrs.addAll(taskAttrList);
            allAttrs.addAll(tcTestAttrList);
            allAttrs.addAll(tcCleanupAttrList);
            ArrayList<String> allBodies = new ArrayList<String>();
            allBodies.addAll(tcSetupBodyList);
            allBodies.addAll(taskBodyList);
            allBodies.addAll(tcTestBodyList);
            allBodies.addAll(tcCleanupBodyList);
            int step = 1;
            for (Map map : allAttrs) {
                String className = (String)map.get("class");
                String desc = (String)map.get("desc");
                String autoCommit = (String)map.get("autocommit");
                String level = (String)map.get("level");
                String outputfile = (String)map.get("outputfile");
                String includeheader = (String)map.get("includeheader");
                sb.append("\n\n    <Task step='" + version + "." + step + "' " + "class='" + className + "' " + (level == null ? "" : "level='" + level + "' ") + "desc='" + desc + "' " + (autoCommit == null ? "" : "autocommit='" + autoCommit + "' ") + (outputfile == null ? "" : "outputfile='" + outputfile + "' ") + (includeheader == null ? "" : "includeheader='" + includeheader + "' ") + ">");
                sb.append(((String)allBodies.get(step - 1)).replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
                sb.append("\n    </Task>");
                ++step;
            }
            sb.append("\n\n</TaskSequence>");
            fc.setContents(sb);
            fc.saveFile(planFilePath, LocaleMgr.getExternalDefaultEncoding());
        }
        catch (Exception e) {
            Main.logException(e);
            Main.logln("Error occurred while trying to create verification file for '" + planFilePath + "'");
            Main.logln(e.getMessage());
            return 2;
        }
        return 0;
    }

    private static ITask getITask(String className) {
        if (iTaskMap.get(className) == null) {
            try {
                Class<?> c = Class.forName("com.ibm.dmh.dbutil.tasks." + className);
                iTaskMap.put(className, (ITask)c.newInstance());
            }
            catch (Exception e) {
                Main.logException(e);
            }
        }
        return iTaskMap.get(className);
    }

    private static int runMigratePlan(String runSteps) {
        FileContents fc = new FileContents();
        SimpleDateFormat sdf = new SimpleDateFormat("hh:mm:ss a");
        File migratePlanDir = new File(ConfigMgr.get((String)"User.Utility.stagingDir") + "/migrate_plan");
        if (!migratePlanDir.exists() || migratePlanDir.listFiles().length == 0) {
            Main.logln("ERROR:  Directory '" + ConfigMgr.get((String)"User.Utility.stagingDir") + "/migrate_plan' was not found. ");
            Main.logln("You must run 'dbUtil -createMigratePlan' before using the '-runMigratePlan' option.");
            return 2;
        }
        Object[] planFiles = migratePlanDir.listFiles();
        Arrays.sort(planFiles);
        String startStep = "";
        String endStep = "";
        if (runSteps != null && !runSteps.equals("")) {
            String[] s = StringUtils.split((String)runSteps, (char)'-');
            startStep = s[0].trim();
            endStep = (s.length > 1 ? s[1] : s[0]).trim();
            boolean isBad = false;
            Main.logln("startStep='" + startStep + "', endStep='" + endStep + "', ");
            if (!(startStep.equals("") || startStep.matches("v\\d+\\.\\d+") && new File(migratePlanDir + "/Migrate_" + startStep.substring(0, startStep.indexOf(46)) + ".xml").exists())) {
                isBad = true;
            }
            if (!(endStep.equals("") || endStep.matches("v\\d+\\.\\d+") && new File(migratePlanDir + "/Migrate_" + endStep.substring(0, endStep.indexOf(46)) + ".xml").exists())) {
                isBad = true;
            }
            if (isBad) {
                Main.logln("Invalid steps specified.  Start and stop steps must be of the format v###.#.");
                return 2;
            }
        }
        try {
            for (int i = 0; i < planFiles.length; ++i) {
                Object planFile = planFiles[i];
                fc.readFile(((File)planFile).getAbsolutePath(), LocaleMgr.getExternalDefaultEncoding());
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Element rootElement = builder.parse(new InputSource(new StringReader(fc.getContents()))).getDocumentElement();
                String version = rootElement.getAttribute("version");
                if (!Main.fileIsInRunSteps(version, startStep, endStep)) {
                    Main.logln("Skipping plan file '" + ((File)planFile).getAbsolutePath() + "'.");
                    continue;
                }
                Main.logln("\n======================================================================\n Running plan file '" + ((File)planFile).getAbsolutePath() + "'\n" + DIV1);
                Main.logln("\n----------------------------------------------------------------------\n Getting initial counts for later comparison.\n----------------------------------------------------------------------");
                Map<String, Integer> beginCounts = Main.getDbCounts();
                String fileVersion = rootElement.getAttribute("version");
                NodeList taskList = rootElement.getElementsByTagName("Task");
                boolean lastStepWasSkipped = false;
                for (int j = 0; j < taskList.getLength(); ++j) {
                    int r;
                    String nextStepName;
                    String step;
                    Element task = (Element)taskList.item(j);
                    String taskBody = "";
                    NodeList nl = task.getChildNodes();
                    if (nl.getLength() > 0) {
                        taskBody = nl.item(0).getNodeValue();
                    }
                    if (!Main.stepIsInRunSteps(step = task.getAttribute("step"), startStep, endStep)) {
                        Main.logln("Skipping step '" + step + "'");
                        lastStepWasSkipped = true;
                        continue;
                    }
                    Main.logln("\n----------------------------------------------------------------------\n '" + step + "' - " + sdf.format(new Date()) + " \n " + task.getAttribute("desc") + "\n" + DIV2);
                    ITask iTask = Main.getITask(task.getAttribute("class"));
                    if (iTask == null) {
                        Main.logln("Could not locate task implementation class: '" + task.getAttribute("class") + "'");
                        return 2;
                    }
                    String stepName = task.getAttribute("step");
                    String string = nextStepName = taskList.getLength() == j + 1 ? null : ((Element)taskList.item(j + 1)).getAttribute("step");
                    if (nextStepName == null && i + 1 != planFiles.length) {
                        nextStepName = ((File)planFiles[i + 1]).getName().substring(8, 12) + ".1";
                    }
                    if ((r = iTask.run(taskBody, task.getAttributes(), stepName, nextStepName)) != 0) {
                        Main.promptToExit("Last task failed.", false);
                    }
                    lastStepWasSkipped = false;
                }
                if (lastStepWasSkipped) continue;
                Main.logln("\n----------------------------------------------------------------------\n Count differences (start -> end) for '" + fileVersion + "'\n" + DIV2);
                for (Map.Entry<String, Integer> e : Main.getDbCounts().entrySet()) {
                    int i2;
                    int i1;
                    String t = e.getKey();
                    if (!beginCounts.containsKey(t) || (i1 = beginCounts.get(t).intValue()) == (i2 = e.getValue().intValue())) continue;
                    Main.logln(String.format("%-18s: %8d --> %-8d", t, i1, i2));
                }
                Main.logln("\n----------------------------------------------------------------------\n Verifying current schema of database as '" + fileVersion + "'\n" + DIV2);
                int r = Main.verifyDbAtLevel(fileVersion);
                if (r == 1) {
                    Main.logln("These differences could indicate that a problem occurred.");
                    Main.logln("These differences should be investigated before proceeding with the migration.");
                    Main.promptToExit("Proceed with running migration?", false);
                    continue;
                }
                if (r != 2) continue;
                Main.promptToExit("Proceed with running migration?", false);
            }
        }
        catch (Exception e) {
            Main.logException(e);
            return 2;
        }
        for (String message : MigrateEndMessage.messages) {
            Main.logln(message);
        }
        return 0;
    }

    public static int verifyDbAtLevel(String level) {
        int v = Integer.parseInt(level.substring(1));
        String tSchema = ConfigMgr.get((String)"User.Database.tSchema");
        String os = ConfigMgr.get((String)"User.Database.os").equalsIgnoreCase("zOS") ? "zOS" : "UDB";
        boolean isDistEnabled = ConfigMgr.getBoolean((String)"User.Database.isDistEnabled");
        String xDist = isDistEnabled || v >= 600 ? "wDist" : "woDist";
        File f = new File(dbUtilHome + "/verify/" + level + "/Verify_" + os + "_" + xDist + ".xml");
        if (!f.exists()) {
            Main.logln("WARNING:  Unable to verify current version of database.  Could not find verify file '" + f.getAbsolutePath() + "'.");
            return 2;
        }
        try {
            DbMetaData dmd = new DbMetaData(DbAdmin.getThreadConnection(), ConfigMgr.get((String)"User.Database.tSchema"), "n/a");
            DbMetaData verifyDbMetaData = new DbMetaData(f, tSchema);
            String[] diffs = dmd.compareTo(verifyDbMetaData);
            if (diffs.length == 0) {
                Main.logln("Current database version verified.");
                return 0;
            }
            Main.logln("Comparison of current database schema with expected schema at this particular level showed " + diffs.length + " differences.");
            for (int i = 0; i < diffs.length; ++i) {
                Main.logln(i + 1 + ": " + diffs[i]);
            }
            return 1;
        }
        catch (Exception e) {
            Main.logException(e);
            return 2;
        }
    }

    private static boolean fileIsInRunSteps(String version, String startStep, String endStep) {
        int v = Integer.parseInt(version.substring(1));
        int ss = startStep.equals("") ? 0 : Integer.parseInt(startStep.substring(1, startStep.indexOf(46)));
        int es = endStep.equals("") ? 9999 : Integer.parseInt(endStep.substring(1, endStep.indexOf(46)));
        return v >= ss && v <= es;
    }

    private static boolean stepIsInRunSteps(String step, String startStep, String endStep) {
        int stepVer = Integer.parseInt(step.substring(1, step.indexOf(46)));
        int startVer = startStep.equals("") ? 0 : Integer.parseInt(startStep.substring(1, startStep.indexOf(46)));
        int endVer = endStep.equals("") ? 9999 : Integer.parseInt(endStep.substring(1, endStep.indexOf(46)));
        int stepNum = Integer.parseInt(step.substring(step.indexOf(46) + 1));
        int startNum = startStep.equals("") ? 0 : Integer.parseInt(startStep.substring(startStep.indexOf(46) + 1));
        int endNum = endStep.equals("") ? 99999 : Integer.parseInt(endStep.substring(endStep.indexOf(46) + 1));
        return (stepVer > startVer || stepVer == startVer && stepNum >= startNum) && (stepVer < endVer || stepVer == endVer && stepNum <= endNum);
    }

    private static Map<String, String> getArgMap(String[] args, int startIndex, String[] validArgs) {
        String s = StringUtils.join((Object[])Arrays.asList(args).subList(startIndex, args.length).toArray(new String[0]), (String)" ");
        Arrays.sort(validArgs);
        args = StringUtils.splitQuoted((String)s, (char)' ');
        HashMap<String, String> m = new HashMap<String, String>();
        String arg = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                arg = args[i].substring(1);
                if (Arrays.binarySearch(validArgs, arg) < 0) {
                    Main.printUsageAndExit("Invalid parameter specified:  '" + arg + "'");
                }
                m.put(arg, args[++i]);
            }
        }
        catch (IndexOutOfBoundsException e) {
            Main.printUsageAndExit("Value not specified for argument '" + arg + "'");
        }
        return m;
    }

    public static int executeSql(String sql, boolean verbose, boolean ignoreWarnings, boolean ignoreErrors) {
        try {
            if (verbose) {
                Main.logln(sql);
            }
            sql = sql.replaceAll("\n", " ");
            DbAdmin.update((CharSequence)sql, (Object[])new Object[0]);
            if (verbose) {
                Main.logln("STATUS:  OK\n");
            }
            return 0;
        }
        catch (Exception e) {
            if (!ignoreErrors) {
                if (!verbose) {
                    Main.logln(sql);
                }
                Main.logln("STATUS:  ERROR");
                Main.logln(e.getMessage());
                Main.promptToExit("Exception occurred while running the last command.", true);
            }
            return 2;
        }
    }

    public static int executeSqlValidate(String sql, String expectedResults, boolean verbose, boolean ignoreWarnings, boolean ignoreErrors) {
        DbResultSet rs = null;
        try {
            if (verbose) {
                Main.logln("Test query:  " + sql);
            }
            sql = sql.replaceAll("\n", "");
            rs = DbAdmin.query((CharSequence)sql, (Object[])new Object[0]);
            StringBuffer sb = new StringBuffer();
            int numCols = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                for (int i = 1; i <= numCols; ++i) {
                    sb.append(rs.getString(i).trim() + (i == numCols ? "" : ","));
                }
                sb.append("\n");
            }
            String results = sb.toString().trim();
            if (!expectedResults.equals(results)) {
                Main.logln("TEST FAILED!");
                Main.logln("--- Expected results -------------------------------------------------");
                Main.logln(expectedResults.replace(' ', '~'));
                Main.logln(DIV2);
                Main.logln("--- Actual results ---------------------------------------------------");
                Main.logln(results.replace(' ', '~'));
                Main.logln(DIV2);
                Main.promptToExit("Test failed.", true);
            }
            if (verbose) {
                Main.logln("STATUS:  OK\n");
            }
            return 0;
        }
        catch (Exception e) {
            if (!ignoreErrors) {
                if (!verbose) {
                    Main.logln(sql);
                }
                Main.logln("STATUS:  ERROR");
                Main.logln(e.getMessage());
                Main.promptToExit("Exception occurred while running the last command.", true);
            }
            return 2;
        }
    }

    private static FileContents getResolvedXmlFileContents(String path) throws Exception {
        FileContents fc = new FileContents();
        fc.readFile(path, LocaleMgr.getExternalDefaultEncoding());
        ResourceBundle rb = LocaleMgr.getBundleForFile((String)path, (Locale)LocaleMgr.getLocale((String)ConfigMgr.get((String)"User.Database.locale")));
        if (rb != null) {
            fc.insertVars("L", rb, true, true);
        } else {
            fc.insertVars("L", new Hashtable(), true, true);
        }
        fc.insertVars("C", (Map)ConfigMgr.getAllValues((boolean)true), true, false);
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Element rootElement = builder.parse(new InputSource(new StringReader(fc.getContents()))).getDocumentElement();
        NodeList varsList = rootElement.getElementsByTagName("Vars");
        if (varsList.getLength() > 0) {
            Hashtable<String, String> varTable = new Hashtable<String, String>();
            Element vars = (Element)varsList.item(0);
            NodeList x = vars.getElementsByTagName("Var");
            for (int i = 0; i < x.getLength(); ++i) {
                Element var = (Element)x.item(i);
                String value = var.getAttribute("value");
                String sql = var.getAttribute("sql");
                String defaultVal = var.hasAttribute("default") ? var.getAttribute("default") : null;
                varTable.put(var.getAttribute("name"), value == null || value.equals("") ? Main.runVarSql(sql, defaultVal) : value);
            }
            fc.insertVars("", varTable, true, false);
        }
        VarResolver vr = new VarResolver();
        vr.addVar("MB", (AbstractVar)new MathBoolVar(), null);
        vr.addVar("MF", (AbstractVar)new MathFloatVar(), null);
        vr.addVar("MI", (AbstractVar)new MathIntVar(), null);
        fc.insertVars(vr);
        fc.evaluateCommands();
        return fc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String runVarSql(String sql, String defaultVal) throws Exception {
        String string;
        sql = sql.replaceAll("\\$\\{tSchema\\}", ConfigMgr.get((String)"User.Database.tSchema"));
        Object st = null;
        Object rs = null;
        try {
            String s = DbAdmin.query((CharSequence)sql, (Object[])new Object[0]).toSingleString();
            if (s == null) {
                throw new Exception("The variable query [" + sql + "] returned null.  It likely needs to be modified to include a value() column function.");
            }
            string = s;
        }
        catch (Exception e) {
            String string2;
            try {
                if (defaultVal == null) {
                    Main.logln("Exception caught trying to run the following query: [" + sql + "]");
                    throw e;
                }
                string2 = defaultVal;
            }
            catch (Throwable throwable) {
                DbAdmin.close((Object[])new Object[]{rs, st});
                throw throwable;
            }
            DbAdmin.close((Object[])new Object[]{rs, st});
            return string2;
        }
        DbAdmin.close((Object[])new Object[]{rs, st});
        return string;
    }

    private static String getElementBody(Element e) {
        NodeList nl = e.getChildNodes();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nl.getLength(); ++i) {
            sb.append(nl.item(i).getNodeValue());
        }
        return sb.toString();
    }

    public static void log(String msg) {
        if (logFileWriter != null) {
            logFileWriter.print(msg);
        }
        System.out.print(msg);
    }

    public static void logln(String msg) {
        if (logFileWriter != null) {
            logFileWriter.println(msg);
            logFileWriter.flush();
        }
        System.out.println(msg);
    }

    public static void logException(Exception e) {
        if (logFileWriter != null) {
            e.printStackTrace(logFileWriter);
        }
        e.printStackTrace(System.out);
    }

    private static Map<String, Integer> getDbCounts() throws SQLException {
        TreeMap<String, Integer> m = new TreeMap<String, Integer>();
        DbMetaData dmd = new DbMetaData(DbAdmin.getThreadConnection(), DbAdmin.getSchemaName(), "");
        for (DbTable t : dmd.getTables()) {
            if (t.getType() != 'T') continue;
            m.put(t.getName(), DbAdmin.query((CharSequence)("select count(*) from $(SCHEMA)." + t.getName()), (Object[])new Object[0]).toSingleInt());
        }
        return m;
    }

    static {
        validOSes = new String[]{"zOS", "WINDOWS", "AIX"};
        varResolver = new VarResolver();
        varResolver.addVar("SchemaExists", (AbstractVar)new SchemaExistsVar(), null);
        varResolver.addVar("TableExists", (AbstractVar)new TableExistsVar(), null);
        varResolver.addVar("IndexExists", (AbstractVar)new IndexExistsVar(), null);
        varResolver.addVar("ColumnExists", (AbstractVar)new ColumnExistsVar(), null);
        varResolver.addVar("TriggerExists", (AbstractVar)new TriggerExistsVar(), null);
        iTaskMap = new HashMap<String, ITask>();
    }
}

