/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.dbutil.tasks.v420;

import com.ibm.dmh.cfgmgr.ConfigMgr;
import com.ibm.dmh.db.DbAdmin;
import com.ibm.dmh.dbutil.Main;
import com.ibm.dmh.dbutil.tasks.ITask;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PopulateDmhSpace
implements ITask {
    public static final String SPACE_TABLE_NAME = "DMH_SPACE";
    public static final String SPACE_ID = "SPACE_ID";
    public static final String SPACE_TYPE = "SPACE_TYPE";
    public static final String SPACE_DESC = "DESCRIPTION";
    public static final String WAR_TABLE_NAME = "DMH_WAR";
    public static final String EAR_TABLE_NAME = "DMH_EAR";
    public static final String URL_SPACE_COL_NAME = "URL_SPACE";
    public static final String TAGLIB_COL_NAME = "TAGLIB_SPACE";
    private static final int URL_SPACE_TYPE = 0;
    private static final int TAGLIB_SPACE_TYPE = 1;

    @Override
    public String getPlanTaskBody(String taskBody, NamedNodeMap attrs) {
        return taskBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int run(String taskBody, NamedNodeMap attrs, String stepName, String nextStepName) {
        int n;
        TreeSet<Short> allSpaces;
        int howMany;
        String selectQuery;
        PreparedStatement insertStatement;
        Statement selectStatement;
        Connection c;
        block5: {
            c = null;
            selectStatement = null;
            insertStatement = null;
            c = DbAdmin.getThreadConnection();
            selectQuery = null;
            howMany = 0;
            Main.logln("Running task [PopulateDmhSpace]...");
            selectStatement = c.createStatement();
            insertStatement = c.prepareStatement(this.getInsertCommand());
            allSpaces = new TreeSet<Short>();
            Main.logln("checking preconditions ...");
            if (this.isTableEmpty(selectStatement)) break block5;
            Main.logln("DMH_SPACE table is not empty. can't do migration");
            int n2 = 2;
            DbAdmin.close((Object[])new Object[]{selectStatement});
            DbAdmin.close((Object[])new Object[]{insertStatement});
            return n2;
        }
        try {
            Main.logln("DMH_SPACE table is empty.");
            Main.logln("populating URL_SPACE from DMH_EAR");
            selectQuery = this.generateSelectSql(EAR_TABLE_NAME, URL_SPACE_COL_NAME);
            howMany = this.populateValues(selectStatement, selectQuery, insertStatement, 0, allSpaces);
            Main.logln(howMany + " records were inserted\n");
            Main.logln("populating URL_SPACE from DMH_WAR");
            selectQuery = this.generateSelectSql(WAR_TABLE_NAME, URL_SPACE_COL_NAME);
            howMany = this.populateValues(selectStatement, selectQuery, insertStatement, 0, allSpaces);
            Main.logln(howMany + " records were inserted\n");
            Main.logln("populating TAGLIB_SPACE from DMH_WAR");
            selectQuery = this.generateSelectSql(WAR_TABLE_NAME, TAGLIB_COL_NAME);
            howMany = this.populateValues(selectStatement, selectQuery, insertStatement, 1, allSpaces);
            Main.logln(howMany + " records were inserted\n");
            Main.logln("done\n");
            c.commit();
            n = 0;
        }
        catch (SQLException e) {
            int n3;
            try {
                Main.logException(e);
                n3 = 2;
            }
            catch (Throwable throwable) {
                DbAdmin.close((Object[])new Object[]{selectStatement});
                DbAdmin.close((Object[])new Object[]{insertStatement});
                throw throwable;
            }
            DbAdmin.close((Object[])new Object[]{selectStatement});
            DbAdmin.close((Object[])new Object[]{insertStatement});
            return n3;
        }
        DbAdmin.close((Object[])new Object[]{selectStatement});
        DbAdmin.close((Object[])new Object[]{insertStatement});
        return n;
    }

    private boolean isTableEmpty(Statement pSelectStatement) throws SQLException {
        int count;
        boolean empty = false;
        String DMH = ConfigMgr.get((String)"User.Database.tSchema");
        String query = "select count(*) from " + DMH + "." + SPACE_TABLE_NAME;
        ResultSet res = pSelectStatement.executeQuery(query);
        if (res.next() && (count = res.getInt(1)) == 0) {
            empty = true;
        }
        return empty;
    }

    private String getInsertCommand() {
        String DMH = ConfigMgr.get((String)"User.Database.tSchema");
        StringBuffer command = new StringBuffer();
        command.append("INSERT INTO ");
        command.append(DMH);
        command.append(".");
        command.append(SPACE_TABLE_NAME);
        command.append(" ( ");
        command.append(SPACE_ID);
        command.append(" , ");
        command.append(SPACE_TYPE);
        command.append(" , ");
        command.append(SPACE_DESC);
        command.append(" ) VALUES ( ? , ? , ?) ");
        return command.toString();
    }

    private String generateSelectSql(String pTableName, String pColumnName) {
        String DMH = ConfigMgr.get((String)"User.Database.tSchema");
        StringBuffer query = new StringBuffer();
        query.append("SELECT DISTINCT ");
        query.append(pColumnName);
        query.append(" FROM ");
        query.append(DMH);
        query.append(".");
        query.append(pTableName);
        return query.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int populateValues(Statement pSelectStatement, String pSelectQuery, PreparedStatement pInsertStatement, int pType, Set<Short> pAllSpaces) throws SQLException {
        int howMany = 0;
        ResultSet result = null;
        try {
            result = pSelectStatement.executeQuery(pSelectQuery);
        }
        catch (SQLException e) {
            Main.logException(e);
            Main.logln(pSelectQuery);
            throw e;
        }
        try {
            while (result.next()) {
                short id = result.getShort(1);
                Short idObj = new Short(id);
                try {
                    if (!pAllSpaces.contains(idObj)) {
                        pInsertStatement.setShort(1, id);
                        pInsertStatement.setInt(2, pType);
                        pInsertStatement.setString(3, "");
                        pAllSpaces.add(idObj);
                        howMany += pInsertStatement.executeUpdate();
                        pInsertStatement.clearParameters();
                        pInsertStatement.clearWarnings();
                        continue;
                    }
                    Main.logln("the id " + id + " was already inserted into DMH_SPACE");
                }
                catch (SQLException e1) {
                    Main.logException(e1);
                    Main.logln("while inserting (" + id + " , " + pType + "," + "''" + ")");
                    throw e1;
                }
            }
            if (result == null) return howMany;
        }
        catch (SQLException e) {
            int n;
            try {
                Main.logException(e);
                Main.logln("while exeuting query " + pSelectQuery);
                n = 0;
                if (result == null) return n;
            }
            catch (Throwable throwable) {
                if (result == null) throw throwable;
                DbAdmin.close((Object[])new Object[]{result});
                throw throwable;
            }
            DbAdmin.close((Object[])new Object[]{result});
            return n;
        }
        DbAdmin.close((Object[])new Object[]{result});
        return howMany;
    }
}

