/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.dbutil.tasks.v420;

import com.ibm.dmh.db.DbAdmin;
import com.ibm.dmh.db.DbResultSet;
import com.ibm.dmh.db.SQLRuntimeException;
import com.ibm.dmh.dbutil.Main;
import com.ibm.dmh.dbutil.tasks.ITask;
import com.ibm.dmh.util.StringUtils;
import java.util.HashMap;
import org.w3c.dom.NamedNodeMap;

public class ScanRootUpdates
implements ITask {
    public String getPlanTaskBody(String taskBody, NamedNodeMap attrs) {
        return taskBody;
    }

    public int run(String taskBody, NamedNodeMap attrs, String stepName, String nextStepName) {
        DbResultSet rs = null;
        String sql = null;
        try {
            Main.logln("Running task [ScanRootUpdates]...");
            sql = "select A.CRAWL_ROOT_ID, C.FILESYSTEM_PATH, C.ACCESS, B.RESOURCE_NAME from $(SCHEMA).DMH_CRAWL_ROOT A, $(SCHEMA).DMH_RESOURCE_MNGR B, $(SCHEMA).DMH_CR_TEMP C where A.RESOURCE_MNGR_ID=B.RESOURCE_MNGR_ID and A.CRAWL_ROOT_ID=C.CRAWL_ROOT_ID";
            rs = DbAdmin.query((CharSequence)sql, (Object[])new Object[0]);
            while (rs.next()) {
                int srId = rs.getInt(1);
                String access = rs.getString(3).trim();
                String resourceName = rs.getString(4).trim();
                if (access.equals("")) continue;
                HashMap<String, String> m = new HashMap<String, String>();
                if (resourceName.equals("FileSystem")) {
                    m.put("path", access);
                } else if (resourceName.equals("ClearCase")) {
                    m.put("viewPath", access);
                } else if (resourceName.equals("WAS4AE") || resourceName.equals("WAS5")) {
                    m.put("reuseXMLConfig", "true");
                    m.put("adminNodeName", "unknown");
                    m.put("nameServiceNode", "unknown");
                    m.put("nameServicePort", "900");
                    m.put("wasHome", "%wasHome%");
                    m.put("javaHome", "%javaHome%");
                    m.put("wsExtDirs", "%javaHome%\\lib;%wasHome%\\classes;%wasHome%\\lib;%wasHome%\\lib\\ext;%wasHome%\\web\\help;%db2JdbcDriverJar%");
                    m.put("dbDriverPath", "%db2JdbcDriverJar%");
                    m.put("applArchives", "");
                } else if (resourceName.equals("Pvcs")) {
                    m.put("dbLocation", ScanRootUpdates.getToken(access, "-pr"));
                    m.put("projectName", ScanRootUpdates.getToken(access, "-pp"));
                    m.put("revisionLabel", ScanRootUpdates.getToken(access, "-r"));
                    String user = ScanRootUpdates.getToken(access, "-id");
                    String pw = "";
                    if (user.indexOf(58) != -1) {
                        pw = user.substring(user.indexOf(58) + 1);
                        user = user.substring(0, user.indexOf(58));
                    }
                    m.put("user", user);
                    m.put("pw", pw);
                } else if (resourceName.equals("CVSS")) {
                    String[] tokens = StringUtils.split((String)access, (char)'$');
                    if (tokens.length == 3) {
                        m.put("revision", tokens[2]);
                    }
                    m.put("module", tokens[1]);
                    tokens = StringUtils.split((String)tokens[0].substring(1), (char)':');
                    if (tokens.length < 4) {
                        Main.logln("CVSS path not valid: [" + access + "]\n");
                        m.put("serverType", "unknown");
                        m.put("hostname", "unknown");
                        m.put("port", "unknown");
                        m.put("user", "unknown");
                        m.put("pw", "unknown");
                        m.put("path", "unknown");
                    } else {
                        m.put("serverType", tokens[0]);
                        m.put("user", tokens[1]);
                        m.put("path", tokens[3]);
                        tokens = StringUtils.split((String)tokens[2], (char)'@');
                        if (tokens.length < 2) {
                            Main.logln("CVSS path not valid: [" + access + "]\n");
                            m.put("hostname", "unknown");
                            m.put("port", "unknown");
                            m.put("pw", "unknown");
                        } else {
                            m.put("pw", tokens[0]);
                            if (tokens[1].indexOf(35) == -1) {
                                m.put("hostname", tokens[1]);
                                m.put("port", "0");
                            } else {
                                tokens = StringUtils.split((String)tokens[1], (char)'#');
                                m.put("hostname", tokens[0]);
                                m.put("port", tokens[1]);
                            }
                        }
                    }
                }
                Main.executeSql("delete from $(SCHEMA).DMH_CRAWL_ROOT_DAT where CRAWL_ROOT_ID=" + srId, true, false, false);
                DbAdmin.commit();
                for (String field : m.keySet()) {
                    String value = (String)m.get(field);
                    Main.executeSql("insert into $(SCHEMA).DMH_CRAWL_ROOT_DAT (CRAWL_ROOT_ID, FIELD, IDX, DATA) values (" + srId + ", '" + field + "', 0, '" + value + "')", true, false, false);
                }
                DbAdmin.commit();
            }
            Main.executeSql("drop table $(SCHEMA).DMH_CR_TEMP", true, false, false);
            DbAdmin.commit();
            Main.logln("done\n");
            return 0;
        }
        catch (SQLRuntimeException e) {
            Main.logException((Exception)((Object)e));
            Main.logln("sql=" + sql + "");
            return 2;
        }
    }

    private static String getToken(String s, String tokenId) {
        int i = s.indexOf(tokenId);
        if (i == -1) {
            return "";
        }
        int j = s.indexOf(45, i + 1);
        if (j == -1) {
            j = s.length();
        }
        String val = s.substring(i + tokenId.length(), j);
        return val.trim();
    }
}

