/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh;

import com.ibm.dmh.util.StringUtils;
import com.ibm.jjson.JsonMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessExec {
    private boolean isConsoleLogging = false;
    private boolean isFinished;
    private boolean isLogging = false;
    private Exception exception;
    private int timeout;
    private long logLimit = Long.MAX_VALUE;
    private long consoleLogLimit = Long.MAX_VALUE;
    private Process p;
    private ProcessBuilder pb;
    private String input;
    private String submitPw = null;
    private StringBuffer log;
    private StringBuffer stderr = new StringBuffer();
    private StringBuffer stdout = new StringBuffer();
    private Map<String, String> envVars = new JsonMap();
    private int returnCode;

    public ProcessExec(String ... stringArray) {
        this.pb = new ProcessBuilder(stringArray);
    }

    public ProcessExec(List<String> list) {
        this.pb = new ProcessBuilder(list);
    }

    public ProcessExec setLocation(String string) {
        this.pb.directory(new File(string));
        return this;
    }

    public ProcessExec setEnvVar(String string, String string2) {
        this.envVars.put(string, string2);
        this.pb.environment().put(string, string2);
        return this;
    }

    public ProcessExec appendEnvVar(String string, String string2, String string3) {
        Map<String, String> map = this.pb.environment();
        for (String string4 : map.keySet()) {
            if (!string4.equalsIgnoreCase(string)) continue;
            string = string4;
        }
        String string5 = StringUtils.getString(map.get(string), "");
        map.put(string, (String)string5 + (string5.length() == 0 || string5.endsWith(string3) ? "" : string3) + string2);
        return this;
    }

    public Exception getException() {
        return this.exception;
    }

    public StringBuffer getLog() {
        return this.log;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setSubmitPw(String string) {
        this.submitPw = string;
    }

    public ProcessExec setTimeout(int n) {
        this.timeout = n;
        return this;
    }

    public ProcessExec setLogging(boolean bl) {
        return this.setLogging(bl, Long.MAX_VALUE);
    }

    public ProcessExec setLogging(boolean bl, long l) {
        this.isLogging = bl;
        this.logLimit = l;
        return this;
    }

    public ProcessExec setConsoleLogging(boolean bl) {
        return this.setConsoleLogging(bl, Long.MAX_VALUE);
    }

    public ProcessExec setConsoleLogging(boolean bl, long l) {
        this.isConsoleLogging = bl;
        this.consoleLogLimit = l;
        return this;
    }

    public ProcessExec setInput(String string) {
        this.input = string;
        return this;
    }

    private void log(String string) {
        if (this.isLogging) {
            this.log.append(string + "\n");
        }
        if (this.isConsoleLogging) {
            System.out.println(string + "\n");
        }
    }

    public int run() {
        this.returnCode = 0;
        try {
            if (this.isLogging) {
                this.log = new StringBuffer();
            }
            String string = StringUtils.join(this.pb.command().iterator(), " ");
            if (this.submitPw != null) {
                string = StringUtils.replace(string, this.submitPw, "********");
            }
            this.log("Starting command:  " + string);
            this.log("   From location:  " + (this.pb.directory() == null ? "not-specified" : this.pb.directory().getAbsolutePath()));
            this.log("    Timeout(sec):  " + this.timeout);
            this.log("        Env vars:  " + this.envVars.toString());
            if (this.isConsoleLogging) {
                System.out.println(this.log);
            }
            this.p = this.pb.start();
            ProcessWatcher processWatcher = null;
            if (this.timeout > 0) {
                processWatcher = new ProcessWatcher();
                processWatcher.start();
            }
            StreamWatcher streamWatcher = new StreamWatcher(1);
            StreamWatcher streamWatcher2 = new StreamWatcher(2);
            streamWatcher.start();
            streamWatcher2.start();
            if (this.input != null) {
                Thread.sleep(1000L);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.p.getOutputStream());
                outputStreamWriter.write(this.input);
                ((Writer)outputStreamWriter).flush();
                ((Writer)outputStreamWriter).close();
            }
            this.p.waitFor();
            if (streamWatcher.isAlive()) {
                streamWatcher.join(10000L);
            }
            if (streamWatcher2.isAlive()) {
                streamWatcher2.join(10000L);
            }
            this.isFinished = true;
            if (this.isLogging) {
                this.log("---STDOUT---");
                this.log(this.stdout.toString());
                this.log("---STDERR---");
                this.log(this.stderr.toString());
            }
            this.log("");
            if (this.timeout < 0) {
                throw new IOException("Command timed out.");
            }
            this.returnCode = this.p.exitValue();
        }
        catch (IOException iOException) {
            this.exception = iOException;
            this.returnCode = 1;
        }
        catch (InterruptedException interruptedException) {
            this.exception = interruptedException;
            this.returnCode = 2;
        }
        this.log("Return code:  " + this.returnCode);
        if (this.exception != null) {
            this.log("Exception:  " + this.exception.getLocalizedMessage());
        }
        return this.returnCode;
    }

    public ProcessExec exec() {
        this.run();
        return this;
    }

    public class StreamWatcher
    extends Thread {
        public StringBuffer buffer;
        public int type;

        public StreamWatcher(int n) {
            this.type = n;
            this.buffer = n == 1 ? ProcessExec.this.stdout : ProcessExec.this.stderr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            InputStreamReader inputStreamReader = new InputStreamReader(this.type == 1 ? ProcessExec.this.p.getInputStream() : ProcessExec.this.p.getErrorStream());
            try {
                int n;
                while ((n = ((Reader)inputStreamReader).read()) != -1) {
                    if (ProcessExec.this.timeout < 0) {
                        System.err.println("Stream watcher thread timed out!");
                        break;
                    }
                    if (ProcessExec.this.isLogging && ProcessExec.this.logLimit-- > 0L) {
                        this.buffer.append((char)n);
                    }
                    if (!ProcessExec.this.isConsoleLogging || ProcessExec.this.consoleLogLimit-- <= 0L) continue;
                    System.out.print((char)n);
                }
            }
            catch (Exception exception) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10000);
                exception.printStackTrace(new PrintStream(byteArrayOutputStream));
                this.buffer.append(byteArrayOutputStream.toString());
            }
            finally {
                try {
                    ((Reader)inputStreamReader).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public class ProcessWatcher
    extends Thread {
        public void run() {
            block3: {
                do {
                    try {
                        ProcessWatcher.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ProcessExec.this.timeout--;
                    if (ProcessExec.this.isFinished) break block3;
                } while (ProcessExec.this.timeout >= 0);
                System.err.println("Process watcher thread timed out!  Will destroy process.");
                ProcessExec.this.p.destroy();
            }
        }
    }
}

