/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.analyzers.utils;

import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTypeClassification {
    private Map<Integer, String> attcList = null;
    private Map<Integer, Integer> attnList = null;
    private Map<Integer, Set> inclList = null;
    private final String FILE_TYPE_CD_DBD = "DBD";
    private final String FILE_TYPE_CD_INCL = "INCL";
    private final String FILE_TYPE_CD_MAC = "MAC";
    private final String FILE_TYPE_CD_MAIN = "MAIN";
    private final String FILE_TYPE_CD_MAP = "MAP";
    private final String FILE_TYPE_CD_MFS = "MFS";
    private final String FILE_TYPE_CD_PROC = "PROC";
    private final String FILE_TYPE_CD_PSB = "PSB";
    private final String FILE_TYPE_CD_UNKNOWN = "UNKN";

    public FileTypeClassification(Map<Integer, String> map, Map<Integer, Integer> map2, Map<Integer, Set> map3) {
        this.attcList = map;
        this.attnList = map2;
        this.inclList = map3;
    }

    private String checkAsmFileTypeCd() {
        if (this.attnList.containsKey(39) && this.attnList.get(39) != 0) {
            return "MAC";
        }
        if (this.attnList.containsKey(65)) {
            return "MAP";
        }
        if (this.attnList.containsKey(87)) {
            return "MFS";
        }
        if (this.fileContainsEntry()) {
            return "MAIN";
        }
        if (this.inclList.containsKey(8)) {
            if (this.inclList.get(8).contains("DBDGEN")) {
                return "DBD";
            }
            if (this.inclList.get(8).contains("PSBGEN")) {
                return "PSB";
            }
        }
        return "INCL";
    }

    private String classifyAsm() {
        boolean bl = false;
        String string = this.checkAsmFileTypeCd();
        if (!string.equals("INCL")) {
            return string;
        }
        bl = this.doIncludedFilesContainEntry();
        if (bl) {
            return "MAIN";
        }
        return "INCL";
    }

    private String classifyCobol() {
        if (this.attnList.containsKey(34)) {
            return "MAIN";
        }
        return "INCL";
    }

    private String classifyJcl() {
        if (this.attnList.containsKey(39) && this.attnList.get(39) != 0) {
            return "PROC";
        }
        if (this.attnList.containsKey(52)) {
            return "MAIN";
        }
        return "INCL";
    }

    private String classifyPli() {
        if (this.attcList.containsKey(56) && this.attcList.get(56).equals("MAIN")) {
            return "MAIN";
        }
        if (this.attnList.containsKey(37)) {
            return "MAIN";
        }
        return "INCL";
    }

    private boolean doIncludedFilesContainEntry() {
        boolean bl = false;
        return bl;
    }

    private boolean fileContainsEntry() {
        if (this.attnList.containsKey(46) || this.attnList.containsKey(57) || this.attnList.containsKey(47) || this.attnList.containsKey(82) || this.attnList.containsKey(84) || this.attnList.containsKey(85) || this.attnList.containsKey(86)) {
            return true;
        }
        return this.inclList.containsKey(8) && this.inclList.get(8).contains("DFHEIENT");
    }

    public String identifyFileType(String string) {
        if (string.equals("ASM")) {
            return this.classifyAsm();
        }
        if (string.equals("COB")) {
            return this.classifyCobol();
        }
        if (string.equals("JCL")) {
            return this.classifyJcl();
        }
        if (string.equals("PLI")) {
            return this.classifyPli();
        }
        return "UNKN";
    }
}

