/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.msg;

import com.ibm.dmh.msg.WsaaMessageGeneric;
import com.ibm.dmh.msg.WsaaMessageText;
import com.ibm.dmh.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsaaMessage
extends LogRecord {
    private final WsaaMessageGeneric msg;
    private final Map<String, String> vars;
    public static final int INFORMATION_STATUS = 0;
    public static final int WARNING_STATUS = 1;
    public static final int ERROR_STATUS = 2;
    public static final int SEVERE_STATUS = 3;

    public WsaaMessage(WsaaMessageGeneric wsaaMessageGeneric, Map<String, String> map) {
        super(wsaaMessageGeneric.getSeverity(), "");
        this.msg = wsaaMessageGeneric;
        this.vars = map;
        this.setMessage(this.toTextString());
    }

    public WsaaMessage(WsaaMessageGeneric wsaaMessageGeneric, String[] stringArray, String[] stringArray2) {
        super(wsaaMessageGeneric.getSeverity(), "");
        this.msg = wsaaMessageGeneric;
        this.vars = new HashMap<String, String>();
        int n = Math.min(stringArray.length, stringArray2.length);
        for (int i = 0; i < n; ++i) {
            this.vars.put(stringArray[i], stringArray2[i]);
        }
        this.setMessage(this.toTextString());
    }

    public WsaaMessageText getExplanation() {
        return new WsaaMessageText(this.msg.getExplanation(), this.vars);
    }

    public WsaaMessageText getIdentifier() {
        return new WsaaMessageText(this.msg.getIdentifier(), this.vars);
    }

    public WsaaMessageText getSystemAction() {
        return new WsaaMessageText(this.msg.getSystemAction(), this.vars);
    }

    public WsaaMessageText getModule() {
        return new WsaaMessageText(this.msg.getModule(), this.vars);
    }

    public WsaaMessageText getTitle() {
        return new WsaaMessageText(this.msg.getTitle(), this.vars);
    }

    public WsaaMessageText getUserResponse() {
        return new WsaaMessageText(this.msg.getUserResponse(), this.vars);
    }

    public Level getSeverity() {
        return this.msg.getSeverity();
    }

    public String toTextString() {
        return this.getIdentifier().getText() + ": " + this.getTitle().getText();
    }

    public String toHtmlString() {
        return this.getIdentifier().getText() + ": " + this.getTitle().getHtml();
    }

    public String toString() {
        return this.toTextString();
    }

    public int getMessageNumber() {
        String string = this.getIdentifier().getText();
        int n = "DMH".length();
        String string2 = string.substring(n, n + "0000".length());
        return Integer.parseInt(string2);
    }

    public boolean equals(Object object) {
        if (object instanceof WsaaMessage) {
            return this.toTextString().equals(((WsaaMessage)object).toTextString());
        }
        return false;
    }

    public int hashCode() {
        return this.toTextString().hashCode();
    }

    public String getVarKeys() {
        return StringUtils.join(this.vars.keySet().iterator(), ',', true);
    }

    public String getVarValues() {
        return StringUtils.join(this.vars.values().iterator(), ',', true);
    }
}

