/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.qp;

import com.ibm.dmh.log.LoggerManager;
import com.ibm.dmh.qp.WorkFlag;
import com.ibm.dmh.qp.WorkListener;
import com.ibm.dmh.qp.WorkProcessor;
import com.ibm.dmh.qp.WorkRules;
import com.ibm.dmh.qp.WorkStatus;
import com.ibm.jjson.beans.annotation.Bean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Bean(properties={"workName", "workId", "workRules", "submitUser", "status", "cancelFlag", "updateTimestamp", "startTime", "endTime", "elapsedTime", "description", "currentActivity", "totalWork", "currentWork", "percentComplete", "messages", "warnings", "exceptions"})
public abstract class AbstractWork
implements Runnable,
Serializable,
Cloneable {
    String workName;
    transient WorkRules workRules;
    protected String submitUser;
    protected String submitPw;
    int workId;
    protected WorkStatus status;
    protected WorkFlag cancelFlag;
    transient WorkListener workListener;
    Date updateTimestamp;
    public Date startTime;
    public Date endTime;
    String description;
    String currentActivity;
    int totalWork;
    int currentWork;
    private SortedMap<String, WorkFlag> workFlags = Collections.synchronizedSortedMap(new TreeMap());
    private List<String> messages = Collections.synchronizedList(new LinkedList());
    private List<String> warnings = Collections.synchronizedList(new LinkedList());
    private List<Throwable> exceptions = Collections.synchronizedList(new LinkedList());

    @Override
    public abstract void run();

    public void release() {
    }

    public void delete() {
    }

    public void workStatusChanged(WorkStatus workStatus) {
    }

    void setWorkManagerFields(String string, String string2, String string3, WorkRules workRules, WorkStatus workStatus, boolean bl, WorkListener workListener) {
        this.workRules = workRules;
        this.workName = string;
        this.status = workStatus;
        this.cancelFlag = new WorkFlag("isCancelled", bl);
        this.workListener = workListener;
        this.submitUser = string2;
        this.submitPw = string3;
    }

    void changeStatus(WorkStatus workStatus) {
        this.getLogger().fine("Changing status on work item [" + this.workId + "] to [" + (Object)((Object)workStatus) + "]");
        this.status = workStatus;
        this.updateTimestamp = new Date();
        WorkListener workListener = this.workListener;
        switch (workStatus) {
            case STARTED: {
                this.startTime = new Date();
                break;
            }
            case COMPLETED: 
            case FAILED: {
                this.endTime = new Date();
            }
        }
        this.workStatusChanged(workStatus);
        if (workListener != null) {
            workListener.workStatusChanged(workStatus, this);
        }
        if (workStatus.isInState(this.workRules.deleteIfStateIn)) {
            WorkProcessor.deleteWorkItem(this.workId);
        }
    }

    public WorkFlag getCancelFlag() {
        return this.cancelFlag;
    }

    protected WorkFlag getFlag(String string) {
        return (WorkFlag)this.workFlags.get(string);
    }

    protected void createFlag(String string, boolean bl) {
        this.workFlags.put(string, new WorkFlag(string, string, bl));
    }

    public WorkFlag[] getFlags() {
        return this.workFlags.values().toArray(new WorkFlag[this.workFlags.size()]);
    }

    public void addMessage(String string) {
        this.messages.add(string);
    }

    public String[] getMessages() {
        return this.messages.toArray(new String[this.messages.size()]);
    }

    public void addWarning(String string) {
        this.warnings.add(string);
    }

    public void addException(Throwable throwable) {
        this.getLogger().log(Level.WARNING, throwable.getLocalizedMessage(), throwable);
        this.exceptions.add(throwable);
    }

    public Throwable[] getExceptions() {
        return this.exceptions.toArray(new Throwable[this.exceptions.size()]);
    }

    public String[] getWarnings() {
        return this.warnings.toArray(new String[this.warnings.size()]);
    }

    public List<String> getErrors() {
        ArrayList<String> arrayList = new ArrayList<String>(this.exceptions.size());
        for (Throwable throwable : this.exceptions) {
            arrayList.add(throwable.getMessage());
        }
        return arrayList;
    }

    public void markAborted() {
        this.changeStatus(WorkStatus.ABORTED);
    }

    public WorkStatus getStatus() {
        return this.status;
    }

    public boolean isInState(WorkStatus ... workStatusArray) {
        return this.status.isInState(workStatusArray);
    }

    public int getWorkId() {
        return this.workId;
    }

    public Date deleteAfter() {
        if (this.status.isInState(WorkStatus.COMPLETED, WorkStatus.FAILED, WorkStatus.REJECTED, WorkStatus.ABORTED, WorkStatus.INDETERMINATE)) {
            if (this.cancelFlag.isSet() && this.workRules.deleteIfCancelled) {
                return new Date();
            }
            if (this.workRules.deleteAfter != Long.MAX_VALUE) {
                return new Date(this.workRules.deleteAfter + this.updateTimestamp.getTime());
            }
        }
        return null;
    }

    protected void setCurrentActivity(String string) {
        this.currentActivity = string;
        if (WorkProcessor.logger.isLoggable(Level.FINER)) {
            WorkProcessor.logger.log(Level.FINER, "[QP:" + this.workName + "]-" + string);
        }
    }

    public String getCurrentActivity() {
        return this.currentActivity;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUrlInfo() {
        return "$X{RealUrl}";
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    public String getSubmitUser() {
        return this.submitUser;
    }

    public String getSubmitPw() {
        return this.submitPw;
    }

    public String getWorkName() {
        return this.workName;
    }

    public WorkRules getWorkRules() {
        return this.workRules;
    }

    public Logger getLogger() {
        if (this.workRules != null) {
            return this.workRules.logger;
        }
        return LoggerManager.getMainLogger();
    }

    public void setTotalWork(int n) {
        this.totalWork = n;
    }

    public void addTotalWork(int n) {
        this.totalWork += n;
    }

    public int getTotalWork() {
        return this.totalWork;
    }

    public void setCurrentWork(int n) {
        this.currentWork = n;
    }

    public void addCurrentWork(int n) {
        this.currentWork += n;
    }

    public int getCurrentWork() {
        return this.currentWork;
    }

    public int getPercentComplete() {
        if (this.isInState(WorkStatus.COMPLETED)) {
            return 100;
        }
        return this.currentWork == 0 ? 0 : this.currentWork * 100 / this.totalWork;
    }

    public int getElapsedTime() {
        if (this.startTime == null) {
            return 0;
        }
        if (this.endTime == null) {
            return (int)(new Date().getTime() - this.startTime.getTime());
        }
        return (int)(this.endTime.getTime() - this.startTime.getTime());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

