/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.qp;

import com.ibm.dmh.qp.AbstractWork;
import com.ibm.dmh.qp.IWorkManager;
import com.ibm.dmh.qp.WorkCancelledException;
import com.ibm.dmh.qp.WorkException;
import com.ibm.dmh.qp.WorkStatus;
import com.ibm.websphere.asynchbeans.Work;
import com.ibm.websphere.asynchbeans.WorkEvent;
import com.ibm.websphere.asynchbeans.WorkListener;
import com.ibm.websphere.asynchbeans.WorkManager;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class AsynchBeanWorkManager
implements IWorkManager {
    private WorkManager abWorkManager;

    public AsynchBeanWorkManager(String string) throws WorkException {
        try {
            InitialContext initialContext = new InitialContext();
            try {
                this.abWorkManager = (WorkManager)initialContext.lookup(string);
            }
            catch (Exception exception) {
                throw new WorkException("WSAA:  Couldn't find [" + string + "].");
            }
        }
        catch (NamingException namingException) {
            throw new WorkException(namingException);
        }
    }

    public void startWork(AbstractWork abstractWork) throws WorkException {
        try {
            ABWorkWrapper aBWorkWrapper = new ABWorkWrapper(abstractWork);
            this.abWorkManager.startWork((Work)aBWorkWrapper, Long.MAX_VALUE, (WorkListener)aBWorkWrapper);
        }
        catch (com.ibm.websphere.asynchbeans.WorkException workException) {
            workException.printStackTrace(System.err);
            throw new WorkException((Exception)((Object)workException));
        }
    }

    public void remove(AbstractWork abstractWork) {
        if (abstractWork.status != WorkStatus.STARTED) {
            abstractWork.changeStatus(WorkStatus.REJECTED);
        }
    }

    public void shutdown() {
    }

    public boolean awaitTermination() {
        return false;
    }

    private class ABWorkWrapper
    implements Work,
    WorkListener {
        private AbstractWork w;

        public ABWorkWrapper(AbstractWork abstractWork) {
            this.w = abstractWork;
        }

        public void release() {
            try {
                this.w.release();
            }
            catch (Throwable throwable) {
                this.w.addException(throwable);
            }
        }

        public void run() {
            try {
                if (this.w.status != WorkStatus.REJECTED) {
                    this.w.run();
                }
            }
            catch (WorkCancelledException workCancelledException) {
                this.w.changeStatus(WorkStatus.ABORTED);
            }
            catch (Throwable throwable) {
                this.w.addException(throwable);
            }
        }

        public void workAccepted(WorkEvent workEvent) {
            this.w.changeStatus(WorkStatus.ACCEPTED);
        }

        public void workRejected(WorkEvent workEvent) {
            this.w.changeStatus(WorkStatus.REJECTED);
        }

        public void workStarted(WorkEvent workEvent) {
            if (this.w.status != WorkStatus.REJECTED) {
                this.w.changeStatus(WorkStatus.STARTED);
            }
        }

        public void workCompleted(WorkEvent workEvent) {
            if (workEvent.getException() != null) {
                this.w.addException((Throwable)workEvent.getException());
            }
            if (!this.w.isInState(WorkStatus.ABORTED, WorkStatus.REJECTED, WorkStatus.FAILED)) {
                this.w.changeStatus(this.w.getExceptions().length == 0 ? WorkStatus.COMPLETED : WorkStatus.FAILED);
            }
        }
    }
}

