/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

import com.ibm.dmh.db.DbAdmin;
import com.ibm.dmh.log.LoggerManager;
import com.ibm.dmh.msg.WsaaException;
import com.ibm.dmh.util.StringUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DbInfo {
    private Vendor vendor;
    private Product product;
    private int versionMajor;
    private int versionMinor;
    private int schemaLevel;
    public static int SUPPORT_GET_GENERATED_KEYS = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbInfo(Connection connection, String string) throws SQLException, WsaaException {
        ResultSet resultSet;
        Statement statement;
        block13: {
            statement = null;
            resultSet = null;
            this.vendor = Vendor.IBM;
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                resultSet = databaseMetaData.getTables(null, "SYSIBM", "SYSDATABASE", null);
                this.product = resultSet.next() ? Product.DB2_ZOS : Product.DB2_LUW;
                resultSet.close();
                try {
                    this.versionMajor = databaseMetaData.getDatabaseMajorVersion();
                    this.versionMinor = databaseMetaData.getDatabaseMinorVersion();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (this.versionMajor == 0) {
                    String string2 = databaseMetaData.getDatabaseProductVersion();
                    Pattern pattern = Pattern.compile("DSN(\\d{2})(\\d{2})(\\d+)");
                    Pattern pattern2 = Pattern.compile("(\\d{2})\\.(\\d{2})\\.(\\d{4})");
                    Matcher matcher = pattern.matcher(string2);
                    if (matcher.matches()) {
                        this.versionMajor = StringUtils.getInt((String)matcher.group(1), (int)0);
                        this.versionMinor = StringUtils.getInt((String)matcher.group(2), (int)0);
                    } else {
                        matcher = pattern2.matcher(string2);
                        if (matcher.matches()) {
                            this.versionMajor = StringUtils.getInt((String)matcher.group(1), (int)0);
                            this.versionMinor = StringUtils.getInt((String)matcher.group(2), (int)0);
                        }
                    }
                }
                if (this.versionMajor == 0) {
                    this.versionMajor = 8;
                }
            }
            catch (Throwable throwable) {
                DbAdmin.close(resultSet);
                throw throwable;
            }
            DbAdmin.close(resultSet);
            LoggerManager.getMainLogger().log(Level.INFO, "Database os detected as vendor=[" + (Object)((Object)this.vendor) + "], os=[" + (Object)((Object)this.product) + "], version=[" + this.versionMajor + "." + this.versionMinor + "]");
            this.schemaLevel = 0;
            try {
                statement = connection.createStatement();
                resultSet = statement.executeQuery("select SYS_INT_ATTR from " + string + ".DMH_SYSTEM_ATTR where SYS_ATTR_ID=500");
                if (!resultSet.next()) break block13;
                this.schemaLevel = resultSet.getInt(1);
            }
            catch (SQLException sQLException) {
                try {
                    LoggerManager.getMainLogger().log(Level.WARNING, "Could not query " + string + ".DMH_SYSTEM_ATTR", sQLException);
                }
                catch (Throwable throwable) {
                    DbAdmin.close(statement, resultSet);
                    throw throwable;
                }
                DbAdmin.close(statement, resultSet);
            }
        }
        DbAdmin.close(statement, resultSet);
    }

    public static boolean checkSupportFor(int n) throws SQLException {
        if (n == SUPPORT_GET_GENERATED_KEYS) {
            Connection connection = DbAdmin.getThreadConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try {
                databaseMetaData.getClass().getMethod("supportsGetGeneratedKeys", null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
                return false;
            }
            return databaseMetaData.supportsGetGeneratedKeys();
        }
        return false;
    }

    public Vendor getVendor() {
        return this.vendor;
    }

    public Product getProduct() {
        return this.product;
    }

    public int getVersionMajor() {
        return this.versionMajor;
    }

    public int getVersionMinor() {
        return this.versionMinor;
    }

    public int getSchemaLevel() {
        return this.schemaLevel;
    }

    public boolean isDb2Zos() {
        return this.product == Product.DB2_ZOS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Product {
        DB2_LUW,
        DB2_ZOS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Vendor {
        IBM;

    }
}

