/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.db;

import com.ibm.dmh.ProcessExec;
import com.ibm.dmh.cfgmgr.ConfigMgr;
import com.ibm.dmh.db.DbAdmin;
import com.ibm.dmh.db.DbFlags;
import com.ibm.dmh.db.DbPreparedStatement;
import com.ibm.dmh.db.SQLRuntimeException;
import com.ibm.dmh.log.LoggerManager;
import com.ibm.dmh.util.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DbLoadStatement
extends DbPreparedStatement {
    private String table;
    private File loadFile;
    private BufferedWriter loadFileOut;
    private String[] columns;
    private int counter = 0;
    Logger logger = LoggerManager.getMainLogger();

    protected DbLoadStatement(int n, String string, String ... stringArray) throws IOException {
        this.flags = n;
        this.table = string;
        if (stringArray.length == 0) {
            stringArray = DbAdmin.getMetaData().getTable(string).getColumnNames();
        }
        this.columns = stringArray;
    }

    public DbLoadStatement addBatch(Object ... objectArray) throws SQLRuntimeException {
        try {
            if (this.loadFile == null) {
                this.loadFile = new File(ConfigMgr.get((String)"Common.tempDir") + "/" + this.table + "_" + System.currentTimeMillis() + ".ddl");
                this.loadFileOut = new BufferedWriter(new FileWriter(this.loadFile));
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (i != 0) {
                    this.loadFileOut.append(',');
                }
                this.loadFileOut.append(objectArray[i].toString());
            }
            this.loadFileOut.append("\n");
        }
        catch (IOException iOException) {
            throw new SQLRuntimeException(iOException.getLocalizedMessage());
        }
        ++this.counter;
        return this;
    }

    public DbPreparedStatement setAutoBatchExecuteSize(int n, int n2) {
        return this;
    }

    public DbPreparedStatement executeBatch() throws SQLRuntimeException {
        this.runLoad();
        return this;
    }

    public DbPreparedStatement executeBatch(boolean bl) throws SQLRuntimeException {
        this.runLoad();
        return this;
    }

    public void close() throws SQLRuntimeException {
    }

    private void runLoad() throws SQLRuntimeException {
        if (this.loadFile == null) {
            this.logger.log(Level.WARNING, "No rows found in load statement for table [" + this.table + "].  Load will be skipped.");
            return;
        }
        try {
            this.loadFileOut.flush();
            this.loadFileOut.close();
            this.load(this.loadFile);
            this.loadFile = null;
        }
        catch (IOException iOException) {
            throw new SQLRuntimeException(iOException.getLocalizedMessage());
        }
    }

    protected void load(File file) throws SQLRuntimeException {
        String string = DbAdmin.getSchemaName();
        boolean bl = DbFlags.isVerbose(this.flags);
        File file2 = new File(ConfigMgr.get((String)"Common.tempDir") + "/load.ddl");
        try {
            if (bl) {
                this.logger.log(Level.INFO, "Loading file [" + file.getCanonicalPath() + "] into table [" + this.table + "]");
            }
            long l = System.currentTimeMillis();
            FileWriter fileWriter = new FileWriter(file2);
            String string2 = DbAdmin.getThreadUser();
            String string3 = DbAdmin.getThreadPw();
            DbAdmin.commit();
            fileWriter.write("CONNECT TO " + ConfigMgr.get((String)"Common.Database.name") + (string2.equals("") ? "" : " user " + string2) + (string3.equals("") ? "" : " using " + string3) + ";\n");
            fileWriter.write("LOCK TABLE " + string + "." + this.table + " IN EXCLUSIVE MODE;\n");
            fileWriter.write("LOAD FROM \"" + file.getCanonicalPath() + "\" OF DEL INSERT INTO " + string + "." + this.table + " (" + StringUtils.join((Object[])this.columns, (String)",") + ");\n");
            fileWriter.write("COMMIT;\n");
            fileWriter.write("CONNECT RESET;\n");
            fileWriter.close();
            ProcessExec processExec = new ProcessExec(new String[]{"db2cmd", "/i", "/c", "/w", "db2", "-vtf", "load.ddl"}).setLocation(ConfigMgr.get((String)"Common.tempDir")).setLogging(bl).appendEnvVar("PATH", new File(ConfigMgr.get((String)"Common.PrereqPaths.db2Home") + "/bin").getPath(), ";").exec();
            int n = processExec.getReturnCode();
            if (n != 0) {
                this.logger.log(Level.WARNING, "Command output \n------START------\n," + processExec.getLog().toString() + "\n------END------\n");
            }
            if (bl) {
                this.logger.log(Level.INFO, "LOAD command finished with return code [" + n + "] in [" + (System.currentTimeMillis() - l) + "ms]");
            }
        }
        catch (IOException iOException) {
            throw new SQLRuntimeException(iOException.getLocalizedMessage());
        }
    }
}

