/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsaa.util;

import com.ibm.wsaa.util.StringUtils;

public class ObjectUtils {
    public static boolean toBoolean(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return StringUtils.getBoolean((String)object);
        }
        if (object != null) {
            return StringUtils.getBoolean(object.toString());
        }
        throw new RuntimeException("Null passed to ObjectUtils.toBoolean()");
    }

    public static boolean toBoolean(Object object, boolean bl) {
        if (object == null) {
            return bl;
        }
        return ObjectUtils.toBoolean(object);
    }

    public static int toInt(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String && StringUtils.isNumeric((String)object)) {
            return StringUtils.getInt((String)object, 0);
        }
        throw new RuntimeException("Null or non-number passed to ObjectUtils.toInt().  o.class=[" + object.getClass().getName() + "], o.value=[" + object + "]");
    }

    public static int toInt(Object object, int n) {
        if (object == null) {
            return n;
        }
        return ObjectUtils.toInt(object);
    }

    public static String toString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object != null) {
            return object.toString();
        }
        throw new RuntimeException("Null passed to ObjectUtils.toString()");
    }

    public static String toString(Object object, String string) {
        if (object == null) {
            return string;
        }
        return ObjectUtils.toString(object);
    }

    public static boolean[] toBooleanArray(Object[] objectArray) {
        boolean[] blArray = new boolean[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            blArray[n] = ObjectUtils.toBoolean(objectArray[n]);
            ++n;
        }
        return blArray;
    }

    public static int[] toIntArray(Object[] objectArray) {
        int[] nArray = new int[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            nArray[n] = ObjectUtils.toInt(objectArray[n]);
            ++n;
        }
        return nArray;
    }

    public static String[] toStringArray(Object[] objectArray) {
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            stringArray[n] = ObjectUtils.toString(objectArray[n]);
            ++n;
        }
        return stringArray;
    }
}

