/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dmh.dbutil.tasks;

import com.ibm.dmh.db.DbAdmin;
import com.ibm.dmh.dbutil.Main;
import com.ibm.dmh.dbutil.tasks.ITask;
import com.ibm.wsaa.util.FileContents;
import com.ibm.wsaa.util.LocaleMgr;
import com.ibm.wsaa.util.StringUtils;
import java.io.File;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.regex.Pattern;
import org.w3c.dom.NamedNodeMap;

public class SqlOutputFile
implements ITask {
    public String getPlanTaskBody(String taskBody, NamedNodeMap attrs) {
        taskBody = taskBody.replaceAll("\n\\s*\n", "\n");
        taskBody = taskBody.replaceAll("([^\\\\];)", "$1\n");
        taskBody = Pattern.compile("[\\s]*$", 8).matcher(taskBody).replaceAll("");
        return taskBody;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String taskBody, NamedNodeMap attrs, String stepName, String nextStepName) {
        String[] commands = SqlOutputFile.breakUpCommands(taskBody);
        Statement st = null;
        ResultSet rs = null;
        try {
            try {
                st = DbAdmin.getConnection().createStatement();
                String outputfile = attrs.getNamedItem("outputfile").getNodeValue();
                boolean includeheader = StringUtils.getBoolean((String)attrs.getNamedItem("includeheader").getNodeValue(), (boolean)false);
                FileContents fc = new FileContents();
                StringBuffer sb = fc.getContentsBuffer();
                int numRows = 0;
                int i = 0;
                while (i < commands.length) {
                    String sql = commands[i].trim();
                    if (!sql.trim().equals("")) {
                        sql = sql.replaceAll("\n        ", "\n");
                        sql = sql.replaceAll("\n\t\t", "\n");
                        rs = st.executeQuery(sql);
                        ResultSetMetaData rsmd = rs.getMetaData();
                        int numCols = rsmd.getColumnCount();
                        if (includeheader) {
                            StringBuffer head = new StringBuffer();
                            int j = 1;
                            while (j <= numCols) {
                                head.append(rsmd.getColumnName(j).trim() + (j == numCols ? "" : ","));
                                ++j;
                            }
                            sb.append("# " + head + "\n\n");
                        }
                        while (rs.next()) {
                            ++numRows;
                            int j = 1;
                            while (j <= numCols) {
                                sb.append(rs.getString(j).trim() + (j == numCols ? "" : ","));
                                ++j;
                            }
                            sb.append("\n");
                        }
                    }
                    ++i;
                }
                File f = new File(outputfile);
                Main.logln("Generating file:  [" + f.getAbsolutePath() + "]");
                Main.logln("Encoding:         [" + LocaleMgr.getExternalDefaultEncoding() + "]");
                Main.logln("#-Rows:           [" + numRows + "]");
                fc.saveFile(outputfile, LocaleMgr.getExternalDefaultEncoding());
            }
            catch (Exception e) {
                Main.logException(e);
                int n = 2;
                Object var20_23 = null;
                DbAdmin.close(st);
                return n;
            }
            Object var20_22 = null;
        }
        catch (Throwable throwable) {
            Object var20_24 = null;
            DbAdmin.close(st);
            throw throwable;
        }
        DbAdmin.close(st);
        return 0;
    }

    private static String[] breakUpCommands(String commands) {
        commands = commands + "\n";
        commands = commands.replaceAll("\n\\s*--[^\n]*", "\n");
        return StringUtils.split((String)commands, (char)';', (boolean)true);
    }
}

