;;;
;;; Global load file for astl-04
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;        Copyright (c) 1993  Alan W Black (awb@ed.ac.uk)
;;;
;;; This file is part of an implementation of ASTL a computational
;;; situation theoretic language.  This implementation of ASTL is free
;;; software; you can redistribute it and/or modify it under the terms
;;; of the GNU General Public License as published by the Free
;;; Software Foundation; either version 1, or (at your option) any
;;; later version.
;;;
;;; ASTL is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY.  No author or distributor accepts
;;; responsibility to anyone for the consequences of using it or for
;;; whether it serves any particular purpose or works at all, unless
;;; he says so in writing.  Refer to the GNU Genral Public License for
;;; full details.
;;;
;;; Everyone is granted permission to copy, modify and redistribute
;;; this file, but only under the conditions described in the
;;; GNU General Public License.   A copy of this license is
;;; supposed to have been given to you along with this program so you
;;; can know your rights and responsibilities.  It should be in a
;;; file named COPYING.  Among other things, the copyright notice
;;; and this notice must be preserved on all copies.
;;;
;;; The author gratefully acknowledges financial support for the
;;; research this implementation is based on from an SERC studnetship
;;; (number 89313458) and Esprit Basic Research Action Project 6852
;;; (DYANA-2).
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; ASTL is a computational situation theoretic language intended to
;;; be used for giving executable specifications of aspects of natural
;;; language semantic theories.  Details of which are in the PhD
;;; thesis entitled "A situation theoretic approach to computational
;;; semantics" which is reprinted as a DYANA technical report and is
;;; available from HCRC, University of Edinburgh, 2 Buccleuch Place,
;;; Edinburgh, EH8 9NW.
;;;
;;; Alan W Black (awb@ed.ac.uk)
;;; Mar 15 1993
;;;
;;;

;;;   Change astl-dir to the diretcory in which you have unpacked
;;;   the code.  Note the / at the end of the directory name.

(setq astl-dir "/home/user4/awb/THESIS/LISP/astl-0.4/")

;;#+sun(defvar astl-dir "/home/forth2/phds.89/awb/THESIS/LISP/astl-0.4/")
;;#+minix(defvar astl-dir "/user/awb/THESIS/LISP/astl-0.4/")
;;#+akcl(progn
;;(if (string-equal (si:getenv "DOMAIN") "spottis")
;;    (setq astl-dir "/user/awb/THESIS/LISP/astl-0.4/"))
;;(if (string-equal (si:getenv "DOMAIN") "aiaiyp")
;;    (setq astl-dir "/tmp/awb/astl-0.4/"))
;;(if (string-equal (si:getenv "DOMAIN") "cstr")
;;    (setq astl-dir "/u11/sip/awb/src/astl-0.4/"))
;;(if (string-equal (si:getenv "DOMAIN") "cogsci")
;;    (setq astl-dir "/home/user4/awb/THESIS/LISP/astl-0.4/")))
;;#+:cmu(defvar astl-dir "/home/user4/awb/THESIS/LISP/astl-0.4/")

(load (merge-pathnames astl-dir "prules.lisp"))
(load (merge-pathnames astl-dir "stparse.lisp"))
(load (merge-pathnames astl-dir "si-match.lisp"))
(load (merge-pathnames astl-dir "si-chart.lisp"))
(load (merge-pathnames astl-dir "ekn.lisp"))


(defun loadit ()
#+kcl(load (merge-pathnames astl-dir "prules.o"))
#+kcl(load (merge-pathnames astl-dir "stparse.o"))
#+kcl(load (merge-pathnames astl-dir "si-match.o"))
#+kcl(load (merge-pathnames astl-dir "si-chart.o"))
#+kcl(load (merge-pathnames astl-dir "ekn.o"))
;; #+kcl(use-fast-links t)

#+:cmu(load (merge-pathnames astl-dir "prules.sparcf"))
#+:cmu(load (merge-pathnames astl-dir "stparse.sparcf"))
#+:cmu(load (merge-pathnames astl-dir "si-match.sparcf"))
#+:cmu(load (merge-pathnames astl-dir "si-chart.sparcf"))
#+:cmu(load (merge-pathnames astl-dir "ekn.sparcf"))
)

(defun compit ()
  (proclaim '(optimize (speed 3) (space 0) (safety 0)))
  (compile-file "prules.lisp")
  (compile-file "stparse.lisp")
  (compile-file "si-match.lisp")
  (compile-file "si-chart.lisp")
  (compile-file "ekn.lisp")
)
