;;;
;;;   File: cons4.st
;;;
;;;   A simple use of constraints to do "parsing"
;;;
;;;   Alan W Black May 91 (awb@ed.ac.uk)
;;;
;;;   This has situations representing the utterance of the words
;;;   Hanako likes Taro.  The constraints build up a sentence from
;;;   those word utterances.
;;;

Individuals
    {v0, v1, v2, v3}
Relations
    (cat/2 NounPhrase/0 VerbPhrase/0 Sentence/0 Verb/0
     use_of/2
     daughter1/2 daughter2/2
     start/2 end/2)
Parameters
    {S, NP, VP, V}
Variables
    {*S, *T, *NP, *VP, *V, *WS, *WM, *WE}
Situations
    (SitH :: [S ! S != <<cat,SitH,NounPhrase,1>>
                  S != <<start,S,v0,1>>
		  S != <<end,S,v1,1>>
                  S != <<use_of,SitH,"Hanako",1>>]
     SitL :: [S ! S != <<cat,SitL,Verb,1>>
                  S != <<start,S,v1,1>>
		  S != <<end,S,v2,1>>
                  S != <<use_of,SitL,"likes",1>>]
     SitT :: [S ! S != <<cat,SitT,NounPhrase,1>>
                  S != <<start,S,v2,1>>
		  S != <<end,S,v3,1>>
                  S != <<use_of,SitT,"Taro",1>>]
    )
Constraints
   [S ! S != <<cat,S,Sentence,1>>
        S != <<start,S,*WS,1>>
        S != <<end,S,*WE,1>>
        S != <<daughter1,S,*NP,1>>
        S != <<daughter2,S,*VP,1>>]
   <=
    *NP : [NP ! NP != <<cat,NP,NounPhrase,1>>
                NP != <<start,NP,*WS,1>>
                NP != <<end,NP,*WM,1>>],
    *VP : [VP ! VP != <<cat,VP,VerbPhrase,1>>
                VP != <<start,VP,*WM,1>>
                VP != <<end,VP,*WE,1>>].

   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<start,VP,*WS,1>>
         VP != <<end,VP,*WE,1>>
         VP != <<daughter1,VP,*V,1>>
         VP != <<daughter2,VP,*NP,1>>]
   <=
    *V : [V ! V != <<cat,V,Verb,1>>
              V != <<start,V,*WS,1>>
              V != <<end,V,*WM,1>>],
    *NP : [NP ! NP != <<cat,*NP,NounPhrase,1>>
                NP != <<start,NP,*WM,1>>
                NP != <<end,NP,*WE,1>>].

