;;;
;;;   File: dpl-nl.st
;;;
;;;   Alan W Black (awb@ed.ac.uk) Feb 1992
;;;
;;;   An astl description of a simple natural language grammar
;;;   whose semantics is defined in terms of a DPL like semantics
;;;   Utterance situations are related to input and output 
;;;   assignments which contain actual assignment and conditions
;;;   on what they assign
;;;
;;;   This is based on the DRT description.  Bascially the whole
;;;   DRT description can be used and only the constraints regarding
;;;   the relations of DRSs need to be re-written.  The threading
;;;   relations of DRSs and DPL assignment is exactly the same.
;;;
;;;   (I hope)
;;;

Individuals {}
Relations ()
Parameters {S, X, T, A}
Variables  (*S, *NP, *VP, *D, *N, *X, *Y, *Z, *T, *U, *A,
            *V, *W, *I, *J,
            *AOut, *AIn, *AIntype, *Rel, *Ind, *Var,
            *G, *H, *K, *M, *Scope,
            *GType, *Htype, *KType *MType,
            *Need, *Out, *Need2, *Feed, *Assign,
            *Scope, *Range)
Situations ( EmptyAssign)
GoalProp
   *S : [S ! S != <<cat,S,Sentence,1>>
             S != <<AssignOut,S,*X,1>>]

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
                           Constraints
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  There are two sections of constraints here -- first the ones
;;;  defining the threading relation over the utterance situations
;;;  Second there are constraints definition the relationship between
;;;  the Assignments of an utterance situation
;;;
*S : [S ! S != <<AssignIn,S,*Assign,1>>]
   <=
;;       *S : [S ! S != <<cat,S,*X,1>>].
     *U : [S ! S != <<t-in,*S,*T ::
                         [T ! T != <<AssignOut,T,*Assign,1>>],1>>].

;;;  This one is a hack to give an empty assignment to the first thing
;;;  in the discourse
;;;
*S : [S ! S != <<AssignIn,S,EmptyAssign,1>>]
<=
   *T : [S ! S != <<cat,S,Sentence,1>>
             S != <<t-need,S,*S,1>>].

;;*T : [S ! S != <<AssignIn,S,EmptyAssign,1>>]
;;<=
;;   *T : [S ! S != <<cat,S,Sentence,1>>].
;;;
;;;  Lexical utterance situations have t-need and t-out as themselves
;;;
*S : [S ! S != <<t-need,S,S,1>>
          S != <<t-out,S,S,1>>]
<=
   *S : [S ! S != <<use_of,S,*X,1>>].

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;   The following constraints relate the Output assignment of an
;;;   utterance situation to the input and whatever semantics is given
;;;   by that utterance.
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  The two interesting cases are for the semantics of determiners
;;;  (i.e. the uttsits that introduce quantifiers).  
;;;
;;;  Existential

*S : [S ! S != <<AssignOut,S,
                     *H :: *Htype &
                     [T ! T != <<exists,*K,1>>],1>>]
    <=
       *T : [S ! S != <<t-scope,
                         *S :: 
                         [P ! P != <<cat,*S,Determiner,1>>
                              P != <<AssignMid,*S,*K,1>>
                              P != <<sem,*S,exists,1>>],
                         *Scope ::
                         [T ! T != <<AssignOut,*Scope,*H :: *Htype ,1>>],
                         1>>].

;;;  Universal

*S : [S ! S != <<AssignOut,S,
                  *AOut :: *AIntype &
                   [T ! T != <<forall,
                                *K,
                                *M :: [U ! U != <<forall,*I,*J,1>>],
                                1>>],
                   1>>]
    <=
       *S : [S ! S != <<cat,S,Determiner,1>>
                 S != <<sem,S,forall,1>>
                 S != <<AssignMid,S,*K,1>>
                 S != <<AssignIn,S,*G :: *AIntype,1>>],
       *T : [S ! S != <<t-scope,
                        *S,
                        *V :: 
                        [T ! T != <<AssignOut,*V,*I,1>>],
                        1>>],
       *U : [S ! S != <<t-range,
                        *S,
                        *W :: 
                        [T ! T != <<AssignOut,*W,*J,1>>],
                        1>>].


;;;
;;;  Here something happens that may appear strange.  The output
;;;  assignment for the sentence uttsit is only concerned with the the
;;;  predicate of the sentence.  This is not (necessarily) the ouput
;;;  that will be passed on to the rest of discourse.  That output is
;;;  the AssignOut of the t-out of the sentence uttsit
;;;
*S : [S ! S != <<AssignOut,S,*AOut :: *Aintype &
                              [T ! T != <<*Rel,*Ind,1>>],1>>]
<=
   *S : [S ! S != <<cat,S,Sentence,1>>
             S != <<sem,S,<<*Rel,*Ind,1>>,1>>
             S != <<AssignIn,S,*AIn :: *Aintype,1>>].

*S : [S ! S != <<AssignOut,S,*Assign,1>>]
<=
   *S : [S ! S != <<cat,S,VerbPhrase,1>>
             S != <<AssignIn,S,*Assign,1>>].

*S : [S ! S != <<AssignOut,S,*Assign,1>>]
<=
   *S : [S ! S != <<cat,S,NounPhrase,1>>
             S != <<AssignIn,S,*Assign,1>>].

*S : [S ! S != <<AssignOut,S,*AOut :: *AIntype &
                                      [T ! T != <<*Rel,*Ind,1>>],1>>]
<=
   *S : [S ! S != <<cat,S,Noun,1>>
             S != <<sem,S,*Rel,1>>
             S != <<ind,S,*Ind,1>>
             S != <<AssignIn,S,*AIn :: *AIntype,1>>].

;;;
;;;  To get the incoming assignment to the first noun in a scoped
;;;  expression a special case is needed.  In this case we do *not*
;;;  use the normal threading relations.
;;;
;;;  This actually does for both "every" and "a" determiners
;;;

*S : [S ! S != <<AssignIn,S,*A,1>>]
<=
   *T : [S ! S != <<t-range,
                    *D :: [T ! T != <<AssignMid,T,*A,1>>],
                    *S,1>>].

*S : [S ! S != <<AssignMid,S,*AIn :: *AIntype &
                          [T ! T != <<assign,*Var,*Ind,1>>],1>>]
<=
   *T : [S ! S != <<cat,S,nounphrase,1>>
             S != <<daughters,S,
                    *S :: [T ! T != <<AssignIn,*S,*A :: *AIntype,1>>
                               T != <<var,*S,*Var,1>>],
                    *N :: [T ! T != <<ind,T,*Ind,1>>],1>>].

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
                            Grammar Rules
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;
;;;   The grammar rules specify the syntactic structure and
;;;   the basic threading relations
;;;   They also do the simple semantics (predicate argument relations)
;;;

*S : [S ! S != <<cat,S,sentence,1>>
          S != <<sem,S,<<*Rel,*Ind,1>>,1>>
          S != <<daughters,S,*NP,*VP,1>>
          S != <<t-need,S,*Need,1>>
          S != <<t-out,S,*Out,1>>
          S != <<t-in,*Need2,*Feed,1>>
          S != <<t-in,*S,*VP,1>>
          S != <<t-scope,*Out,*S,1>>]
->
   *NP : [S ! S != <<cat,S,NounPhrase,1>>
              S != <<sem,S,*Ind,1>>
              S != <<t-need,S,*Need,1>>
              S != <<t-out,S,*Out,1>>
              S != <<t-feed,S,*Feed,1>>],
   *VP : [S ! S != <<cat,S,VerbPhrase,1>>
              S != <<sem,S,*Rel,1>>
              S != <<t-need,S,*Need2,1>>].

*NP : [S ! S != <<cat,S,Nounphrase,1>>
           S != <<daughters,S,*D,*N,1>>
           S != <<sem,S,*Ind,1>>
           S != <<t-need,S,*D,1>>
           S != <<t-out,S,*D,1>>
           S != <<t-in,*NP,*N,1>>
           S != <<t-feed,*NP,*NP,1>>
           S != <<t-range,*D,*N,1>>]
->
   *D : [S ! S != <<cat,S,Determiner,1>>
             S != <<var,S,*Ind,1>>],
   *N : [S ! S != <<cat,S,Noun,1>>].

Lexical Entries

a -     [S ! S != <<cat,S,Determiner,1>>
             S != <<use_of,S,"a",1>>
             S != <<sem,S,exists,1>>
             S != <<var,S,X,1>>]
every - [S ! S != <<cat,S,Determiner,1>>
             S != <<use_of,S,"every",1>>
             S != <<sem,S,forall,1>>
             S != <<var,S,X,1>>]
man   - [S ! S != <<cat,S,Noun,1>>
             S != <<use_of,S,"man",1>>
             S != <<sem,S,man,1>>
             S != <<ind,S,A,1>>]
walks - [S ! S != <<cat,S,VerbPhrase,1>>
             S != <<use_of,S,"walks",1>>
             S != <<sem,S,walk,1>>
             S != <<ind,S,X,1>>]

