;;;
;;;   File: dpl.st
;;;
;;;   Dynamic predicate logic in astl
;;;
;;;   Alan W Black (awb@ed.ac.uk) Feb 92
;;;
;;;   This is an nth attempt to try and get a reasonable translation
;;;   for DPL. Here we treat utterances as DPL expressions.  This means
;;;   the grammar if the syntax of DPL.
;;;


Individuals   {h, t}
Relations     (cat/2 var/2 scope/2 AssignIn/2 AssignOut/2
               ind/2 wff/1
               exists/1 forall/2 man/1 walk/1)
Parameters    {S T A B C X}
Variables     {*S, *T, *G, *H, *K, *M, *Scope, *Rel,
               *Ind, *X, *AIn, *AOut, *Aintype, *Gtype,
               *Htype, *C1, *C2, *D1, *D2}
Situations    
         (EmptyAssign)
GoalProp *S : [S ! S != <<cat,S,sentence,1>>
                   S != <<AssignOut,S,*H,1>>]
Constraints
    *S : [S ! S != <<AssignOut,S,
                     *AOut :: *Aintype &
                            [T ! T != <<*Rel,*Ind,1>>],1>>]
    <=
       *S : [S ! S != <<cat,S,pred,1>>
                 S != <<sem,S,*Rel,1>>
                 S != <<ind,S,*Ind,1>>
                 S != <<AssignIn,S,*AIn :: *Aintype,1>>].

    *S : [S ! S != <<AssignOut,S,
                     *H :: *Htype &
                     [T ! T != <<exists,*K,1>>],1>>]
    <=
       *S : [S ! S != <<cat,S,exists,1>>
                 S != <<var,S,*X,1>>
                 S != <<scope,S,
                        *Scope ::
                         [T ! T != <<ind,*Scope,*Ind,1>>
                              T != <<AssignOut,*Scope,*H :: *Htype ,1>>
                              T != <<AssignIn,*Scope,*K,1>>],1>>].

    *T : [S ! S != <<AssignIn,S,*K :: *Gtype &
                                    [T ! T != <<assign,*X,*Ind,1>>],
                     1>>]
    <=
      *S : [S ! S != <<cat,S,exists,1>>
                S != <<AssignIn,S,*G :: *Gtype,1>>
                S != <<scope,S,*T :: [T ! T != <<ind,*T,*Ind,1>>],1>>
                S != <<var,S,*X,1>>].

    *S : [S ! S != <<AssignOut,S,
                     *G :: *AIntype &
                     [T ! T != <<forall,*K,*M,1>>],1>>]
    <=
       *S : [S ! S != <<cat,S,forall,1>>
                 S != <<var,S,*X,1>>
                 S != <<scope,S,
                        *Scope ::
                         [T ! T != <<ind,*Scope,*Ind,1>>
                              T != <<AssignOut,*Scope,*M,1>>
                              T != <<AssignIn,*Scope,*K,1>>],1>>
                 S != <<AssignIn,S,*G :: *AIntype,1>>].

    *T : [S ! S != <<AssignIn,S,*K :: *Gtype &
                                    [T ! T != <<assign,*X,*Ind,1>>],
                     1>>]
    <=
      *S : [S ! S != <<cat,S,forall,1>>
                S != <<AssignIn,S,*G :: *Gtype,1>>
                S != <<scope,S,*T :: [T ! T!= <<ind,*T,*Ind,1>>],1>>
                S != <<var,S,*X,1>>].

    *T : [S ! S != <<AssignIn,S,EmptyAssign,1>>]
    <=
      *S : [S ! S != <<cat,S,sentence,1>>
                S != <<scope,S,*T,1>>].
    *T : [S ! S != <<AssignIn,S,EmptyAssign,1>>
              S != <<AssignOut,S,*H,1>>]
    <=
      *T : [S ! S != <<cat,S,sentence,1>>
                S != <<scope,S,*Scope :: 
                               [T ! T != <<AssignOut,T,*H,1>>],1>>].
Grammar Rules
;;;
;;;  None of this natural language grammar stuff just old-fasioned
;;;  logical form - this is harder than it should be 
;;;
*S : [S ! S != <<cat,S,sentence,1>>
          S != <<Scope,S,*T,1>>]
->
   [S ! S != <<cat,S,period,1>>],
   *T : [S ! S != <<wff,S,1>>],
   [S ! S != <<cat,S,period,1>>].

*S : [S ! S != <<cat,S,conj,1>>
          S != <<wff,S,1>>
          S != <<conjunct,S,*C1,1>>
          S != <<conjunct,S,*C2,1>>]
->
   *C1 : [S ! S != <<wff,S,1>>],
   [S ! S != <<cat,S,and,1>>],
   *C2 : [S ! S != <<wff,S,1>>].

*S : [S ! S != <<cat,S,disj,1>>
          S != <<wff,S,1>>
          S != <<disjunct,S,*D1,1>>
          S != <<disjunct,S,*D2,1>>]
->
   *D1 : [S ! S != <<wff,S,1>>],
   [S ! S != <<cat,S,or,1>>],
   *D2 : [S ! S != <<wff,S,1>>].

*S : [S ! S != <<cat,S,exists,1>>
          S != <<wff,S,1>>
          S != <<scope,S,*Scope,1>>
          S != <<var,S,*X,1>>]
->
   [S ! S != <<cat,S,exists-quant,1>>
        S !=  <<var,S,*X,1>>],
   *Scope : [S ! S != <<wff,S,1>>].

*S : [S ! S != <<cat,S,forall,1>>
          S != <<wff,S,1>>
          S != <<scope,S,*Scope,1>>
          S != <<var,S,*X,1>>]
->
   [S ! S != <<cat,S,forall-quant,1>>
        S != <<var,S,*X,1>>],
   *Scope : [S ! S != <<wff,S,1>>].

Lexical Entries

man-x - [S ! S != <<cat,S,pred,1>>
             S != <<sem,S,man,1>>
             S != <<ind,S,A,1>>
             S != <<wff,S,1>>]
walk-x - [S ! S != <<cat,S,pred,1>>
              S != <<sem,S,walk,1>>
              S != <<ind,S,B,1>>
              S != <<wff,S,1>>]
exists-x - [S ! S != <<cat,S,exists-quant,1>>
                S != <<var,S,X,1>>]
forall-x - [S ! S != <<cat,S,forall-quant,1>>
                S != <<var,S,X,1>>]
and - [S ! S != <<cat,S,and,1>>]
or - [S ! S != <<cat,S,or,1>>]
period - [S ! S != <<cat,S,period,1>>]

          
