;;;
;;;   File: drt2.st
;;;
;;;   Discourse Representation Theory in Situation Theoretic Grammar
;;;
;;;   Alan W Black (awb@ed.ac.uk) September 91
;;;
;;;   This is the bare minimum showing how a thread of a domain of
;;;   individuals being discussed and a set of conditions (effectively
;;;   a described situation) can be threaded through an analysis.
;;;
;;;   This version works for transitive and intransitive verbs with
;;;   proper noun arguments. 
;;;

Individuals
    {h,t,a,p}
Relations
    ( use_of/2 cat/2 
      sem/2 env/2 type/2 threads/2
      NounPhrase/1 Sentence/1 VerbPhrase/1 Discourse/1 
      ProperNoun/1 ProNoun/1
      FullDiscourse/1 DisStart/1 DisEnd/1
      subj/1 pred/1 
      label/2 anchor/2
      sing/1 like/2 smile/1
      named/2 male/1 female/1 neuter/1
      DRSIn/2 DRSOut/2
    )
Hush            ;; relations not to be displayed on output
    (daughter threads)
Parameters
    {R1,A1,S,S1,S2,TS,NP,VP,PN,V,Env,DS,Res,
     PN1, PN2, PN3}
Variables
    {*X, *Y, *Z, *S, *Fact, *VPEnv, *SEnv, *VPEnvType, *VEnv, *VEnvType,
     *R1, *A1, *A2, *VR1, *VA1, *VA2, *DS, *DS1, *PN,
     *DRSInType, *DRSIn, *DRSout,
     *ThreadS, *ThreadNP, *ThreadVP, *ThreadV, *Thread, *ThreadDS, 
     *ThreadDS1, *TYPE
     *T1, *T2, *S1, *S2, *P1, *P2, *NPSem,
     *NP, *VP, *V}
Situations
    (SingEnv :: [Env ! Env != <<label,R1,pred,1>>
		       Env != <<anchor,R1,sing,1>>
		       Env != <<label,A1,subj,1>>]
     SmileEnv :: [Env ! Env != <<label,R1,pred,1>>
		        Env != <<anchor,R1,smile,1>>
		        Env != <<label,A1,subj,1>>]
     LikeEnv :: [Env ! Env != <<label,R1,pred,1>>
		       Env != <<anchor,R1,like,1>>
		       Env != <<label,A1,subj,1>>
		       Env != <<label,A2,obj,1>>]
     DRSStart ;; : [DS ! DS != <<female,h,1>>]
     Dstart :: [S ! S != <<cat,S,Discourse,1>>
                    S != <<DRSout,S,DRSStart,1>>]
     SitResource :: [Res ! Res != <<named,h,"Hanako",1>>
                           Res != <<female,h,1>>
                           Res != <<named,a,"Anna",1>>
                           Res != <<female,a,1>>
                           Res != <<named,p,"Pedro",1>>
                           Res != <<neuter,p,1>>
                           Res != <<named,t,"Taro",1>>
                           Res != <<male,t,1>>]
    )
GoalProp
   *S : [S ! S != <<cat,S,fulldiscourse,1>>
             S != <<DRSOut,S,*DRSout,1>>
        ]

Constraints
;;;
;;;  These first set of constraint define the relationship between
;;;  the incoming DRS and the outgoing DRS in the various types of
;;;  node.  The only interesting ones are sentences where a new 
;;;  condition is added, propernouns where type information male/female
;;;  is added and pronouns where the current DRSIn is check for a 
;;;  object of the right type that has already been mentioned.
;;;  The other utterance types simply "copy" the DRSIn to DRSOut.
;;;
   *S : [S ! S != <<DRSOut,S,*DRSOut :: *DRSInType &
                                        [DS ! DS != <<*VR1,*VA1,1>>],1>>]
   <=
      *S : [S ! S != <<cat,S,sentence,1>>
                S != <<DRSIn,S,*DRSIn :: *DRSInType,1>>
                S != <<sem,S,<<*R1,*A1,1>>,1>>
                S != <<env,S,*SEnv ::
                             [Env ! Env != <<anchor,*R1,*VR1,1>>
                                    Env != <<anchor,*A1,*VA1,1>>],1>>].

   *S : [S ! S != <<DRSOut,S,*DRSOut ::
                                *DRSInType &
                                [DS ! DS != <<*VR1,*VA1,*VA2,1>>],1>>]
   <=
      *S : [S ! S != <<cat,S,sentence,1>>
                S != <<DRSIn,S,*DRSIn :: *DRSInType,1>>
                S != <<sem,S,<<*R1,*A1,*A2,1>>,1>>
                S != <<env,S,*SEnv ::
                             [Env ! Env != <<anchor,*R1,*VR1,1>>
                                    Env != <<anchor,*A1,*VA1,1>>
				    Env != <<anchor,*A2,*VA2,1>>],1>>].

*S : [S ! S != <<DRSout,S,*DRSout ::
                         *DRSInType &
                         [DS ! DS != <<*TYPE,*X,1>>],1>>]
  <= 
      *S : [S ! S != <<cat,S,ProperNoun,1>>
                S != <<sem,S,*X,1>>
                S != <<DRSIn,S,*DRSin :: *DRSInType,1>>
           ],
      SitResource : [Res ! Res != <<*TYPE,*X,1>>].

*S : [S ! S != <<DRSout,S,*DRSout ::
                         *DRSInType &
                         [DS ! DS != <<is,*X,*Y,1>>],1>>]
  <= 
      *S : [S ! S != <<cat,S,Pronoun,1>>
                S != <<type,S,*TYPE,1>>
                S != <<sem,S,*X,1>>
                S != <<DRSIn,S,*DRSin :: *DRSInType &
                            [S1 ! S1 != <<*TYPE,*Y,1>>],1>>
            ],
      SitResource : [Res ! Res != <<*TYPE,*Y,1>>].


*S : [S ! S != <<DRSOut,S,*DRSOut,1>>]
  <= 
     *S : [S ! S != <<cat,S,NounPhrase,1>>
               S != <<DRSIn,S,*DRSOut,1>>].

*S : [S ! S != <<DRSOut,S,*DRSOut,1>>]
  <= 
      *S : [S ! S != <<cat,S,VerbPhrase,1>>
                S != <<DRSIn,S,*DRSOut,1>>].

*S : [S ! S != <<DRSOut,S,*DRSOut,1>>]
  <= 
      *S : [S ! S != <<cat,S,Verb,1>>
                S != <<DRSIn,S,*DRSOut,1>>].

*S : [S ! S != <<DRSOut,S,*DRSOut,1>>]
  <= 
      *S : [S ! S != <<cat,S,Discourse,1>>
                S != <<DRSIn,S,*DRSOut,1>>].

*S : [S ! S != <<DRSOut,S,*DRSOut,1>>]
  <= 
      *S : [S ! S != <<cat,S,FullDiscourse,1>>
                S != <<daughter,S,*DS ::
                                  [DS ! DS != <<DRSOut,DS,*DRSOut,1>>],
                       1>>].

;;;
;;;  The relationship between the DRSIn and the previous DRSOut
;;;  is done by threading.  All the situations which support the
;;;  t-in are checked for one where information about the threading
;;;  of that situation is found.
;;;
*S : [S ! S != <<DRSIn,S,*DRSin,1>>]
<=
  *Y : [TS ! TS != <<t-in,*S,*S1 :: [S1 ! S1 != <<DRSOut,S1,*DRSIn,1>>],1>>].

;;;
;;;  This is basically a lexical rule to add the base case of the
;;;  threads.  Lexical items thread through themselves as they have
;;;  no daughters.
;;;
*S : [S ! S != <<threads,S,*Thread ::
                           [TS ! TS != <<t-need,*S,*S,1>>],1>>]
<=
   *S : [S ! S != <<use_of,S,*Y,1>>].

Grammar Rules
;;;
;;;   S -> NP VP
;;;
   *S : [S ! S != <<cat,S,Sentence,1>>
             S != <<sem,S,*Fact,1>>
             S != <<env,S,*SEnv :: *VPEnvType & 
  	                           [Env ! Env != <<anchor,*P1,*NPSem,1>>],1>>
	     S != <<daughter,S,*NP,1>>
	     S != <<daughter,S,*VP,1>>
	     S != <<threads,S,*ThreadS ::
			    [TS ! TS != <<t-need,*S,*Y,1>>
				  TS != <<t-in,*X,*NP,1>>
				  TS != <<t-in,*S,*VP,1>>],1>>
        ]
   ->
    *NP : [NP ! NP != <<cat,NP,NounPhrase,1>>
                NP != <<sem,NP,*NPSem,1>>
                NP != <<threads,NP,*ThreadNP ::
                                   [TS ! TS != <<t-need,*NP,*Y,1>>],1>>
           ],
    *VP : [VP ! VP != <<cat,VP,VerbPhrase,1>>
                VP != <<sem,VP, *Fact ,1>>
                VP != <<env,VP,*VPEnv :: *VPEnvType &
                                      [Env ! Env != <<label,*P1,subj,1>>],1>>
                VP != <<threads,VP,*ThreadVP ::
                                    [TS ! TS != <<t-need,*VP,*X,1>>],1>>
          ].

;;;
;;;   VP -> V NP
;;;
   *VP : [VP ! VP != <<cat,VP,VerbPhrase,1>>
               VP != <<sem,VP,*Fact,1>>
               VP != <<env,VP,*VPEnv :: *VEnvType & 
    		                    [Env ! Env != <<anchor,*P1,*NPSem,1>>],1>>
  	       VP != <<daughter,VP,*V,1>>
	       VP != <<daughter,VP,*NP,1>>
               VP != <<threads,VP,*ThreadVP ::
                               [TS ! TS != <<t-need,*VP,*X,1>>
                                     TS != <<t-in,*Y,*V,1>>
                                     TS != <<t-in,*VP,*NP,1>>],1>>]
   ->
    *V  : [V ! V != <<cat,V,Verb,1>>
               V != <<sem,V,*Fact,1>>
               V != <<env,V,*VEnv :: *VEnvType &
                               [Env ! Env != <<label,*P1,obj,1>>],1>>
               V != <<threads,V,*ThreadV ::
		           [TS ! TS != <<t-need,*V,*X,1>>],1>>],
    *NP : [NP ! NP != <<cat,NP,NounPhrase,1>>
                NP != <<sem,NP,*NPSem,1>>
                NP != <<threads,NP,*ThreadNP ::
                             [TS ! TS != <<t-need,*NP,*Y,1>>],1>>].

;;;
;;;  NP -> Pronoun
;;;
   *NP : [NP ! NP != <<cat,NP,NounPhrase,1>>
               NP != <<sem,NP,*X,1>>
               NP != <<daughter,NP,*PN,1>>
               NP != <<threads,NP,*ThreadNP ::
                               [TS ! TS != <<t-need,*NP,*Y,1>>
                                     TS != <<t-in,*NP,*PN,1>>],1>>]
   ->
      *PN : [PN ! PN != <<cat,PN,Pronoun,1>>
                  PN != <<sem,PN,*X,1>>
                  PN != <<threads,PN,*Thread ::
                               [TS ! TS != <<t-need,*PN,*Y,1>>],1>>].

;;;
;;;  NP -> Propernoun
;;;
   *NP : [NP ! NP != <<cat,NP,NounPhrase,1>>
               NP != <<sem,NP,*X,1>>
               NP != <<daughter,NP,*PN,1>>
               NP != <<threads,NP,*ThreadNP ::
                               [TS ! TS != <<t-need,*NP,*Y,1>>
                                     TS != <<t-in,*NP,*PN,1>>],1>>]
   ->
      *PN : [PN ! PN != <<cat,PN,ProperNoun,1>>
                  PN != <<sem,PN,*X,1>>
                  PN != <<threads,PN,*Thread ::
                               [TS ! TS != <<t-need,*PN,*Y,1>>],1>>
             ].

;;;
;;;  Discourse -> S
;;;
   *DS : [DS ! DS != <<cat,DS,Discourse,1>>
               DS != <<daughter,DS,*S,1>>
               DS != <<threads,DS,*ThreadDS ::
                             [TS ! TS != <<t-need,*DS,*X,1>>
                                   TS != <<t-in,*DS,*S,1>>],1>>]
   ->
     *S : [S ! S != <<cat,S,sentence,1>>
               S != <<threads,S,*ThreadS ::
                             [TS ! TS != <<t-need,*S,*X,1>>],1>>].

;;;
;;;  Discourse -> Discourse S
;;;  

   *DS1 : [DS ! DS != <<cat,DS,Discourse,1>>
                DS != <<daughter,DS,*DS,1>>
                DS != <<daughter,DS,*S,1>>
                DS != <<threads,DS,*ThreadDS1 ::
                              [TS ! TS != <<t-need,*DS1,*X,1>>
                                    TS != <<t-in,*Y,*DS,1>>
                                    TS != <<t-in,*DS1,*S,1>>],1>>]
   ->
     *DS : [DS ! DS != <<cat,DS,Discourse,1>>
                 DS != <<threads,DS,*ThreadDS ::
                                 [TS ! TS != <<t-need,*DS,*X,1>>],1>>],
     *S : [S ! S != <<cat,S,sentence,1>>
               S != <<threads,S,*ThreadS ::
                             [TS ! TS != <<t-need,*S,*Y,1>>],1>>].

;;;
;;;  Fulldiscourse -> ds Discourse de
;;;
   [DS ! DS != <<cat,DS,fulldiscourse,1>>
         DS != <<daughter,DS,*DS,1>>
         DS != <<threads,DS,
                    *ThreadDS :: [TS ! TS != <<t-in,*X,DStart,1>>],1>>
         ]
  ->
    [S ! S != <<cat,S,DisStart,1>>],
    *DS : [DS ! DS != <<cat,DS,discourse,1>>
                DS != <<threads,DS,*ThreadDS ::
                          [TS ! TS != <<t-need,*DS,*X,1>>],1>>
              ],
    [S ! S != <<cat,S,DisEnd,1>>].
    
      
Lexical Entries

ds -
   [DS ! DS != <<cat,DS,DisStart,1>>]
de -
   [DS ! DS != <<cat,DS,DisEnd,1>>]
Hanako - 
   [PN ! PN != <<cat,PN,ProperNoun,1>>
         PN != <<use_of,PN,"Hanako",1>>
         PN != <<sem,PN,h,1>>]
Anna - 
   [PN ! PN != <<cat,PN,ProperNoun,1>>
         PN != <<use_of,PN,"Anna",1>>
         PN != <<sem,PN,a,1>>]
Taro -
   [PN ! PN != <<cat,PN,ProperNoun,1>>
         PN != <<use_of,PN,"Taro",1>>
         PN != <<sem,PN,t,1>>]
Pedro -
   [PN ! PN != <<cat,PN,ProperNoun,1>>
         PN != <<use_of,PN,"Pedro",1>>
         PN != <<sem,PN,p,1>>]
he -
   [PN ! PN != <<cat,PN,ProNoun,1>>
         PN != <<use_of,PN,"he",1>>
         PN != <<type,PN,male,1>>
         PN != <<sem,PN,PN1,1>>]
she -
   [PN ! PN != <<cat,PN,ProNoun,1>>
         PN != <<use_of,PN,"he",1>>
         PN != <<type,PN,female,1>>
         PN != <<sem,PN,PN2,1>>]
it -
   [PN ! PN != <<cat,PN,ProNoun,1>>
         PN != <<use_of,PN,"it",1>>
         PN != <<type,PN,neuter,1>>
         PN != <<sem,PN,PN3,1>>]
sings -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"sings",1>>
         VP != <<sem,VP,<<R1,A1,1>>,1>>
         VP != <<env,VP,SingEnv,1>>]
smiles -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"smiles",1>>
         VP != <<sem,VP,<<R1,A1,1>>,1>>
         VP != <<env,VP,SmileEnv,1>>]
likes -
   [V ! V != <<cat,V,Verb,1>>
        V != <<use_of,V,"likes",1>>
        V != <<sem,V,<<R1,A1,A2,1>>,1>>
        V != <<env,V,LikeEnv,1>>]

