;;;
;;;   File: stg3.st
;;;
;;;   A situation theoretic grammar treatment of more of Rooth's
;;;   fragment (Rooth87).  This is small fragment which is enough to
;;;   allowing interesting donkey sentences.
;;;
;;;   Alan W Black (awb@ed.ac.uk) July 91
;;;
;;;   Each utterance (or part of an utterance) is represented by a
;;;   situation.  The grammar rules are constraint between such
;;;   utterance situations.  An utterance situation is related to a
;;;   semantics which is a parametric object, each utterance also has
;;;   a labelling and anchoring environment which labels and anchors
;;;   the parameters in the semantics.  Via constraints a basis
;;;   relation can be specified which is depended on the environment
;;;   an paramteric object.  The basis is effectively the reduction of
;;;   the semantics with respect to the anchoring.
;;;
;;;

Individuals
    {a,h,t}
Relations
    ( 
;;;  These are the relations which act like features in a conventional
;;;  attribute value system
      use_of/2 cat/2 person/2 case/2 tense/2 anaphoric_mode/2 
      env/2 sem/2 basis/2

;;; Syntactic functions which act as arguments to cat/2
      NounPhrase/1 Noun/1 Determiner/1
      Sentence/1 VerbPhrase/1 Verb/1 
      PrepPhrase/1 Preposition/1
      Discourse/1

;;; Arguments to functional relations (can you say feature values :-)
      third/1 first/1 second/1
      nom/1 acc/1
      inf/1 pres/1 past/1

;;; These are grammatical functions used as labels on objects
      subj/1 obj/1 comp/1 pred/1 
      var/1 range/1 body/1 quantifier/1

;;; Used in the label-anchoring part of the environment
      label/2 anchor/2 

;;; These are relations to do with the semantics of utterances
      beat/2 like/2 walk/1 talk/1 smile/1 sing/1 run/1
      man/1 donkey/1
      named/2 male/1 female/1 neuter/1
    )
Parameters
    {R1,Q1,A1,A2,A3,D,S,NP,VP,PN,N,PREP,DET,V,RES,ENV,DS}
Variables
    {*X, *S, *Y, *tense, 
     *Fact, *Qexpr,
     *DS, *Env, 
     *SEnv, *VPEnv, *VEnv, *NPEnv, *Nenv, *DetEnv, 
     *EnvType,
     *Body, *Range, *Type, *Z
     *R1, *A1, *A2, *A3, *VR1, *VA1, *VA2, *VA3,
     *SDS, *DStype,
     *pred, *Var, *Pvar, *Basis, *pobj, *obj}
Situations
    (SitResource :: [Res ! Res != <<named,a,"Anna",1>>
			   Res != <<female,a,1>>
                           Res != <<named,t,"Taro",1>>
                           Res != <<male,t,1>>
                           Res != <<named,h,"Hanako",1>>
                           Res != <<female,h,1>>]
     SmileEnv :: [Env ! Env != <<label,R1,pred,1>>
		       Env != <<anchor,R1,smile,1>>
		       Env != <<label,SMA1,subj,1>>]
     SingEnv :: [Env ! Env != <<label,R1,pred,1>>
		       Env != <<anchor,R1,sing,1>>
		       Env != <<label,SA1,subj,1>>]
     WalkEnv :: [Env ! Env != <<label,R1,pred,1>>
		       Env != <<anchor,R1,walk,1>>
		       Env != <<label,WA1,subj,1>>]
     Run :: [Env ! Env != <<label,R1,pred,1>>
		   Env != <<anchor,R1,run,1>>
		   Env != <<label,RA1,subj,1>>]
     TalkEnv :: [Env ! Env != <<label,R1,pred,1>>
		       Env != <<anchor,R1,talk,1>>
		       Env != <<label,TA1,subj,1>>]
     LikeEnv :: [Env ! Env != <<label,R1,pred,1>>
		       Env != <<anchor,R1,like,1>>
		       Env != <<label,LA1,subj,1>>
		       Env != <<label,LA2,obj,1>>]
     BeatEnv :: [Env ! Env != <<label,R1,pred,1>>
		       Env != <<anchor,R1,beat,1>>
		       Env != <<label,BA1,subj,1>>
		       Env != <<label,BA2,obj,1>>]
     ManEnv :: [Env ! Env != <<label,R1,pred,1>>
		      Env != <<anchor,R1,man,1>>
		      Env != <<label,MA1,arg1,1>>]
     DonkeyEnv :: [Env ! Env != <<label,R1,pred,1>>
		         Env != <<anchor,R1,donkey,1>>
		         Env != <<label,DA1,arg1,1>>]
     AEnv :: [Env ! Env != <<label,Q1,quantifier,1>>
                    Env != <<anchor,Q1,some,1>>
                    Env != <<label,A1,var,1>>
                    Env != <<label,A2,range,1>>
                    Env != <<label,A3,body,1>>]
     EveryEnv :: [Env ! Env != <<label,Q1,quantifier,1>>
		        Env != <<anchor,Q1,every,1>>
		        Env != <<label,A1,var,1>>
		        Env != <<label,A2,range,1>>
		        Env != <<label,A3,body,1>>]
    )

GoalProp
   *S : [S ! S != <<cat,S,sentence,1>>
             S != <<basis,S,*Basis,1>>]

Constraints
;;;
;;;  A rather exhaustive set of constraints need to be specified
;;;  although they really all deal with different cases of the same
;;;  notional constraint.  They can be viewed in two classes, First
;;;  the constraint that find the bases for sentences, that is where
;;;  the the anchor environment is fully specified.  The other for
;;;  verbatprhases only reduces as much as there anchorings --
;;;  actually this part is a little too hard-wired.
;;;
;;;  Also these specification are incomplete as anchors will not be
;;;  applied to parameters that are part of acnhors of other
;;;  parameters (full beta-reduction).  Some solution to this should
;;;  be sought.
;;;

*S : [S ! S != <<basis,S,<<*VR1,*VA1,*VA2,*VA3,1>>,1>>]
<=
   *S : [S ! S != <<cat,S,sentence,1>>
             S != <<sem,S,<<*R1,*A1,*A2,*A3,1>>,1>>
             S != <<env,S,*SEnv ::
                          [Env ! Env != <<anchor,*R1,*VR1,1>>
                                 Env != <<anchor,*A1,*VA1,1>>
                                 Env != <<anchor,*A2,*VA2,1>>
                                 Env != <<anchor,*A3,*VA3,1>>],1>>].

*S : [S ! S != <<basis,S,<<*VR1,*VA1,*VA2,*VA3,1>>,1>>]
<=
   *S : [S ! S != <<cat,S,VerbPhrase,1>>
             S != <<env,S,*SEnv ::
                          [Env ! Env != <<anchor,*R1,*VR1,1>>
                                 Env != <<anchor,*A1,*VA1,1>>
                                 Env != <<anchor,*A2,*VA2,1>>
                                 Env != <<anchor,*A3,*VA3,1>>],1>>
             S != <<sem,S,<<*R1,*A1,*A2,*A3,1>>,1>>].

*S : [S ! S != <<basis,S,<<*VR1,*VA1,*VA2,1>>,1>>]
<=
   *S : [S ! S != <<cat,S,sentence,1>>
             S != <<sem,S,<<*R1,*A1,*A2,1>>,1>>
             S != <<env,S,*SEnv ::
                          [Env ! Env != <<anchor,*R1,*VR1,1>>
                                 Env != <<anchor,*A1,*VA1,1>>
                                 Env != <<anchor,*A2,*VA2,1>>],1>>].

*S : [S ! S != <<basis,S,<<*VR1,*A1,*VA2,1>>,1>>]
<=
   *S : [S ! S != <<cat,S,VerbPhrase,1>>
             S != <<env,S,*VPEnv ::
                          [Env ! Env != <<anchor,*R1,*VR1,1>>
                                 Env != <<anchor,*A2,*VA2,1>>],1>>
             S != <<sem,S,<<*R1,*A1,*A2,1>>,1>>].

*S : [S ! S != <<basis,S,<<*VR1,*VA1,1>>,1>>]
<=
   *S : [S ! S != <<cat,S,sentence,1>>
             S != <<sem,S,<<*R1,*A1,1>>,1>>
             S != <<env,S,*SEnv ::
                          [Env ! Env != <<anchor,*R1,*VR1,1>>
                                 Env != <<anchor,*A1,*VA1,1>>],1>>].

*S : [S ! S != <<basis,S,<<*VR1,*A1,1>>,1>>]
<=
   *S : [S ! S != <<cat,S,VerbPhrase,1>>
             S != <<sem,S,<<*R1,*A1,1>>,1>>
             S != <<env,S,*VPEnv ::
                          [Env ! Env != <<anchor,*R1,*VR1,1>>],1>>].

Grammar Rules
;;;
;;;   S -> NP VP
;;;
;;;   As Proper nouns are not be treated like quantifiers (a la
;;;   Montague) two rules are necessary, one to deal with a proper
;;;   noun subject and a second to deal with a quantified NP.
;;;
   [S ! S != <<cat,S,Sentence,1>>
        S != <<tense,S,pres,1>>
        S != <<sem,S,*Fact,1>>
        S != <<env,S,*SEnv :: *EnvType & 
                              [Env ! Env != <<anchor,*X,*Y,1>>],1>>]
   ->
    [NP ! NP != <<cat,NP,NounPhrase,1>>
          NP != <<anaphoric_mode,NP,proper,1>>
          NP != <<sem,NP,*Y,1>>],
    [VP ! VP != <<cat,VP,VerbPhrase,1>>
          VP != <<tense,VP,pres,1>>
          VP != <<sem,VP,*Fact,1>>
          VP != <<env,VP,*VPEnv :: *EnvType & 
                                   [Env ! Env != <<label,*X,subj,1>>],
  		       1>>].

   [S ! S != <<cat,S,Sentence,1>>
        S != <<tense,S,pres,1>>
        S != <<sem,S,*Qexpr,1>>
        S != <<env,S,*SEnv :: *EnvType & 
                              [Env ! Env != <<anchor,*Y,*Var,1>>
                                     Env != <<anchor,*Body,*Basis,1>>],
                   1>>]
   ->
    [NP ! NP != <<cat,NP,NounPhrase,1>>
          NP != <<sem,NP,*Qexpr,1>>
          NP != <<env,NP, *Env :: *EnvType &
                                  [Env ! Env != <<label,*Body,body,1>>
                                         Env != <<label,*X,var,1>>
                                         Env != <<anchor,*X,*Var,1>>],1>>],
    [VP ! VP != <<cat,VP,VerbPhrase,1>>
          VP != <<tense,VP,pres,1>>
          VP != <<basis,VP,*Basis,1>>
          VP != <<env,VP,*VPEnv :: [Env ! Env != <<label,*Y,subj,1>>],
  		       1>>
          VP != <<sem,VP,*Fact,1>>].
;;;
;;;   VP -> V NP
;;;   
;;;   Again two rules, one for a proper noun object and the second for
;;;   quantified NPs.
;;;
    [VP ! VP != <<cat,VP,VerbPhrase,1>>
          VP != <<tense,VP,*tense,1>>
          VP != <<env,VP,*VPEnv :: *EnvType &
                                   [Env ! Env != <<anchor,*Body,
	 						<<*pred,*Y,*Var,1>>,1>>
                                          Env != <<label,*Y,subj,1>>],
                      1>>
          VP != <<sem,VP,*Qexpr,1>>]
    ->
       [V ! V != <<cat,V,Verb,1>>
            V != <<tense,V,*tense,1>>
            V != <<env,V,*Env :: [Env ! Env != <<label,*Y,subj,1>>
				        Env != <<label,*R1,pred,1>>
                                        Env != <<anchor,*R1,*pred,1>>],
  		       1>>
            V != <<sem,V,*Fact,1>>],
       [NP ! NP != <<cat,NP,NounPhrase,1>>
             NP != <<env,NP,*Env :: *Envtype & 
                                    [Env ! Env != <<label,*Range,range,1>>
                                           Env != <<label,*Body,body,1>>
                                           Env != <<label,*Pvar,var,1>>
                                           Env != <<anchor,*Pvar,*Var,1>>],
  		       1>>
             NP != <<sem,NP,*Qexpr,1>>].

    [VP ! VP != <<cat,VP,VerbPhrase,1>>
          VP != <<tense,VP,*tense,1>>
          VP != <<env,VP,*VPEnv :: *EnvType &
                                   [Env ! Env != <<anchor,*X,*Y,1>>],1>>
          VP != <<sem,VP,*Fact,1>>]
    ->
       [V ! V != <<cat,V,Verb,1>>
            V != <<tense,V,*tense,1>>
            V != <<env,V,*Env :: *Envtype & [Env ! Env != <<label,*X,obj,1>>],
  		       1>>
            V != <<sem,V,*Fact,1>>],
       [NP ! NP != <<cat,NP,NounPhrase,1>>
             NP != <<anaphoric_mode,NP,proper,1>>
             NP != <<sem,NP,*Y,1>>].

;;;
;;;   NP -> Det N
;;;
    [NP ! NP != <<cat,NP,NounPhrase,1>>
          NP != <<sem,NP,*QEXPR,1>>
          NP != <<env,NP,*NPEnv :: 
                         *EnvType &
                         [Env ! Env != <<anchor,*X,*A1,1>>
                                Env != <<anchor,*Range,
                                                <<*pred,*A1,1>>,1>>],
                      1>>]
    ->
      [DET ! DET != <<cat,DET,Determiner,1>>
             DET != <<sem,DET,*QEXPR,1>>
             DET != <<env,DET,*DetEnv :: 
                              *EnvType &
                              [Env ! Env != <<label,*Range,range,1>>
                                     Env != <<label,*X,var,1>>],1>>],
      [N ! N != <<cat,N,noun,1>>
           N != <<env,N,*Env :: [Env ! Env != <<label,*A1,arg1,1>>
                                       Env != <<anchor,*R1,*pred,1>>],1>>
           N != <<sem,N,<<*R1,*A1,1>>,1>>].

;;;
;;;                  ***** Lexical Entries *****
;;;
;;; A basic set of lexical entries to allow some the simple classic
;;; sentences.  Note the the constraints above are sometimes used to
;;; expand entries (i.e like Lexical Redunancy Rules).
;;;
;;;
Lexical Entries

;;;
;;;   Nouns
;;;
Hanako - 
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"Hanako",1>>
         PN != <<person,PN,third,1>>
         PN != <<anaphoric_mode,PN,proper,1>>
         PN != <<sem,PN,h,1>>]
Taro -
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"Taro",1>>
         PN != <<person,PN,third,1>>
         PN != <<anaphoric_mode,PN,proper,1>>
         PN != <<sem,PN,t,1>>]
Anna - 
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"Anna",1>>
         PN != <<person,PN,third,1>>
         PN != <<anaphoric_mode,PN,proper,1>>
         PN != <<sem,PN,a,1>>]
man -
   [N ! N != <<cat,N,Noun,1>>
        N != <<use_of,N,"man",1>>
        N != <<person,N,third,1>>
        N != <<sem,N,<<R1,MA1,1>>,1>>
        N != <<env,N,ManEnv,1>>]
donkey -
   [N ! N != <<cat,N,Noun,1>>
        N != <<use_of,N,"donkey",1>>
        N != <<person,N,third,1>>
        N != <<sem,N,<<R1,DA1,1>>,1>>
        N != <<env,N,DonkeyEnv,1>>]
;;;
;;;   Pronouns
;;;
;;;   Not used in this actual description
;;;
he - 
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"he",1>>
         PN != <<person,PN,third,1>>
         PN != <<anaphoric_mode,PN,pronominal,1>>
         PN != <<case,PN,nom,1>> 
         PN != <<sem,PN,*X,1>>]
she - 
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"she",1>>
         PN != <<person,PN,third,1>>
         PN != <<anaphoric_mode,PN,pronominal,1>>
         PN != <<case,PN,nom,1>>
         PN != <<sem,PN,*X,1>>]
it - 
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"it",1>>
         PN != <<person,PN,third,1>>
         PN != <<anaphoric_mode,PN,pronominal,1>>
         PN != <<sem,PN,*X,1>>]
;;;
;;;   Determiners
;;;
;;;   Their semantics is a relation between a variable (a parameter)
;;;   and a range (a fact) and a body (a fact too).
;;;
a - 
   [DET ! DET != <<cat,DET,Determiner,1>>
          DET != <<use_of,DET,"a",1>>
          DET != <<sem,DET,<<Q1,A1,A2,A3,1>>,1>>
          DET != <<env,DET,AEnv,1>>]
every - 
   [DET ! DET != <<cat,DET,Determiner,1>>
          DET != <<use_of,DET,"every",1>>
          DET != <<sem,DET,<<Q1,A1,A2,A3,1>>,1>>
          DET != <<env,DET,EveryEnv,1>>]
;;;
;;;   Verbs
;;;
smiles -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"smiles",1>>
         VP != <<tense,VP,pres,1>>
         VP != <<sem,VP, <<R1,SMA1,1>>,1>>
         VP != <<env,VP,SmileEnv,1>>]
sings -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"sings",1>>
         VP != <<tense,VP,pres,1>>
         VP != <<sem,VP, <<R1,SA1,1>>,1>>
         VP != <<env,VP,SingEnv,1>>]
walks -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"walks",1>>
         VP != <<tense,VP,pres,1>>
         VP != <<sem,VP, <<R1,WA1,1>>,1>>
         VP != <<env,VP,WalkEnv,1>>]
talks -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"talks",1>>
         VP != <<tense,VP,pres,1>>
         VP != <<sem,VP,<<R1,TA1,1>>,1>>
         VP != <<env,VP,TalkEnv,1>>]
runs -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"runs",1>>
         VP != <<tense,VP,pres,1>>
         VP != <<sem,VP,<<R1,RA1,1>>,1>>
         VP != <<env,VP,RunEnv,1>>]
likes -
   [V ! V != <<cat,V,Verb,1>>
        V != <<use_of,V,"likes",1>>
        V != <<tense,V,pres,1>>
        V != <<env,V,LikeEnv,1>>
        V != <<sem,V,<<R1,LA1,LA2,1>>,1>>]
beats -
   [V ! V != <<cat,V,Verb,1>>
        V != <<use_of,V,"beats",1>>
        V != <<tense,V,pres,1>>
        V != <<sem,V,<<R1,BA1,BA2,1>>,1>>
        V != <<env,V,BeatEnv,1>>]
;;;
;;;  Prepositions
;;;
to - 
     [PREP ! PREP != <<cat,PREP,Preposition,1>>
             PREP != <<pform,PREP,to,1>>
             PREP != <<use_of,PREP,"to",1>>]
with - 
     [PREP ! PREP != <<cat,PREP,Preposition,1>>
             PREP != <<pform,PREP,with,1>>
             PREP != <<use_of,PREP,"with",1>>]
on - 
     [PREP ! PREP != <<cat,PREP,Preposition,1>>
             PREP != <<pform,PREP,on,1>>
             PREP != <<use_of,PREP,"on",1>>]

