;;;
;;;   File: th-drt+.st
;;;   Alan W Black (awb@ed.ac.uk) October 91
;;;   
;;;   Modified <Aug 92> from th-drt.st to deal with simple event
;;;   discourse markers.
;;;
;;;   A description of DRT in astl.  Again based on the [Rooth87] fragment
;;;   Unlike the STG description this now deals with pronouns, (including
;;;   donkey anaphora).
;;;
;;;   Unlike the STG description the semantics (DRS) is built up
;;;   using a threading technique rather than what is effectively lambda
;;;   application and reduction.  Threading relations are set up between
;;;   utterance situations specified an order.  The DRSs are specified
;;;   as montonically increasing over threads.
;;;
;;;   Problems
;;;     PPs in PPs case a loop in the threads
;;;

Individuals
    {h,t,a,p}
Relations
    ( use_of/2 cat/2 
      sem/2 env/2 type/2 threads/2
      NounPhrase/1 Sentence/1 VerbPhrase/1 Discourse/1 
      ProperNoun/1 ProNoun/1 PrepPhrase/1 Preposition/1
      FullDiscourse/1 DisStart/1 DisEnd/1
      subj/1 pred/1 
      label/2 anchor/2
      sing/1 like/2 smile/1
      donkey/1 man/1 hat/1 with/2
      named/2 male/1 female/1 neuter/1
      DRSIn/2 DRSOut/2
      t-in/2 t-out/2 t-feed/2 t-need/2
      accessible/2
    )
Hush            ;; relations not to be displayed on output (by default)
    (daughter threads)
Parameters
    {R1,A1,A2,A3,S,S1,S2,TS,NP,VP,PN,V,Env,DS,Res,
     PN1, PN2, PN3, A, PREP, PP,
     DA1, MA1, HA1, T, H, P,D,D2  }
Variables
    {*X, *Y, *Z, *S, *U, *Fact, *VPEnv, *SEnv, *VPEnvType, *VEnv, *VEnvType,
     *Env, *PPEnv, *PEnv, *EnvType, *Nenv,
     *R1, *A1, *A2, *VR1, *VA1, *VA2, *DS, *DS1, *PN,
     *pred, 
     *DRSInType, *DRSIn, *DRSout,
     *ThreadS, *ThreadNP, *ThreadVP, *ThreadV, *Thread, *ThreadDS, 
     *ThreadDS1, *TYPE, *OUT,
     *A, *ACC1, *AType, *OUT1, *M1, *M2,
     *QEXPR, *Range, *Body, *BodyDRS, *RangeDRS,
     *QUANT, *PQUANT, *PVAR, *PRANGE, *PBODY, *Name
     *T1, *T2, *T3, *S1, *S2, *P1, *P2, *NPSem, *SSem, *EDM,
     *NP, *VP, *V, *N, *DET, *PP, *PREP, *N1, *D, *D1, *D2}
Situations
    (SingEnv :: [Env ! Env != <<label,R1,pred,1>>
		       Env != <<anchor,R1,sing,1>>
		       Env != <<label,A1,subj,1>>]
     SmileEnv :: [Env ! Env != <<label,R1,pred,1>>
		        Env != <<anchor,R1,smile,1>>
		        Env != <<label,A1,subj,1>>]
     WalkEnv :: [Env ! Env != <<label,R1,pred,1>>
                       Env != <<anchor,R1,walk,1>>
                       Env != <<label,WA1,subj,1>>]
     TalkEnv :: [Env ! Env != <<label,R1,pred,1>>
                       Env != <<anchor,R1,talk,1>>
                       Env != <<label,TA1,subj,1>>]
     LikeEnv :: [Env ! Env != <<label,R1,pred,1>>
		       Env != <<anchor,R1,like,1>>
		       Env != <<label,A1,subj,1>>
		       Env != <<label,A2,obj,1>>]
     SeeEnv :: [Env ! Env != <<label,R1,pred,1>>
	              Env != <<anchor,R1,see,1>>
		      Env != <<label,A1,subj,1>>
		      Env != <<label,A2,obj,1>>]
     ManEnv :: [Env ! Env != <<label,R1,pred,1>>
		      Env != <<anchor,R1,man,1>>
		      Env != <<label,MA1,arg1,1>>]
     DonkeyEnv :: [Env ! Env != <<label,R1,pred,1>>
		         Env != <<anchor,R1,donkey,1>>
		         Env != <<label,DA1,arg1,1>>]
     HatEnv :: [Env ! Env != <<label,R1,pred,1>>
		      Env != <<anchor,R1,hat,1>>
		      Env != <<label,HA1,arg1,1>>]
     AEnv :: [Env ! Env != <<label,Q1,quantifier,1>>
                    Env != <<anchor,Q1,some,1>>
                    Env != <<label,A1,var,1>>
                    Env != <<label,A2,range,1>>
                    Env != <<label,A3,body,1>>]
     EveryEnv :: [Env ! Env != <<label,Q1,quantifier,1>>
		        Env != <<anchor,Q1,every,1>>
		        Env != <<label,A1,var,1>>
		        Env != <<label,A2,range,1>>
		        Env != <<label,A3,body,1>>]
     WithEnv :: [Env ! Env != <<label,P1,prep,1>>
		       Env != <<anchor,P1,with,1>>
		       Env != <<label,A1,arg1,1>>
		       Env != <<label,A2,arg2,1>>]
     DRSStart AccessStart
     Dstart :: [S ! S != <<cat,S,Discourse,1>>
                    S != <<DRSout,S,DRSStart,1>>
                    S != <<accessible,S,AccessStart,1>>]
     SitResource :: [Res ! Res != <<named,h,"Hanako",1>>
                           Res != <<female,h,1>>
                           Res != <<named,a,"Anna",1>>
                           Res != <<female,a,1>>
                           Res != <<named,p,"Pedro",1>>
                           Res != <<neuter,p,1>>
                           Res != <<named,t,"Taro",1>>
                           Res != <<male,t,1>>]
    )
GoalProp
   *S : [S ! S != <<cat,S,fulldiscourse,1>>
             S != <<DRSOut,S,*DRSout,1>> 
        ]

Constraints
;;;
;;;  These first set of constraints define the relationship between
;;;  the incoming DRS and the outgoing DRS in the various types of
;;;  node.  The only interesting ones are sentences where a new 
;;;  condition is added, propernouns where type information male/female
;;;  is added and pronouns where the current DRSIn is check for a 
;;;  object of the right type that has already been mentioned.
;;;  The other utterance types simply "copy" the DRSIn to DRSOut.
;;;
   *S : [S ! S != <<DRSOut,S,*DRSOut :: *DRSInType &
                                       [DS ! DS != <<*VR1,*VA1,1>>],1>>]
   <=
      *S : [S ! S != <<cat,S,sentence,1>>
                S != <<DRSIn,S,*DRSIn :: *DRSInType,1>>
                S != <<sem,S,<<*R1,*A1,1>>,1>>
                S != <<env,S,*SEnv ::
                             [Env ! Env != <<anchor,*R1,*VR1,1>>
                                    Env != <<anchor,*A1,*VA1,1>>],1>>].

   *S : [S ! S != <<DRSOut,S,*DRSOut ::
                               *DRSInType &
                               [DS ! DS != <<*VR1,*VA1,*VA2,1>>],1>>]
   <=
      *S : [S ! S != <<cat,S,sentence,1>>
                S != <<daughter,S,
                       *D1 :: [D ! D != <<cat,D,verbphrase,1>>
                                   D != <<daughter,S,*D2 ::
                                        [D2 ! D2 != <<cat,D2,nounphrase,1>>],
                                          1>>],1>>
                S != <<DRSIn,S,*DRSIn :: *DRSInType,1>>
                S != <<sem,S,<<*R1,*A1,*A2,1>>,1>>
                S != <<env,S,*SEnv ::
                             [Env ! Env != <<anchor,*R1,*VR1,1>>
                                    Env != <<anchor,*A1,*VA1,1>>
				    Env != <<anchor,*A2,*VA2,1>>],1>>].

   *S : [S ! S != <<DRSOut,S,*DRSOut ::
                               *DRSInType &
                               [DS ! DS != <<*VR1,*VA1,*DS,1>>
                                     DS != <<label,*EDM,*DS,1>>
                                     DS != <<neuter,*EDM,1>>],1>>]
   <=
      *S : [S ! S != <<cat,S,sentence,1>>
                S != <<daughter,S,
                       *D1 :: [D ! D != <<cat,D,verbphrase,1>>
                                   D != <<daughter,D,*D2 ::
                                        [D2 ! D2 != <<cat,D2,sentence,1>>
                                              D2 != <<threads,D2,*Y ::
                           [TS ! TS != <<t-out,*D2,*X ::
                             [S ! S != <<relevant,S,1>>
                                  S != <<DRSOut,S,*DS,1>>],1>>],1>>],
                                          1>>],1>>
                S != <<DRSIn,S,*DRSIn :: *DRSInType,1>>
                S != <<sem,S,<<*R1,*A1,*A2,1>>,1>>
                S != <<env,S,*SEnv ::
                             [Env ! Env != <<anchor,*R1,*VR1,1>>
                                    Env != <<anchor,*A1,*VA1,1>>
				    Env != <<anchor,*A2,*VA2,1>>],1>>].
      

   *S : [S ! S != <<described,S,*DS :: [DS ! DS != <<*VR1,*VA1,1>>],1>>]
   <=
      *S : [S ! S != <<cat,S,sentence,1>>
                S != <<sem,S,<<*R1,*A1,1>>,1>>
                S != <<env,S,*SEnv ::
                             [Env ! Env != <<anchor,*R1,*VR1,1>>
                                    Env != <<anchor,*A1,*VA1,1>>],1>>].

   *S : [S ! S != <<described,S,*DS :: 
                               [DS ! DS != <<*VR1,*VA1,*VA2,1>>],1>>]
   <=
      *S : [S ! S != <<cat,S,sentence,1>>
                S != <<sem,S,<<*R1,*A1,*A2,1>>,1>>
                S != <<env,S,*SEnv ::
                             [Env ! Env != <<anchor,*R1,*VR1,1>>
                                    Env != <<anchor,*A1,*VA1,1>>
				    Env != <<anchor,*A2,*VA2,1>>],1>>].

*S : [S ! S != <<DRSout,S,*DRSout ::
                        *DRSInType &
                        [DS ! DS != <<named,*X,*Name,1>>
                              DS != <<*TYPE,*X,1>>],1>>]
  <= 
      *S : [S ! S != <<cat,S,ProperNoun,1>>
                S != <<use_of,S,*Name,1>>
                S != <<sem,S,*X,1>>
                S != <<DRSIn,S,*DRSIn :: *DRSInType,1>>],
      SitResource : [Res ! Res != <<*TYPE,*X,1>>].

*S : [S ! S != <<DRSout,S,*DRSout ::
                        *DRSInType &
                        [DS ! DS != <<is,*X,*Y,1>>],1>>]
  <= 
      *S : [S ! S != <<cat,S,Pronoun,1>>
                S != <<type,S,*TYPE,1>>
                S != <<sem,S,*X,1>>
                S != <<DRSIn,S,*DRSIn :: *DRSInType,1>>
		S != <<accessible,S,*A ::
                            [A ! A != <<*TYPE,*Y,1>>],1>>
            ].

*S : [S ! S != <<DRSOut,S,*DRSOut ::
                           *DRSInType &
                           [DS ! DS != <<every,*RangeDRS,*BodyDRS,1>>],1>>]
  <= 
      *S : [S ! S != <<cat,S,Determiner,1>>
	        S != <<DRSIn,S,*DRSIn :: *DRSInType,1>>
                S != <<sem,S,<<*PQUANT,*X,*Y,*Z,1>>,1>>
                S != <<env,S,*SEnv ::
                             [Env ! Env != <<anchor,*PQUANT,every,1>>],1>>],
      *T1 : [TS ! TS != <<relevant,TS,1>>
                  TS != <<t-body,*S,*Body ::
                             [S ! S != <<relevant,S,1>>
                                  S != <<DRSOut,S,*BodyDRS,1>>],1>>],
      *T2 : [TS ! TS != <<relevant,TS,1>>
                  TS != <<t-range,*S,*Range ::
                             [S ! S != <<relevant,S,1>>
                                  S != <<DRSOut,S,*RangeDRS,1>>],1>>].

*S : [S ! S != <<DRSOut,S,*DRSOut ::
                            *DRSInType ,1>>]
  <= 
      *S : [S ! S != <<cat,S,Determiner,1>>
                S != <<sem,S,<<*PQUANT,*X,*Y,*Z,1>>,1>>
                S != <<env,S,*SEnv ::
                              [Env ! Env != <<anchor,*PQUANT,some,1>>],1>>],
      *T2 : [TS ! TS != <<relevant,TS,1>>
                  TS != <<t-body,*S,*Body ::
                      [S ! S != <<relevant,S,1>>
                           S != <<DRSOut,S,*BodyDRS :: *DRSInType ,1>>],1>>].

*S : [S ! S != <<DRSOut,S,*DRSOut,1>>]
  <= 
      *S : [S ! S != <<cat,S,NounPhrase,1>>
                S != <<daughter,S,*DS :: [DS ! DS != <<cat,DS,determiner,1>>],1>>
                S != <<DRSIn,S,*DRSOut,1>>].

*S : [S ! S != <<DRSOut,S,*BodyDRS,1>>]
  <= 
      *S : [S ! S != <<cat,S,NounPhrase,1>>
                S != <<daughter,S,*DS :: [DS ! DS != <<cat,DS,ProperNoun,1>>],1>>],
      *T2 : [TS ! TS != <<relevant,TS,1>>
                  TS != <<t-body,*S,*Body ::
                     [S ! S != <<relevant,S,1>>
                          S != <<DRSOut,S,*BodyDRS,1>>],1>>].
*S : [S ! S != <<DRSOut,S,*BodyDRS,1>>]
  <= 
      *S : [S ! S != <<cat,S,NounPhrase,1>>
                S != <<daughter,S,*DS :: [DS ! DS != <<cat,DS,ProNoun,1>>],1>>],
      *T2 : [TS ! TS != <<relevant,TS,1>>
                  TS != <<t-body,*S,*Body ::
                      [S ! S != <<relevant,S,1>>
                           S != <<DRSOut,S,*BodyDRS,1>>],1>>].

*S : [S ! S != <<DRSOut,S,*DRSOut :: *DRSInType &
                              [DS ! DS != <<*VR1,*A1,1>>
                                    DS != <<*TYPE,*A1,1>>],1>>]
  <= 
      *S : [S ! S != <<cat,S,Noun,1>>
                S != <<use_of,S,*X,1>>
                S != <<sem,S,<<*R1,*A1,1>>,1>>
                S != <<type,S,*TYPE,1>>
                S != <<env,S,*SEnv ::
                              [Env ! Env != <<anchor,*R1,*VR1,1>>],1>>
                S != <<DRSIn,S,*DRSIn :: *DRSInType,1>>].

*S : [S ! S != <<DRSOut,S,*DRSOut :: *DRSInType &
                             [DS ! DS != <<*VR1,*VA1,*VA2,1>>],1>>]
  <= 
      *S : [S ! S != <<cat,S,Noun,1>>
                S != <<env,S,*SEnv ::
                              [Env ! Env != <<label,*VA1,arg1,1>>],1>>
                 S != <<daughter,S,*PP ::
                         [PP ! PP != <<cat,PP,PrepPhrase,1>>
                               PP != <<sem,PP,<<*R1,*A1,*A2,1>>,1>>
                               PP != <<env,PP,*Env ::
                                       [Env ! Env != <<anchor,*R1,*VR1,1>>
                                              Env != <<anchor,*A2,*VA2,1>>],1>>],1>>
                 S != <<DRSIn,S,*DRSIn :: *DRSIntype,1>>
            ].

*S : [S ! S != <<DRSOut,S,*DRSOut,1>>]
  <= 
      *S : [S ! S != <<cat,S,VerbPhrase,1>>
                S != <<DRSIn,S,*DRSOut,1>>].


*S : [S ! S != <<DRSOut,S,*BodyDRS,1>>]
  <= 
      *S : [S ! S != <<cat,S,Verb,1>>
                S != <<sem,S,<<*R1,*A1,1>>,1>>],
;;                S != <<DRSIn,S,*DRSOut,1>>].
      *T2 : [TS ! TS != <<relevant,TS,1>>
                  TS != <<t-body,*S,*Body ::
                     [S ! S != <<relevant,S,1>>
                          S != <<DRSOut,S,*BodyDRS,1>>],1>>].

*S : [S ! S != <<DRSOut,S,*DRSOut,1>>]
  <= 
      *S : [S ! S != <<cat,S,Verb,1>>
                S != <<sem,S,<<*R1,*A1,*A2,1>>,1>>
                S != <<DRSIn,S,*DRSOut,1>>].

*S : [S ! S != <<DRSOut,S,*DRSOut,1>>]
  <= 
      *S : [S ! S != <<cat,S,VerbSubCatS,1>>
                S != <<DRSIn,S,*DRSOut,1>>].

*S : [S ! S != <<DRSOut,S,*DRSOut,1>>]
  <= 
      *S : [S ! S != <<cat,S,Preposition,1>>
                S != <<DRSIn,S,*DRSOut,1>>].

*S : [S ! S != <<DRSOut,S,*DRSOut,1>>]
  <= 
      *S : [S ! S != <<cat,S,PrepPhrase,1>>
                S != <<DRSIn,S,*DRSOut,1>>].

*S : [S ! S != <<DRSOut,S,*DRSOut,1>>]
  <= 
      *S : [S ! S != <<cat,S,Discourse,1>>
                S != <<DRSIn,S,*DRSOut,1>>].

*S : [S ! S != <<DRSOut,S,*DRSOut,1>>
          S != <<accessible,S,*A,1>>
      ]
  <= 
      *S : [S ! S != <<cat,S,FullDiscourse,1>>
                S != <<threads,S,*T1 ::
                          [TS ! TS != <<t-out,*S,*X ::
                            [DS ! DS != <<DRSOut,DS,*DRSOut,1>>
                                  DS != <<accessible,DS,*A,1>>
                            ],1>>],1>>
           ].

;;;
;;;  The accessible domain markers are defined in a similar way to
;;;  the DRSs they are threaded in the same way, though the threads
;;;  at a determiner utterance are slightly different.
;;;
;;;  In constrast to the DRS threading we include the threading
;;;  information within the the accessible constraints rather than
;;;  have a DRSIn and DRSOut and a separate constraint for following
;;;  threading.  I believe there is no theoretical advantage in
;;;  either technique.
;;;
;;;  The first three (verbal) simply pass the accessible markers
;;;  on with no change
;;;
*S : [S ! S != <<accessible,S,*A,1>>]
  <= 
    *S : [S ! S != <<cat,S,Verb,1>>
              S != <<sem,S,<<*R1,*A1,*A2,1>>,1>>],
    *T1 : [TS ! TS != <<relevant,TS,1>>
                TS != <<t-in,*S,*S1 ::
                                [S1 ! S1 != <<accessible,S1,*A,1>>],1>>].
*S : [S ! S != <<accessible,S,*A,1>>]
  <= 
    *S : [S ! S != <<cat,S,Verb,1>>
              S != <<sem,S,<<*R1,*A1,1>>,1>>],
    *T1 : [TS ! TS != <<relevant,TS,1>>
                TS != <<t-body,*S,*S1 ::
                                  [S1 ! S1 != <<relevant,S1,1>>
                                        S1 != <<accessible,S1,*A,1>>],1>>].
*S : [S ! S != <<accessible,S,*A,1>>]
  <= 
    *S : [S ! S != <<cat,S,VerbSubCatS,1>>],
    *T1 : [TS ! TS != <<relevant,TS,1>>
                TS != <<t-in,*S,*S1 ::
                                 [S1 ! S1 != <<accessible,S1,*A,1>>],1>>].
*S : [S ! S != <<accessible,S,*A,1>>]
  <= 
    *S : [S ! S != <<cat,S,VerbPhrase,1>>],
    *T1 : [TS ! TS != <<relevant,TS,1>>
                TS != <<t-in,*S,*S1 ::
                                 [S1 ! S1 != <<accessible,S1,*A,1>>],1>>].
*S : [S ! S != <<accessible,S,*A,1>>]
  <= 
    *S : [S ! S != <<cat,S,Sentence,1>>],
    *T1 : [TS ! TS != <<relevant,TS,1>>
                TS != <<t-in,*S,*S1 ::
                                 [S1 ! S1 != <<accessible,S1,*A,1>>],1>>].
*S : [S ! S != <<accessible,S,*A,1>>]
  <= 
    *S : [S ! S != <<cat,S,Discourse,1>>],
    *T1 : [TS ! TS != <<relevant,TS,1>>
                TS != <<t-in,*S,*S1 ::
                                 [S1 ! S1 != <<accessible,S1,*A,1>>],1>>].
*S : [S ! S != <<accessible,S,*A,1>>]
  <= 
    *S : [S ! S != <<cat,S,Preposition,1>>],
    *T1 : [TS ! TS != <<relevant,TS,1>>
                TS != <<t-in,*S,*S1 ::
                                [S1 ! S1 != <<accessible,S1,*A,1>>],1>>].
*S : [S ! S != <<accessible,S,*A,1>>]
  <= 
    *S : [S ! S != <<cat,S,PrepPhrase,1>>],
    *T1 : [TS ! TS != <<relevant,TS,1>>
                TS != <<t-in,*S,*S1 ::
                                [S1 ! S1 != <<accessible,S1,*A,1>>],1>>].

*S : [S ! S != <<accessible,S,*A,1>>]
  <= 
    *S : [S ! S != <<cat,S,Marker,1>>
              S != <<access,S,*X :: [S1 ! S1 != <<accessible,S1,*A,1>>],1>>].

;;;
;;;  The next (nominal) constraints (potentially) add new markers
;;;  the the accessible situation.
;;;

;;; lexical noun
*S : [S ! S != <<accessible,S,*A :: *AType &
                                    [A ! A != <<*TYPE,*A1,1>>],1>>]
  <= 
    *S : [S ! S != <<cat,S,Noun,1>>
              S != <<sem,S,<<*R1,*A1,1>>,1>>
              S != <<type,S,*TYPE,1>>],
    *T1 : [TS ! TS != <<relevant,TS,1>>
                TS != <<t-in,*S,*S1 ::
                      [S1 ! S1 != <<accessible,S1,*ACC1 :: *AType ,1>>],1>>].

;;; noun with PP
*S : [S ! S != <<accessible,S,*A,1>>]
  <= 
    *S : [S ! S != <<cat,S,Noun,1>>
              S != <<sem,S,<<*R1,*A1,1>>,1>>
              S != <<daughter,S,*X,1>>],
    *T1 : [TS ! TS != <<relevant,TS,1>>
                TS != <<t-in,*S,*S1 ::
                       [S1 ! S1 != <<accessible,S1,*A,1>>],1>>].

*S : [S ! S != <<accessible,S,*A :: *AType &
                                    [A ! A != <<*TYPE,*A1,1>>],1>>]
  <= 
    *S : [S ! S != <<cat,S,ProperNoun,1>>
              S != <<sem,S,*A1,1>>],
    SitResource : [S ! S != <<*TYPE,*A1,1>>],
    *T1 : [TS ! TS != <<relevant,TS,1>>
                TS != <<t-in,*S,*S1 ::
                      [S1 ! S1 != <<accessible,S1,*ACC1 :: *AType ,1>>],1>>].

*S : [S ! S != <<accessible,S,*A,1>>]
  <= 
    *S : [S ! S != <<cat,S,NounPhrase,1>>
              S != <<daughter,S,*DS :: [DS ! DS != <<cat,DS,ProperNoun,1>>],1>>],
    *T1 : [TS ! TS != <<relevant,TS,1>>
                TS != <<t-body,*S,*S1 ::
                                  [S1 ! S1 != <<relevant,S1,1>>
                                        S1 != <<accessible,S1,*A,1>>],1>>].
*S : [S ! S != <<accessible,S,*A,1>>]
  <= 
    *S : [S ! S != <<cat,S,NounPhrase,1>>
              S != <<daughter,S,*DS :: [DS ! DS != <<cat,DS,ProNoun,1>>],1>>],
    *T1 : [TS ! TS != <<relevant,TS,1>>
                TS != <<t-body,*S,*S1 ::
                                  [S1 ! S1 != <<relevant,S1,1>>
                                        S1 != <<accessible,S1,*A,1>>],1>>].
*S : [S ! S != <<accessible,S,*A,1>>]
  <= 
    *S : [S ! S != <<cat,S,NounPhrase,1>>
              S != <<daughter,S,*DS ::
                     [DS ! DS != <<cat,DS,Determiner,1>>],1>>],
    *T1 : [TS ! TS != <<relevant,TS,1>>
                TS != <<t-in,*S,*S1 ::
                                [S1 ! S1 != <<accessible,S1,*A,1>>],1>>].

*S : [S ! S != <<accessible,S,*A,1>>]
  <= 
    *S : [S ! S != <<cat,S,Determiner,1>>
              S != <<sem,S,<<*PQUANT,*X,*Y,*Z,1>>,1>>
              S != <<env,S,*SEnv ::
                           [Env ! Env != <<anchor,*PQUANT,some,1>>],1>>],
    *T1 : [TS ! TS != <<relevant,TS,1>>
                TS != <<t-body,*S,*Body ::
                               [S1 ! S1 != <<relevant,S1,1>>
                                     S1 != <<accessible,S1,*A,1>>],1>>].

*S : [S ! S != <<accessible,S,*A,1>>]
  <= 
    *S : [S ! S != <<cat,S,Determiner,1>>
              S != <<sem,S,<<*PQUANT,*X,*Y,*Z,1>>,1>>
              S != <<env,S,*SEnv ::
                            [Env ! Env != <<anchor,*PQUANT,every,1>>],1>>],
    *T1 : [TS ! TS != <<relevant,TS,1>>
                TS != <<t-in,*S,*S1 ::
                                [S1 ! S1 != <<accessible,S1,*A,1>>],1>>].

;;; Pronouns do not add anything new
*S : [S ! S != <<accessible,S,*A,1>>]
  <= 
    *S : [S ! S != <<cat,S,Pronoun,1>>],
    *T1 : [TS ! TS != <<relevant,TS,1>>
                TS != <<t-in,*S,*S1 ::
                                [S1 ! S1 != <<accessible,S1,*A,1>>],1>>].

;;;
;;;  The relationship between the DRSIn and the previous DRSOut
;;;  is done by threading.  All the situations which support the
;;;  t-in are checked for one where information about the threading
;;;  of that situation is found.
;;;
*S : [S ! S != <<DRSIn,S,*DRSin,1>>]
<=
  *T1 : [TS ! TS != <<relevant,TS,1>>
              TS != <<t-in,*S,*S1 :: [S1 ! S1 != <<DRSOut,S1,*DRSIn,1>>],1>>].

;;;
;;;  This is basically a lexical rule to add the base case of the
;;;  threads.  Lexical items thread through themselves as they have
;;;  no daughters.
;;;
*S : [S ! S != <<threads,S,*Thread ::
                           [TS ! TS != <<t-need,*S,*S,1>>],1>>]
<=
   *S : [S ! S != <<use_of,S,*Y,1>>].

*Thread : [TS ! TS != <<t-out,*S,*S,1>>]
<=
   *S : [S ! S != <<cat,S,noun,1>>
             S != <<use_of,S,*Y,1>>
             S != <<threads,S,*Thread,1>>].

*Thread : [TS ! TS != <<t-out,*S,*S,1>>]
<=
   *S : [S ! S != <<cat,S,verbphrase,1>>
  	     S != <<use_of,S,*Y,1>>
             S != <<threads,S,*Thread,1>>].

;;;
;;;  Spurious partial analyses can occur so it is necessary to
;;;  identify which utterance situations are relevant and which are
;;;  not.  Basically anything that is an immediate daughter of a 
;;;  full discourse utterance situation is relevant, and anything
;;;  that is the daughter of a relevant utterance is relevant
;;;
*D : [D ! D != <<relevant,D,1>>]
<=
   *S : [S ! S != <<cat,S,FullDiscourse,1>>
             S != <<daughter,S,*D,1>>].

*D : [D ! D != <<relevant,D,1>>]
<=
   *S : [S ! S != <<daughter,S,*D,1>>
             S != <<relevant,S,1>>].

*T1 : [D ! D != <<relevant,D,1>>]
<=
   *S : [S ! S != <<threads,S,*T1,1>>
             S != <<relevant,S,1>>].

Grammar Rules
;;;
;;;   S -> NP VP
;;;
   *S : [S ! S != <<cat,S,Sentence,1>>
             S != <<sem,S,*Fact,1>>
             S != <<env,S,*SEnv :: *VPEnvType & 
  		                   [Env ! Env != <<anchor,*P1,*NPSem,1>>],1>>
	     S != <<daughter,S,*NP,1>>
	     S != <<daughter,S,*VP,1>>
	     S != <<threads,S,*ThreadS ::
			    [TS ! TS != <<t-need,*S,*Y,1>>
				  TS != <<t-in,*X,*Z,1>>
                                  TS != <<t-body,*OUT,*S,1>>
;;                                  TS != <<t-body,*OUT1,*S,1>>
				  TS != <<t-in,*S,*VP,1>>
                                  TS != <<t-out,*S,*OUT,1>>],1>>]
   ->
    *NP : [NP ! NP != <<cat,NP,NounPhrase,1>>
                NP != <<sem,NP,*NPSem,1>>
                NP != <<threads,NP,*ThreadNP ::
                                    [TS ! TS != <<t-need,*NP,*Y,1>>
                                          TS != <<t-out,*NP,*OUT,1>>
                                          TS != <<t-feed,*NP,*Z,1>>],1>>
           ],
    *VP : [VP ! VP != <<cat,VP,VerbPhrase,1>>
                VP != <<sem,VP, *Fact ,1>>
                VP != <<env,VP,*VPEnv :: *VPEnvType &
                                      [Env ! Env != <<label,*P1,subj,1>>],1>>
                VP != <<threads,VP,*ThreadVP ::
                                    [TS ! TS != <<t-need,*VP,*X,1>>
                                          TS != <<t-out,*VP,*OUT1,1>>],1>>].

;;;
;;;   VP -> V NP
;;;
   *VP : [VP ! VP != <<cat,VP,VerbPhrase,1>>
               VP != <<sem,VP,*Fact,1>>
               VP != <<env,VP,*VPEnv :: *VEnvType & 
    		                    [Env ! Env != <<anchor,*P1,*NPSem,1>>],1>>
 	       VP != <<daughter,VP,*V,1>>
	       VP != <<daughter,VP,*NP,1>>
               VP != <<threads,VP,*ThreadVP ::
                               [TS ! TS != <<t-need,*VP,*Y,1>>
                                     TS != <<t-in,*X,*Z,1>>
                                     TS != <<t-out,*VP,*OUT,1>>
                                     TS != <<t-in,*VP,*V,1>>],1>>]
   ->
    *V : [V ! V != <<cat,V,Verb,1>>
              V != <<sem,V,*Fact,1>>
              V != <<env,V,*VEnv :: *VEnvType &
                               [Env ! Env != <<label,*P1,obj,1>>],1>>
              V != <<threads,V,*ThreadV ::
		           [TS ! TS != <<t-need,*V,*X,1>>],1>>],
    *NP : [NP ! NP != <<cat,NP,NounPhrase,1>>
                NP != <<sem,NP,*NPSem,1>>
                NP != <<threads,NP,*ThreadNP ::
                             [TS ! TS != <<t-need,*NP,*Y,1>>
                                   TS != <<t-feed,*NP,*Z,1>>
                                   TS != <<t-out,*NP,*OUT,1>>],1>>].
;;;
;;;   VP -> Vs S
;;;
   *VP : [VP ! VP != <<cat,VP,VerbPhrase,1>>
               VP != <<sem,VP,*Fact,1>>
               VP != <<env,VP,*VPEnv :: *VEnvType & 
    		                    [Env ! Env != <<anchor,*P1,*DS,1>>],1>>
 	       VP != <<daughter,VP,*V,1>>
	       VP != <<daughter,VP,*S,1>>
               VP != <<threads,VP,*ThreadVP ::
                               [TS ! TS != <<t-need,*VP,*V,1>>
;;                                     TS != <<t-in,*V,*OUT,1>>
                                     TS != <<t-in,*Y,*M1 ::
                                           [S ! S != <<cat,S,Marker,1>>
                                                S != <<DRSout,S,DRSStart,1>>],
                                                       1>>
                                     TS != <<t-out,*VP,*VP,1>>
                                     TS != <<t-in,*VP,*V,1>>],1>>]
   ->
    *V : [V ! V != <<cat,V,VerbSubCatS,1>>
              V != <<sem,V,*Fact,1>>
              V != <<env,V,*VEnv :: *VEnvType &
                               [Env ! Env != <<label,*P1,obj,1>>],1>>],
    *S : [S ! S != <<cat,S,Sentence,1>>
              S != <<described,S,*DS,1>>
              S != <<threads,S,*ThreadS ::
                           [TS ! TS != <<t-need,*S,*Y,1>>
;;                                 TS != <<t-feed,*S,*Z,1>>
                                 TS != <<t-out,*S,*OUT,1>>],1>>].
;;;
;;;   VP -> Vintrans
;;;
   *VP : [VP ! VP != <<cat,VP,VerbPhrase,1>>
               VP != <<sem,VP,<<*R1,*A1,1>>,1>>
               VP != <<env,VP,*VPEnv,1>>
 	       VP != <<daughter,VP,*V,1>>
               VP != <<threads,VP,*ThreadVP ::
                               [TS ! TS != <<t-need,*VP,*VP,1>>
                                     TS != <<t-out,*VP,*V,1>>],1>>]
   ->
    *V : [V ! V != <<cat,V,Verb,1>>
              V != <<sem,V,<<*R1,*A1,1>>,1>>
              V != <<env,V,*VPEnv,1>>].

;;;
;;;  NP -> Det Noun
;;;
    *NP : [NP ! NP != <<cat,NP,NounPhrase,1>>
                NP != <<sem,NP,*A1,1>>
                NP != <<daughter,NP,*DET,1>>
                NP != <<daughter,NP,*N,1>>
                NP != <<threads,NP,*T2 ::
                    [TS ! TS != <<t-need,*NP,*X,1>>
                          TS != <<t-in,*Y,*M1 ::
                              [S ! S != <<cat,S,Marker,1>>
                                   S != <<DRSout,S,DRSStart,1>>
                                   S != <<access,S,*X,1>>],1>>
                          TS != <<t-in,*NP,*OUT,1>>
                          TS != <<t-range,*DET,*OUT,1>>
                          TS != <<t-feed,*NP,*M2 ::
                              [S ! S != <<cat,S,Marker,1>>
                                   S != <<DRSout,S,DRSStart,1>>
                                   S != <<access,S,*OUT,1>>],1>>
                          TS != <<t-out,*NP,*DET,1>>],1>>]
    ->
      *DET : [DET ! DET != <<cat,DET,Determiner,1>>
                    DET != <<sem,DET,<<*PQUANT,*PVAR,*PRANGE,*PBODY,1>>,1>>
                    DET != <<env,DET,*Env ::
                               [Env ! Env != <<anchor,*PQUANT,every,1>>],1>>
                    DET != <<threads,DET,*T1 ::
                                 [TS ! TS != <<t-need,*DET,*X,1>>],1>>],
      *N : [N ! N != <<cat,N,noun,1>>
                N != <<env,N,*Env :: [Env ! Env != <<label,*A1,arg1,1>>],1>>
                N != <<sem,N,<<*R1,*A1,1>>,1>>
                N != <<threads,N,*T3 ::
                                 [TS ! TS != <<t-need,*N,*Y,1>>
                                       TS != <<t-out,*N,*OUT,1>>],1>>].

    *NP : [NP ! NP != <<cat,NP,NounPhrase,1>>
                NP != <<sem,NP,*A1,1>>
                NP != <<daughter,NP,*DET,1>>
                NP != <<daughter,NP,*N,1>>
                NP != <<threads,NP,*T2 ::
                             [TS ! TS != <<t-need,*NP,*Y,1>>
                                   TS != <<t-in,*NP,*OUT,1>>
                                   TS != <<t-range,*DET,*OUT,1>>
                                   TS != <<t-feed,*NP,*NP,1>>
                                   TS != <<t-out,*NP,*DET,1>>],1>>]
    ->
      *DET : [DET ! DET != <<cat,DET,Determiner,1>>
                    DET != <<sem,DET,<<*PQUANT,*PVAR,*PRANGE,*PBODY,1>>,1>>
                    DET != <<env,DET,*Env ::
                               [Env ! Env != <<anchor,*PQUANT,some,1>>],1>>
                    DET != <<threads,DET,*T1 ::
                                 [TS ! TS != <<t-need,*DET,*X,1>>],1>>],
      *N : [N ! N != <<cat,N,noun,1>>
                N != <<env,N,*Env :: [Env ! Env != <<label,*A1,arg1,1>>],1>>
                N != <<sem,N,<<*R1,*A1,1>>,1>>
                N != <<threads,N,*T3 ::
                                 [TS ! TS != <<t-need,*N,*Y,1>>
                                       TS != <<t-out,*N,*OUT,1>>],1>>].

;;;
;;;  NP -> Pronoun
;;;
   *NP : [NP ! NP != <<cat,NP,NounPhrase,1>>
               NP != <<sem,NP,*X,1>>
               NP != <<daughter,NP,*PN,1>>
               NP != <<threads,NP,*ThreadNP ::
                               [TS ! TS != <<t-need,*NP,*Y,1>>
                                     TS != <<t-out,*NP,*NP,1>>
                                     TS != <<t-feed,*NP,*PN,1>>],1>>]

   ->
      *PN : [PN ! PN != <<cat,PN,Pronoun,1>>
                  PN != <<sem,PN,*X,1>>
                  PN != <<threads,PN,*Thread ::
                               [TS ! TS != <<t-need,*PN,*Y,1>>],1>>].

;;;
;;;  NP -> Propernoun
;;;
   *NP : [NP ! NP != <<cat,NP,NounPhrase,1>>
               NP != <<sem,NP,*X,1>>
               NP != <<daughter,NP,*PN,1>>
               NP != <<threads,NP,*ThreadNP ::
                               [TS ! TS != <<t-need,*NP,*Y,1>>
                                     TS != <<t-out,*NP,*NP,1>>
                                     TS != <<t-feed,*NP,*PN,1>>],1>>]
   ->
      *PN : [PN ! PN != <<cat,PN,ProperNoun,1>>
                  PN != <<sem,PN,*X,1>>
                  PN != <<threads,PN,*Thread ::
                               [TS ! TS != <<t-need,*PN,*Y,1>>],1>>
             ].

;;;
;;;   N -> N PP
;;;
  *N1 :  [N ! N != <<cat,N,noun,1>>
              N != <<daughter,N,*N,1>>
              N != <<daughter,N,*PP,1>>
              N != <<sem,N,<<*R1,*A1,1>>,1>>
              N != <<env,N,*NEnv :: *Envtype, 1>>
              N != <<threads,N,*T2 :: [TS ! TS != <<t-need,*N1,*X,1>>
                                            TS != <<t-in,*N1,*PP,1>>
                                            TS != <<t-body,*OUT1,*N1,1>>
                                            TS != <<t-in,*Y,*OUT,1>>
                                            TS != <<t-out,*N1,*OUT1,1>>],1>>]
    ->
      *N : [N ! N != <<cat,N,noun,1>>
                N != <<env,N,*Env :: *Envtype &
                                   [Env ! Env != <<label,*A1,arg1,1>>],1>>
                N != <<sem,N,<<*R1,*A1,1>>,1>>
                N != <<threads,N,*T1 :: [TS ! TS != <<t-need,*N,*X,1>>
                                              TS != <<t-out,*N,*OUT,1>>],1>>],
      *PP : [PP ! PP != <<cat,PP,PrepPhrase,1>>
                  PP != <<sem,PP,*Fact,1>>
                  PP != <<threads,PP,*T3 ::
                                [TS ! TS != <<t-need,*PP,*Y,1>>
                                      TS != <<t-out,*PP,*OUT1,1>>],1>>].

;;;
;;;   PP -> P NP
;;;   
    *PP : [PP ! PP != <<cat,PP,PrepPhrase,1>>
                PP != <<daughter,PP,*PREP,1>>
                PP != <<daughter,PP,*NP,1>>
                PP != <<sem,PP,*Fact,1>>
                PP != <<env,PP,*PPEnv :: *EnvType & 
                                [Env ! Env != <<anchor,*P2,*NPSem,1>>],1>>
                PP != <<threads,PP,*T1 :: 
                           [TS ! TS != <<t-need,*PP,*Y,1>>
                                 TS != <<t-in,*X,*Z,1>>
                                 TS != <<t-in,*PP,*PREP,1>>
                                 TS != <<t-out,*PP,*OUT,1>>],1>>
           ]
    ->
      *PREP : [PREP ! PREP != <<cat,PREP,Preposition,1>>
                      PREP != <<sem,PREP,*Fact,1>>
                      PREP != <<env,PREP,*PEnv :: *Envtype &
                                  [Env ! Env != <<label,*P2,arg2,1>>],1>>
                      PREP != <<threads,PREP,*T2 ::
		           [TS ! TS != <<t-need,*PREP,*X,1>>],1>>
               ],
      *NP :  [NP ! NP != <<cat,NP,NounPhrase,1>>
                   NP != <<sem,NP,*NPSem,1>>
                   NP != <<threads,NP,*T3 ::
                              [TS ! TS != <<t-need,*NP,*Y,1>>
                                    TS != <<t-feed,*NP,*Z,1>>
                                    TS != <<t-out,*NP,*OUT,1>>],1>>
              ].

;;;
;;;  Discourse -> S
;;;
   *DS : [DS ! DS != <<cat,DS,Discourse,1>>
               DS != <<daughter,DS,*S,1>>
               DS != <<threads,DS,*ThreadDS ::
                             [TS ! TS != <<t-need,*DS,*X,1>>
                                   TS != <<t-in,*DS,*S,1>>
                                   TS != <<t-out,*DS,*OUT,1>>],1>>]
   ->
     *S : [S ! S != <<cat,S,sentence,1>>
               S != <<threads,S,*ThreadS ::
                             [TS ! TS != <<t-need,*S,*X,1>>
                                   TS != <<t-out,*S,*OUT,1>>],1>>].

;;;
;;;  Discourse -> Discourse S
;;;  

   *DS1 : [DS ! DS != <<cat,DS,Discourse,1>>
                DS != <<daughter,DS,*DS,1>>
                DS != <<daughter,DS,*S,1>>
                DS != <<threads,DS,*ThreadDS1 ::
                              [TS ! TS != <<t-need,*DS1,*X,1>>
                                    TS != <<t-in,*Y,*OUT,1>>
                                    TS != <<t-in,*DS1,*S,1>>
                                    TS != <<t-out,*DS1,*OUT1,1>>],1>>]
   ->
     *DS : [DS ! DS != <<cat,DS,Discourse,1>>
                 DS != <<threads,DS,*ThreadDS ::
                                 [TS ! TS != <<t-need,*DS,*X,1>>
                                       TS != <<t-out,*DS,*OUT,1>>],1>>],
     *S : [S ! S != <<cat,S,sentence,1>>
               S != <<threads,S,*ThreadS ::
                             [TS ! TS != <<t-need,*S,*Y,1>>
                                   TS != <<t-out,*S,*OUT1,1>>],1>>].

;;;
;;;  Fulldiscourse -> ds Discourse de
;;;
   [DS ! DS != <<cat,DS,fulldiscourse,1>>
         DS != <<daughter,DS,*DS,1>>
         DS != <<threads,DS,
                    *ThreadDS :: [TS ! TS != <<relevant,TS,1>>
                                      TS != <<t-in,*X,DStart,1>>
                                      TS != <<t-out,DS,*Y,1>>],1>>
         ]
  ->
    [S ! S != <<cat,S,DisStart,1>>],
    *DS : [DS ! DS != <<cat,DS,discourse,1>>
                 DS != <<threads,DS,*ThreadDS ::
                          [TS ! TS != <<t-need,*DS,*X,1>>
                                TS != <<t-out,*DS,*Y,1>>
                          ],1>>
              ],
    [S ! S != <<cat,S,DisEnd,1>>].
    
      
Lexical Entries

;;;
;;;  Discourse start and end markers
;;;
ds -
   [DS ! DS != <<cat,DS,DisStart,1>>]
de -
   [DS ! DS != <<cat,DS,DisEnd,1>>]

;;; 
;;;   Proper nouns
;;;
Hanako - 
   [PN ! PN != <<cat,PN,ProperNoun,1>>
         PN != <<use_of,PN,"Hanako",1>>
         PN != <<sem,PN,h,1>>]
Anna - 
   [PN ! PN != <<cat,PN,ProperNoun,1>>
         PN != <<use_of,PN,"Anna",1>>
         PN != <<sem,PN,a,1>>]
Taro -
   [PN ! PN != <<cat,PN,ProperNoun,1>>
         PN != <<use_of,PN,"Taro",1>>
         PN != <<sem,PN,t,1>>]
Pedro -           ;; as one might guess, Pedro is a donkey
   [PN ! PN != <<cat,PN,ProperNoun,1>>
         PN != <<use_of,PN,"Pedro",1>>
         PN != <<sem,PN,p,1>>]
;;;
;;;  Pronouns
;;;
he -
   [PN ! PN != <<cat,PN,ProNoun,1>>
         PN != <<use_of,PN,"he",1>>
         PN != <<type,PN,male,1>>
         PN != <<sem,PN,PN1,1>>]
she -
   [PN ! PN != <<cat,PN,ProNoun,1>>
         PN != <<use_of,PN,"she",1>>
         PN != <<type,PN,female,1>>
         PN != <<sem,PN,PN2,1>>]
her -
   [PN ! PN != <<cat,PN,ProNoun,1>>
         PN != <<use_of,PN,"her",1>>
         PN != <<type,PN,female,1>>
         PN != <<sem,PN,PN2,1>>]
it -
   [PN ! PN != <<cat,PN,ProNoun,1>>
         PN != <<use_of,PN,"it",1>>
         PN != <<type,PN,neuter,1>>
         PN != <<sem,PN,PN3,1>>]
;;;
;;;  Common nouns
;;;
man -
   [N ! N != <<cat,N,noun,1>>
        N != <<use_of,N,"man",1>>
        N != <<type,N,male,1>>
        N != <<sem,N,<<R1,MA1,1>>,1>>
        N != <<env,N,ManEnv,1>>]
donkey -
   [N ! N != <<cat,N,noun,1>>
        N != <<use_of,N,"donkey",1>>
        N != <<type,N,neuter,1>>
        N != <<sem,N,<<R1,DA1,1>>,1>>
        N != <<env,N,DonkeyEnv,1>>]
hat -
   [N ! N != <<cat,N,noun,1>>
        N != <<use_of,N,"hat",1>>
        N != <<type,N,neuter,1>>
        N != <<sem,N,<<R1,HA1,1>>,1>>
        N != <<env,N,HatEnv,1>>]
;;;
;;;  Quantifiers
;;;
a -
   [D ! D != <<cat,D,Determiner,1>>
        D != <<use_of,D,"a",1>>
        D != <<sem,D,<<Q1,A1,A2,A3,1>>,1>>
        D != <<env,D,AEnv,1>>]
every -
   [D ! D != <<cat,D,Determiner,1>>
        D != <<use_of,D,"every",1>>
        D != <<sem,D,<<Q1,A1,A2,A3,1>>,1>>
        D != <<env,D,EveryEnv,1>>]
;;;
;;;  Verbs
;;;
sings -
   [VP ! VP != <<cat,VP,Verb,1>>
         VP != <<use_of,VP,"sings",1>>
         VP != <<sem,VP,<<R1,A1,1>>,1>>
         VP != <<env,VP,SingEnv,1>>]
sing -
   [VP ! VP != <<cat,VP,Verb,1>>
         VP != <<use_of,VP,"sing",1>>
         VP != <<sem,VP,<<R1,A1,1>>,1>>
         VP != <<env,VP,SingEnv,1>>]
smiles -
   [VP ! VP != <<cat,VP,Verb,1>>
         VP != <<use_of,VP,"smiles",1>>
         VP != <<sem,VP,<<R1,A1,1>>,1>>
         VP != <<env,VP,SmileEnv,1>>]
walks -
   [VP ! VP != <<cat,VP,Verb,1>>
         VP != <<use_of,VP,"walks",1>>
         VP != <<sem,VP, <<R1,WA1,1>>,1>>
         VP != <<env,VP,WalkEnv,1>>]
talks -
   [VP ! VP != <<cat,VP,Verb,1>>
         VP != <<use_of,VP,"talks",1>>
         VP != <<sem,VP,<<R1,TA1,1>>,1>>
         VP != <<env,VP,TalkEnv,1>>]
likes -
   [V ! V != <<cat,V,Verb,1>>
        V != <<use_of,V,"likes",1>>
        V != <<sem,V,<<R1,A1,A2,1>>,1>>
        V != <<env,V,LikeEnv,1>>]
sees -
   [V ! V != <<cat,V,VerbSubCatS,1>>
        V != <<use_of,V,"sees",1>>
        V != <<sem,V,<<R1,A1,A2,1>>,1>>
        V != <<env,V,SeeEnv,1>>]

;;; 
;;;  Preprositions
;;;
with -
   [PREP ! PREP != <<cat,PREP,Preposition,1>>
           PREP != <<use_of,PREP,"with",1>>
           PREP != <<sem,PREP,<<P1,A1,A2,1>>,1>>
           PREP != <<env,PREP,WithEnv,1>>]

