;;;   
;;;   %%   File: th-rooth.st
;;;   %%   Alan W Black (awb@ed.ac.uk) July 91
;;;   
;;;   This \astl/ description is a for a simple syntactic grammar
;;;   (described in Section \ref{rooth-fragment}) based on the fragment
;;;   in \cite{rooth87}.  The grammar is large enough to deal with
;;;   simple declarative sentences, including quantifiers and anaphora.
;;;   It can analyse sentences like
;;;   
;;;   \begin{lingeg}
;;;   Hanako sings.\\
;;;   A man walks. He talks.\\
;;;   Every man with a donkey likes it.
;;;   \end{lingeg}
;;;   Note this only defines the syntax, semantic forms are built on
;;;   top of this structure in the later STG, DRT and DPL-NL descriptions
;;;   
;;;   \begin{linespacing}{1.0}\begin{verbatim}
Individuals
    {}
Relations
    ( 
;;;  These are the relations which act like features in a 
;;;  conventional attribute value system
      use_of/2 cat/2 
;;; Syntactic functions which act as arguments to cat/2
      NounPhrase/1 Noun/1 Determiner/1
      Sentence/1 VerbPhrase/1 Verb/1 
      PrepPhrase/1 Preposition/1
      Discourse/1
;;; Structural relation
      daughter/1 )
Parameters
    {D,S,NP,VP,PN,N,PREP,DET,V}
Variables
    {*S,*NP, *VP, *V, *N, *PP, *PREP, *DET, *D }
Situations
    ()
GoalProp
   *S : [S ! S != <<cat,S,discourse,1>>]
Grammar Rules
;;;
;;;  S -> NP VP
;;;
   [S ! S != <<cat,S,Sentence,1>>
        S != <<daughter,*NP,1>>
        S != <<daughter,*VP,1>>]
   ->
    *NP : [NP ! NP != <<cat,NP,NounPhrase,1>>],
    *VP : [VP ! VP != <<cat,VP,VerbPhrase,1>>].
;;;
;;;  VP -> V NP
;;;
    [VP ! VP != <<cat,VP,VerbPhrase,1>>
          VP != <<daughter,*V,1>>
          VP != <<daughter,*NP,1>>]
    ->
       *V : [V ! V != <<cat,V,Verb,1>>],
       *NP : [NP ! NP != <<cat,NP,NounPhrase,1>>].
;;;
;;;  N -> N PP
;;;
    [N ! N != <<cat,N,noun,1>>
         N != <<daughter,*N,1>>
         N != <<daughter,*PP,1>>]
    ->
      *N : [N ! N != <<cat,N,noun,1>>],
      *PP : [PP ! PP != <<cat,PP,PrepPhrase,1>>].
;;;
;;;  NP -> Det N
;;;
    [NP ! NP != <<cat,NP,NounPhrase,1>>
          NP != <<daughter,*DET,1>>
          NP != <<daughter,*N,1>>]
    ->
      *DET : [DET ! DET != <<cat,DET,Determiner,1>>],
      *N :   [N ! N != <<cat,N,noun,1>>].
;;;
;;;  PP -> P NP
;;;
    [PP ! PP != <<cat,PP,PrepPhrase,1>>
          PP != <<daughter,*PREP,1>>
          PP != <<daughter,*NP,1>>]
    ->
      *PREP : [PREP ! PREP != <<cat,PREP,Preposition,1>>],
      *NP : [NP ! NP != <<cat,NP,NounPhrase,1>>].
;;;
;;;  D -> S
;;;
    [D ! D != <<cat,D,Discourse,1>>
         D != <<daughter,*S,1>>]
    ->
      *S : [S ! S != <<cat,S,Sentence,1>>].
;;;
;;;  D -> D S
;;;
    [D ! D != <<cat,D,Discourse,1>>
         D != <<daughter,*D,1>>
         D != <<daughter,*S,1>>]
    ->
      *D : [D ! D != <<cat,D,Discourse,1>>],
      *S : [S ! S != <<cat,S,Sentence,1>>].
;;;   \end{verbatim}\end{linespacing}
;;;   %%              ***** Lexical Entries *****
;;;   A basic set of lexical entries to allow some the simple classic
;;;   sentences.  
;;;   
;;;   \begin{linespacing}{1.0}\begin{verbatim}
Lexical Entries

;;;
;;;  Nouns
;;;
Hanako - 
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"Hanako",1>>]
Taro -
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"Taro",1>>]
Anna - 
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"Anna",1>>]
man -
   [N ! N != <<cat,N,Noun,1>>
        N != <<use_of,N,"man",1>>]
donkey -
   [N ! N != <<cat,N,Noun,1>>
        N != <<use_of,N,"donkey",1>>]
;;;
;;;  Pronouns
;;;
he - 
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"he",1>>]
she - 
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"she",1>>]
it - 
   [PN ! PN != <<cat,PN,NounPhrase,1>>
         PN != <<use_of,PN,"it",1>>]
;;;
;;;  Determiners
;;;
a - 
   [DET ! DET != <<cat,DET,Determiner,1>>
          DET != <<use_of,DET,"a",1>>]
the - 
   [DET ! DET != <<cat,DET,Determiner,1>>
          DET != <<use_of,DET,"the",1>>]
every - 
   [DET ! DET != <<cat,DET,Determiner,1>>
          DET != <<use_of,DET,"every",1>>]
;;;
;;;  Verbs
;;;
smiles -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"smiles",1>>]

sings -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"sings",1>>]
walks -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"walks",1>>]
talks -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"talks",1>>]
runs -
   [VP ! VP != <<cat,VP,VerbPhrase,1>>
         VP != <<use_of,VP,"runs",1>>]
likes -
   [V ! V != <<cat,V,Verb,1>>
        V != <<use_of,V,"likes",1>>]
beats -
   [V ! V != <<cat,V,Verb,1>>
        V != <<use_of,V,"beats",1>>]
;;;
;;;  Prepositions
;;;
to - 
     [PREP ! PREP != <<cat,PREP,Preposition,1>>
             PREP != <<use_of,PREP,"to",1>>]
with - 
     [PREP ! PREP != <<cat,PREP,Preposition,1>>
             PREP != <<use_of,PREP,"with",1>>]
on - 
     [PREP ! PREP != <<cat,PREP,Preposition,1>>
             PREP != <<use_of,PREP,"on",1>>]
;;;   \end{verbatim}\end{linespacing}
